/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.mnt.client.AbstractRptLoanListFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RptLoanListFilterUI
extends AbstractRptLoanListFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptLoanListFilterUI.class);
    private Set bankIdSet = null;
    private Set currencyIdSet = null;
    private Set inGroupIdSet = null;

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.kDTextField1.setEnabled(false);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        this.kDBank.setIcon((Icon)new ImageIcon(icon_off));
        Calendar instance = Calendar.getInstance();
        int thisYear = instance.get(1);
        SpinnerNumberModel yModel = new SpinnerNumberModel(thisYear - 1, 1900, 2999, 1);
        this.yearFrom.setModel((SpinnerModel)yModel);
        SpinnerNumberModel yModel1 = new SpinnerNumberModel(thisYear, 1900, 2999, 1);
        this.yearTo.setModel((SpinnerModel)yModel1);
        this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.kDCompany.setText(ContextHelperFactory.getRemoteInstance().getCurrentCompany().toString());
        this.kDRadioButtonCompany.setSelected(true);
        this.kDCurrency.setData(null);
        this.kDCheckBoxInGroup.setSelected(false);
    }

    public boolean verify() {
        int endBegain;
        int yearBegain = (Integer)this.yearFrom.getValue();
        if (yearBegain > (endBegain = ((Integer)this.yearTo.getValue()).intValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"479_RptCreditLimitListFilterUI"));
            SysUtil.abort();
        }
        if (endBegain - yearBegain > 10) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"480_RptCreditLimitListFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Set getF7Bank() {
        Set<String> bankIdSet = new HashSet();
        Set selectIdSet = this.getIdSetFromByBankTreeNode(this.selectedNode);
        if (selectIdSet != null && selectIdSet.size() < 1) {
            String sql = " SELECT DISTINCT \"INSTITUTION\".FID AS \"INSTITUTION.ID\" FROM T_FIN_LOAN AS \"LOAN\" INNER JOIN T_BD_Bank AS \"INSTITUTION\" ON \"LOAN\".FInstitutionId = \"INSTITUTION\".FID";
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = null;
            try {
                rs = exec.executeSQL();
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
            try {
                while (rs.next()) {
                    bankIdSet.add(rs.getString("Institution.id"));
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        } else {
            bankIdSet = this.getIdSetFromByBankTreeNode(this.selectedNode);
        }
        return bankIdSet;
    }

    protected Set getInGroupIdSet() {
        Set<String> tempInGroupIdSet = new HashSet<String>();
        if (this.kDCheckBoxInGroup.isSelected()) {
            CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            boolean isOU = false;
            try {
                isOU = ContextHelperFactory.getRemoteInstance().isOnlyUnion(CURRENT_COMPANY);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (isOU) {
                tempInGroupIdSet.clear();
                tempInGroupIdSet = this.companyIdSet;
            } else {
                tempInGroupIdSet.clear();
                tempInGroupIdSet.add(CURRENT_COMPANY.getId().toString());
            }
            return tempInGroupIdSet;
        }
        tempInGroupIdSet.clear();
        return tempInGroupIdSet;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = this.getF7Bank();
        rcm.setProperty("bankIdSet", (Object)this.bankIdSet);
        rcm.setProperty("childBankTree", (Object)this.selectedNode);
        this.currencyIdSet = this.getIdSetFromF7(this.kDCurrency);
        rcm.setProperty("currencyIdSet", (Object)this.currencyIdSet);
        this.inGroupIdSet = this.getInGroupIdSet();
        rcm.setProperty("inGroupIdSet", (Object)this.inGroupIdSet);
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        this.selectedNode = this.getBankTreeNodeFromByIdSet(this.bankIdSet);
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        this.inGroupIdSet = this.getInGroupIdSet();
        super.setCustomCondition(params);
        Set names = this.getNameSetFromByBankTreeNode(this.selectedNode);
        if (names != null) {
            this.kDTextField1.setText(names.toString());
        }
    }

    @Override
    protected void kDRadioButtonBank_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonBank_actionPerformed(e);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(false);
    }

    @Override
    protected void kDRadioButtonCompany_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonCompany_actionPerformed(e);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonCurrency_actionPerformed(e);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDBank_actionPerformed(ActionEvent e) throws Exception {
        if (this.bankSelectDlg == null) {
            this.bankSelectDlg = RptFmClientUtil.selectBank((RptFmClientUtil.SelectBankListener)this, (Component)((Object)this));
        }
        this.bankSelectDlg.show();
        Set names = this.getNameSetFromByBankTreeNode(this.selectedNode);
        if (names != null) {
            this.kDTextField1.setText(names.toString());
        }
        super.kDBank_actionPerformed(e);
    }
}

