/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.mnt.client.AbstractRptLoanStruAnalyseFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class RptLoanStruAnalyseFilterUI
extends AbstractRptLoanStruAnalyseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptLoanStruAnalyseFilterUI.class);
    private Set bankIdSet = null;
    private Set currencyIdSet = null;
    private Set inGroupIdSet = null;

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = this.getF7Bank();
        rcm.setProperty("bankIdSet", (Object)this.bankIdSet);
        rcm.setProperty("childBankTree", (Object)this.selectedNode);
        this.currencyIdSet = this.getIdSetFromF7(this.kDCurrency);
        rcm.setProperty("currencyIdSet", (Object)this.currencyIdSet);
        this.inGroupIdSet = this.getInGroupIdSet();
        rcm.setProperty("inGroupIdSet", (Object)this.inGroupIdSet);
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        Set names;
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = (Set)params.getObject("bankIdSet");
        this.selectedNode = this.getBankTreeNodeFromByIdSet(this.bankIdSet);
        this.currencyIdSet = (Set)params.getObject("currencyIdSet");
        this.inGroupIdSet = this.getInGroupIdSet();
        super.setCustomCondition(params);
        if (this.kDUnit.getSelectedItem() == null) {
            this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        }
        if ((names = this.getNameSetFromByBankTreeNode(this.selectedNode)) != null) {
            this.kDTextField1.setText(names.toString());
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.kDCurrency.setEditable(true);
        this.kDCheckBoxInGroup.setSelected(false);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        this.kDBank.setIcon((Icon)new ImageIcon(icon_off));
        this.kDCurrency.setData(null);
        this.kDTextField1.setEnabled(false);
        this.kDUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.getFirstDayOfMonth(this.kDDateFrom);
        this.getLastDayOfMonth(this.kDDateTo);
        this.kDRadioButtonCompany.setSelected(true);
        this.kDCompany.setText(ContextHelperFactory.getRemoteInstance().getCurrentCompany().toString());
    }

    private void getFirstDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    private void getLastDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    protected Set getF7Bank() {
        Set<String> bankIdSet = new HashSet();
        if (!this.kDRadioButtonBank.isSelected()) {
            Set selectID = this.getIdSetFromByBankTreeNode(this.selectedNode);
            if (selectID != null && selectID.size() < 1) {
                String sql = " SELECT DISTINCT \"INSTITUTION\".FID AS \"INSTITUTION.ID\" FROM T_FIN_LOAN AS \"LOAN\" INNER JOIN T_BD_Bank AS \"INSTITUTION\" ON \"LOAN\".FInstitutionId = \"INSTITUTION\".FID";
                ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
                IRowSet rs = null;
                try {
                    rs = exec.executeSQL();
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
                try {
                    while (rs.next()) {
                        bankIdSet.add(rs.getString("Institution.id"));
                    }
                }
                catch (SQLException e) {
                    this.handUIException(e);
                }
            } else {
                bankIdSet = this.getIdSetFromByBankTreeNode(this.selectedNode);
            }
        } else {
            bankIdSet = this.getIdSetFromByBankTreeNode(this.selectedNode);
        }
        return bankIdSet;
    }

    protected Set getInGroupIdSet() {
        Set<String> tempInGroupIdSet = new HashSet<String>();
        if (this.kDCheckBoxInGroup.isSelected()) {
            CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            boolean isOU = false;
            try {
                isOU = ContextHelperFactory.getRemoteInstance().isOnlyUnion(CURRENT_COMPANY);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (isOU) {
                tempInGroupIdSet.clear();
                tempInGroupIdSet = this.companyIdSet;
            } else {
                tempInGroupIdSet.clear();
                tempInGroupIdSet.add(CURRENT_COMPANY.getId().toString());
            }
            return tempInGroupIdSet;
        }
        tempInGroupIdSet.clear();
        return tempInGroupIdSet;
    }

    public boolean verify() {
        Date kdDateFrom = (Date)this.kDDateFrom.getValue();
        Date kdDateTo = (Date)this.kDDateTo.getValue();
        if (this.kDRadioButtonLongTime.isSelected() || this.kDRadioButtonFinRes.isSelected()) {
            if (kdDateTo == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"436_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
        } else {
            if (kdDateFrom == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"437_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
            if (kdDateTo == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"436_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
            if ((kdDateFrom = DateTimeUtils.truncateDate((Date)kdDateFrom)).compareTo(kdDateTo = DateTimeUtils.truncateDate((Date)kdDateTo)) > 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.mnt.MNTAutoGenerateResource", (String)"438_RptAcceptanceStruAnalyseFilterUI"));
                SysUtil.abort();
            }
        }
        return super.verify();
    }

    @Override
    protected void kDRadioButtonBank_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonBank_actionPerformed(e);
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
        this.kDCheckBoxInGroup.setSelected(true);
        this.kDCheckBoxInGroup.setEnabled(false);
    }

    @Override
    protected void kDRadioButtonCompany_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonCompany_actionPerformed(e);
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonCurrency_actionPerformed(e);
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonFinRes_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonFinRes_actionPerformed(e);
        this.kDDateFrom.setValue(null);
        this.kDDateFrom.setEnabled(false);
        this.kDCheckBoxInGroup.setSelected(true);
        this.kDCheckBoxInGroup.setEnabled(false);
    }

    @Override
    protected void kDRadioButtonGT_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonGT_actionPerformed(e);
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonLongTime_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonLongTime_actionPerformed(e);
        this.kDDateFrom.setValue(null);
        this.kDDateFrom.setEnabled(false);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDRadioButtonTerm_actionPerformed(ActionEvent e) throws Exception {
        super.kDRadioButtonTerm_actionPerformed(e);
        if (this.kDDateFrom.getValue() == null) {
            this.getFirstDayOfMonth(this.kDDateFrom);
        }
        this.kDDateFrom.setEnabled(true);
        this.kDCheckBoxInGroup.setSelected(false);
        this.kDCheckBoxInGroup.setEnabled(true);
    }

    @Override
    protected void kDBank_actionPerformed(ActionEvent e) throws Exception {
        if (this.bankSelectDlg == null) {
            this.bankSelectDlg = RptFmClientUtil.selectBank((RptFmClientUtil.SelectBankListener)this, (Component)((Object)this));
        }
        this.bankSelectDlg.show();
        Set names = this.getNameSetFromByBankTreeNode(this.selectedNode);
        if (names != null) {
            this.kDTextField1.setText(names.toString());
        }
        super.kDBank_actionPerformed(e);
    }
}

