/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.mnt.MerageUnitTreeFactory;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.eas.fm.mnt.MergeScope;
import com.kingdee.eas.fm.mnt.client.AbstractRptMergeCashFlowEliminateFilterUI;
import com.kingdee.eas.fm.mnt.client.RptMergeCashFlowEliminateFilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RptMergeCashFlowEliminateFilterUI
extends AbstractRptMergeCashFlowEliminateFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptMergeCashFlowEliminateFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setRequired(true);
        this.dpEndDate.setRequired(true);
        this.prmtMergeScope.setRequired(true);
        this.prmtFundFlowItem.setEnabledMultiSelection(true);
        this.comboMergeScope.setSelectedItem((Object)MergeScope.all);
        this.dpStartDate.setValue((Object)DateHelper.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)DateHelper.getDayBegin());
        this.btnCompanySelect.setVisible(false);
    }

    public Object getParam() {
        Object[] fundFlowItems;
        CompanyOrgUnitInfo company;
        RptMergeCashFlowEliminateFilterParam filterParam = new RptMergeCashFlowEliminateFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if ((company = (CompanyOrgUnitInfo)this.prmtCompany.getData()) != null) {
            filterParam.setCompanyId(company.getId().toString());
        }
        filterParam.setStartDate(this.dpStartDate.getSqlDate());
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        MerageUnitTreeInfo mergeTree = (MerageUnitTreeInfo)this.prmtMergeScope.getData();
        if (mergeTree != null) {
            filterParam.setMergeUnitTreeId(mergeTree.getId().toString());
        }
        if ((fundFlowItems = (Object[])this.prmtFundFlowItem.getData()) != null) {
            HashSet<String> itemIdSet = new HashSet<String>();
            for (int i = 0; i < fundFlowItems.length; ++i) {
                FundFlowItemInfo item = (FundFlowItemInfo)fundFlowItems[i];
                if (item == null) continue;
                itemIdSet.add(item.getId().toString());
            }
            filterParam.setFundFlowItemSet(itemIdSet);
        }
        if (this.comboMergeScope.getSelectedItem() instanceof MergeScope) {
            filterParam.setMergeScope((MergeScope)((Object)this.comboMergeScope.getSelectedItem()));
        }
        return filterParam;
    }

    public void setParam(Object param) {
        HashSet<String> itemIdSet;
        RptMergeCashFlowEliminateFilterParam filterParam = (RptMergeCashFlowEliminateFilterParam)((Object)param);
        String companyId = filterParam.getCompanyId();
        if (companyId != null) {
            CompanyOrgUnitInfo company = null;
            try {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.prmtCompany.setValue((Object)company);
        }
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        String mergeTreeId = filterParam.getMergeUnitTreeId();
        if (mergeTreeId != null) {
            MerageUnitTreeInfo tree = null;
            try {
                tree = MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeInfo((IObjectPK)new ObjectUuidPK(mergeTreeId));
                this.prmtMergeScope.setValue((Object)tree);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if ((itemIdSet = filterParam.getFundFlowItemSet()) != null && itemIdSet.size() > 0) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", itemIdSet, CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                this.prmtFundFlowItem.setValue((Object)FundFlowItemFactory.getRemoteInstance().getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (filterParam.getMergeScope() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboMergeScope, (Object)((Object)filterParam.getMergeScope()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboMergeScope, (Object)((Object)MergeScope.all));
        }
    }

    public boolean verify() {
        super.verify();
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpStartDate);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpEndDate);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtMergeScope);
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return true;
    }

    protected Class getParamClass() {
        return RptMergeCashFlowEliminateFilterParam.class;
    }
}

