/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.fm.mnt.MerageUnitCollection;
import com.kingdee.eas.fm.mnt.MerageUnitFactory;
import com.kingdee.eas.fm.mnt.MerageUnitInfo;
import com.kingdee.eas.fm.mnt.MerageUnitTreeCollection;
import com.kingdee.eas.fm.mnt.MerageUnitTreeFactory;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.eas.fm.mnt.MergeScope;
import com.kingdee.eas.fm.mnt.client.RptMergeCashFlowEliminateFilterParam;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptMergeCashFlowEliminateHandler
implements IRptHandler {
    private static final Logger logger = CoreUIObject.getLogger(RptMergeCashFlowEliminateHandler.class);
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private static final String RESOURCE = "com.kingdee.eas.fm.mnt.ReportResource";
    protected KDTable tblMain;
    protected RptMergeCashFlowEliminateFilterParam filterParam;
    protected IRowSet rowSet;

    public RptMergeCashFlowEliminateHandler(KDTable tblMain, RptMergeCashFlowEliminateFilterParam filterParam) {
        this.filterParam = filterParam;
        this.tblMain = tblMain;
    }

    public void initHeader() {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().setOrientation(1);
        this.initColumn();
    }

    public IRowSet getRowSet(RptMergeCashFlowEliminateFilterParam filterParam) throws BOSException {
        String mergeId = filterParam.getMergeUnitTreeId();
        Date startDate = filterParam.getStartDate();
        Date endDate = filterParam.getEndDate();
        MergeScope mergeScope = filterParam.getMergeScope();
        String companyId = filterParam.getCompanyId();
        StringBuffer comIds = new StringBuffer();
        if ((comIds = this.getCompanyIdByGroup(mergeId, comIds)) != null && comIds.length() > 0) {
            comIds.deleteCharAt(comIds.length() - 1);
        }
        StringBuffer mergeUnitIds = new StringBuffer();
        if ((mergeUnitIds = this.getMergeUnitIdByGroup(mergeId, mergeUnitIds)) != null && mergeUnitIds.length() > 0) {
            mergeUnitIds.deleteCharAt(mergeUnitIds.length() - 1);
        }
        HashSet<String> itemSet = filterParam.getFundFlowItemSet();
        StringBuffer itemIds = new StringBuffer();
        if (itemSet != null && itemSet.size() > 0) {
            Iterator<String> iter = itemSet.iterator();
            while (iter.hasNext()) {
                itemIds.append("'").append(iter.next()).append("',");
            }
            itemIds.deleteCharAt(itemIds.length() - 1);
        }
        if (comIds != null && comIds.length() > 0 && mergeScope != null) {
            StringBuffer sql = new StringBuffer();
            int mergeScopeValue = mergeScope.getValue();
            if ((mergeScopeValue == 1 || mergeScopeValue == 3) && mergeUnitIds != null && mergeUnitIds.length() > 0) {
                sql.append("select comName,comId,oppName,oppcomId, itemName, itemid,currencyId,offsetamt, 1 as mergeScope from ");
                sql.append("(select comName,comId,oppName,oppcomId,itemname,itemid,currencyId,");
                sql.append(" case  ");
                sql.append("   when direction = 1 then sum(debitamt - creditamt)/10000  ");
                sql.append("   when direction = 2 then sum(debitamt - creditamt)/10000*-1  ");
                sql.append(" end offsetamt ");
                sql.append(" from (select com.fname_l2 comName,com.fid comId,(case when acct1.fname_l2 is null then report.foppcompanystr else acct1.fname_l2  end) as oppName,report.FOppCompanyOrgID oppcomId, ");
                sql.append("item.fname_l2 itemname,item.fid itemid,item.FDirection direction,report.fcurrencyid currencyId,report.fcreditamt creditamt,report.fdebitamt debitamt ");
                sql.append("from t_mnt_fundflowdayreport report ");
                sql.append("inner join T_CAS_FundFlowItem item on report.ffundflowitemid = item.fid and item.FDirection in (1,2) ");
                sql.append("left join t_org_company com on report.fcompanyid = com.fid ");
                sql.append("left join (  ");
                sql.append("select acct.fid,com1.fname_l2 from T_BD_AccountBanks acct ");
                sql.append("left join t_org_company com1 on acct.FCompanyID = com1.fid ");
                sql.append("where com1.FIsSealUp = 0 ) acct1 on acct1.fid = report.foppbankacctid ");
                sql.append("where item.fisrpteliminate = 1 and item.FIsRptCalc = 1 ");
                sql.append(" and report.FBizTime >= {d'").append(DateHelper.formatDate2((java.util.Date)startDate)).append("'}");
                sql.append(" and report.FBizTime <= {d'").append(DateHelper.formatDate2((java.util.Date)endDate)).append("'}");
                if (companyId != null && companyId.length() > 0) {
                    sql.append(" and report.fcompanyid = '").append(companyId).append("'");
                } else {
                    sql.append(" and report.fcompanyid in (").append(comIds.toString()).append(")");
                }
                sql.append(" and report.FoppcompanyorgId in (").append("select CFCompanyID from T_MNT_MerageUnit where fid in(").append(mergeUnitIds.toString()).append(")) ");
                if (itemIds.length() > 0) {
                    sql.append(" and item.fid in(").append(itemIds.toString()).append(")");
                }
                sql.append(" ) t1 group by comName,comId,oppName,oppcomId,itemname,itemid,direction,currencyId ) as t12");
            }
            if (mergeScopeValue == 3 && mergeUnitIds != null && mergeUnitIds.length() > 0) {
                sql.append(" union all ");
            }
            if (mergeScopeValue == 2 || mergeScopeValue == 3) {
                sql.append("select comName,comId,oppName,oppcomId, itemName, itemid,currencyId,offsetamt, 2 as mergeScope from ");
                sql.append("(select comName,comId,oppName,oppcomId,itemname,itemid,currencyId, ");
                sql.append(" case  ");
                sql.append("   when direction = 1 then sum(debitamt - creditamt)/10000  ");
                sql.append("   when direction = 2 then sum(debitamt - creditamt)/10000*-1 ");
                sql.append(" end offsetamt ");
                sql.append(" from (select com.fname_l2 comName,com.fid comId,(case when acct1.fname_l2 is null then report.foppcompanystr else acct1.fname_l2  end) as oppName,report.FOppCompanyOrgID oppcomId, ");
                sql.append("item.fname_l2 itemname,item.fid itemid,item.FDirection direction,report.fcurrencyid currencyId,report.fcreditamt creditamt,report.fdebitamt debitamt ");
                sql.append("from t_mnt_fundflowdayreport report ");
                sql.append("inner join T_CAS_FundFlowItem item on report.ffundflowitemid = item.fid and item.FDirection in (1,2) ");
                sql.append("left join t_org_company com on report.fcompanyid = com.fid ");
                sql.append("left join (  ");
                sql.append("select acct.fid,com1.fname_l2 from T_BD_AccountBanks acct ");
                sql.append("left join t_org_company com1 on acct.FCompanyID = com1.fid ");
                sql.append("where com1.FIsSealUp = 0 ) acct1 on acct1.fid = report.foppbankacctid ");
                sql.append("where item.fisrpteliminate = 1  and item.FIsRptCalc = 1 ");
                sql.append(" and report.FBizTime >= {d'").append(DateHelper.formatDate2((java.util.Date)startDate)).append("'}");
                sql.append(" and report.FBizTime <= {d'").append(DateHelper.formatDate2((java.util.Date)endDate)).append("'}");
                if (companyId != null && companyId.length() > 0) {
                    sql.append(" and report.fcompanyid = '").append(companyId).append("'");
                } else {
                    sql.append(" and report.fcompanyid in (").append(comIds.toString()).append(")");
                }
                if (mergeUnitIds != null && mergeUnitIds.length() > 0) {
                    sql.append(" and report.FoppcompanyorgId in (").append("select CFCompanyID from T_MNT_MerageUnit where CFCompanyID not in");
                    sql.append("(select CFCompanyID from t_mnt_merageunit where fid in(");
                    sql.append(mergeUnitIds.toString()).append(")))");
                }
                if (itemIds.length() > 0) {
                    sql.append(" and item.fid in(").append(itemIds.toString()).append(")");
                }
                sql.append(" ) t1 group by comName,comId,oppName,oppcomId,itemname,itemid,direction,currencyId ) as t13");
            }
            StringBuffer finalSql = new StringBuffer();
            finalSql.append("select * from (").append(sql.toString());
            finalSql.append(") as t order by mergeScope,comId,oppcomId,itemid,currencyId ");
            return SQLExecutorFactory.getRemoteInstance((String)finalSql.toString()).executeSQL();
        }
        return null;
    }

    public void fillData(KDTable tblMain, IRowSet rs) throws BOSException {
        tblMain.getGroupManager().setGroup(true);
        tblMain.getColumn("company").setGroup(true);
        tblMain.getColumn("mergeScope").setGroup(true);
        tblMain.getColumn("oppCompany").setGroup(true);
        tblMain.getColumn("fundFlowItem").setGroup(true);
        tblMain.getColumn("company").setMergeable(true);
        tblMain.getColumn("mergeScope").setMergeable(true);
        tblMain.getColumn("oppCompany").setMergeable(true);
        Map<String, BigDecimal> rateMap = null;
        String mergeCurrencyId = null;
        String exchangeTableId = null;
        MerageUnitTreeInfo mergeTree = null;
        try {
            if (rs != null && rs.next()) {
                mergeTree = this.getMerageUnitTreeInfo(this.filterParam.getMergeUnitTreeId());
                if (mergeTree != null) {
                    if (mergeTree.getMergeCurrency() != null) {
                        mergeCurrencyId = mergeTree.getMergeCurrency().getId().toString();
                    }
                    if (mergeTree.getRptConvertExaTable() != null) {
                        exchangeTableId = mergeTree.getRptConvertExaTable().getId().toString();
                    }
                }
                if (mergeCurrencyId != null && exchangeTableId != null) {
                    rateMap = this.getRateMap(this.filterParam, mergeCurrencyId, exchangeTableId);
                }
                String itemIdStandBy = rs.getString("itemid");
                String comNameStandBy = rs.getString("comName");
                String comIdStandBy = rs.getString("comId");
                String oppComIdStandBy = rs.getString("oppcomId");
                String oppComStandBy = rs.getString("oppName");
                String itemNameStandBy = rs.getString("itemName");
                String currencyIdStandBy = rs.getString("currencyId");
                int scopeStandBy = rs.getInt("mergeScope");
                BigDecimal addAmount = this.getMergeAount(rateMap, currencyIdStandBy, rs.getBigDecimal("offsetamt"));
                while (rs.next()) {
                    String itemId = rs.getString("itemid");
                    int scope = rs.getInt("mergeScope");
                    String comId = rs.getString("comId");
                    String oppComId = rs.getString("oppcomId");
                    if (itemIdStandBy.equals(itemId) && scopeStandBy == scope && oppComIdStandBy.equals(oppComId) && comIdStandBy.equals(comId)) {
                        String currencyId = rs.getString("currencyId");
                        addAmount = addAmount.add(this.getMergeAount(rateMap, currencyId, rs.getBigDecimal("offsetamt")));
                        continue;
                    }
                    IRow row = tblMain.addRow();
                    row.getCell("company").setValue((Object)comNameStandBy);
                    row.getCell("oppCompany").setValue((Object)oppComStandBy);
                    row.getCell("fundFlowItem").setValue((Object)itemNameStandBy);
                    row.getCell("offsetAmt").setValue((Object)addAmount);
                    if (scopeStandBy == 1) {
                        row.getCell("mergeScope").setValue((Object)"\u5408\u5e76\u8303\u56f4\u5185");
                    } else {
                        row.getCell("mergeScope").setValue((Object)"\u5408\u5e76\u8303\u56f4\u5916\u96c6\u56e2\u5185");
                    }
                    itemIdStandBy = rs.getString("itemid");
                    comNameStandBy = rs.getString("comName");
                    oppComStandBy = rs.getString("oppName");
                    itemNameStandBy = rs.getString("itemName");
                    scopeStandBy = rs.getInt("mergeScope");
                    comIdStandBy = rs.getString("comId");
                    oppComIdStandBy = rs.getString("oppcomId");
                    currencyIdStandBy = rs.getString("currencyId");
                    addAmount = this.getMergeAount(rateMap, currencyIdStandBy, rs.getBigDecimal("offsetamt"));
                }
                IRow row = tblMain.addRow();
                row.getCell("company").setValue((Object)comNameStandBy);
                row.getCell("oppCompany").setValue((Object)oppComStandBy);
                row.getCell("fundFlowItem").setValue((Object)itemNameStandBy);
                row.getCell("offsetAmt").setValue((Object)addAmount);
                if (scopeStandBy == 1) {
                    row.getCell("mergeScope").setValue((Object)EASResource.getString((String)RESOURCE, (String)"WithinScopeText"));
                } else {
                    row.getCell("mergeScope").setValue((Object)EASResource.getString((String)RESOURCE, (String)"OutsideScopeText"));
                }
                this.setCurrencyColumnFmt(tblMain.getColumn("offsetAmt"), mergeCurrencyId);
            }
            tblMain.repaint();
            tblMain.getGroupManager().group();
            tblMain.getGroupManager().setGroup(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    private void initColumn() {
        IColumn colCompany = this.tblMain.addColumn();
        colCompany.setKey("company");
        colCompany.setWidth(200);
        colCompany.getStyleAttributes().setBackground(new Color(16119270));
        IColumn colMergeScope = this.tblMain.addColumn();
        colMergeScope.setKey("mergeScope");
        colMergeScope.setWidth(150);
        colMergeScope.getStyleAttributes().setBackground(new Color(16119270));
        IColumn colOppCompany = this.tblMain.addColumn();
        colOppCompany.setKey("oppCompany");
        colOppCompany.setWidth(200);
        colOppCompany.getStyleAttributes().setBackground(new Color(16119270));
        IColumn colFundFlowItem = this.tblMain.addColumn();
        colFundFlowItem.setKey("fundFlowItem");
        colFundFlowItem.setWidth(300);
        colFundFlowItem.getStyleAttributes().setBackground(new Color(16119270));
        IColumn colOffsetAmt = this.tblMain.addColumn();
        colOffsetAmt.setKey("offsetAmt");
        colOffsetAmt.setWidth(200);
        colOffsetAmt.getStyleAttributes().setBackground(new Color(16119270));
        IRow headRow = this.tblMain.addHeadRow();
        headRow.getCell("company").setValue((Object)EASResource.getString((String)RESOURCE, (String)"CompanyTitle"));
        headRow.getCell("mergeScope").setValue((Object)EASResource.getString((String)RESOURCE, (String)"MergeScopeTitle"));
        headRow.getCell("oppCompany").setValue((Object)EASResource.getString((String)RESOURCE, (String)"OppCompanyTitle"));
        headRow.getCell("fundFlowItem").setValue((Object)EASResource.getString((String)RESOURCE, (String)"FundFlowItemTitle"));
        headRow.getCell("offsetAmt").setValue((Object)EASResource.getString((String)RESOURCE, (String)"OffsetAmtTitle"));
        this.tblMain.setEditable(false);
    }

    private StringBuffer getCompanyIdByGroup(String hbId, StringBuffer comIds) {
        if (hbId == null || hbId.length() == 0) {
            return comIds;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)hbId));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("company.id"));
            sc.add(new SelectorItemInfo("company.number"));
            sc.add(new SelectorItemInfo("company.name"));
            view.setFilter(filter);
            view.setSelector(sc);
            MerageUnitCollection mc = MerageUnitFactory.getRemoteInstance().getMerageUnitCollection(view);
            if (mc != null && mc.size() > 0) {
                for (int j = 0; j < mc.size(); ++j) {
                    MerageUnitInfo unit = mc.get(j);
                    if (unit == null || unit.getCompany() == null) continue;
                    comIds.append("'" + unit.getCompany().getId() + "'");
                    comIds.append(",");
                }
            }
            MerageUnitTreeCollection muc = MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeCollection(" select id where parent.id= '" + hbId + "'");
            for (int i = 0; muc != null && i < muc.size(); ++i) {
                MerageUnitTreeInfo unit = muc.get(i);
                String id = unit.getId().toString();
                this.getCompanyIdByGroup(id, comIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comIds;
    }

    private StringBuffer getMergeUnitIdByGroup(String hbId, StringBuffer mergeUnitIds) {
        if (hbId == null || hbId.length() == 0) {
            return mergeUnitIds;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)hbId));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            view.setFilter(filter);
            view.setSelector(sc);
            MerageUnitCollection mc = MerageUnitFactory.getRemoteInstance().getMerageUnitCollection(view);
            if (mc != null && mc.size() > 0) {
                for (int j = 0; j < mc.size(); ++j) {
                    MerageUnitInfo unit = mc.get(j);
                    if (unit == null || unit.getId() == null) continue;
                    mergeUnitIds.append("'" + unit.getId() + "'");
                    mergeUnitIds.append(",");
                }
            }
            MerageUnitTreeCollection muc = MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeCollection(" select id where parent.id= '" + hbId + "'");
            for (int i = 0; muc != null && i < muc.size(); ++i) {
                MerageUnitTreeInfo tree = muc.get(i);
                String id = tree.getId().toString();
                this.getMergeUnitIdByGroup(id, mergeUnitIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mergeUnitIds;
    }

    private Map<String, BigDecimal> getRateMap(RptMergeCashFlowEliminateFilterParam filterParam, String baseCurrencyID, String baseExTableID) throws BOSException {
        HashMap<String, BigDecimal> rateMap = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select rpt.FCurrencyID  ");
        sql.append(" from T_MNT_FundFlowDayReport rpt ");
        sql.append(" where rpt.FFundFlowItemID is not null ");
        sql.append(" and rpt.FBizDate >= {ts'" + DateHelper.formatDate2((java.util.Date)filterParam.getStartDate()) + "'}");
        sql.append(" and rpt.FBizDate <= {ts'" + DateHelper.formatDate2((java.util.Date)filterParam.getEndDate()) + "'}");
        sql.append(" group by rpt.FCurrencyID ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
        try {
            if (rs != null) {
                rateMap = new HashMap<String, BigDecimal>();
                while (rs.next()) {
                    String srcCurrencyID = rs.getString("FCurrencyID");
                    if (srcCurrencyID.equals(baseCurrencyID)) {
                        rateMap.put(srcCurrencyID, Constants.ONE);
                        continue;
                    }
                    ExchangeRateInfo erInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(baseExTableID), (IObjectPK)new ObjectUuidPK(srcCurrencyID), (IObjectPK)new ObjectUuidPK(baseCurrencyID), (java.util.Date)filterParam.getEndDate());
                    if (erInfo == null) {
                        logger.error((Object)("srcCurrencyID = " + srcCurrencyID + "not find rate!"));
                        throw new BOSException(EASCommonResource.getString((String)resourcePath, (String)"NoExchange", (Locale)SysContext.getSysContext().getLocale()));
                    }
                    rateMap.put(srcCurrencyID, erInfo.getConvertRate());
                }
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            new BOSException((Throwable)e);
        }
        return rateMap;
    }

    private MerageUnitTreeInfo getMerageUnitTreeInfo(String mergeTreeId) throws EASBizException, BOSException {
        Date endDate = this.filterParam.getEndDate();
        if (mergeTreeId != null) {
            return MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeInfo((IObjectPK)new ObjectUuidPK(mergeTreeId));
        }
        return null;
    }

    private BigDecimal getMergeAount(Map rateMap, String currencyId, BigDecimal amount) {
        BigDecimal mergeAmount = amount;
        if (rateMap != null && rateMap.size() > 0 && rateMap.containsKey(currencyId)) {
            mergeAmount = amount.multiply((BigDecimal)rateMap.get(currencyId));
        }
        return mergeAmount;
    }

    private void setCurrencyColumnFmt(IColumn column, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        column.getStyleAttributes().setNumberFormat(numberFtm);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

