/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.mnt.BillTypeEnum;
import com.kingdee.eas.fm.mnt.RptOverdueOperationWarnAnalyseFilterParam;
import com.kingdee.eas.fm.mnt.client.IRptOverdueOperationWarnAnalyseHandler;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class RptOverdueOperationWarnAnalyseHandlerBase
implements IRptOverdueOperationWarnAnalyseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.fin.client.OverdueOperationWarnAnalyseResource";
    protected RptOverdueOperationWarnAnalyseFilterParam filterParam = null;
    protected KDTable kdt = null;
    protected BigDecimal LocalBalanceAmountTotal = SysConstant.BIGZERO;
    protected int amountUnit;
    protected long DateDiff;
    protected Date dateDays;

    public RptOverdueOperationWarnAnalyseHandlerBase(RptOverdueOperationWarnAnalyseFilterParam param, KDTable kdt) {
        this.filterParam = param;
        this.kdt = kdt;
        this.dateDays = param.getDate();
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.mnt.app.RptFallInOperationWarnAnalyseQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterParam.getFilter());
        ev.getSorter().addObjectCollection((IObjectCollection)this.filterParam.getSorterItems());
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    protected void initHeadRows() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("TypeID").setValue((Object)this.getResString("TypeID"));
        headRow.getCell("BillType").setValue((Object)this.getResString("BillType"));
        headRow.getCell("BillNumber").setValue((Object)this.getResString("BillNumber"));
        headRow.getCell("ExpiredDate").setValue((Object)this.getResString("ExpiredDate"));
        headRow.getCell("OverDueDate").setValue((Object)this.getResString("OverDueDate"));
        headRow.getCell("CompanyName").setValue((Object)this.getResString("CompanyName"));
        headRow.getCell("BankName").setValue((Object)this.getResString("BankName"));
        headRow.getCell("BankAccount").setValue((Object)this.getResString("BankAccount"));
        headRow.getCell("Currency").setValue((Object)this.getResString("Currency"));
        headRow.getCell("BalanceAmount").setValue((Object)this.getResString("BalanceAmount"));
        headRow.getCell("LocalBalanceAmount").setValue((Object)this.getResString("LocalBalanceAmount"));
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.amountUnit = this.filterParam.getUnit().getValue();
        this.LocalBalanceAmountTotal = SysConstant.BIGZERO;
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            this.LocalBalanceAmountTotal = this.LocalBalanceAmountTotal.add(rs.getBigDecimal("LocalAmount").divide(new BigDecimal(this.amountUnit), 10, 4));
            row.getCell("TypeID").setValue((Object)rs.getString("FTypeID"));
            if (rs.getString("BillName").equals("14") || rs.getString("BillName").equals("9")) {
                row.getCell("BillType").setValue((Object)TimeDepositTypeEnum.getEnum((String)rs.getString("LGTypeName")).getAlias(SysContext.getSysContext().getLocale()));
            } else if (rs.getString("BillName").equals("6")) {
                row.getCell("BillType").setValue((Object)BillTypeEnum.bankFactor.getAlias(SysContext.getSysContext().getLocale()));
            } else {
                row.getCell("BillType").setValue((Object)rs.getString("LGTypeName"));
            }
            row.getCell("BillNumber").setValue((Object)rs.getString("LGNumber"));
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                row.getCell("ExpiredDate").setValue((Object)dtformat.format(df.parse(rs.getString("ExpiredDate"))));
            }
            catch (ParseException e) {
                Logger.error((Throwable)e, (String)e.getMessage());
            }
            Date queryDate = DateUtil.getDayBegin((Date)this.dateDays);
            Date expiredDate = DateUtil.getDayBegin((Date)rs.getDate("ExpiredDate"));
            this.DateDiff = DateUtil.dateDiff((Date)expiredDate, (Date)queryDate) / 86400000L;
            row.getCell("OverDueDate").setValue((Object)new BigDecimal(this.DateDiff));
            row.getCell("CompanyName").setValue((Object)rs.getString("CompanyName"));
            row.getCell("BankName").setValue((Object)rs.getString("InstitutionName"));
            row.getCell("BankAccount").setValue((Object)rs.getString("BankAccount"));
            row.getCell("Currency").setValue((Object)rs.getString("Currencyname"));
            row.getCell("BalanceAmount").setValue((Object)rs.getBigDecimal("BalanceAmount").divide(new BigDecimal(this.amountUnit), 10, 4));
            row.getCell("LocalBalanceAmount").setValue((Object)rs.getBigDecimal("LocalAmount").divide(new BigDecimal(this.amountUnit), 10, 4));
            row.setUserObject((Object)rs.getString("LGID"));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    @Override
    public void mergedFlowRow() {
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            String GetCellValue;
            if (i < 1 || (GetCellValue = (String)this.kdt.getRow(i).getCell("TypeID").getValue()) != null) continue;
            String CellBlValue = (String)this.kdt.getRow(i - 1).getCell("TypeID").getValue();
            String CellValueTotal = (String)this.kdt.getRow(i).getCell("BankAccount").getValue();
            if (!CellValueTotal.equals(this.getResString("SubTotalLocalBalanceAmount"))) continue;
            if ("1".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 9);
                this.kdt.getRow(i).getCell("BillType").setValue((Object)this.getResString("SubTotalLocalBalanceAmount1"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.kdt.getRow(i).getCell("LocalBalanceAmount").getStyleAttributes().setBackground(new Color(16119270));
            }
            if ("2".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 9);
                this.kdt.getRow(i).getCell("BillType").setValue((Object)this.getResString("SubTotalLocalBalanceAmount2"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.kdt.getRow(i).getCell("LocalBalanceAmount").getStyleAttributes().setBackground(new Color(16119270));
            }
            if ("3".equals(CellBlValue)) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 9);
                this.kdt.getRow(i).getCell("BillType").setValue((Object)this.getResString("SubTotalLocalBalanceAmount3"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.kdt.getRow(i).getCell("LocalBalanceAmount").getStyleAttributes().setBackground(new Color(16119270));
            }
            if (!"4".equals(CellBlValue)) continue;
            this.kdt.getMergeManager().mergeBlock(i, 1, i, 9);
            this.kdt.getRow(i).getCell("BillType").setValue((Object)this.getResString("SubTotalLocalBalanceAmount4"));
            this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            this.kdt.getRow(i).getCell("LocalBalanceAmount").getStyleAttributes().setBackground(new Color(16119270));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        Object[][] dd = new Object[][]{new Object[this.kdt.getRowCount()], new Object[this.kdt.getRowCount()]};
        int n = dd[0].length;
        for (int i = 0; i < n; ++i) {
            dd[0][i] = this.kdt.getCell(i, 1).getValue();
            dd[1][i] = this.kdt.getCell(i, 2).getValue();
        }
        List mergeList = CellMatrix.parseAutoMatchMergeRegion((Object[][])dd, (boolean)true, (boolean)false, (boolean)false);
        int n2 = mergeList.size();
        for (int i = 0; i < n2; ++i) {
            int[] r = (int[])mergeList.get(i);
            this.kdt.getMergeManager().mergeBlock(r[0], r[1] + 1, r[2], r[3] + 1);
        }
    }

    @Override
    public void insertAbsractFlowRow() {
        String text = this.getResString("AllBalanceAmountTotal");
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell("LocalBalanceAmount").setValue((Object)this.LocalBalanceAmountTotal);
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 1, r, 9);
        row.getCell(1).setValue((Object)text);
        row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }
}

