/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mnt.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.mnt.DataSourceSettingCollection;
import com.kingdee.eas.fm.mnt.DataSourceSettingFactory;
import com.kingdee.eas.fm.mnt.DataSourceSettingInfo;
import com.kingdee.eas.fm.mnt.DcDirection;
import com.kingdee.eas.fm.mnt.FundFlowDayReportInfo;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleCollection;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleFactory;
import com.kingdee.eas.fm.mnt.FundFlowItemMapRuleInfo;
import com.kingdee.eas.fm.mnt.IDataSourceSetting;
import com.kingdee.eas.fm.mnt.IMerageUnit;
import com.kingdee.eas.fm.mnt.IMerageUnitTree;
import com.kingdee.eas.fm.mnt.MerageUnitCollection;
import com.kingdee.eas.fm.mnt.MerageUnitFactory;
import com.kingdee.eas.fm.mnt.MerageUnitInfo;
import com.kingdee.eas.fm.mnt.MerageUnitTreeCollection;
import com.kingdee.eas.fm.mnt.MerageUnitTreeFactory;
import com.kingdee.eas.fm.mnt.MerageUnitTreeInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MNTUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mnt.utils.MNTUtils");
    public static final String START_BALANCE_FLOW_ID = "lVIAAAAqMMlggo5y";

    public static DataSourceSettingInfo getDataSourceSetting(Context ctx, String cuId) throws BOSException, EASBizException {
        DataSourceSettingInfo info = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IDataSourceSetting iDataSourceSetting = null;
        iDataSourceSetting = ctx != null ? DataSourceSettingFactory.getLocalInstance(ctx) : DataSourceSettingFactory.getRemoteInstance();
        DataSourceSettingCollection colls = iDataSourceSetting.getDataSourceSettingCollection(view);
        if (colls != null && colls.size() > 0) {
            info = colls.get(0);
            return info;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.id"));
        CompanyOrgUnitInfo company = null;
        company = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector) : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
        if (company != null && company.getParent() != null) {
            info = MNTUtils.getDataSourceSetting(ctx, company.getParent().getId().toString());
        }
        return info;
    }

    public static String getNumberRule(Context ctx, IObjectValue info, String companyId) throws BOSException, EASBizException {
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        codingRuleManager = ctx != null ? CodingRuleManagerFactory.getLocalInstance((Context)ctx) : CodingRuleManagerFactory.getRemoteInstance();
        boolean hasRule = codingRuleManager.isExist(info, companyId);
        if (hasRule) {
            number = codingRuleManager.getNumber(info, companyId);
        }
        return number;
    }

    public static FundFlowItemInfo getFundFlowItem(Context ctx, FundFlowDayReportInfo info) throws BOSException {
        FundFlowItemInfo ffiInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("payerAcctBank.id"));
        sic.add(new SelectorItemInfo("payeeAcctBank.id"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)info.getBizType().getValue()));
        view.setFilter(filter);
        FundFlowItemMapRuleCollection coll = FundFlowItemMapRuleFactory.getLocalInstance(ctx).getFundFlowItemMapRuleCollection(view);
        if (coll.size() > 0) {
            String payeeAcctBankID;
            FundFlowItemMapRuleInfo rule = coll.get(0);
            String payerAcctBankID = rule.getPayerAcctBank() != null ? rule.getPayerAcctBank().getId().toString() : "";
            String string = payeeAcctBankID = rule.getPayeeAcctBank() != null ? rule.getPayeeAcctBank().getId().toString() : "";
            if (info.getDcDirection() == DcDirection.debit && info.getAccountBank() != null && payerAcctBankID.equals(info.getAccountBank().getId().toString())) {
                ffiInfo = coll.get(0).getFundFlowItem();
            }
            if (info.getDcDirection() == DcDirection.credit && info.getAccountBank() != null && payeeAcctBankID.equals(info.getAccountBank().getId().toString())) {
                ffiInfo = coll.get(0).getFundFlowItem();
            }
        }
        return ffiInfo;
    }

    public static Map<String, FundFlowItemInfo> getFlowItemMatchMap(Context ctx, Set<String> companyIds, String bizType) throws BOSException {
        HashMap<String, FundFlowItemInfo> matchMap = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("payerAcctBank.id"));
        sic.add(new SelectorItemInfo("payeeAcctBank.id"));
        sic.add(new SelectorItemInfo("payeeAcctBankStr"));
        sic.add(new SelectorItemInfo("payerAcctBankStr"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)new Integer(1)));
        if (!"-2".equals(bizType)) {
            filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)bizType));
        } else {
            HashSet<String> typeSet = new HashSet<String>();
            typeSet.add("0");
            typeSet.add("1");
            typeSet.add("3");
            typeSet.add("4");
            filter.getFilterItems().add(new FilterItemInfo("bizType", typeSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        FundFlowItemMapRuleCollection colls = FundFlowItemMapRuleFactory.getLocalInstance(ctx).getFundFlowItemMapRuleCollection(view);
        if (colls.size() > 0) {
            matchMap = new HashMap<String, FundFlowItemInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                String k2;
                String k1;
                FundFlowItemMapRuleInfo rule = colls.get(i);
                String key = rule.getCompany().getId().toString() + rule.getBizType().getValue();
                FundFlowItemInfo value = rule.getFundFlowItem();
                String payerAccId = null;
                payerAccId = rule.getPayerAcctBank() != null ? rule.getPayerAcctBank().getId().toString() : rule.getPayerAcctBankStr();
                if (payerAccId != null && !matchMap.containsKey(k1 = key + payerAccId)) {
                    matchMap.put(k1, value);
                }
                String payeeAccId = null;
                payeeAccId = rule.getPayeeAcctBank() != null ? rule.getPayeeAcctBank().getId().toString() : rule.getPayeeAcctBankStr();
                if (payeeAccId == null || matchMap.containsKey(k2 = key + payeeAccId)) continue;
                matchMap.put(k2, value);
            }
        }
        return matchMap;
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, String companyName, Map<String, List<String>> aliasMap) throws BOSException {
        CompanyOrgUnitInfo company = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)companyName, CompareType.EQUALS));
        view.setFilter(filter);
        CompanyOrgUnitCollection colls = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
            company = colls.get(0);
        } else {
            for (Map.Entry<String, List<String>> entry : aliasMap.entrySet()) {
                List<String> lst = entry.getValue();
                if (lst == null || lst.size() <= 0) continue;
                for (String name : lst) {
                    if (!name.equals(companyName)) continue;
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)entry.getKey()));
                    return company;
                }
            }
        }
        return company;
    }

    public static StringBuffer getCompanyIdByGroup(String hbId, StringBuffer comIds) {
        if (hbId == null || hbId.length() == 0) {
            return comIds;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)hbId));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("company.id"));
            sc.add(new SelectorItemInfo("company.number"));
            sc.add(new SelectorItemInfo("company.name"));
            view.setFilter(filter);
            view.setSelector(sc);
            MerageUnitCollection mc = MerageUnitFactory.getRemoteInstance().getMerageUnitCollection(view);
            if (mc != null && mc.size() > 0) {
                for (int j = 0; j < mc.size(); ++j) {
                    MerageUnitInfo unit = mc.get(j);
                    if (unit == null || unit.getCompany() == null) continue;
                    comIds.append("'" + unit.getCompany().getId() + "'");
                    comIds.append(",");
                }
            }
            MerageUnitTreeCollection muc = MerageUnitTreeFactory.getRemoteInstance().getMerageUnitTreeCollection(" select id where parent.id= '" + hbId + "'");
            for (int i = 0; muc != null && i < muc.size(); ++i) {
                MerageUnitTreeInfo unit = muc.get(i);
                String id = unit.getId().toString();
                MNTUtils.getCompanyIdByGroup(id, comIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comIds;
    }

    public static Set<String> getMergeOrgID(Context ctx, String treeId, Set<String> orgIds) throws BOSException, EASBizException {
        if (orgIds == null) {
            orgIds = new HashSet<String>();
        }
        IMerageUnit iMerageUnit = null;
        iMerageUnit = ctx != null ? MerageUnitFactory.getLocalInstance(ctx) : MerageUnitFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)treeId));
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("company.name"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sc);
        MerageUnitCollection coll = iMerageUnit.getMerageUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            MerageUnitInfo unit = coll.get(i);
            if (unit.getCompany() == null) continue;
            orgIds.add(unit.getCompany().getId().toString());
        }
        String sql = "select FID from T_MNT_MerageUnitTree where FParentID = '" + treeId + "'";
        ISQLExecutor iSQLExecutor = null;
        iSQLExecutor = ctx != null ? SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql) : SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = iSQLExecutor.executeSQL();
        try {
            while (rs.next()) {
                String fid = rs.getString("FID");
                MNTUtils.getMergeOrgID(ctx, fid, orgIds);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orgIds;
    }

    public static StringBuffer getMergeUnitIdByGroup(Context ctx, String hbId, StringBuffer mergeUnitIds) {
        if (hbId == null || hbId.length() == 0) {
            return mergeUnitIds;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)hbId));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            view.setFilter(filter);
            view.setSelector(sc);
            IMerageUnit mergeUnit = null;
            mergeUnit = ctx == null ? MerageUnitFactory.getRemoteInstance() : MerageUnitFactory.getLocalInstance(ctx);
            MerageUnitCollection mc = mergeUnit.getMerageUnitCollection(view);
            if (mc != null && mc.size() > 0) {
                for (int j = 0; j < mc.size(); ++j) {
                    MerageUnitInfo unit = mc.get(j);
                    if (unit == null || unit.getId() == null) continue;
                    mergeUnitIds.append("'" + unit.getId() + "'");
                    mergeUnitIds.append(",");
                }
            }
            IMerageUnitTree mergeUnitTree = null;
            mergeUnitTree = ctx == null ? MerageUnitTreeFactory.getRemoteInstance() : MerageUnitTreeFactory.getLocalInstance(ctx);
            MerageUnitTreeCollection muc = mergeUnitTree.getMerageUnitTreeCollection(" select id where parent.id= '" + hbId + "'");
            for (int i = 0; muc != null && i < muc.size(); ++i) {
                MerageUnitTreeInfo tree = muc.get(i);
                String id = tree.getId().toString();
                MNTUtils.getMergeUnitIdByGroup(ctx, id, mergeUnitIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mergeUnitIds;
    }

    public static String idListToInClause(List<String> idList) {
        StringBuffer sb = new StringBuffer();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append("'" + idList.get(0) + "'");
        } else {
            Iterator<String> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append("'" + it.next() + "'").append(", ");
            }
            sb.append("'" + it.next() + "'");
        }
        return sb.toString();
    }
}

