/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.eas.fm.mobile.util.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class BigDecimalUtil {
    public static BigDecimal makeData(BigDecimal number) {
        if (BigDecimalUtils.isNullOrZero(number)) {
            return BigDecimal.ZERO;
        }
        try {
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            double fudu = Double.parseDouble(number.toString()) * 0.1;
            double value = rand.nextDouble() * fudu * 2.0 - fudu;
            return number.add(new BigDecimal((long)(value * 100.0)).divide(new BigDecimal(100), RoundingMode.HALF_UP));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }
}

