/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.util.TimestampSetUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.util.DateUtil");

    public static Date truncate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date makeDate(String strDate) throws FMMobileException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMMobileException(FMMobileException.COMMON, e, new Object[]{e.getMessage()});
        }
    }

    public static String formatDate(Date bizDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(bizDate);
    }

    public static String formatDateTime(Date bizDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return df.format(bizDate);
    }

    public static String getNow() {
        return DateUtils.formatDateTime(new Date());
    }

    public static Date getPrevTwoMonth() {
        TimestampSetUtil timestampSetUtil = new TimestampSetUtil(new Date());
        return timestampSetUtil.getBeforeMonth(-2);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        return month / 3 + 1;
    }

    public static int getWeekendCount(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month + 1, 1);
        cal.add(5, -1);
        return DateUtils.getWeekendCount(cal.getTime());
    }

    public static int getWeekendCount(Date date) {
        TimestampSetUtil timestampSetUtil = new TimestampSetUtil(date);
        return timestampSetUtil.getDaysWithWeekOfMonth().size();
    }

    public static String getYearType(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Calendar when = Calendar.getInstance();
        when.setTime(date);
        when.set(cal.get(1), 6, 1);
        return cal.before(when) ? "FIRST_HALF_YEAR" : "SECOND_HALF";
    }

    public static int getAPeriodOfTenDaysType(Date date) {
        return Math.min((DateUtils.getDay(date) - 1) / 10, 2);
    }

    public static int getWeekOfYearCountFixed(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 11, 31);
        return DateUtils.getWeekOfYearCountFixed(DateUtils.truncate(cal.getTime()));
    }

    public static int getWeekOfYearCountFixed(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfYear = cal.get(6) - 1;
        cal.set(cal.get(1), 0, 1);
        int dayOfWeek = cal.get(7) - 1;
        return (dayOfYear + dayOfWeek) / 7 + 1;
    }

    public static Date getLastDayWithMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getThisMonthBegin(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return DateUtils.truncate(cal.getTime());
    }
}

