/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.mobile.FMMobileException;
import com.kingdee.eas.fm.mobile.app.message.ImageMessageAdapter;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageBuilderType;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageCollection;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageFactory;
import com.kingdee.eas.fm.mobile.app.message.MobileMessageInfo;
import com.kingdee.eas.fm.mobile.app.message.TextMessageAdapter;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceFacade;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class XuntHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.util.XuntHelper");
    private final Context ctx;
    private String pubaccConfigName;
    private final String requestBuilderType;

    public XuntHelper(Context ctx, String pubaccConfigName, String requestBuilderType) {
        this.ctx = ctx;
        this.pubaccConfigName = pubaccConfigName;
        this.requestBuilderType = requestBuilderType;
    }

    public MobileMessageCollection sendMessage() throws EASBizException, BOSException {
        if (StringUtil.isEmpty(this.pubaccConfigName)) {
            this.pubaccConfigName = "XT_FM_MOBILE";
        }
        String permItemName = "CAPITAL_INSIGHT_USE";
        MobileMessageCollection messages = this.getMobileMessageCollection(this.ctx, this.requestBuilderType);
        for (MobileMessageInfo mobileMessageInfo : messages) {
            List<String> personIDs;
            BOSUuid orgID = mobileMessageInfo.getCompany().getId();
            if (orgID == null) {
                logger.error((Object)String.format("MobileMessage no org ID,send Xunt fail!ID is [%s]!", mobileMessageInfo.getId()));
                continue;
            }
            Collection userIDs = PermissionFactory.getLocalInstance((Context)this.ctx).getAuthorizedUsers((IObjectPK)new ObjectUuidPK(orgID), "CAPITAL_INSIGHT_USE");
            try {
                personIDs = this.getRelationPersonIDs(userIDs);
            }
            catch (SQLException e) {
                logger.error((Object)String.format("\u5c06userID\u8f6c\u6362\u4e3apersonID\u51fa\u9519\uff01\u5177\u4f53\u539f\u56e0\u4e3a\uff1a[%s]", e.getMessage()), (Throwable)e);
                continue;
            }
            this.send(this.pubaccConfigName, mobileMessageInfo.getTitle(), mobileMessageInfo.getDetail(), mobileMessageInfo.getImgText(), mobileMessageInfo.getBuilderType(), personIDs);
        }
        return messages;
    }

    private List<String> getRelationPersonIDs(Collection userIDs) throws BOSException, SQLException {
        String[] userIDArray = userIDs.toArray(new String[0]);
        String sql = "select fpersonid from t_pm_user where fid in " + FMHelper.Array2String((String[])userIDArray);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(rs.getString("fpersonid"));
        }
        return result;
    }

    private MobileMessageCollection getMobileMessageCollection(Context ctx, String builderType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("title");
        selectors.add("detail");
        selectors.add("builderType");
        selectors.add("imgText");
        selectors.add("company.id");
        view.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("builderType", (Object)(builderType + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSendXunt", (Object)false));
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.getSorter().add(new SorterItemInfo("createTime"));
        view.setSorter(sorter);
        MobileMessageCollection mobileMessageCollection = MobileMessageFactory.getLocalInstance((Context)ctx).getMobileMessageCollection(view);
        return mobileMessageCollection;
    }

    private void send(String pubAcctName, String title, String summary, String imgText, MobileMessageBuilderType builderType, List<String> personIDs) throws FMMobileException {
        IMessageAdapter adapter = this.createMessageAdapter(title, summary, imgText, builderType, personIDs);
        boolean isPushSuccessed = XTServiceFacade.pushMessage((Context)this.ctx, (IMessageAdapter)adapter, (String)pubAcctName);
        if (!isPushSuccessed) {
            throw new FMMobileException(FMMobileException.COMMON, new Object[]{String.format("\u8baf\u901a\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\u516c\u4f17\u53f7\uff1a[%s]\uff0c\u6807\u9898\uff1a[%s]\uff0c\u5185\u5bb9\uff1a[%s]\uff0c\u7528\u6237\u5217\u8868\uff1a[%s]", this.pubaccConfigName, title, summary, Arrays.toString((Object[])personIDs.toArray(new String[0])))});
        }
    }

    private IMessageAdapter createMessageAdapter(String title, String summary, String imgText, MobileMessageBuilderType builderType, List<String> personIDs) {
        if (StringUtil.isEmpty(imgText)) {
            return new TextMessageAdapter(title, summary, personIDs);
        }
        return new ImageMessageAdapter(title, summary, imgText, builderType, personIDs);
    }

    public void modifyStatus(MobileMessageCollection mobileMessageCollection) throws BOSException {
        if (mobileMessageCollection == null || mobileMessageCollection.size() == 0) {
            return;
        }
        String filter = FMHelper.coll2String((IObjectCollection)mobileMessageCollection);
        String sql = "update T_FMM_MobileMessage set FIsSendXunt = ? where FID IN " + filter;
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{true});
    }

    public static void modifyOldStatus(Context ctx, String requestBuilderType) throws BOSException {
        String sql = "update T_FMM_MobileMessage set FIsSendXunt = ? where FBuilderType like '" + requestBuilderType + "%'";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{true});
    }
}

