/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.fm.mobile.util.period.APeriodOfTenDaysPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.CustomPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.DayPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.HarfAYearPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.MonthPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.NonePeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.QuarterPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.WeekOfYearPeriodFilter;
import com.kingdee.eas.fm.mobile.util.period.YearPeriodFilter;
import java.util.Date;

public class PeriodFilterFactory {
    private String periodSolution;
    private Date date;

    public PeriodFilterFactory(String periodSolution, Date currentDate) {
        this.periodSolution = periodSolution;
        this.date = currentDate;
    }

    public PeriodFilter makePeriodFilter() {
        if (StringUtil.isEmpty(this.periodSolution)) {
            return new NonePeriodFilter();
        }
        if ("YEAR".equals(this.periodSolution)) {
            return new YearPeriodFilter(this.date);
        }
        if ("HALF_A_YEAR".equals(this.periodSolution)) {
            return new HarfAYearPeriodFilter(this.date);
        }
        if ("QUARTER".equals(this.periodSolution)) {
            return new QuarterPeriodFilter(this.date);
        }
        if ("MONTH".equals(this.periodSolution)) {
            return new MonthPeriodFilter(this.date);
        }
        if ("A_PERIOD_OF_TEN_DAYS".equals(this.periodSolution)) {
            return new APeriodOfTenDaysPeriodFilter(this.date);
        }
        if ("WEEK".equals(this.periodSolution)) {
            return new WeekOfYearPeriodFilter(this.date);
        }
        if ("DAY".equals(this.periodSolution)) {
            return new DayPeriodFilter(this.date);
        }
        return new NonePeriodFilter();
    }

    public PeriodFilter makeCustomPeriodFilter(Date beginDate, Date endDate) {
        return new CustomPeriodFilter(beginDate, endDate);
    }
}

