/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import java.util.Date;

public class QuarterPeriodFilter
implements PeriodFilter {
    private final int year;
    private final int quarter;
    private int currentYear;
    private int currentQuarter;

    public QuarterPeriodFilter(Date date) {
        this.year = DateUtils.getYear(date);
        this.quarter = DateUtils.getQuarter(date);
        this.currentYear = this.year;
        this.currentQuarter = this.quarter;
    }

    @Override
    public String getText() {
        return String.format("%d\u5e74\u7b2c%d\u5b63\u5ea6", this.currentYear, this.currentQuarter);
    }

    @Override
    public boolean hasNext() {
        return this.year != this.currentYear || this.quarter != this.currentQuarter;
    }

    @Override
    public void previous() {
        --this.currentQuarter;
        if (this.currentQuarter < 1) {
            --this.currentYear;
            this.currentQuarter = 4;
        }
    }

    @Override
    public void next() {
        ++this.currentQuarter;
        if (this.currentQuarter > 4) {
            ++this.currentYear;
            this.currentQuarter = 1;
        }
    }

    @Override
    public String getURLParameters() {
        return null;
    }
}

