/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import java.util.Date;

public class WeekOfMonthPeriodFilter
implements PeriodFilter {
    private final int year;
    private final int month;
    private final int weekOfMonth;
    private int currentYear;
    private int currentMonth;
    private int currentWeekOfMonth;
    private int calResultWeekOfMonth;

    public WeekOfMonthPeriodFilter(Date date) {
        this.year = DateUtils.getYear(date);
        this.month = DateUtils.getMonth(date);
        this.weekOfMonth = DateUtils.getWeekendCount(date);
        this.currentYear = this.year;
        this.currentMonth = this.month;
        this.currentWeekOfMonth = this.weekOfMonth;
        this.calResultWeekOfMonth = this.weekOfMonth;
    }

    @Override
    public String getText() {
        return String.format("%d\u5e74%d\u6708\u7b2c%d\u5468", this.currentYear, this.currentMonth + 1, this.currentWeekOfMonth);
    }

    @Override
    public boolean hasNext() {
        return this.year != this.currentYear || this.month != this.currentMonth || this.weekOfMonth != this.currentWeekOfMonth;
    }

    @Override
    public void previous() {
        --this.currentWeekOfMonth;
        if (this.currentWeekOfMonth <= 0) {
            --this.currentMonth;
            if (this.currentMonth < 0) {
                --this.currentYear;
                this.currentMonth = 11;
            }
            this.currentWeekOfMonth = this.calResultWeekOfMonth = DateUtils.getWeekendCount(this.currentYear, this.currentMonth);
        }
    }

    @Override
    public void next() {
        ++this.currentWeekOfMonth;
        if (this.currentWeekOfMonth > this.calResultWeekOfMonth) {
            ++this.currentMonth;
            if (this.currentMonth > 11) {
                ++this.currentYear;
                this.currentMonth = 0;
            }
            this.calResultWeekOfMonth = DateUtils.getWeekendCount(this.currentYear, this.currentMonth);
            this.currentWeekOfMonth = 1;
        }
    }

    @Override
    public String getURLParameters() {
        return null;
    }
}

