/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period.parsor;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.ValidateUtil;
import com.kingdee.eas.fm.mobile.util.period.parsor.PeriodFilterParsor;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class YearParsor
implements PeriodFilterParsor {
    private final int year;

    private YearParsor(int year) {
        this.year = year;
    }

    public YearParsor(Map bizData) throws EASBizException {
        ValidateUtil.validateParam(bizData, "year");
        this.year = Integer.parseInt((String)bizData.get("year"));
    }

    @Override
    public Date getBeginDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, 0, 1);
        return cal.getTime();
    }

    @Override
    public Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.year, 11, 31);
        if (this.isThisYear()) {
            cal.setTime(DateUtils.truncate(new Date()));
        }
        return cal.getTime();
    }

    private boolean isThisYear() {
        return DateUtils.getYear(new Date()) == this.year;
    }

    @Override
    public PeriodFilterParsor previous() {
        return new YearParsor(this.year - 1);
    }
}

