/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.nt.MoneyUnitEnum;
import com.kingdee.eas.fm.nt.RomanNumberEnum;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class NTDateFormat
extends DateFormat {
    private static final Logger logger = CoreUIObject.getLogger(NTDateFormat.class);

    @Override
    public Date parse(String source, ParsePosition pos) {
        return null;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        toAppendTo.append(this.getCapYear(year));
        toAppendTo.append(this.getUnit("20"));
        int month = cal.get(2);
        toAppendTo.append(this.getCapMonthOrDay(month + 1));
        toAppendTo.append(this.getUnit("30"));
        int day = cal.get(5);
        toAppendTo.append(this.getCapMonthOrDay(day));
        toAppendTo.append(this.getUnit("40"));
        return toAppendTo;
    }

    private String getCapValue(long value) {
        StringBuffer geWeiValue = new StringBuffer();
        long geWei = value - value / 10000L * 10000L;
        if (geWei != 0L) {
            long qian = geWei / 1000L;
            long bai = (geWei - qian * 1000L) / 100L;
            long shi = (geWei - qian * 1000L - bai * 100L) / 10L;
            long ge = geWei - qian * 1000L - bai * 100L - shi * 10L;
            if (qian != 0L) {
                geWeiValue.append(this.getCap(qian));
                geWeiValue.append(this.getUnit("6"));
            }
            if (bai == 0L) {
                if (qian != 0L && (shi != 0L || ge != 0L)) {
                    geWeiValue.append(this.getCap(0L));
                }
            } else {
                geWeiValue.append(this.getCap(bai));
                geWeiValue.append(this.getUnit("5"));
            }
            if (shi == 0L) {
                if (bai != 0L && ge != 0L) {
                    geWeiValue.append(this.getCap(0L));
                }
            } else {
                geWeiValue.append(this.getCap(shi));
                geWeiValue.append(this.getUnit("4"));
            }
            if (ge != 0L) {
                geWeiValue.append(this.getCap(ge));
            }
        }
        if ((value /= 10000L) == 0L) {
            return geWeiValue.toString();
        }
        long wanWei = value - value / 10000L * 10000L;
        String wanWeiValue = this.getCapValue(wanWei);
        if (wanWei == 0L) {
            wanWeiValue = geWeiValue.toString();
        } else {
            if (geWei < 1000L && geWei != 0L) {
                geWeiValue.insert(0, this.getCap(0L));
            }
            wanWeiValue = wanWeiValue + this.getUnit("7") + geWeiValue;
        }
        if ((value /= 10000L) == 0L) {
            return wanWeiValue.toString();
        }
        long yiWei = value;
        String yiWeiValue = this.getCapValue(yiWei);
        if (wanWei < 1000L && wanWei != 0L) {
            wanWeiValue = this.getCap(0L) + wanWeiValue;
        }
        yiWeiValue = yiWeiValue + this.getUnit("8") + wanWeiValue;
        return yiWeiValue;
    }

    private String getUnit(String unit) {
        MoneyUnitEnum unitEnum = MoneyUnitEnum.getEnum(unit);
        return unitEnum.getAlias();
    }

    private String getCapYear(int year) {
        String sYear = "";
        Integer iYear = new Integer(year);
        for (int i = 0; i < iYear.toString().length(); ++i) {
            char digit = iYear.toString().toCharArray()[i];
            String sDigit = new String(new char[]{digit});
            sYear = sYear + this.getCap(new Long(sDigit));
        }
        return sYear;
    }

    private String getCapMonthOrDay(int day) {
        String capValue = this.getCapValue(day);
        if (day <= 10 || day == 20 || day == 30) {
            capValue = this.getCap(0L) + capValue;
        }
        return capValue;
    }

    private String getCap(long digit) {
        RomanNumberEnum cap = RomanNumberEnum.getEnum(new Long(digit).toString());
        return cap.getAlias();
    }
}

