/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.BTPUtil;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.ILetterOfCreditReach;
import com.kingdee.eas.fm.nt.IOprtLog;
import com.kingdee.eas.fm.nt.IOprtLogFacade;
import com.kingdee.eas.fm.nt.LetterOfCreditReachCollection;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.OprtLogCollection;
import com.kingdee.eas.fm.nt.OprtLogFacadeFactory;
import com.kingdee.eas.fm.nt.OprtLogFactory;
import com.kingdee.eas.fm.nt.OprtLogInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.nt.client.CSF7Selector;
import com.kingdee.eas.fm.nt.client.CSF7SelectorSupplier;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class NTHelper {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    public static final String ReceivableBill = "com.kingdee.eas.fm.nt.app.ReceivableBill";
    public static final String DiscountBill = "com.kingdee.eas.fm.nt.app.DiscountBill";
    public static final String EndorsementBill = "com.kingdee.eas.fm.nt.app.EndorsementBill";
    public static final String ReturnBill = "com.kingdee.eas.fm.nt.app.ReturnBill";
    public static final String PayableBill = "com.kingdee.eas.fm.nt.app.PayableBill";
    public static final String PayableApplyBill = "com.kingdee.eas.fm.nt.app.PayableApplyBill";
    public static final String RepaymentBill = "com.kingdee.eas.fm.fin.app.Repayment";
    public static final String ReceivingBill = "com.kingdee.eas.fi.cas.app.ReceivingBill";
    public static final String PayableTransferBill = "com.kingdee.eas.fm.nt.app.PayableTransferBill";
    public static final String BankDraftReq = "com.kingdee.eas.fm.nt.BankDraftReq";
    public static final String BankDraft = "com.kingdee.eas.fm.nt.BankDraft";
    private static final String NT_RES = "com.kingdee.eas.fm.nt.NtResource";

    public static List getAccordReceivableList(Component comp, List srcList, String fieldname, Object conditionObj, String msg) throws Exception {
        String errNumber = "";
        ArrayList<String> descList = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < srcList.size(); ++i) {
            String id = (String)srcList.get(i);
            set.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(fi);
        ReceivableBillCollection colInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        Iterator iter = colInfo.iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo selInfo = (ReceivableBillInfo)iter.next();
            if (conditionObj == null) {
                if (selInfo.get(fieldname) == null) {
                    errNumber = errNumber + selInfo.getNumber() + ",";
                    continue;
                }
                descList.add(selInfo.getId().toString());
                continue;
            }
            if (!selInfo.get(fieldname).toString().equals(conditionObj.toString())) {
                errNumber = errNumber + selInfo.getNumber() + ",";
                continue;
            }
            descList.add(selInfo.getId().toString());
        }
        if (!errNumber.equals("")) {
            errNumber = errNumber.substring(0, errNumber.length() - 1);
            MsgBox.showWarning((Component)comp, (String)(msg + ":\n" + errNumber));
        }
        return descList;
    }

    public static void setF7AccountEvi(IUIObject owner, String currencyId, CompanyOrgUnitInfo currentCompany, KDBizPromptBox prmtOppAccount) throws EASBizException, BOSException {
        String companyId = currentCompany.getId().toString();
        String cuId = currentCompany.getCU().getId().toString();
        prmtOppAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        AccountPromptBox opseelect = new AccountPromptBox(owner, currentCompany, treeevi.getFilter(), false, true);
        prmtOppAccount.setSelector((KDPromptSelector)opseelect);
        prmtOppAccount.setEntityViewInfo(evi);
    }

    public static void OnWaybgCtrl(Context ctx, String billId) throws BOSException, EASBizException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(billId));
    }

    public static void updateFpItem(Context ctx, IObjectPK pk, String handleName) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
    }

    public static void cancelFpItem(Context ctx, String sId) throws EASBizException, BOSException {
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(sId));
    }

    public static void initCSF7Filter(IUIObject editUI, KDBizPromptBox prompt, String sInfo) {
        ExtendParser parser = new ExtendParser(prompt);
        prompt.setCommitParser((IParser)parser);
        prompt.setEditable(true);
        prompt.setDisplayFormat("$name$");
        prompt.setEditFormat("$name$");
        prompt.setCommitFormat("$number$");
        prompt.setQueryInfo(sInfo);
        CSF7Selector arg0 = new CSF7Selector(editUI, prompt);
        prompt.setSelector((KDPromptSelector)arg0);
        prompt.setEntityViewInfo(NTHelper.getCSF7ViewInfoFilter());
    }

    public static EntityViewInfo getCSF7ViewInfoFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FusedStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        view.setFilter(filter);
        return view;
    }

    public static void initCSF7(IUIObject editUI, KDBizPromptBox prompt, String sInfo) {
        prompt.setEditable(true);
        prompt.setDisplayFormat("$name$");
        prompt.setEditFormat("$number$");
        prompt.setCommitFormat("$number$");
        prompt.setQueryInfo(sInfo);
        CSF7Selector arg0 = new CSF7Selector(editUI, prompt);
        prompt.setSelector((KDPromptSelector)arg0);
        prompt.setEntityViewInfo(NTHelper.getCSF7ViewInfoStr());
    }

    public static void initCSF7Supplier(IUIObject editUI, KDBizPromptBox prompt, String sInfo) {
        prompt.setEditable(true);
        prompt.setDisplayFormat("$name$");
        prompt.setEditFormat("$number$");
        prompt.setCommitFormat("$number$");
        prompt.setQueryInfo(sInfo);
        CSF7SelectorSupplier arg0 = new CSF7SelectorSupplier(editUI, prompt);
        prompt.setSelector((KDPromptSelector)arg0);
        prompt.setEntityViewInfo(NTHelper.getCSF7ViewInfo());
    }

    public static void initCSF7(IUIObject editUI, KDBizPromptBox prompt, String sInfo, EntityViewInfo view) {
        ExtendParser parser = new ExtendParser(prompt);
        prompt.setCommitParser((IParser)parser);
        prompt.setEditable(true);
        prompt.setDisplayFormat("$name$");
        prompt.setEditFormat("$name$");
        prompt.setCommitFormat("$number$");
        prompt.setQueryInfo(sInfo);
        CSF7Selector arg0 = new CSF7Selector(editUI, prompt);
        prompt.setSelector((KDPromptSelector)arg0);
        prompt.setEntityViewInfo(view);
    }

    public static EntityViewInfo getCSF7ViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        view.setFilter(filter);
        return view;
    }

    public static EntityViewInfo getCSF7ViewInfoStr() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FusedStatus", (Object)new Integer(1)));
        view.setFilter(filter);
        return view;
    }

    public static void initAccountBankPromt(KDBizPromptBox prompt) {
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        FilterInfo filter = null;
        filter = prompt.getEntityViewInfo() != null ? prompt.getEntityViewInfo().getFilter() : new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        prompt.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bank.*");
        sic.add("currency.*");
        sic.add("account.*");
        prompt.setSelectorCollection(sic);
    }

    public static void initAccountBankPromt(KDBizPromptBox prompt, int property) {
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        FilterInfo filter = null;
        filter = prompt.getEntityViewInfo() != null ? prompt.getEntityViewInfo().getFilter() : new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)property));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        prompt.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bank.*");
        sic.add("currency.*");
        prompt.setSelectorCollection(sic);
    }

    public static void initAccountBankF7IncludeEDShared(KDBizPromptBox prmt, String curentCompId, int property) throws BOSException {
        Set<String> sharedAcctSet;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = null;
        fi = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo().getFilter() : new FilterInfo();
        if (curentCompId != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)curentCompId));
        }
        fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        if (property != -1) {
            fi.getFilterItems().add(new FilterItemInfo("property.property", (Object)property));
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet = NTHelper.getSharedAcctSet(curentCompId))) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (property != -1) {
                fi.setMaskString("(#0 or #3) and #1 and #2 ");
            } else {
                fi.setMaskString("(#0 or #2) and #1 ");
            }
        }
        evi.setFilter(fi);
        prmt.setEntityViewInfo(evi);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("bank.*");
        selector.add("currency.*");
        prmt.setSelectorCollection(selector);
    }

    public static Set<String> getSharedAcctSet(String curentCompId) throws BOSException {
        HashSet<String> sharedAcctSet = new HashSet<String>();
        String sql = "SELECT head.FBankAccountID FROM T_BD_SharedAcct head LEFT JOIN T_BD_SharedAcctEntries entries ON entries.FParentID = head.FID WHERE head.FShareType IN (2,3) AND entries.FSharedCompanyID = '" + curentCompId + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        try {
            while (rs.next()) {
                sharedAcctSet.add(rs.getString("FBankAccountID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sharedAcctSet;
    }

    public static boolean reRecAccount(Context ctx, ReceivableBillInfo receivableInfo, EndorsementBillInfo endorsementInfo, ReturnBillInfo returnInfo, boolean isNotAuto) throws BOSException, EASBizException {
        boolean flag = false;
        if (returnInfo.getSrcBillState() == 1 || returnInfo.getSrcBillState() == 8) {
            NTBookHelper.bookOppositeSubsidiary(ctx, receivableInfo.getId().toString(), returnInfo.getId().toString(), returnInfo.getReturnDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"385_NTHelper", (Locale)ctx.getLocale()));
        } else if (returnInfo.getSrcBillState() == 7 && endorsementInfo != null) {
            BigDecimal debitAmount = receivableInfo.getBillAmt().multiply(Constants.ONE.subtract(endorsementInfo.getFeeRate()));
            NTBookHelper.bookOppositeSubsidiary(ctx, endorsementInfo.getId().toString(), returnInfo.getId().toString(), returnInfo.getReturnDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"382_NTBookHelper", (Locale)ctx.getLocale()), debitAmount, Constants.ZERO);
        }
        if (isNotAuto || NTHelper.getParam4Boolean(ctx, "NT015", false) && !NTHelper.getParam4Boolean(ctx, "NT014", false)) {
            flag = NTBookHelper.bookOppositeJournal(ctx, receivableInfo, returnInfo);
        }
        return flag;
    }

    public static boolean reRecAccountNew(Context ctx, ReceivableBillInfo receivableInfo, EndorsementBillInfo endorsementInfo, ReturnBillInfo returnInfo, boolean isNotAuto, boolean isReceiving) throws BOSException, EASBizException {
        boolean flag = false;
        if (returnInfo.getSrcBillState() == 1 || returnInfo.getSrcBillState() == 8) {
            NTBookHelper.bookOppositeSubsidiary(ctx, receivableInfo.getId().toString(), returnInfo.getId().toString(), returnInfo.getReturnDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"385_NTHelper", (Locale)ctx.getLocale()));
        } else if (returnInfo.getSrcBillState() == 7 && endorsementInfo != null) {
            BigDecimal debitAmount = receivableInfo.getBillAmt().multiply(Constants.ONE.subtract(endorsementInfo.getFeeRate()));
            NTBookHelper.bookOppositeSubsidiary(ctx, endorsementInfo.getId().toString(), returnInfo.getId().toString(), returnInfo.getReturnDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"382_NTBookHelper", (Locale)ctx.getLocale()), debitAmount, Constants.ZERO);
        }
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        int val = contextHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(returnInfo.getCompany().getId().toString()));
        boolean nt015 = NTHelper.getParam4Boolean(ctx, "NT015", false);
        boolean nt014 = NTHelper.getParam4Boolean(ctx, "NT014", false);
        if (isNotAuto || val == 0 && nt015 && (!nt014 || nt014 && !isReceiving)) {
            flag = NTBookHelper.bookOppositeJournal(ctx, receivableInfo, returnInfo);
        }
        return flag;
    }

    public static boolean getParam4Boolean(Context ctx, String paramNum, boolean isSys) {
        IContextHelper contextHelper = null;
        contextHelper = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx) : ContextHelperFactory.getRemoteInstance();
        if (isSys) {
            return contextHelper.getBooleanParam(paramNum, null);
        }
        return contextHelper.getBooleanParam(paramNum, (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId().toString()));
    }

    public static boolean getParam4Boolean(Context ctx, String paramNum, CompanyOrgUnitInfo companyInfo) {
        IContextHelper contextHelper = null;
        contextHelper = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx) : ContextHelperFactory.getRemoteInstance();
        if (companyInfo == null) {
            return contextHelper.getBooleanParam(paramNum, null);
        }
        return contextHelper.getBooleanParam(paramNum, (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
    }

    public static void genReceivingBillByBotp(Context ctx, CoreBillBaseInfo srcBillInfo) throws BOSException, BTPException, EASBizException {
        FMHelper.genBillByBotp((Context)ctx, (CoreBillBaseInfo)srcBillInfo, (String)new ReceivingBillInfo().getBOSType().toString());
    }

    public static void botpByRuleFilter(Context ctx, CoreBillBaseInfo srcBillInfo, String destBillType) throws BOSException, BTPException, EASBizException {
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        col.add(srcBillInfo);
        BTPTransformResult btpResult = NTHelper.getBotpResult(ctx, col, destBillType);
        IObjectCollection destBillCols = btpResult.getBills();
        if (destBillCols == null) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
        int size = destBillCols.size();
        for (int i = 0; i < size; ++i) {
            iBTPManager.saveRelations((CoreBillBaseInfo)destBillCols.getObject(i), botRelateColl);
        }
    }

    public static void botpByRuleFilterNew(Context ctx, CoreBillBaseInfo srcBillInfo, String destBillType) throws BOSException, BTPException, EASBizException {
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        col.add(srcBillInfo);
        BTPTransformResult btpResult = iBTPManager.transform(col, destBillType);
        IObjectCollection destBillCols = btpResult.getBills();
        if (destBillCols == null) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
        int size = destBillCols.size();
        for (int i = 0; i < size; ++i) {
            iBTPManager.saveRelations((CoreBillBaseInfo)destBillCols.getObject(i), botRelateColl);
        }
    }

    public static BTPTransformResult getBotpResult(Context ctx, CoreBillBaseCollection col, String destBillType) throws BOSException, BOTPException, BTPException {
        IBTPManager iBTPManager = null;
        IBOTMapping botMapping = null;
        if (ctx == null) {
            iBTPManager = BTPManagerFactory.getRemoteInstance();
            botMapping = BOTMappingFactory.getRemoteInstance();
        } else {
            iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        }
        CoreBillBaseInfo srcBillInfo = col.get(0);
        ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
        srcBillColsList.add(col);
        ArrayList<String> botMappingPKCols = new ArrayList<String>();
        HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
        transmitCtx.put("TRANSMITCU", srcBillInfo.getCU());
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(col, destBillType, DefineSysEnum.BTP, transmitCtx);
        Iterator iter = botMappingCollection.iterator();
        ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
        while (iter.hasNext()) {
            String currentOrgId;
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
            String string = currentOrgId = SysContext.getSysContext().getCurrentFIUnit() == null ? "" : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
            companyMappings.add(mappingInfo);
        }
        if (companyMappings.size() == 0) {
            throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
        }
        Iterator iter2 = companyMappings.iterator();
        HashSet<String> mappingSet = new HashSet<String>();
        while (iter2.hasNext()) {
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter2.next();
            try {
                NTHelper.acceptMapping(ctx, (IObjectCollection)col, mappingInfo);
            }
            catch (BOTPException ex) {
                continue;
            }
            botMappingPKCols.add(mappingInfo.getId().toString());
            mappingSet.add(mappingInfo.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", mappingSet, CompareType.INCLUDE));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BOTMappingCollection mappingColl = botMapping.getBOTMappingCollection(evi);
        int level = 0;
        String botMappingId = "";
        if (mappingColl.size() > 1) {
            for (int i = 0; i < mappingColl.size(); ++i) {
                String longNumber;
                String[] array;
                BOTMappingInfo info = mappingColl.get(i);
                CtrlUnitInfo cu = info.getCU();
                if (cu == null || (array = (longNumber = cu.getLongNumber()).split("!")).length < level) continue;
                level = array.length;
                botMappingId = info.getId().toString();
            }
        } else if (mappingColl.size() == 1) {
            botMappingId = (String)botMappingPKCols.get(0);
        } else {
            throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
        }
        BTPTransformResult btpResult = iBTPManager.transformForBotp(col, destBillType, (IObjectPK)new ObjectUuidPK(botMappingId));
        return btpResult;
    }

    public static void genPaymentBillByBotp(Context ctx, CoreBillBaseInfo srcBillInfo) throws BOSException, BTPException, EASBizException {
        FMHelper.genBillByBotp((Context)ctx, (CoreBillBaseInfo)srcBillInfo, (String)new PaymentBillInfo().getBOSType().toString());
    }

    public static void genPaymentBillByBotp(Context ctx, CoreBillBaseInfo srcBillInfo, boolean isSubmit) throws BOSException, BTPException, EASBizException {
        FMHelper.genBillByBotp((Context)ctx, (CoreBillBaseInfo)srcBillInfo, (String)new PaymentBillInfo().getBOSType().toString(), (boolean)isSubmit);
    }

    public static int getNTInitState(Context ctx, boolean isReceivable) {
        boolean isNeedAudit = NTHelper.getParam4Boolean(ctx, "NT011", true);
        int returnValue = -1;
        returnValue = isReceivable ? (isNeedAudit ? 8 : 1) : 5;
        return returnValue;
    }

    public static void acceptMapping(Context ctx, IObjectCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        int i;
        IObjectValue sourceBill0 = sourceBillCollection.getObject(0);
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BTPUtil.getBOTMappingFilter((BOTMappingInfo)mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i2 = 0; i2 < count; ++i2) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i2);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        ArrayList<Object> billIdList = new ArrayList<Object>();
        int count = sourceBillCollection.size();
        for (int i3 = 0; i3 < count; ++i3) {
            billIdList.add(sourceBillCollection.getObject(i3).get("id"));
        }
        FilterInfo newHeadFilterInfo = NTHelper.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        if (hasEntryFilter) {
            int es = evi.getEntryFilters().size();
            for (int e = 0; e < es; ++e) {
                FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                String entryName = entryFilterInfo.getEntryName();
                ArrayList<Object> entryIdList = new ArrayList<Object>();
                int count2 = sourceBillCollection.size();
                for (i = 0; i < count2; ++i) {
                    IObjectValue srcBillInfo = sourceBillCollection.getObject(i);
                    if (srcBillInfo.get(entryName) == null || !(srcBillInfo.get(entryName) instanceof IObjectCollection)) continue;
                    IObjectCollection entryCols = (IObjectCollection)srcBillInfo.get(entryName);
                    int entryCount = entryCols.size();
                    for (int j = 0; j < entryCount; ++j) {
                        entryIdList.add(entryCols.getObject(j).get("id"));
                    }
                }
                NTHelper.mergeFilterWithIdList(entryIdList, entryFilterInfo);
            }
        }
        ArrayList<CoreBillBaseInfo> errorBillCollection = new ArrayList<CoreBillBaseInfo>();
        IDynamicObject iDynObj = null;
        iDynObj = ctx != null ? DynamicObjectFactory.getLocalInstance((Context)ctx) : DynamicObjectFactory.getRemoteInstance();
        IObjectCollection filteredCols = iDynObj.getCollection(sourceBill0.getBOSType(), evi);
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count3 = filteredCols.size();
        for (int i4 = 0; i4 < count3; ++i4) {
            IObjectValue filteredInfo = filteredCols.getObject(i4);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
        for (CoreBillBaseInfo sourceBillInfo : sourceBillCollection) {
            if (pkListMap.containsKey(sourceBillInfo.getId().toString())) continue;
            errorBillCollection.add(sourceBillInfo);
        }
        if (errorBillCollection.size() > 0) {
            StringBuffer billNumberList = new StringBuffer();
            for (CoreBillBaseInfo sourceBillInfo : errorBillCollection) {
                billNumberList.append(sourceBillInfo.getNumber());
                billNumberList.append(" ");
            }
            throw new BOTPException(BOTPException.ILLEGALBILLLIST, new Object[]{billNumberList.toString()});
        }
    }

    private static FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    public static FilterInfo mergeFilter4RPCreateFrom(CompanyOrgUnitInfo currentCompany, Map uiContext, String descBillName) {
        String targetBillType;
        FilterInfo filter = null;
        Map botpCtx = (Map)uiContext.get("BTPEDITPARAMETER");
        if (botpCtx != null && (targetBillType = (String)botpCtx.get("TargetBillType")) != null && targetBillType.equals(descBillName)) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("rpBillId", null));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        }
        return filter;
    }

    public static void writOprtLog(Context ctx, IObjectValue newInfo, String oldInfoId, OprtEnum newOprt, OprtEnum oldOprt) throws BOSException, EASBizException {
        IOprtLogFacade iOprLog = OprtLogFacadeFactory.getLocalInstance(ctx);
        ReceivableBillInfo info = (ReceivableBillInfo)newInfo;
        if (OprtEnum.SAVE.equals((Object)newOprt) && OprtEnum.TRUST.equals((Object)oldOprt) && info.getBillState() != BillStateEnum.SAVED && info.getBillState() != BillStateEnum.Audit) {
            return;
        }
        if (OprtEnum.SAVE.equals((Object)newOprt) && OprtEnum.PLEDGE.equals((Object)oldOprt) && info.getBillState() != BillStateEnum.SAVED && info.getBillState() != BillStateEnum.Audit) {
            return;
        }
        if (OprtEnum.PLEDGE.equals((Object)newOprt) && OprtEnum.SAVE.equals((Object)oldOprt) && info.getBillState() != BillStateEnum.SAVED && info.getBillState() != BillStateEnum.Audit) {
            return;
        }
        iOprLog.doLog(info, oldInfoId, newOprt, oldOprt);
    }

    public static boolean ifHaveDestBills(Context ctx, String srcBillID, String descBillID) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection coll = iBTPManager.getDestRelation(srcBillID);
        for (BOTRelationInfo type : coll) {
            if (type.getDestObjectID().toString().equals(descBillID)) continue;
            return true;
        }
        return false;
    }

    public static Set getNTTypesByGroup(NTTypeGroupEnum ntenum) {
        HashSet<String> ntSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(ntenum.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("id"));
        try {
            NTTypeCollection coll = NTTypeFactory.getRemoteInstance().getNTTypeCollection(view);
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                NTTypeInfo type = (NTTypeInfo)iterator.next();
                ntSet.add(type.getId().toString());
            }
        }
        catch (BOSException e) {
            MsgBox.showWarning((String)e.getMessage());
            SysUtil.abort();
        }
        return ntSet;
    }

    public static String getPlainString(BigDecimal number) {
        Method method;
        Class<?> cls = number.getClass();
        try {
            method = cls.getMethod("toPlainString", null);
        }
        catch (SecurityException e) {
            method = null;
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)number, null);
            }
            catch (IllegalArgumentException e) {
                return number.toString();
            }
            catch (IllegalAccessException e) {
                return number.toString();
            }
            catch (InvocationTargetException e) {
                return number.toString();
            }
        }
        return number.toString();
    }

    public static String genRedReceivingByReturnBill(Context ctx, ReturnBillInfo returnInfo, String receivingId) throws EASBizException, BOSException {
        String rtnMsg = "";
        ReceivingBillInfo receivingInfo = NTHelper.getReceivingBillById(ctx, receivingId);
        if (receivingInfo != null) {
            ReceivingBillInfo newReceivingInfo = (ReceivingBillInfo)receivingInfo.clone();
            BOSUuid newPK = BOSUuid.create((BOSObjectType)newReceivingInfo.getBOSType());
            newReceivingInfo.setId(newPK);
            newReceivingInfo.setNumber(null);
            newReceivingInfo.setBillStatus(BillStatusEnum.SUBMIT);
            newReceivingInfo.setDescription(null);
            newReceivingInfo.setBizDate(returnInfo.getReturnDate());
            newReceivingInfo.setRecBillType(NTHelper.getReceivingBillType(ctx));
            newReceivingInfo.setSourceBillId(returnInfo.getId().toString());
            newReceivingInfo.setActRecAmt(NTHelper.getOppsValue(newReceivingInfo.getActRecAmt()));
            newReceivingInfo.setActRecLocAmt(NTHelper.getOppsValue(newReceivingInfo.getActRecLocAmt()));
            newReceivingInfo.setLocalAmt(NTHelper.getOppsValue(newReceivingInfo.getLocalAmt()));
            newReceivingInfo.setAmount(NTHelper.getOppsValue(newReceivingInfo.getAmount()));
            newReceivingInfo.setAuditDate(null);
            newReceivingInfo.setAuditor(null);
            newReceivingInfo.setFiVouchered(false);
            newReceivingInfo.setVoucherNumber(null);
            newReceivingInfo.setVoucherType(null);
            newReceivingInfo.setVoucher(null);
            newReceivingInfo.setCashier(null);
            newReceivingInfo.setAccountant(null);
            newReceivingInfo.setVerifiedAmt(Constants.ZERO);
            newReceivingInfo.setVerifiedAmtLoc(Constants.ZERO);
            for (ReceivingBillEntryInfo element : newReceivingInfo.getEntries()) {
                element.setId(null);
                element.setSourceBillId(returnInfo.getId().toString());
                element.setActualAmt(NTHelper.getOppsValue(element.getActualAmt()));
                element.setActualLocAmt(NTHelper.getOppsValue(element.getActualLocAmt()));
                element.setAmount(NTHelper.getOppsValue(element.getAmount()));
                element.setLocalAmt(NTHelper.getOppsValue(element.getLocalAmt()));
                element.setUnLockAmt(NTHelper.getOppsValue(element.getUnLockAmt()));
                element.setUnLockLocAmt(NTHelper.getOppsValue(element.getUnLockLocAmt()));
                element.setUnVcAmount(NTHelper.getOppsValue(element.getUnVcAmount()));
                element.setUnVcLocAmount(NTHelper.getOppsValue(element.getUnVcLocAmount()));
                element.setRecBillType(newReceivingInfo.getRecBillType());
                element.setAmountVc(Constants.ZERO);
                element.setLocalAmtVc(Constants.ZERO);
                element.setLockAmt(Constants.ZERO);
                element.setLockLocAmt(Constants.ZERO);
            }
            IObjectPK pk = ReceivingBillFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)newReceivingInfo);
            FinUtils.addBotRelation((Context)ctx, (String)returnInfo.getId().toString(), (String)pk.toString());
            rtnMsg = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"57_ReceivableBillControllerBean", (Locale)ctx.getLocale());
        } else {
            rtnMsg = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"387_NTHelper", (Locale)ctx.getLocale());
        }
        return rtnMsg;
    }

    public static String genRedPaymentByReturnBill(Context ctx, ReturnBillInfo returnInfo, String paymentId, ReceivableBillInfo receivableInfo) throws EASBizException, BOSException {
        String rtnMsg = "";
        PaymentBillInfo paymentInfo = NTHelper.getPaymentById(ctx, paymentId);
        if (paymentInfo != null) {
            PaymentBillInfo newPaymentInfo = (PaymentBillInfo)paymentInfo.clone();
            BOSUuid newPK = BOSUuid.create((BOSObjectType)newPaymentInfo.getBOSType());
            newPaymentInfo.setId(newPK);
            newPaymentInfo.setNumber(null);
            newPaymentInfo.setBillStatus(BillStatusEnum.SUBMIT);
            newPaymentInfo.setDescription(null);
            newPaymentInfo.setBizDate(returnInfo.getReturnDate());
            newPaymentInfo.setPayBillType(NTHelper.getPaymentBillType(ctx));
            newPaymentInfo.setIsRedBill(true);
            newPaymentInfo.setSourceBillId(returnInfo.getId().toString());
            newPaymentInfo.setAuditDate(null);
            newPaymentInfo.setAuditor(null);
            newPaymentInfo.setFiVouchered(false);
            newPaymentInfo.setVoucherNumber(null);
            newPaymentInfo.setVoucherType(null);
            newPaymentInfo.setVoucher(null);
            newPaymentInfo.setCashier(null);
            newPaymentInfo.setAccountant(null);
            newPaymentInfo.setVerifiedAmt(Constants.ZERO);
            newPaymentInfo.setVerifiedAmtLoc(Constants.ZERO);
            PaymentBillEntryInfo newEntryInfo = (PaymentBillEntryInfo)newPaymentInfo.getEntries().get(0).clone();
            newEntryInfo.setId(null);
            newEntryInfo.setSourceBillId(returnInfo.getId().toString());
            if (newPaymentInfo.getEntries().size() == 1) {
                newEntryInfo.setAmount(NTHelper.getOppsValue(newEntryInfo.getAmount()));
                newEntryInfo.setActualAmt(NTHelper.getOppsValue(newEntryInfo.getActualAmt()));
                newEntryInfo.setActualLocAmt(NTHelper.getOppsValue(newEntryInfo.getActualLocAmt()));
                newEntryInfo.setLocalAmt(NTHelper.getOppsValue(newEntryInfo.getLocalAmt()));
                newEntryInfo.setUnLockAmt(NTHelper.getOppsValue(newEntryInfo.getUnLockAmt()));
                newEntryInfo.setUnVcAmount(NTHelper.getOppsValue(newEntryInfo.getUnVcAmount()));
                newEntryInfo.setUnLockLocAmt(NTHelper.getOppsValue(newEntryInfo.getUnLockLocAmt()));
                newEntryInfo.setUnVcLocAmount(NTHelper.getOppsValue(newEntryInfo.getUnVcLocAmount()));
            } else {
                newEntryInfo.setAmount(NTHelper.getOppsValue(receivableInfo.getBillAmt()));
                newEntryInfo.setActualAmt(NTHelper.getOppsValue(receivableInfo.getBillAmt()));
                newEntryInfo.setActualLocAmt(NTHelper.getOppsValue(receivableInfo.getNaturalAmt()));
                newEntryInfo.setLocalAmt(NTHelper.getOppsValue(receivableInfo.getNaturalAmt()));
                newEntryInfo.setUnLockAmt(NTHelper.getOppsValue(receivableInfo.getBillAmt()));
                newEntryInfo.setUnVcAmount(NTHelper.getOppsValue(receivableInfo.getBillAmt()));
                newEntryInfo.setUnLockLocAmt(NTHelper.getOppsValue(receivableInfo.getNaturalAmt()));
                newEntryInfo.setUnVcLocAmount(NTHelper.getOppsValue(receivableInfo.getNaturalAmt()));
            }
            newEntryInfo.setAmountVc(Constants.ZERO);
            newEntryInfo.setLocalAmtVc(Constants.ZERO);
            newEntryInfo.setLockAmt(Constants.ZERO);
            newEntryInfo.setLockLocAmt(Constants.ZERO);
            newPaymentInfo.getEntries().clear();
            newPaymentInfo.getEntries().add(newEntryInfo);
            newPaymentInfo.setActPayAmt(NTHelper.getOppsValue(newEntryInfo.getAmount()));
            newPaymentInfo.setActPayLocAmt(NTHelper.getOppsValue(newEntryInfo.getLocalAmt()));
            newPaymentInfo.setAmount(NTHelper.getOppsValue(newEntryInfo.getAmount()));
            newPaymentInfo.setLocalAmt(NTHelper.getOppsValue(newEntryInfo.getLocalAmt()));
            IObjectPK pk = PaymentBillFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)newPaymentInfo);
            FinUtils.addBotRelation((Context)ctx, (String)returnInfo.getId().toString(), (String)pk.toString());
            rtnMsg = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"388_NTHelper", (Locale)ctx.getLocale());
        } else {
            rtnMsg = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"389_NTHelper", (Locale)ctx.getLocale());
        }
        return rtnMsg;
    }

    private static PaymentBillTypeInfo getPaymentBillType(Context ctx) throws EASBizException, BOSException {
        return PaymentBillTypeFactory.getLocalInstance((Context)ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK("NLGLdwEREADgAAHpwKgSRj6TKVs="));
    }

    private static ReceivingBillTypeInfo getReceivingBillType(Context ctx) throws EASBizException, BOSException {
        return ReceivingBillTypeFactory.getLocalInstance((Context)ctx).getReceivingBillTypeInfo((IObjectPK)new ObjectUuidPK("DAWSqQEREADgAAInwKgSfCqo2zU="));
    }

    private static BigDecimal getOppsValue(BigDecimal value) {
        if (value != null) {
            value = value.negate();
        }
        return value;
    }

    private static PaymentBillInfo getPaymentById(Context ctx, String id) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((String)id) || !BOSUuid.read((String)id).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("payerAccount.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        return PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    private static ReceivingBillInfo getReceivingBillById(Context ctx, String id) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((String)id) || !BOSUuid.read((String)id).getType().equals((Object)new ReceivingBillInfo().getBOSType())) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("payeeAccount.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        return ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    public static CustomerCompanyInfoInfo getCustomerCompanyByCustomer(String custId, String companyId) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("operationer.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        CustomerCompanyInfoInfo customerCompanyInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(custId), (IObjectPK)new ObjectUuidPK(companyId), sic);
        return customerCompanyInfo;
    }

    public static boolean checkIsReachDispose(Context ctx, FinancingBillInfo info) throws BOSException {
        ILetterOfCreditReach iLetterOfCreditReach = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("credit.id", (Object)info.getId().toString()));
        evi.setFilter(fi);
        iLetterOfCreditReach = ctx == null ? LetterOfCreditReachFactory.getRemoteInstance() : LetterOfCreditReachFactory.getLocalInstance(ctx);
        LetterOfCreditReachCollection coll = iLetterOfCreditReach.getLetterOfCreditReachCollection(evi);
        return coll.size() > 0;
    }

    public static void updateOprtLog(Context ctx, EndorsementBillInfo oldInfo, String newInfoId, EndorsementBillInfo newInfo) throws BOSException, EASBizException {
        IOprtLog iOprLog = OprtLogFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billid", (Object)newInfoId));
        fi.getFilterItems().add(new FilterItemInfo("oprtState", (Object)String.valueOf(13)));
        fi.getFilterItems().add(new FilterItemInfo("changeAmt", (Object)Constants.ZERO, CompareType.LESS));
        fi.getFilterItems().add(new FilterItemInfo("bizdate", (Object)newInfo.getEndorseDate()));
        evi.setFilter(fi);
        OprtLogCollection coll = iOprLog.getOprtLogCollection(evi);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            OprtLogInfo optInfo = (OprtLogInfo)iter.next();
            if (oldInfo.getEndorseDate() == null) continue;
            optInfo.setBizDate(oldInfo.getEndorseDate());
            iOprLog.update((IObjectPK)new ObjectUuidPK(optInfo.getId()), (CoreBaseInfo)optInfo);
        }
    }

    public static ObjectBaseInfo getCSInfoByNumber(String number) throws BOSException, EASBizException {
        FilterInfo filter;
        EntityViewInfo view = new EntityViewInfo();
        if (BOSUuid.isValid((String)number, (boolean)false)) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)number));
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("browseGroup.deletedStatus", (Object)1));
            filter.setMaskString("#0  and #1 and #2");
            view.setFilter(filter);
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)number));
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("browseGroup.deletedStatus", (Object)1));
            filter.setMaskString("(#0 or #1) and #2 and #3");
            view.setFilter(filter);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("CU.id"));
        view.setSelector(selector);
        ObjectBaseCollection cColl = CustomerFactory.getRemoteInstance().getObjectBaseCollection(view);
        if (cColl != null && cColl.size() > 0) {
            return NTHelper.checkDataBase(cColl);
        }
        ObjectBaseCollection sColl = SupplierFactory.getRemoteInstance().getObjectBaseCollection(view);
        if (sColl != null && sColl.size() > 0) {
            return NTHelper.checkDataBase(sColl);
        }
        return null;
    }

    protected static ObjectBaseInfo checkDataBase(ObjectBaseCollection coll) throws BOSException {
        String cuId = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString();
        for (int i = 0; i < coll.size(); ++i) {
            if (cuId.equals(coll.get(i).getCU().getId().toString())) {
                return coll.get(i);
            }
            BOSUuid bataBaseId = coll.get(i).getId();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("dataBaseDID", (Object)bataBaseId.toString()));
            filter.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)cuId));
            filter.getFilterItems().add(new FilterItemInfo("bosObjectType", (Object)bataBaseId.getType().toString()));
            view.setFilter(filter);
            DataBaseDAssignCollection acoll = DataBaseDAssignFactory.getRemoteInstance().getDataBaseDAssignCollection(view);
            if (acoll == null || acoll.size() <= 0) continue;
            return coll.get(i);
        }
        return null;
    }

    public static IObjectPK genReceivableBill(Context ctx, ReceivableBillInfo info) throws EASBizException, BOSException {
        IObjectPK pk = null;
        try {
            pk = ReceivableBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        }
        catch (BgControlException e) {
            if (e.getMessage() != null && e.getSubCode().equals("312")) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{e.getMessage().replaceAll(EASResource.getString((String)NT_RES, (String)"currentbill"), EASResource.getString((String)NT_RES, (String)"ReceivableBill"))});
            }
            throw e;
        }
        return pk;
    }

    public static BigDecimal getSettleAmt(Set draftNumber, CurrencyInfo currency, String currentCompanyId, boolean receivableNeedAudit) {
        BigDecimal amt = Constants.ZERO;
        if (EmptyUtil.isEmpty((Collection)draftNumber)) {
            return amt;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyId));
        if (receivableNeedAudit) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"8"));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isDisPledge", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPoolPledge", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPoolTrustee", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("draftnumber", (Object)draftNumber, CompareType.INCLUDE));
        filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8");
        if (currency != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8 AND #9");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ReceivableBillCollection receivableBillCollection = new ReceivableBillCollection();
        try {
            receivableBillCollection = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(evi);
            if (draftNumber.size() != receivableBillCollection.size()) {
                MsgBox.showError((String)EASResource.getString((String)NT_RES, (String)"settleCenterError"));
                SysUtil.abort();
            }
            for (int i = 0; receivableBillCollection != null && i < receivableBillCollection.size(); ++i) {
                ReceivableBillInfo receivableBill = receivableBillCollection.get(i);
                amt = amt.add(receivableBill.getBillAmt());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return amt;
    }

    public static Map getSettleNumInfo(Set draftNumber, CurrencyInfo currency, String currentCompanyId, boolean receivableNeedAudit) {
        HashMap<String, Number> result = new HashMap<String, Number>();
        BigDecimal amt = Constants.ZERO;
        int billSize = 0;
        if (EmptyUtil.isEmpty((Collection)draftNumber)) {
            result.put("amt", amt);
            result.put("billSize", billSize);
            return result;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyId));
        if (receivableNeedAudit) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"8"));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isDisPledge", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPoolPledge", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isPoolTrustee", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("draftnumber", (Object)draftNumber, CompareType.INCLUDE));
        filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8");
        if (currency != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            filter.setMaskString("#0 AND #1 AND (#2 OR (#3 AND #4)) AND #5 AND #6 AND #7 AND #8 AND #9");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ReceivableBillCollection receivableBillCollection = new ReceivableBillCollection();
        try {
            receivableBillCollection = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(evi);
            billSize = receivableBillCollection.size();
            for (int i = 0; receivableBillCollection != null && i < receivableBillCollection.size(); ++i) {
                ReceivableBillInfo receivableBill = receivableBillCollection.get(i);
                amt = amt.add(receivableBill.getBillAmt());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        result.put("amt", amt);
        result.put("billSize", billSize);
        return result;
    }

    public static BigDecimal getEndorsementBillAmount(Context ctx, String billId) throws EASBizException, BOSException {
        BigDecimal amount = null;
        if (BOSUuid.read((String)billId).getType().equals((Object)new EndorsementBillInfo().getBOSType())) {
            EndorsementBillInfo info = null;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("localAmount");
            info = ctx == null ? EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(billId), selector) : EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(billId), selector);
            amount = info.getLocalAmount();
        }
        return amount;
    }

    public static PayableBillInfo getEntrustPayInfo(Context ctx, PayableBillInfo subPayInfo) throws BOSException, NTException {
        PayableBillInfo entrustPayInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)subPayInfo.getDraftNumber()));
        fi.getFilterItems().add(new FilterItemInfo("makeType", (Object)BillMakeTypeEnum.ENTRUST));
        evi.setFilter(fi);
        evi.setSelector(sic);
        PayableBillCollection entrustPayCol = null;
        entrustPayCol = ctx == null ? PayableBillFactory.getRemoteInstance().getPayableBillCollection(evi) : PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(evi);
        if (entrustPayCol.size() > 1) {
            throw new NTException(NTException.HASMOREENTRUST);
        }
        if (entrustPayCol.size() == 0) {
            throw new NTException(NTException.HASNOENTRUST);
        }
        entrustPayInfo = entrustPayCol.get(0);
        return entrustPayInfo;
    }

    public static PayableBillInfo getSubPayInfo(Context ctx, PayableBillInfo entrustPayInfo) throws BOSException, NTException {
        PayableBillInfo subPayInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)entrustPayInfo.getDraftNumber()));
        fi.getFilterItems().add(new FilterItemInfo("makeType", (Object)BillMakeTypeEnum.SUB));
        evi.setFilter(fi);
        evi.setSelector(sic);
        PayableBillCollection subPayCol = null;
        subPayCol = ctx == null ? PayableBillFactory.getRemoteInstance().getPayableBillCollection(evi) : PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(evi);
        if (subPayCol.size() > 1) {
            throw new NTException(NTException.HASMORESUB);
        }
        if (subPayCol.size() == 0) {
            throw new NTException(NTException.HASNOSUB);
        }
        subPayInfo = subPayCol.get(0);
        return subPayInfo;
    }

    public static ObjectBaseInfo getCSInfoByNumber(Context ctx, String number) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.deletedStatus", (Object)1));
        filter.setMaskString("(#0 or #1) and #2 and #3");
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        CustomerCollection cColl = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
        if (cColl != null && cColl.size() > 0) {
            return cColl.get(0);
        }
        SupplierCollection sColl = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
        if (sColl != null && sColl.size() > 0) {
            return sColl.get(0);
        }
        return null;
    }

    public static ObjectBaseInfo getCSInfoByNumberWithCom(String fid, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        FilterInfo filter;
        EntityViewInfo view = new EntityViewInfo();
        CtrlUnitInfo cu = null;
        String cuId = null;
        if (!company.isIsCU()) {
            cu = company.getCU();
            cuId = cu.getId().toString();
        } else {
            cuId = company.getId().toString();
        }
        if (BOSUuid.isValid((String)fid, (boolean)false)) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid));
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("browseGroup.deletedStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cuId));
            filter.setMaskString("#0  and #1 and #2 and #3");
            view.setFilter(filter);
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)fid));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)fid));
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("browseGroup.deletedStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cuId));
            filter.setMaskString("(#0 or #1) and #2 and #3 and #4");
            view.setFilter(filter);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        CustomerCollection cColl = CustomerFactory.getRemoteInstance().getCustomerCollection(view);
        if (cColl != null && cColl.size() > 0) {
            return cColl.get(0);
        }
        SupplierCollection sColl = SupplierFactory.getRemoteInstance().getSupplierCollection(view);
        if (sColl != null && sColl.size() > 0) {
            return sColl.get(0);
        }
        return null;
    }

    public static void genSaveStateRecBillByBotp(Context ctx, CoreBillBaseInfo srcBillInfo) throws BOSException, BTPException, EASBizException {
        FMHelper.genBillByBotp((Context)ctx, (CoreBillBaseInfo)srcBillInfo, (String)new ReceivingBillInfo().getBOSType().toString(), (boolean)false);
    }
}

