/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.nt.MoneyUnitEnum;
import com.kingdee.eas.fm.nt.RomanNumberEnum;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.apache.log4j.Logger;

public class NTNumberFormat
extends Format {
    private static final Logger logger = CoreUIObject.getLogger(NTNumberFormat.class);
    private String iso;

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)obj;
            if ("RMB".equalsIgnoreCase(this.iso)) {
                BigInteger y = value.toBigInteger();
                value = value.subtract(new BigDecimal(String.valueOf(y)));
                long j = value.multiply(new BigDecimal("10")).intValue();
                long f = (long)value.multiply(new BigDecimal("100")).intValue() - j * 10L;
                if (y.signum() != 0) {
                    toAppendTo.append(this.getCapValue(y.longValue()));
                    toAppendTo.append(this.getUnit("3"));
                    if (j == 0L && f == 0L) {
                        toAppendTo.append(this.getUnit("10"));
                    }
                }
                if (j != 0L) {
                    toAppendTo.append(this.getCap(j));
                    toAppendTo.append(this.getUnit("2"));
                    if (f == 0L) {
                        toAppendTo.append(this.getUnit("10"));
                    }
                }
                if (f != 0L) {
                    if (y.signum() != 0 && j == 0L) {
                        toAppendTo.append(this.getCap(0L));
                    }
                    toAppendTo.append(this.getCap(f));
                    toAppendTo.append(this.getUnit("1"));
                }
            } else if ("USD".equalsIgnoreCase(this.iso)) {
                BigInteger y = value.toBigInteger();
                value = value.subtract(new BigDecimal(String.valueOf(y)));
                long f = value.multiply(new BigDecimal("100")).intValue();
                if (y.signum() != 0) {
                    toAppendTo.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"390_NTNumberFormat"));
                    toAppendTo.append(this.getCapValue(y.longValue()));
                    toAppendTo.append(this.getUnit("3"));
                    if (f == 0L) {
                        toAppendTo.append(this.getUnit("10"));
                    }
                }
                if (f != 0L) {
                    if (f < 10L) {
                        toAppendTo.append(this.getCap(0L));
                    }
                    toAppendTo.append(this.getCapValue(f));
                    toAppendTo.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"391_NTNumberFormat"));
                }
            }
        } else if (obj instanceof String) {
            BigDecimal value = new BigDecimal((String)obj);
            toAppendTo.append(this.format(value));
        } else {
            return null;
        }
        return toAppendTo;
    }

    private String getCapValue(long value) {
        StringBuffer geWeiValue = new StringBuffer();
        long geWei = value - value / 10000L * 10000L;
        if (geWei != 0L) {
            long qian = geWei / 1000L;
            long bai = (geWei - qian * 1000L) / 100L;
            long shi = (geWei - qian * 1000L - bai * 100L) / 10L;
            long ge = geWei - qian * 1000L - bai * 100L - shi * 10L;
            if (qian != 0L) {
                geWeiValue.append(this.getCap(qian));
                geWeiValue.append(this.getUnit("6"));
            }
            if (bai == 0L) {
                if (qian != 0L && (shi != 0L || ge != 0L)) {
                    geWeiValue.append(this.getCap(0L));
                }
            } else {
                geWeiValue.append(this.getCap(bai));
                geWeiValue.append(this.getUnit("5"));
            }
            if (shi == 0L) {
                if (bai != 0L && ge != 0L) {
                    geWeiValue.append(this.getCap(0L));
                }
            } else {
                geWeiValue.append(this.getCap(shi));
                geWeiValue.append(this.getUnit("4"));
            }
            if (ge != 0L) {
                geWeiValue.append(this.getCap(ge));
            }
        }
        if ((value /= 10000L) == 0L) {
            return geWeiValue.toString();
        }
        long wanWei = value - value / 10000L * 10000L;
        String wanWeiValue = this.getCapValue(wanWei);
        if (wanWei == 0L) {
            wanWeiValue = geWeiValue.toString();
        } else {
            if (geWei < 1000L && geWei != 0L) {
                geWeiValue.insert(0, this.getCap(0L));
            }
            wanWeiValue = wanWeiValue + this.getUnit("7") + geWeiValue;
        }
        if ((value /= 10000L) == 0L) {
            return wanWeiValue.toString();
        }
        long yiWei = value;
        String yiWeiValue = this.getCapValue(yiWei);
        if (wanWei < 1000L && wanWei != 0L) {
            wanWeiValue = this.getCap(0L) + wanWeiValue;
        }
        yiWeiValue = yiWeiValue + this.getUnit("8") + wanWeiValue;
        return yiWeiValue;
    }

    private String getUnit(String unit) {
        MoneyUnitEnum unitEnum = MoneyUnitEnum.getEnum(unit);
        return unitEnum.getAlias();
    }

    private String getCap(long digit) {
        RomanNumberEnum cap = RomanNumberEnum.getEnum(new Long(digit).toString());
        return cap.getAlias();
    }

    public static void main(String[] args) {
        NTNumberFormat u = new NTNumberFormat("rmb");
        String unit = u.format("555.55");
        logger.info((Object)unit);
    }

    private NTNumberFormat(String iso) {
        if (iso == null || iso.equalsIgnoreCase("HKD") || iso.equalsIgnoreCase("EUR")) {
            iso = "rmb";
        }
        this.iso = iso;
    }

    public static NTNumberFormat getInstance(String iso) {
        return new NTNumberFormat(iso);
    }
}

