/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillStateEnum;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillImportVerify;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.app.NTDataImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableBillDataImport
extends AbstractDataTransmission {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)PayableBillDataImport.class.getName());
    private static final BigDecimal DEFAULT_EXCHANGERATE = Constants.ONE;
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private CompanyOrgUnitInfo currentCompany;

    protected ICoreBase getController(Context arg0) throws TaskExternalException {
        try {
            return PayableBillFactory.getLocalInstance(arg0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"PayableBillDataImport.transmit");
        String pfLogId_parseHead = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"PayableBillDataImport.transmit.parseHead");
        PayableBillInfo head = new PayableBillInfo();
        GuaranteeDetailInfo entry = null;
        String number = (String)this.getData(hsData, "number");
        if (!EmptyUtil.isEmpty((String)number) && number.length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"493_PayableBillDataImport", (Locale)ctx.getLocale()));
        }
        boolean flag = true;
        this.curKey = number;
        logger.error((Object)("\u83b7\u53d6\u5230EXCEL \u5355\u636e\u7f16\u7801\u4e3a\uff1a" + number));
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            head = (PayableBillInfo)this.parseHead(hsData, ctx);
            head.setCompany(this.currentCompany);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)head.getNumber()));
            view.setFilter(fi);
            PayableBillCollection coll = null;
            try {
                coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll.size() > 0) {
                head.setId(coll.get(0).getId());
            }
        } else {
            if (EmptyUtil.isEmpty((String)number)) {
                try {
                    boolean isUsedParam = DataImportUtils.getImportParam((Context)ctx);
                    if (isUsedParam) {
                        String souID = this.currentCompany.getId().toString().trim();
                        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        if (!iCodingRuleManager.isExist((IObjectValue)head, souID)) {
                            IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                            EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(this.currentCompany.getBOSType());
                            String[] materialNames = new String[]{entityObjectInfo.getAlias()};
                            throw new BOSException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"494_PayableBillDataImport", (Locale)ctx.getLocale()));
                        }
                        head.setCompany(this.currentCompany);
                        this.curKey = iCodingRuleManager.getNumber((IObjectValue)head, souID, "");
                    } else {
                        flag = false;
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.toString());
                }
            }
            if (!this.isExistHead(hsData, ctx)) {
                if (!this.infoMap.containsKey(this.curKey)) {
                    head = (PayableBillInfo)this.parseHead(hsData, ctx);
                    this.infoMap.put(this.curKey, head);
                } else {
                    head = (PayableBillInfo)this.infoMap.get(this.curKey);
                }
                if (this.isTransmitEntry(hsData) && (entry = (GuaranteeDetailInfo)this.parseEntry(head, hsData, ctx)) != null) {
                    head.getGuaranteeEntrys().add(entry);
                }
            }
            if (flag) {
                head.setCompany(this.currentCompany);
                head.setNumber(this.curKey);
            }
        }
        PerfLogRecorder.endRecord((String)pfLogId_parseHead);
        new PayableBillImportVerify().verifyHead(ctx, (CoreBaseInfo)head);
        PerfLogRecorder.endRecord((String)pfLogId);
        return head;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        String company = this.currentCompany.getNumber();
        String number = (String)this.getData(hsData, "number");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        try {
            PayableBillCollection coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(evi);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"392_PayableBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return true;
        }
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws TaskExternalException {
        if (obj == null) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"79_ReceivableBillImportVerify", (Locale)ctx.getLocale()), new String(msg));
            throw new TaskExternalException(msgStr);
        }
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        CSBankInfo cs;
        SupplierInfo csInfo;
        BEBankCollection coll;
        FilterInfo filter;
        EntityViewInfo view;
        GuaranteeTypeInfo obj;
        BlockingFlowTypeInfo obj2;
        PayableBillInfo info = new PayableBillInfo();
        BigDecimal zero = Constants.ZERO;
        Object data = null;
        info.setApplyUnit(this.currentCompany);
        data = this.getData(hsData, "number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "draftNumber")) != null && data.toString().trim().length() > 0) {
            info.setDraftNumber(data.toString());
        }
        info.setBillState(PayableBillStateEnum.TempSaved);
        data = this.getData(hsData, "currency");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(NTDataImportUtil.getCurrencyByNumber((Context)ctx, (String)data.toString()));
        } else {
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany));
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"393_PayableBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "historyBill");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"450_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            info.setHistoryBill(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "applyUnit")) != null && data.toString().trim().length() > 0) {
            CompanyOrgUnitInfo obj3 = (CompanyOrgUnitInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"applyUnit", (String)data.toString(), (IObjectValue)new CompanyOrgUnitInfo());
            info.setApplyUnit(obj3);
        }
        this.checkEmpty(ctx, info.getApplyUnit(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"394_PayableBillDataImport", (Locale)ctx.getLocale()));
        data = this.getData(hsData, "FNtType");
        if (data != null && data.toString().trim().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("financeType.*"));
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString()));
            fi.getFilterItems().add(new FilterItemInfo("superGroup", (Object)new Integer(NTTypeGroupEnum.PAYABLE.getValue()), CompareType.EQUALS));
            view2.setFilter(fi);
            view2.setSelector(sic);
            NTTypeCollection ntTypeCol = null;
            try {
                ntTypeCol = NTTypeFactory.getLocalInstance(ctx).getNTTypeCollection(view2);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            NTTypeInfo nTTypeInfo = null;
            if (ntTypeCol == null || ntTypeCol.size() <= 0) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"30_NTDataImportUtil", (Locale)ctx.getLocale()) + "FNtType" + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"31_NTDataImportUtil", (Locale)ctx.getLocale()) + "FNtType" + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"32_NTDataImportUtil", (Locale)ctx.getLocale()));
            }
            nTTypeInfo = ntTypeCol.get(0);
            info.setNtType(nTTypeInfo);
        } else {
            try {
                NTTypeInfo nttype = NTTypeFactory.getLocalInstance(ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK("66666666-6666-6666-6666-6666666666661C9A9013"));
                info.setNtType(nttype);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        this.setFinanceingSource(info);
        boolean isBankDraft = true;
        if (info.getNtType() != null && info.getNtType().getGroup().getAlias().equals(NTTypeGroupEnum.RECEIVABLE_CommerceAccept.getAlias())) {
            isBankDraft = false;
        }
        this.checkEmpty(ctx, info.getType(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"395_PayableBillDataImport", (Locale)ctx.getLocale()));
        data = this.getData(hsData, "billMaker");
        boolean isHistory = false;
        if (!isBankDraft && info.isHistoryBill() && this.currentCompany.getId().toString().equals(info.getApplyUnit().toString())) {
            info.setBillMakerName(data.toString());
            isHistory = true;
        } else {
            info.setBillMaker(this.currentCompany);
            info.setBillMakerName(this.currentCompany.getName());
        }
        if (info.getRegion() == null) {
            info.setRegion(BankAreaTypeEnum.In);
        }
        if ((data = this.getData(hsData, "blockFlowType")) != null && data.toString().trim().length() > 0) {
            obj2 = (BlockingFlowTypeInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"blockFlowType", (String)data.toString(), (IObjectValue)new BlockingFlowTypeInfo());
            info.setBlockFlowType(obj2);
        }
        if ((data = this.getData(hsData, "payee")) != null && data.toString().trim().length() > 0) {
            obj2 = this.getSupplierByNumber(ctx, data.toString());
            if (obj2 != null) {
                info.setPayee((SupplierInfo)obj2);
                info.setPayeeName(obj2.getName());
            } else {
                CustomerInfo obj1 = this.getCustomerByNumber(ctx, data.toString());
                if (obj1 != null) {
                    info.setPayee1(obj1);
                    info.setPayeeName(obj1.getName());
                } else {
                    info.setPayeeName(data.toString());
                }
            }
        }
        if ((data = this.getData(hsData, "currency")) != null && data.toString().trim().length() > 0) {
            obj2 = (CurrencyInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"currency", (String)data.toString(), (IObjectValue)new CurrencyInfo());
            info.setCurrency((CurrencyInfo)obj2);
        }
        info.setAmount(zero);
        data = this.getData(hsData, "amount");
        if (data != null && data.toString().trim().length() > 0) {
            data = this.removeDelimeter(data);
            info.setAmount(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setLocalCurExRate(zero);
        data = this.getData(hsData, "localCurExRate");
        if (data != null && data.toString().trim().length() > 0) {
            data = this.removeDelimeter(data);
            info.setLocalCurExRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if (info.getCreditCurExRate() == null) {
            info.setCreditCurExRate(TypeConversionUtils.objToBigDecimal((Object)"0"));
        }
        info.setAmountLocalCur(info.getAmount().multiply(info.getLocalCurExRate()));
        info.setAssureProportion(zero);
        data = this.getData(hsData, "assureProportion");
        if (data != null && data.toString().trim().length() > 0) {
            data = this.removeDelimeter(data);
            info.setAssureProportion(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setAssureAmount(info.getAmount().multiply(info.getAssureProportion()));
        info.setOriAssureAmount(info.getAmount().multiply(info.getAssureProportion()));
        data = this.getData(hsData, "assureAmount");
        if (data != null && data.toString().trim().length() > 0) {
            data = this.removeDelimeter(data);
            info.setAssureAmount(TypeConversionUtils.objToBigDecimal((Object)data));
            info.setOriAssureAmount(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setBalance(info.getAmount().subtract(info.getAssureAmount()));
        data = this.getData(hsData, "contractNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setContractNumber(data.toString());
        }
        if ((data = this.getData(hsData, "issueDate")) != null && data.toString().trim().length() > 0) {
            boolean canOperate;
            info.setIssueDate(TypeConversionUtils.objToDate((Object)data));
            try {
                canOperate = NTDataImportUtil.checkFinalCheckout((Context)ctx, (SystemEnum)SystemEnum.NT_MANAGEMENT, (String)this.currentCompany.getId().toString(), (Date)TypeConversionUtils.objToDate((Object)data));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TaskExternalException(e.getMessage());
            }
            if (!canOperate) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "acceptDate")) != null && data.toString().trim().length() > 0) {
            info.setAcceptDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "expiredDate")) != null && data.toString().trim().length() > 0) {
            info.setExpiredDate(TypeConversionUtils.objToDate((Object)data));
        }
        if (!EmptyUtil.isEmpty((Object)info.getExpiredDate()) && !EmptyUtil.isEmpty((Object)info.getIssueDate())) {
            info.setHorizon(FinHorizon.getHorizon((Date)info.getIssueDate(), (Date)info.getExpiredDate()));
        }
        if ((data = this.getData(hsData, "remark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "buyerPayDisCnt")) != null && data.toString().trim().length() > 0) {
            info.setBuyerPayDisCnt(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "discountDate")) != null && data.toString().trim().length() > 0) {
            info.setDiscountDate(TypeConversionUtils.objToDate((Object)data));
        }
        info.setBizDate(new Date());
        info.setDiscountRate(zero);
        data = this.getData(hsData, "discountRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setDiscountRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setDiscount(zero);
        data = this.getData(hsData, "discount");
        if (data != null && data.toString().trim().length() > 0) {
            data = this.removeDelimeter(data);
            info.setDiscount(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "isInCredit")) != null && data.toString().trim().length() > 0) {
            info.setIsInCredit(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "creditLimit")) != null && data.toString().trim().length() > 0) {
            CreditLimitInfo obj4 = (CreditLimitInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"creditLimit", (String)data.toString(), (IObjectValue)new CreditLimitInfo());
            this.setCreditLimitInfo(ctx, info, obj4);
        } else if (info.isIsInCredit()) {
            info.setIsInCredit(false);
        }
        if (this.currentCompany.getName().equals(info.getBillMakerName()) && this.currentCompany.getName().equals(info.getApplyUnit().getName())) {
            info.setMakeType(BillMakeTypeEnum.SELF);
        } else if (this.currentCompany.getName().equals(info.getBillMakerName()) && !this.currentCompany.getId().toString().equals(info.getApplyUnit().getName())) {
            info.setMakeType(BillMakeTypeEnum.SUB);
            if (info.isHistoryBill()) {
                info.setConfirmer(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getPerson());
            }
        } else {
            info.setMakeType(BillMakeTypeEnum.ENTRUST);
        }
        data = this.getData(hsData, "garanteeType");
        if (data != null && data.toString().trim().length() > 0) {
            obj = (GuaranteeTypeInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"garanteeType", (String)data.toString(), (IObjectValue)new GuaranteeTypeInfo());
            info.setGaranteeType(obj);
            info.setGuaranteeTypeInputMode(this.getGuaranteeTypeInputModeValue(data.toString()));
        } else {
            obj = (GuaranteeTypeInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"garanteeType", (String)"002", (IObjectValue)new GuaranteeTypeInfo());
            info.setGaranteeType(obj);
            info.setGuaranteeTypeInputMode(this.getGuaranteeTypeInputModeValue(data.toString()));
        }
        data = this.getData(hsData, "outBankAccount");
        if (data != null && data.toString().trim().length() > 0) {
            obj = null;
            if (isHistory) {
                try {
                    CompanyOrgUnitInfo companyInfo = PayableBillDataImport.getCompanyByName(ctx, info.getBillMakerName());
                    obj = NTDataImportUtil.getAccountBankByNumberAndComp((Context)ctx, (String)data.toString(), (CompanyOrgUnitInfo)companyInfo);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            } else {
                obj = NTDataImportUtil.getAccountBankByNumberAndComp((Context)ctx, (String)data.toString(), (CompanyOrgUnitInfo)this.currentCompany);
            }
            info.setOutBankAccount((AccountBankInfo)obj);
            if (obj != null) {
                info.setOutBankAccountName(obj.getBankAccountNumber());
                info.setInstitutionName(obj.getBank().toString());
                info.setInstitution(obj.getBank());
                if (info.getInstitution() != null) {
                    BankInfo bankInfo = info.getInstitution();
                    try {
                        bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getInstitution().getId()));
                        if (bankInfo.getAccountBank() != null) {
                            if (BEBankFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()))) {
                                BEBankInfo beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                                info.setDrawerBankNumber(beInfo.getNumber());
                            }
                        } else {
                            view = new EntityViewInfo();
                            filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("name", (Object)(info.getInstitutionName() + "%"), CompareType.LIKE));
                            view.setFilter(filter);
                            coll = new BEBankCollection();
                            coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                            if (coll.size() > 0) {
                                info.setDrawerBankNumber(coll.get(0).getNumber());
                            }
                        }
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                info.setOutBankAccountName(data.toString());
            }
        }
        if ((data = this.getData(hsData, "FPayeeAccountName")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAccountName(data.toString());
        } else if (info.getPayee() != null || info.getPayee1() != null) {
            csInfo = info.getPayee() != null ? info.getPayee() : info.getPayee1();
            try {
                cs = FMHelper.getCSBankInfo((Context)ctx, (Object)csInfo, (String)this.currentCompany.getId().toString());
                info.setPayeeAccountName(cs.getBankAccount());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        data = this.getData(hsData, "FPayeeBankName");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayeeBankName(data.toString());
        } else if (info.getPayee() != null || info.getPayee1() != null) {
            csInfo = info.getPayee() != null ? info.getPayee() : info.getPayee1();
            try {
                cs = FMHelper.getCSBankInfo((Context)ctx, (Object)csInfo, (String)this.currentCompany.getId().toString());
                info.setPayeeBankName(cs.getBank());
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)(cs.getBank() + "%"), CompareType.LIKE));
                view.setFilter(filter);
                coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                if (coll.size() > 0) {
                    info.setPayeeBankNumber(coll.get(0).getNumber());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        data = this.getData(hsData, "FIsAccept");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"449_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (data.equals(Constants.ONE.toString())) {
                info.setIsAccept(true);
            } else {
                info.setIsAccept(false);
            }
        }
        if ((data = this.getData(hsData, "FAcceptDate")) != null && data.toString().trim().length() > 0) {
            if (!info.isIsAccept()) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"451_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            info.setAcceptDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "FacceptName")) != null && data.toString().trim().length() > 0) {
            info.setAcceptor(data.toString());
        } else if (info.getNtType().getGroup().equals((Object)NTTypeGroupEnum.PAYABLE_BankAccept)) {
            if (info.getInstitution() != null) {
                info.setAcceptor(info.getInstitution().getName());
            }
        } else {
            info.setAcceptor(info.getBillMakerName());
        }
        data = this.getData(hsData, "FBillMedium");
        if (data != null && data.toString().trim().length() > 0) {
            if ("1".equals(data)) {
                info.setBillMedium(BillMediumEnum.PAPERY);
            } else if ("2".equals(data)) {
                info.setBillMedium(BillMediumEnum.ELECTRONIC);
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"542_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FDraftNumber")) != null && data.toString().trim().length() > 0) {
            info.setDraftNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FIsCanTransfer")) != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"543_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            info.setIsCanTransfer(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "FAcceptorAccountName")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorAccountName(data.toString());
        }
        if ((data = this.getData(hsData, "FAcceptorBankNum")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorBankNum(data.toString());
            EntityViewInfo view3 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter2.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            view3.setFilter(filter2);
            BEBankCollection coll2 = new BEBankCollection();
            try {
                coll2 = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view3);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll2.size() > 0) {
                info.setAcceptorBank(coll2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FDrawerBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setDrawerBankNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setPayeeBankNumber(data.toString());
        }
        return info;
    }

    private void setCreditLimitInfo(Context ctx, PayableBillInfo info, CreditLimitInfo clInfo) throws TaskExternalException {
        if (clInfo == null) {
            return;
        }
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("entrys.*");
            selector.add("Currency.*");
            selector.add("CreditUsage.*");
            CreditLimitInfo creditInfo = CreditLimitFactory.getLocalInstance((Context)ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(clInfo.getId()), selector);
            info.setCreditLimit(creditInfo);
            info.setIsInCredit(true);
            info.setCreditCurrency(creditInfo.getCurrency());
            if (creditInfo.getCreditUsage().isColligateCredit() && creditInfo.getShareType() == ShareTypeEnum.ASSIGN) {
                throw new TaskExternalException(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"AmountShareCreditNotImport"));
            }
            if (info.getCurrency().getId().toString().equals(info.getCreditCurrency().getId().toString())) {
                info.setCreditCurExRate(Constants.ONE);
            } else {
                ExchangeRateInfo exRate = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)info.getCurrency(), (CurrencyInfo)info.getCreditCurrency(), (CompanyOrgUnitInfo)this.currentCompany, (Date)info.getBizDate());
                if (exRate == null) {
                    throw new TaskExternalException(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"MaintainExchangeRateTable"));
                }
                info.setCreditCurExRate(exRate.getConvertRate());
            }
            info.setUsedQuota(info.getAmount().multiply(info.getCreditCurExRate()));
            info.setCreditLocalAmt(info.getBalance().multiply(info.getCreditCurExRate()));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void setFinanceingSource(PayableBillInfo info) {
        if (info.getNtType() != null && info.getNtType().getFinanceType() != null) {
            info.setSource(info.getNtType().getFinanceType().getFinancingSource());
            info.setType(info.getNtType().getFinanceType());
        }
    }

    private GuaranteeTypeInputModeEnum getGuaranteeTypeInputModeValue(String guaranteeTypeNumber) {
        if (guaranteeTypeNumber.equals("001")) {
            return GuaranteeTypeInputModeEnum.credit;
        }
        if (guaranteeTypeNumber.equals("002")) {
            return GuaranteeTypeInputModeEnum.assure;
        }
        if (guaranteeTypeNumber.equals("003")) {
            return GuaranteeTypeInputModeEnum.pledge;
        }
        if (guaranteeTypeNumber.equals("004")) {
            return GuaranteeTypeInputModeEnum.impawn;
        }
        return GuaranteeTypeInputModeEnum.other;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo parseEntry(PayableBillInfo headInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        GuaranteeDetailInfo info = new GuaranteeDetailInfo();
        BigDecimal zero = Constants.ZERO;
        Object data = null;
        data = this.getData(hsData, "garantee");
        if (data != null && data.toString().trim().length() > 0) {
            info.setGuaranteeName(data.toString());
        }
        info.setScale(zero);
        data = this.getData(hsData, "proportion");
        if (data != null && data.toString().trim().length() > 0) {
            info.setScale(TypeConversionUtils.objToBigDecimal((Object)data));
        } else {
            info.setScale(Constants.ONE_HUNDRED);
        }
        data = this.getData(hsData, "billNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (GuaranteeTypeInputModeEnum.assure.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                AssureBillInfo assureBill = (AssureBillInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"billNumber", (String)data.toString(), (IObjectValue)new AssureBillInfo());
                this.checkAssureBill(ctx, assureBill);
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.assure);
                info.setBilltype(GuanTypeBillEnum.AssureBill);
                info.setBillNumber(assureBill.getNumber());
                info.setBillId(assureBill.getId().toString());
                info.setAmount(assureBill.getAssureLimitAmt());
                info.setBalance(assureBill.getAssureCfgFee());
                info.setGuaranteeComp(assureBill.getAssureCompany());
                info.setGuaranteeCustomer(assureBill.getAssureCustomer());
                info.setCurrency(assureBill.getCurrency());
                info.setExchangeRate(this.getExchangeRate(ctx, headInfo.getCurrency(), assureBill.getCurrency(), headInfo.getIssueDate()));
                return info;
            } else if (GuaranteeTypeInputModeEnum.pledge.equals((Object)headInfo.getGuaranteeTypeInputMode()) || GuaranteeTypeInputModeEnum.impawn.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                WageInfo wageInfo = (WageInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"billNumber", (String)data.toString(), (IObjectValue)new WageInfo());
                this.checkWage(ctx, wageInfo, headInfo);
                if (GuaranteeTypeInputModeEnum.pledge.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                    info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.pledge);
                } else {
                    info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.impawn);
                }
                info.setBilltype(GuanTypeBillEnum.wage);
                info.setBillNumber(wageInfo.getNumber());
                info.setBillId(wageInfo.getId().toString());
                info.setGuaranteeComp(wageInfo.getCompany());
                info.setGuaranteeName(wageInfo.getGuarantee());
                info.setWage(wageInfo.getAmount());
                info.setWageRate(wageInfo.getWagerate());
                info.setCanWage(wageInfo.getWageAmount());
                info.setRealWage(headInfo.getAmount());
                return info;
            } else {
                if (!GuaranteeTypeInputModeEnum.credit.equals((Object)headInfo.getGuaranteeTypeInputMode())) return null;
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.credit);
                data = this.getData(hsData, "garantee");
                if (data == null || data.toString().trim().length() <= 0) return info;
                info.setGuaranteeCompHand(data.toString());
            }
            return info;
        } else {
            data = this.getData(hsData, "garanCompany");
            if (data != null && data.toString().trim().length() > 0) {
                info.setGuaranteeCompHand(data.toString());
            }
            if ((data = this.getData(hsData, "entrysAmount")) != null && data.toString().trim().length() > 0) {
                info.setAmount(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setWage(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setCanWage(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setRealWage(TypeConversionUtils.objToBigDecimal((Object)data));
            }
            if ((data = this.getData(hsData, "entrysCurrency")) != null && data.toString().trim().length() > 0) {
                CurrencyInfo obj = (CurrencyInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)"entrysCurrency", (String)data.toString(), (IObjectValue)new CurrencyInfo());
                info.setCurrency(obj);
            }
            if ((data = this.getData(hsData, "entrysLocalCurExRate")) != null && data.toString().trim().length() > 0) {
                info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setWageRate(TypeConversionUtils.objToBigDecimal((Object)data));
            }
            if (GuaranteeTypeInputModeEnum.assure.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.assure);
                return info;
            } else if (GuaranteeTypeInputModeEnum.pledge.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.pledge);
                return info;
            } else if (GuaranteeTypeInputModeEnum.impawn.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.impawn);
                return info;
            } else {
                if (!GuaranteeTypeInputModeEnum.credit.equals((Object)headInfo.getGuaranteeTypeInputMode())) return null;
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.credit);
                data = this.getData(hsData, "garantee");
                if (data == null || data.toString().trim().length() <= 0) return info;
                info.setGuaranteeCompHand(data.toString());
            }
        }
        return info;
    }

    private BigDecimal getExchangeRate(Context ctx, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws TaskExternalException {
        try {
            if (sourceCurr == null || destCurr == null) {
                return null;
            }
            BigDecimal rate = null;
            if (sourceCurr.getId().equals((Object)destCurr.getId())) {
                return Constants.ONE;
            }
            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo((Context)ctx, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)sourceCurr, (CurrencyInfo)destCurr, (Date)date);
            if (exchangeRateInfo == null) {
                throw new FinBizException(FinBizException.EXRATENULL);
            }
            rate = exchangeRateInfo.getConvertRate();
            if (exchangeRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                rate = Constants.ONE.divide(rate, 4);
            }
            return rate;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isTransmitEntry(Hashtable hsData) {
        return this.getData(hsData, "garantee") != null && this.getData(hsData, "garantee").toString().trim().length() > 0 || this.getData(hsData, "billNumber") != null && this.getData(hsData, "billNumber").toString().trim().length() > 0 || this.getData(hsData, "garanCompany") != null && this.getData(hsData, "garanCompany").toString().trim().length() > 0;
    }

    protected void checkAssureBill(Context ctx, AssureBillInfo assureBill) throws TaskExternalException {
        String companyName_l1 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getName(new Locale("L1"));
        String companyName_l2 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getName(new Locale("L2"));
        String companyName_l3 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getName(new Locale("L3"));
        if (assureBill.isCanceled() || !assureBill.getState().equals((Object)AssureBillStateEnum.APPROVE)) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError1", (Locale)ctx.getLocale()));
        }
        if (!(assureBill.getAssuredCompany().equals(companyName_l1) || assureBill.getAssuredCompany().equals(companyName_l2) || assureBill.getAssuredCompany().equals(companyName_l3))) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError2", (Locale)ctx.getLocale()));
        }
    }

    protected void checkWage(Context ctx, WageInfo wageInfo, PayableBillInfo headInfo) throws TaskExternalException {
        if (wageInfo.isIsAntiWage() || !wageInfo.getBillStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError3", (Locale)ctx.getLocale()));
        }
        if (wageInfo.getOwnerCompany() != null && !wageInfo.getOwnerCompany().getId().equals((Object)this.currentCompany.getId())) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError4", (Locale)ctx.getLocale()));
        }
        if (headInfo.getInstitution() != null && wageInfo.getInstitution() != null && !headInfo.getInstitution().getId().equals((Object)wageInfo.getInstitution().getId())) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError5", (Locale)ctx.getLocale()));
        }
        if (headInfo.getInstitution() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"bank", (Locale)ctx.getLocale()));
        }
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public static CompanyOrgUnitInfo getCompanyByName(Context ctx, String name) throws BOSException {
        if (EmptyUtil.isEmpty((String)name)) {
            return null;
        }
        CompanyOrgUnitInfo company = null;
        try {
            ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection coll = iCompanyOrg.getCompanyOrgUnitCollection("where name='" + name.trim() + "'");
            if (coll == null || coll.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"184_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
            }
            company = coll.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        return company;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.nt.app.PayableBillExportQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String FAcceptorBankNum;
            String FAcceptorAccountName;
            String FacceptName;
            java.sql.Date FAcceptDate;
            String FIsAccept;
            String blockFlowType;
            String FIsCanTransfer;
            BigDecimal entrysLocalCurExRate;
            String entrysCurrency;
            BigDecimal entrysAmount;
            String garanCompanyhand;
            String garanCompany;
            String billnumber;
            String proportion;
            String garantee;
            String garanteeType;
            String creditLimit;
            String isInCredit;
            String discount;
            BigDecimal discountRate;
            java.sql.Date discountDate;
            String remark;
            java.sql.Date expiredDate;
            java.sql.Date issueDate;
            String contractNumber;
            BigDecimal assureAmount;
            String assureProportion;
            BigDecimal amountLocalCur;
            BigDecimal localCurExRate;
            BigDecimal amount;
            String currency;
            String FPayeeBankNumber;
            String FPayeeBankName;
            String FPayeeAccountName;
            String payee1;
            String payee;
            String FDrawerBankNumber;
            String outBankAccount;
            String billMaker;
            String buyerPayDisCnt;
            String historyBill;
            String FBillMedium;
            String FNtType;
            String FDraftNumber;
            String number;
            String applyUnit = this.getString(rs, "ApplyUnit.number");
            if (applyUnit != null) {
                result.put("applyUnit", applyUnit);
            }
            if ((number = this.getString(rs, "number")) != null) {
                result.put("number", number);
            }
            if ((FDraftNumber = this.getString(rs, "draftNumber")) != null) {
                result.put("FDraftNumber", FDraftNumber);
            }
            if ((FNtType = this.getString(rs, "ntType.number")) != null) {
                result.put("FNtType", FNtType);
            }
            if ((FBillMedium = this.getString(rs, "billMedium")) != null) {
                result.put("FBillMedium", FBillMedium);
            }
            String string = historyBill = rs.getBoolean("historyBill") ? "1" : "0";
            if (historyBill != null) {
                result.put("historyBill", historyBill);
            }
            String string2 = buyerPayDisCnt = rs.getBoolean("buyerPayDisCnt") ? "1" : "0";
            if (buyerPayDisCnt != null) {
                result.put("buyerPayDisCnt", buyerPayDisCnt);
            }
            if ((billMaker = this.getString(rs, "billMaker.number")) != null) {
                result.put("billMaker", billMaker);
            }
            if ((outBankAccount = this.getString(rs, "OutBankAccount.number")) != null) {
                result.put("outBankAccount", outBankAccount);
            }
            if ((FDrawerBankNumber = this.getString(rs, "drawerBankNumber")) != null) {
                result.put("FDrawerBankNumber", FDrawerBankNumber);
            }
            if (!EmptyUtil.isEmpty((String)(payee = this.getString(rs, "payee.number")))) {
                result.put("payee", payee);
            }
            if (!EmptyUtil.isEmpty((String)(payee1 = this.getString(rs, "payee1.number")))) {
                result.put("payee", payee1);
            }
            if ((FPayeeAccountName = this.getString(rs, "PayeeAccountName")) != null) {
                result.put("FPayeeAccountName", FPayeeAccountName);
            }
            if ((FPayeeBankName = this.getString(rs, "PayeeBankName")) != null) {
                result.put("FPayeeBankName", FPayeeBankName);
            }
            if ((FPayeeBankNumber = this.getString(rs, "PayeeBankNumber")) != null) {
                result.put("FPayeeBankNumber", FPayeeBankNumber);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("currency", currency);
            }
            if ((amount = rs.getBigDecimal("amount")) != null) {
                result.put("amount", amount);
            }
            if ((localCurExRate = rs.getBigDecimal("localCurExRate")) != null) {
                result.put("localCurExRate", localCurExRate);
            }
            if ((amountLocalCur = rs.getBigDecimal("amountLocalCur")) != null) {
                result.put("amountLocalCur", amountLocalCur);
            }
            if ((assureProportion = this.getString(rs, "assureProportion")) != null) {
                result.put("assureProportion", assureProportion);
            }
            if ((assureAmount = rs.getBigDecimal("assureAmount")) != null) {
                result.put("assureAmount", assureAmount);
            }
            if ((contractNumber = this.getString(rs, "contractNumber")) != null) {
                result.put("contractNumber", contractNumber);
            }
            if ((issueDate = rs.getDate("issueDate")) != null) {
                result.put("issueDate", DateTimeUtils.format((Date)issueDate, (String)"yyyy-MM-dd"));
            }
            if ((expiredDate = rs.getDate("expiredDate")) != null) {
                result.put("expiredDate", DateTimeUtils.format((Date)expiredDate, (String)"yyyy-MM-dd"));
            }
            if ((remark = this.getString(rs, "remark")) != null) {
                result.put("remark", remark);
            }
            if ((discountDate = rs.getDate("discountDate")) != null) {
                result.put("discountDate", DateTimeUtils.format((Date)discountDate, (String)"yyyy-MM-dd"));
            }
            if ((discountRate = rs.getBigDecimal("discountRate")) != null) {
                result.put("discountRate", discountRate);
            }
            if ((discount = this.getString(rs, "discount")) != null) {
                result.put("discount", discount);
            }
            String string3 = isInCredit = rs.getBoolean("isInCredit") ? "1" : "0";
            if (isInCredit != null) {
                result.put("isInCredit", isInCredit);
            }
            if ((creditLimit = this.getString(rs, "creditLimit")) != null) {
                result.put("creditLimit", creditLimit);
            }
            if ((garanteeType = this.getString(rs, "garanteeType.number")) != null) {
                result.put("garanteeType", garanteeType);
            }
            if ((garantee = this.getString(rs, "entry.guarname")) != null) {
                result.put("garantee", garantee);
            }
            if ((proportion = this.getString(rs, "entry.scale")) != null) {
                result.put("proportion", proportion);
            }
            if ((billnumber = this.getString(rs, "entry.billnumber")) != null) {
                result.put("billNumber", billnumber);
            }
            if (!EmptyUtil.isEmpty((String)(garanCompany = this.getString(rs, "entry.guarcompany")))) {
                result.put("garanCompany", garanCompany);
            }
            if (!EmptyUtil.isEmpty((String)(garanCompanyhand = this.getString(rs, "entry.guarcompanyhand")))) {
                result.put("garanCompany", garanCompanyhand);
            }
            if ((entrysAmount = rs.getBigDecimal("entry.amount")) != null) {
                result.put("entrysAmount", entrysAmount);
            }
            if ((entrysCurrency = this.getString(rs, "entry.currency.number")) != null) {
                result.put("entrysCurrency", entrysCurrency);
            }
            if ((entrysLocalCurExRate = rs.getBigDecimal("entry.exchangerate")) != null) {
                result.put("entrysLocalCurExRate", entrysLocalCurExRate);
            }
            String string4 = FIsCanTransfer = rs.getBoolean("isCanTransfer") ? "1" : "0";
            if (FIsCanTransfer != null) {
                result.put("FIsCanTransfer", FIsCanTransfer);
            }
            if ((blockFlowType = this.getString(rs, "blockFlowType")) != null) {
                result.put("blockFlowType", blockFlowType);
            }
            String string5 = FIsAccept = rs.getBoolean("isAccept") ? "1" : "0";
            if (FIsAccept != null) {
                result.put("FIsAccept", FIsAccept);
            }
            if ((FAcceptDate = rs.getDate("acceptDate")) != null) {
                result.put("FAcceptDate", DateTimeUtils.format((Date)FAcceptDate, (String)"yyyy-MM-dd"));
            }
            if ((FacceptName = this.getString(rs, "acceptName")) != null) {
                result.put("FacceptName", FacceptName);
            }
            if ((FAcceptorAccountName = this.getString(rs, "acceptorAccountName")) != null) {
                result.put("FAcceptorAccountName", FAcceptorAccountName);
            }
            if ((FAcceptorBankNum = this.getString(rs, "acceptorBankNum")) != null) {
                result.put("FAcceptorBankNum", FAcceptorBankNum);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public String getString(IRowSet rs, String columnName) {
        try {
            String value = rs.getString(columnName);
            if (value == null) {
                value = "";
            }
            return value;
        }
        catch (SQLException e) {
            return "";
        }
    }

    private Object removeDelimeter(Object data) {
        if (data instanceof String) {
            data = ((String)data).replace(",", "");
        }
        return data;
    }

    private SupplierInfo getSupplierByNumber(Context ctx, String number) {
        SupplierInfo supplier = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            SupplierCollection colls = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
                supplier = colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u4f9b\u5e94\u5546\u51fa\u9519", (Throwable)e);
        }
        return supplier;
    }

    private CustomerInfo getCustomerByNumber(Context ctx, String number) {
        CustomerInfo cust = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            CustomerCollection colls = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
                cust = colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u5ba2\u6237\u51fa\u9519", (Throwable)e);
        }
        return cust;
    }
}

