/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PledgeExchangeCondStrategy;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import java.math.BigDecimal;
import java.util.List;

public class PledgeExchangeOnlyAmountSame
extends PledgeExchangeCondStrategy {
    public PledgeExchangeOnlyAmountSame(String wageBankName) {
        super(wageBankName);
    }

    @Override
    public FilterInfo getExchangeFindCond(List arrExchangeOut) {
        FilterInfo fi = super.getExchangeFindCond(arrExchangeOut);
        BigDecimal outAmt = new BigDecimal("0");
        for (int i = 0; i < arrExchangeOut.size(); ++i) {
            ReceivableBillInfo billInfo = (ReceivableBillInfo)arrExchangeOut.get(i);
            outAmt = outAmt.add(billInfo.getBillAmt());
        }
        fi.getFilterItems().add(new FilterItemInfo("billAmt", (Object)outAmt, CompareType.LESS_EQUALS));
        return fi;
    }

    @Override
    public void checkExchangeCond(List arrExchangeOut, List arrExchangeIn) throws NTException {
        ReceivableBillInfo billInfo;
        int i;
        super.checkExchangeCond(arrExchangeOut, arrExchangeIn);
        BigDecimal outAmt = new BigDecimal("0");
        BigDecimal inAmt = new BigDecimal("0");
        for (i = 0; i < arrExchangeOut.size(); ++i) {
            billInfo = (ReceivableBillInfo)arrExchangeOut.get(i);
            outAmt = outAmt.add(billInfo.getBillAmt());
        }
        for (i = 0; i < arrExchangeIn.size(); ++i) {
            billInfo = (ReceivableBillInfo)arrExchangeIn.get(i);
            inAmt = inAmt.add(billInfo.getBillAmt());
        }
        if (outAmt.compareTo(inAmt) != 0) {
            throw new NTException(NTException.DONTACCORDEXCHANGECOND);
        }
    }
}

