/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.EndorseListingCollection;
import com.kingdee.eas.fm.nt.EndorseListingFactory;
import com.kingdee.eas.fm.nt.EndorseListingInfo;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.NTDataImportUtil;
import com.kingdee.eas.fm.nt.app.ReceivableBillImportVerify;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceivableBillDataImport
extends AbstractDataTransmission {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)ReceivableBillDataImport.class.getName());
    private static final BigDecimal DEFAULT_EXCHANGERATE = Constants.ONE;
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private static List<String> elecBillStatusList = new ArrayList<String>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ReceivableBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ReceivableBillInfo head = new ReceivableBillInfo();
        EndorseListingInfo entry = null;
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String companyId = ((String)this.getData(hsData, "FCompanyID")).trim();
        CompanyOrgUnitInfo company = null;
        if (!EmptyUtil.isEmpty((String)companyId)) {
            company = NTDataImportUtil.getCompanyByNumber((Context)ctx, (String)companyId);
        }
        currCompany = null == company ? currCompany : company;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            String data = (String)this.getData(hsData, "FNumber");
            head = (ReceivableBillInfo)this.parseHead(hsData, ctx, currCompany);
            head.setNumber(data.toString());
            if (!(head.isIsNoUsed() || FMHelper.isEmpty((Object)this.getData(hsData, "FEndorseDate")) || FMHelper.isEmpty((Object)this.getData(hsData, "FEndorser")) || FMHelper.isEmpty((Object)this.getData(hsData, "FEndorsee")))) {
                entry = (EndorseListingInfo)this.parseEntry(hsData, ctx);
                head.getEndorseListing().add(entry);
            }
            head.setCompany(currCompany);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)head.getNumber()));
            view.setFilter(fi);
            ReceivableBillCollection coll = null;
            try {
                coll = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll.size() > 0) {
                head.setId(coll.get(0).getId());
            }
        } else {
            String data;
            boolean flag;
            block19: {
                flag = false;
                data = (String)this.getData(hsData, "FNumber");
                head = (ReceivableBillInfo)this.parseHead(hsData, ctx, currCompany);
                head.setCompany(currCompany);
                if (EmptyUtil.isEmpty((String)data)) {
                    try {
                        boolean isUsedParam = DataImportUtils.getImportParam((Context)ctx);
                        if (isUsedParam) {
                            String souID = currCompany.getId().toString().trim();
                            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                            if (iCodingRuleManager.isExist((IObjectValue)head, souID)) {
                                data = iCodingRuleManager.getNumber((IObjectValue)head, souID);
                            }
                            break block19;
                        }
                        flag = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    head.setNumber(data.toString());
                }
            }
            this.curKey = data;
            if (this.lastKey == null) {
                this.lastKey = this.curKey;
            }
            if (!this.isExistHead(hsData, currCompany, ctx)) {
                if (!this.infoMap.containsKey(this.curKey)) {
                    head = (ReceivableBillInfo)this.parseHead(hsData, ctx, currCompany);
                    this.infoMap.put(this.curKey, head);
                } else {
                    head = (ReceivableBillInfo)this.infoMap.get(this.curKey);
                }
                if (!(head.isIsNoUsed() || FMHelper.isEmpty((Object)this.getData(hsData, "FEndorseDate")) || FMHelper.isEmpty((Object)this.getData(hsData, "FEndorser")) || FMHelper.isEmpty((Object)this.getData(hsData, "FEndorsee")))) {
                    entry = (EndorseListingInfo)this.parseEntry(hsData, ctx);
                    head.getEndorseListing().add(entry);
                }
            }
            if (!flag) {
                head.setNumber(data);
                head.setCompany(currCompany);
            }
        }
        new ReceivableBillImportVerify().verifyHead(ctx, (CoreBaseInfo)head);
        return head;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, CompanyOrgUnitInfo currentCompany) throws TaskExternalException {
        AccountBankInfo aObj;
        BEBankCollection coll;
        boolean isBankDraft;
        Object data;
        ReceivableBillInfo info;
        block147: {
            block146: {
                FilterInfo filter;
                EntityViewInfo view;
                FilterInfo filter2;
                EntityViewInfo view2;
                block145: {
                    int NT052;
                    info = new ReceivableBillInfo();
                    data = null;
                    data = this.getData(hsData, "FDraftNumber");
                    if (data != null && data.toString().trim().length() > 0) {
                        info.setDraftNumber(data.toString());
                        info.setDraftPackageNumber(data.toString());
                    }
                    if ((data = this.getData(hsData, "FNtType")) != null && data.toString().trim().length() > 0) {
                        String fieldName = ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"395_PayableBillDataImport", (Locale)ctx.getLocale());
                        NTTypeInfo obj = (NTTypeInfo)NTDataImportUtil.getInfoByNumber((Context)ctx, (String)fieldName, (String)data.toString(), (IObjectValue)new NTTypeInfo());
                        boolean isReceivableNTtype = false;
                        try {
                            view2 = new EntityViewInfo();
                            filter2 = new FilterInfo();
                            filter2.getFilterItems().add(new FilterItemInfo("superGroup", (Object)new Integer(NTTypeGroupEnum.RECEIVABLE.getValue()), CompareType.EQUALS));
                            filter2.getFilterItems().add(new FilterItemInfo("isused", (Object)new Integer(1), CompareType.EQUALS));
                            view2.setFilter(filter2);
                            view2.getSelector().add(new SelectorItemInfo("number"));
                            NTTypeCollection ntTypeCollection = NTTypeFactory.getLocalInstance(ctx).getNTTypeCollection(view2);
                            Iterator iter = ntTypeCollection.iterator();
                            while (iter.hasNext()) {
                                NTTypeInfo element = (NTTypeInfo)iter.next();
                                if (!data.toString().equals(element.getNumber())) continue;
                                isReceivableNTtype = true;
                                break;
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        if (!isReceivableNTtype) {
                            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"30_NTDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"31_NTDataImportUtil", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"32_NTDataImportUtil", (Locale)ctx.getLocale()));
                        }
                        info.setNtType(obj);
                    } else {
                        try {
                            NTTypeInfo nttype = NTTypeFactory.getLocalInstance(ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK("33333333-3333-3333-3333-3333333333331C9A9013"));
                            info.setNtType(nttype);
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                    isBankDraft = true;
                    if (info.getNtType() != null && info.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_CommerceAccept)) {
                        isBankDraft = false;
                    }
                    if ((NT052 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("NT052", (IObjectPK)new ObjectUuidPK(currentCompany.getId()))) == 1) {
                        info.setBillState(BillStateEnum.SAVED);
                    } else {
                        info.setBillState(BillStateEnum.TempSaved);
                    }
                    data = this.getData(hsData, "FCurrencyID");
                    if (data != null && data.toString().trim().length() > 0) {
                        info.setCurrency(NTDataImportUtil.getCurrencyByNumber((Context)ctx, (String)data.toString()));
                    } else {
                        try {
                            info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany));
                        }
                        catch (Exception e) {
                            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"393_PayableBillDataImport", (Locale)ctx.getLocale()));
                        }
                    }
                    data = this.getData(hsData, "FBillMedium");
                    if (data != null && data.toString().trim().length() > 0) {
                        int billMedium = TypeConversionUtils.objToInt((Object)data);
                        if (billMedium != 1 && billMedium != 2) throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"551_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                        info.setBillMedium(BillMediumEnum.getEnum(billMedium));
                    } else {
                        info.setBillMedium(BillMediumEnum.PAPERY);
                    }
                    data = this.getData(hsData, "FIsNoUsed");
                    if (data != null && data.toString().trim().length() > 0) {
                        if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"495_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                        info.setIsNoUsed(TypeConversionUtils.objToBoolean((Object)data));
                    }
                    if ((data = this.getData(hsData, "FIsHistory")) != null && data.toString().trim().length() > 0) {
                        if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"496_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                        info.setIsHistory(TypeConversionUtils.objToBoolean((Object)data));
                    }
                    if ((data = this.getData(hsData, "FIsVendeePayInt")) != null && data.toString().trim().length() > 0) {
                        if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"497_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                        info.setIsVendeePayInt(TypeConversionUtils.objToBoolean((Object)data));
                    }
                    if (info.isIsHistory() && info.getBillMedium() == BillMediumEnum.ELECTRONIC) {
                        data = this.getData(hsData, "FElecBillStatus");
                        if (data != null && data.toString().trim().length() > 0) {
                            if (!elecBillStatusList.contains(data)) throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"552_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                            info.setElecBillStatus(ElecBillStatusEnum.getEnum(TypeConversionUtils.objToString((Object)data)));
                        } else {
                            info.setElecBillStatus(ElecBillStatusEnum.NT030006);
                        }
                    }
                    if ((data = this.getData(hsData, "drawer")) != null && data.toString().trim().length() > 0) {
                        CustomerInfo obj = NTDataImportUtil.getCustomerByNumber((String)data.toString(), (Context)ctx);
                        info.setDrawer(obj);
                        if (obj != null) {
                            if (info.isIsNoUsed()) {
                                info.setDeliverName(obj.getName());
                            }
                            info.setDrawerName(obj.getName());
                            try {
                                CSBankInfo cs = FMHelper.getCSBankInfo((Context)ctx, (Object)obj, (String)currentCompany.getId().toString());
                                info.setDrawerAccountName(cs.getBankAccount());
                                view = new EntityViewInfo();
                                filter = new FilterInfo();
                                filter.getFilterItems().add(new FilterItemInfo("name", (Object)(cs.getBank() + "%"), CompareType.LIKE));
                                view.setFilter(filter);
                                BEBankCollection coll2 = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                                if (coll2.size() > 0) {
                                    info.setDrawerBank(coll2.get(0));
                                    info.setDrawerBankName(coll2.get(0).getName());
                                    info.setDrawerBankNum(coll2.get(0).getNumber());
                                    break block145;
                                }
                                info.setDrawerBankName(cs.getBank());
                            }
                            catch (EASBizException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            catch (BOSException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        } else {
                            if (info.isIsNoUsed()) {
                                info.setDeliverName(data.toString());
                            }
                            info.setDrawerName(data.toString());
                        }
                    }
                }
                if ((data = this.getData(hsData, "drawerAccount")) != null && data.toString().trim().length() > 0) {
                    AccountBankInfo aObj2 = NTDataImportUtil.getAccountBankByNumber((Context)ctx, (String)data.toString());
                    info.setDrawerAccount(aObj2);
                    if (aObj2 != null) {
                        info.setDrawerAccountName(aObj2.getBankAccountNumber());
                    } else {
                        info.setDrawerAccountName(data.toString());
                    }
                }
                if ((data = this.getData(hsData, "drawerBank")) != null && data.toString().trim().length() > 0) {
                    EntityViewInfo view3 = new EntityViewInfo();
                    FilterInfo filter3 = new FilterInfo();
                    filter3.getFilterItems().add(new FilterItemInfo("number", (Object)(data.toString() + "%"), CompareType.LIKE));
                    filter3.getFilterItems().add(new FilterItemInfo("name", (Object)(data.toString() + "%"), CompareType.LIKE));
                    filter3.setMaskString("#0 OR #1 ");
                    view3.setFilter(filter3);
                    try {
                        BEBankCollection coll3 = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view3);
                        if (coll3.size() > 0) {
                            info.setDrawerBank(coll3.get(0));
                            info.setDrawerBankName(coll3.get(0).getName());
                            info.setDrawerBankNum(coll3.get(0).getNumber());
                        } else {
                            info.setDrawerBankName(data.toString());
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if ((data = this.getData(hsData, "FDrawerBankNum")) != null && data.toString().trim().length() > 0) {
                    info.setDrawerBankNum(data.toString());
                }
                if ((data = this.getData(hsData, "payeeAccount")) != null && data.toString().trim().length() > 0) {
                    if (info.isIsNoUsed()) {
                        AccountBankInfo obj = NTDataImportUtil.getAccountBankByNumberAndComp((Context)ctx, (String)data.toString(), (CompanyOrgUnitInfo)currentCompany);
                        info.setPayeeAccount(obj);
                        if (obj != null) {
                            info.setPayeeAccountName(obj.getBankAccountNumber());
                        } else if (info.isIsNoUsed()) {
                            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"613_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                        }
                    } else {
                        info.setPayeeAccountName(data.toString());
                    }
                } else if (info.isIsNoUsed()) {
                    throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"499_ReceivableBillDataImport", (Locale)ctx.getLocale()));
                }
                if (info.isIsNoUsed()) {
                    info.setPayeeName(currentCompany.getName());
                    if (info.getPayeeAccount() != null) {
                        info.setPayeeBank(info.getPayeeAccount().getBank());
                        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccount().getBank())) {
                            info.setPayeeBankName(info.getPayeeAccount().getBank().getName());
                            try {
                                BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeBank().getId().toString()));
                                boolean isBase = false;
                                if (bankInfo.getAccountBank() != null) {
                                    if (BEBankFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()))) {
                                        BEBankInfo beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                                        info.setPayeeBankNum(beInfo.getNumber());
                                    } else {
                                        isBase = true;
                                    }
                                } else {
                                    isBase = true;
                                }
                                if (isBase) {
                                    view = new EntityViewInfo();
                                    filter = new FilterInfo();
                                    String name = bankInfo.getName();
                                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)(name + "%"), CompareType.LIKE));
                                    view.setFilter(filter);
                                    BEBankCollection coll4 = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                                    if (coll4.size() > 0) {
                                        info.setPayeeBankNum(coll4.get(0).getNumber());
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                } else {
                    data = this.getData(hsData, "payee");
                    if (data != null && data.toString().trim().length() > 0) {
                        CustomerInfo obj = NTDataImportUtil.getCustomerByNumber((String)data.toString(), (Context)ctx);
                        SupplierInfo supplier = null;
                        if (EmptyUtil.isEmpty((CoreBaseInfo)obj)) {
                            supplier = NTDataImportUtil.getSupplierByNumber((String)data.toString(), (Context)ctx);
                            if (!EmptyUtil.isEmpty((CoreBaseInfo)supplier)) {
                                info.setPayeeSupp(supplier);
                                info.setPayeeName(supplier.getName());
                            } else {
                                info.setPayeeName(data.toString());
                            }
                        } else {
                            info.setPayee(obj);
                            info.setPayeeName(obj.getName());
                        }
                        if (obj instanceof CustomerInfo) {
                            try {
                                CSBankInfo csbankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)obj, (String)currentCompany.getId().toString());
                                info.setPayeeAccountName(csbankInfo.getBankAccount());
                            }
                            catch (EASBizException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            catch (BOSException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if ((data = this.getData(hsData, "payeeBank")) != null && data.toString().trim().length() > 0) {
                        BankInfo obj = NTDataImportUtil.getBankByNumber((Context)ctx, (String)data.toString());
                        info.setPayeeBank(obj);
                        if (obj != null) {
                            info.setPayeeBankName(obj.getName());
                            try {
                                BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeBank().getId().toString()));
                                boolean isBase = false;
                                if (bankInfo.getAccountBank() != null) {
                                    if (BEBankFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()))) {
                                        BEBankInfo beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                                        info.setPayeeBankNum(beInfo.getNumber());
                                    } else {
                                        isBase = true;
                                    }
                                } else {
                                    isBase = true;
                                }
                                if (!isBase) break block146;
                                EntityViewInfo view4 = new EntityViewInfo();
                                FilterInfo filter4 = new FilterInfo();
                                String name = bankInfo.getName();
                                filter4.getFilterItems().add(new FilterItemInfo("name", (Object)(name + "%"), CompareType.LIKE));
                                view4.setFilter(filter4);
                                BEBankCollection coll5 = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view4);
                                if (coll5.size() > 0) {
                                    info.setPayeeBankNum(coll5.get(0).getNumber());
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        } else {
                            info.setPayeeBankName(data.toString());
                            view2 = new EntityViewInfo();
                            filter2 = new FilterInfo();
                            filter2.getFilterItems().add(new FilterItemInfo("name", (Object)(data.toString() + "%"), CompareType.LIKE));
                            view2.setFilter(filter2);
                            try {
                                coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view2);
                                if (coll.size() > 0) {
                                    info.setPayeeBankNum(coll.get(0).getNumber());
                                }
                            }
                            catch (BOSException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            if ((data = this.getData(hsData, "deliver")) != null && data.toString().trim().length() > 0) {
                CustomerInfo obj = NTDataImportUtil.getCustomerByNumber((String)data.toString(), (Context)ctx);
                info.setDeliver(obj);
                if (obj != null) {
                    info.setDeliverName(obj.getName());
                } else {
                    info.setDeliverName(data.toString());
                }
            }
            if ((data = this.getData(hsData, "FPayeeBankNum")) != null && data.toString().trim().length() > 0) {
                info.setPayeeBankNum(data.toString());
            }
            if ((data = this.getData(hsData, "bankAccount")) != null && data.toString().trim().length() > 0) {
                AccountBankInfo obj = NTDataImportUtil.getAccountBankByNumber((Context)ctx, (String)data.toString());
                info.setBankAccount(obj);
            }
            if ((data = this.getData(hsData, "innerAccount")) != null && data.toString().trim().length() > 0) {
                InnerAccountInfo obj = NTDataImportUtil.getInnerAccountByNumber((Context)ctx, (String)data.toString());
                info.setInnerAccount(obj);
            }
            if ((data = this.getData(hsData, "FBillAmt")) != null && data.toString().trim().length() > 0) {
                data = this.removeDelimeter(data);
                info.setBillAmt(TypeConversionUtils.objToBigDecimal((Object)data));
            }
            if ((data = this.getData(hsData, "FExchangeRate")) != null && data.toString().trim().length() > 0) {
                info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
            }
            if (info.getBillAmt() != null && info.getExchangeRate() != null) {
                info.setNaturalAmt(info.getBillAmt().multiply(info.getExchangeRate()));
            }
            if ((data = this.getData(hsData, "FAcceptanceNo")) != null && data.toString().trim().length() > 0) {
                info.setAcceptanceNo(data.toString());
            }
            if ((data = this.getData(hsData, "FContractNo")) != null && data.toString().trim().length() > 0) {
                info.setContractNo(data.toString());
            }
            if ((data = this.getData(hsData, "FIssuesDate")) != null && data.toString().trim().length() > 0) {
                info.setIssuesDate(TypeConversionUtils.objToDate((Object)data));
            }
            if ((data = this.getData(hsData, "FTakeDate")) != null && data.toString().trim().length() > 0) {
                boolean canOperate;
                info.setTakeDate(TypeConversionUtils.objToDate((Object)data));
                try {
                    canOperate = NTDataImportUtil.checkFinalCheckout((Context)ctx, (SystemEnum)SystemEnum.NT_MANAGEMENT, (String)currentCompany.getId().toString(), (java.util.Date)TypeConversionUtils.objToDate((Object)data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new TaskExternalException(e.getMessage());
                }
                if (!canOperate) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED", (Locale)ctx.getLocale()));
                }
            }
            if ((data = this.getData(hsData, "FExpiredDate")) != null && data.toString().trim().length() > 0) {
                info.setExpiredDate(TypeConversionUtils.objToDate((Object)data));
            }
            if (!EmptyUtil.isEmpty((Object)info.getIssuesDate()) && !EmptyUtil.isEmpty((Object)info.getExpiredDate())) {
                info.setPeriod(FinHorizon.getHorizon((java.util.Date)info.getIssuesDate(), (java.util.Date)info.getExpiredDate()));
            }
            if ((data = this.getData(hsData, "FTransferDate")) != null && data.toString().trim().length() > 0) {
                info.setTransferDate(TypeConversionUtils.objToDate((Object)data));
            }
            if ((data = this.getData(hsData, "FDepartmentID")) != null && data.toString().trim().length() > 0) {
                AdminOrgUnitInfo obj = NTDataImportUtil.getAdminOrgUnitByNumber((String)"FDepartmentID", (String)data.toString(), (Context)ctx);
                info.setDepartment(obj);
            }
            if ((data = this.getData(hsData, "FOperatorID")) != null && data.toString().trim().length() > 0) {
                PersonInfo obj = NTDataImportUtil.getPersonByNumber((String)"FOperatorID", (String)data.toString(), (Context)ctx);
                info.setOperator(obj);
            }
            if ((data = this.getData(hsData, "FDigest")) != null && data.toString().trim().length() > 0) {
                info.setDescription(data.toString());
            }
            if ((data = this.getData(hsData, "FAcceptorName")) != null && data.toString().trim().length() > 0) {
                if (isBankDraft) {
                    try {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)(data.toString() + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(data.toString() + "%"), CompareType.LIKE));
                        filter.setMaskString("#0 OR #1 ");
                        view.setFilter(filter);
                        BEBankCollection coll6 = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                        if (coll6.size() > 0) {
                            info.setAcceptorName(coll6.get(0).getName());
                            break block147;
                        }
                        info.setAcceptorName(data.toString());
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    info.setAcceptorName(data.toString());
                }
            }
        }
        if (isBankDraft) {
            info.setAcceptorAccountName("0");
        }
        if ((data = this.getData(hsData, "FAcceptorAccountName")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorAccountName(data.toString());
        }
        data = this.getData(hsData, "acceptorBank");
        String acceptorBankName = null;
        if (data != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(data.toString() + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)(data.toString() + "%"), CompareType.LIKE));
            filter.setMaskString("#0 OR #1 ");
            view.setFilter(filter);
            try {
                coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                if (coll.size() > 0) {
                    info.setAcceptorBank(coll.get(0));
                    acceptorBankName = coll.get(0).getName();
                    info.setAcceptorBankNum(coll.get(0).getNumber());
                } else {
                    acceptorBankName = data.toString();
                    info.setAcceptorBankName(data.toString());
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if ((data = this.getData(hsData, "FAcceptorBankNum")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorBankNum(data.toString());
        }
        if ((data = this.getData(hsData, "FAcceptanceDate")) != null && data.toString().trim().length() > 0) {
            info.setAcceptanceDate(TypeConversionUtils.objToDate((Object)data));
        } else {
            info.setAcceptanceDate(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()));
        }
        data = this.getData(hsData, "FBatchNo");
        if (data != null && data.toString().trim().length() > 0) {
            info.setBatchNo(data.toString());
        }
        if ((data = this.getData(hsData, "FInvoiceNum")) != null && data.toString().trim().length() > 0) {
            info.setInvoiceNum(data.toString());
        }
        info.setHolder(currentCompany);
        info.setSource(BillSourceEnum.BYHAND);
        data = this.getData(hsData, "holderAccount");
        if (data != null && data.toString().trim().length() > 0 && (aObj = NTDataImportUtil.getAccountBankByNumberAndComp((Context)ctx, (String)data.toString(), (CompanyOrgUnitInfo)currentCompany)) != null) {
            info.setHolderAccount(aObj);
        }
        if (!EmptyUtil.isEmpty(acceptorBankName)) {
            info.setAcceptanceBankName(acceptorBankName);
        } else if (isBankDraft) {
            if (!EmptyUtil.isEmpty((String)info.getDrawerBankName())) {
                info.setAcceptanceBankName(info.getDrawerBankName());
            }
        } else if (!EmptyUtil.isEmpty((String)info.getDrawerBankName())) {
            info.setAcceptanceBankName(info.getDrawerBankName());
        } else {
            info.setAcceptanceBankName(info.getDrawerName());
        }
        data = this.getData(hsData, "FIsSplit");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"634_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setIsSplit(TypeConversionUtils.objToBoolean((Object)data));
            if (info.getBillMedium().equals((Object)BillMediumEnum.PAPERY) && data.equals(Constants.ONE.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"633_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FSubStartNumber")) != null && data.toString().trim().length() > 0) {
            if (info.getBillMedium().equals((Object)BillMediumEnum.PAPERY)) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"633_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            }
            if (!info.isIsSplit()) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"638_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            }
            if (!ReceivableBillDataImport.isNumeric(data.toString().trim())) throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"635_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            BigDecimal subStartNumber = new BigDecimal(data.toString().trim());
            if (subStartNumber.compareTo(Constants.ONE) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"635_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setSubStartNumber(subStartNumber);
            info.setStandardBillAmt(new BigDecimal("0.01"));
            BigDecimal subQuantity = info.getBillAmt().divide(info.getStandardBillAmt());
            info.setSubQuantity(subQuantity);
            BigDecimal subEndNumber = subQuantity.add(subStartNumber).subtract(Constants.ONE);
            info.setSubEndNumber(subEndNumber);
            String subRegion = subStartNumber.toString() + "-" + subEndNumber.toString();
            info.setSubRegion(subRegion);
        } else if (info.getBillMedium().equals((Object)BillMediumEnum.ELECTRONIC)) {
            if (info.isIsSplit()) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"636_ReceivableBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setSubQuantity(Constants.ZERO);
            info.setStandardBillAmt(new BigDecimal("0.01"));
            info.setSubStartNumber(Constants.ZERO);
            info.setSubEndNumber(Constants.ZERO);
            info.setSubRegion(Constants.ZERO + "-" + Constants.ZERO);
        }
        data = this.getData(hsData, "FDraftPackageNumber");
        if (data == null || data.toString().trim().length() <= 0) return info;
        info.setDraftPackageNumber(data.toString());
        if (info.isIsSplit()) {
            info.setDraftNumber(data.toString() + "-" + info.getSubRegion());
            return info;
        } else {
            info.setDraftNumber(data.toString());
        }
        return info;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        EndorseListingInfo info = new EndorseListingInfo();
        Object data = null;
        data = this.getData(hsData, "FEndorseDate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setEndorseDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "FEndorser")) != null && data.toString().trim().length() > 0) {
            info.setEndorser(data.toString());
        }
        if ((data = this.getData(hsData, "FEndorsee")) != null && data.toString().trim().length() > 0) {
            info.setEndorsee(data.toString());
        }
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    private boolean isExistHead(Hashtable hsData, CompanyOrgUnitInfo companyInfo, Context ctx) throws TaskExternalException {
        String company = companyInfo.getNumber();
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        try {
            ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(evi);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"392_PayableBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return true;
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ReceivableBillInfo billInfo;
            List list;
            IObjectPK pk = this.getController(ctx).save(coreBaseInfo);
            if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
            }
            if ((list = (billInfo = (ReceivableBillInfo)coreBaseInfo).getEndorseListing()).size() > 0) {
                EndorseListingInfo endorselisting = (EndorseListingInfo)list.get(0);
                endorselisting.setHead(billInfo);
                EndorseListingFactory.getLocalInstance(ctx).save(endorselisting);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.nt.app.ReceivableBillQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String FDraftPackageNumber;
            BigDecimal FSubStartNumber;
            String FIsSplit;
            String FAccountantID;
            String FCreatorID;
            String FDigest;
            String innerAccount;
            String bankAccount;
            String FOperatorID;
            String FDepartmentID;
            Date FTransferDate;
            Date FTakeDate;
            Date FExpiredDate;
            String deliver;
            String FInvoiceNum;
            String FBatchNo;
            String FContractNo;
            Date FAcceptanceDate;
            String FAcceptorBankNum;
            String acceptorBank;
            String FAcceptorAccountName;
            String FAcceptanceNo;
            String FAcceptorName;
            BigDecimal FNaturalAmt;
            BigDecimal FExchangeRate;
            BigDecimal FBillAmt;
            String FCurrencyID;
            String FPayeeBankNum;
            String payeeBank;
            String payeeAccount;
            String payeesupp;
            String payee;
            String FDrawerBankNum;
            String drawerBank;
            String drawerAccount;
            String drawer;
            String FElecBillStatus;
            Date FIssuesDate;
            String FIsVendeePayInt;
            String FIsHistory;
            String FIsNoUsed;
            String FNumber;
            String FNtType;
            String FBillMedium;
            String FCompanyID = this.getString(rs, "company.number");
            if (FCompanyID != null) {
                result.put("FCompanyID", FCompanyID);
            }
            if ((FBillMedium = this.getString(rs, "billMedium")) != null) {
                result.put("FBillMedium", FBillMedium);
            }
            if ((FNtType = this.getString(rs, "ntType.number")) != null) {
                result.put("FNtType", FNtType);
            }
            if ((FNumber = this.getString(rs, "number")) != null) {
                result.put("FNumber", FNumber);
            }
            String string = FIsNoUsed = rs.getBoolean("isNoUsed") ? "1" : "0";
            if (FIsNoUsed != null) {
                result.put("FIsNoUsed", FIsNoUsed);
            }
            String string2 = FIsHistory = rs.getBoolean("isHistory") ? "1" : "0";
            if (FIsHistory != null) {
                result.put("FIsHistory", FIsHistory);
            }
            String string3 = FIsVendeePayInt = rs.getBoolean("isVendeePayInt") ? "1" : "0";
            if (FIsVendeePayInt != null) {
                result.put("FIsVendeePayInt", FIsVendeePayInt);
            }
            if ((FIssuesDate = rs.getDate("issuesDate")) != null) {
                result.put("FIssuesDate", DateTimeUtils.format((java.util.Date)FIssuesDate, (String)"yyyy-MM-dd"));
            }
            if ((FElecBillStatus = this.getString(rs, "elecBillStatus")) != null) {
                result.put("FElecBillStatus", FElecBillStatus);
            }
            if ((drawer = this.getString(rs, "drawer.number")) != null) {
                result.put("drawer", drawer);
            }
            if ((drawerAccount = this.getString(rs, "drawerAccountName")) != null) {
                result.put("drawerAccount", drawerAccount);
            }
            if ((drawerBank = this.getString(rs, "drawerBankName")) != null) {
                result.put("drawerBank", drawerBank);
            }
            if ((FDrawerBankNum = this.getString(rs, "drawerBankNum")) != null) {
                result.put("FDrawerBankNum", FDrawerBankNum);
            }
            if (!EmptyUtil.isEmpty((String)(payee = this.getString(rs, "payee.number")))) {
                result.put("payee", payee);
            }
            if (!EmptyUtil.isEmpty((String)(payeesupp = this.getString(rs, "payeesupp.number")))) {
                result.put("payee", payeesupp);
            }
            if ((payeeAccount = this.getString(rs, "payeeAccountName")) != null) {
                result.put("payeeAccount", payeeAccount);
            }
            if ((payeeBank = this.getString(rs, "payeeBankName")) != null) {
                result.put("payeeBank", payeeBank);
            }
            if ((FPayeeBankNum = this.getString(rs, "payeeBankNum")) != null) {
                result.put("FPayeeBankNum", FPayeeBankNum);
            }
            if ((FCurrencyID = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrencyID", FCurrencyID);
            }
            if ((FBillAmt = rs.getBigDecimal("billAmt")) != null) {
                result.put("FBillAmt", FBillAmt);
            }
            if ((FExchangeRate = rs.getBigDecimal("exchangeRate")) != null) {
                result.put("FExchangeRate", FExchangeRate);
            }
            if ((FNaturalAmt = rs.getBigDecimal("naturalAmt")) != null) {
                result.put("FNaturalAmt", FNaturalAmt);
            }
            if ((FAcceptorName = this.getString(rs, "acceptorName")) != null) {
                result.put("FAcceptorName", FAcceptorName);
            }
            if ((FAcceptanceNo = this.getString(rs, "acceptanceNo")) != null) {
                result.put("FAcceptanceNo", FAcceptanceNo);
            }
            if ((FAcceptorAccountName = this.getString(rs, "acceptorAccountName")) != null) {
                result.put("FAcceptorAccountName", FAcceptorAccountName);
            }
            if ((acceptorBank = this.getString(rs, "acceptorBank")) != null) {
                result.put("acceptorBank", acceptorBank);
            }
            if ((FAcceptorBankNum = this.getString(rs, "acceptorBankNum")) != null) {
                result.put("FAcceptorBankNum", FAcceptorBankNum);
            }
            if ((FAcceptanceDate = rs.getDate("acceptanceDate")) != null) {
                result.put("FAcceptanceDate", DateTimeUtils.format((java.util.Date)FAcceptanceDate, (String)"yyyy-MM-dd"));
            }
            if ((FContractNo = this.getString(rs, "contractNo")) != null) {
                result.put("FContractNo", FContractNo);
            }
            if ((FBatchNo = this.getString(rs, "batchNo")) != null) {
                result.put("FBatchNo", FBatchNo);
            }
            if ((FInvoiceNum = this.getString(rs, "invoiceNum")) != null) {
                result.put("FInvoiceNum", FInvoiceNum);
            }
            if ((deliver = this.getString(rs, "deliver.number")) != null) {
                result.put("deliver", deliver);
            }
            if ((FExpiredDate = rs.getDate("expiredDate")) != null) {
                result.put("FExpiredDate", DateTimeUtils.format((java.util.Date)FExpiredDate, (String)"yyyy-MM-dd"));
            }
            if ((FTakeDate = rs.getDate("takeDate")) != null) {
                result.put("FTakeDate", DateTimeUtils.format((java.util.Date)FTakeDate, (String)"yyyy-MM-dd"));
            }
            if ((FTransferDate = rs.getDate("transferDate")) != null) {
                result.put("FTransferDate", DateTimeUtils.format((java.util.Date)FTransferDate, (String)"yyyy-MM-dd"));
            }
            if ((FDepartmentID = this.getString(rs, "department.number")) != null) {
                result.put("FDepartmentID", FDepartmentID);
            }
            if ((FOperatorID = this.getString(rs, "operator.number")) != null) {
                result.put("FOperatorID", FOperatorID);
            }
            if ((bankAccount = this.getString(rs, "bankAccount.name")) != null) {
                result.put("bankAccount", bankAccount);
            }
            if ((innerAccount = this.getString(rs, "innerAccount.number")) != null) {
                result.put("innerAccount", innerAccount);
            }
            if ((FDigest = this.getString(rs, "digest")) != null) {
                result.put("FDigest", FDigest);
            }
            if ((FCreatorID = this.getString(rs, "creator.name")) != null) {
                result.put("FCreatorID", FCreatorID);
            }
            if ((FAccountantID = this.getString(rs, "accountant.name")) != null) {
                result.put("FAccountantID", FAccountantID);
            }
            String string4 = FIsSplit = rs.getBoolean("isSplit") ? "1" : "0";
            if (FIsSplit != null) {
                result.put("FIsSplit", FIsSplit);
            }
            if ((FSubStartNumber = rs.getBigDecimal("subStartNumber")) != null) {
                result.put("FSubStartNumber", FSubStartNumber);
            }
            if ((FDraftPackageNumber = this.getString(rs, "draftPackageNumber")) != null) {
                result.put("FDraftPackageNumber", FDraftPackageNumber);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("head", (Object)rs.getString("id"), CompareType.EQUALS));
            view.setFilter(filter);
            try {
                EndorseListingCollection coll = EndorseListingFactory.getLocalInstance(ctx).getEndorseListingCollection(view);
                if (coll != null && coll.size() > 0) {
                    String FEndorsee;
                    String FEndorser;
                    java.util.Date FEndorseDate = coll.get(0).getEndorseDate();
                    if (FEndorseDate != null) {
                        result.put("FEndorseDate", DateTimeUtils.format((java.util.Date)FEndorseDate, (String)"yyyy-MM-dd"));
                    }
                    if ((FEndorser = coll.get(0).getEndorser()) != null) {
                        result.put("FEndorser", FEndorser);
                    }
                    if ((FEndorsee = coll.get(0).getEndorsee()) != null) {
                        result.put("FEndorsee", FEndorsee);
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            String holderAccount = this.getString(rs, "holderAccount.bankAccountNumber");
            if (holderAccount != null) {
                result.put("holderAccount", holderAccount);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public String getString(IRowSet rs, String columnName) {
        try {
            String value = rs.getString(columnName);
            if (value == null) {
                value = "";
            }
            return value;
        }
        catch (SQLException e) {
            return "";
        }
    }

    private Object removeDelimeter(Object data) {
        if (data instanceof String) {
            data = ((String)data).replace(",", "");
        }
        return data;
    }

    static {
        elecBillStatusList.add("030006");
        elecBillStatusList.add("100001");
        elecBillStatusList.add("100006");
        elecBillStatusList.add("110101");
        elecBillStatusList.add("110106");
        elecBillStatusList.add("180001");
        elecBillStatusList.add("180006");
        elecBillStatusList.add("180020");
        elecBillStatusList.add("190001");
        elecBillStatusList.add("190006");
        elecBillStatusList.add("200001");
        elecBillStatusList.add("000000");
        elecBillStatusList.add("200312");
        elecBillStatusList.add("200412");
        elecBillStatusList.add("200512");
        elecBillStatusList.add("210001");
        elecBillStatusList.add("210312");
        elecBillStatusList.add("210412");
        elecBillStatusList.add("220607");
    }
}

