/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class RptPayableBillFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3817388480609559194L;
    private Set companyIdSet = null;
    private Set bankIdSet = null;
    private Set currencyIdSet = null;
    private Set typeIdSet = null;
    private Set currencySet = null;
    private Set garanteeTypeSet = null;
    private Set typeSet = null;
    private Date dateFrom = null;
    private Date dateTo = null;
    private int unit1;
    private BigDecimal amount = null;
    private int dimType = 0;
    private String ntypeid = "";
    private int billMedium;
    private boolean isContainEntrustBill = false;

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterInfo filter1 = new FilterInfo();
        FilterInfo filter2 = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        Date date = this.getDateTo();
        Date transferDate = DateHelper.truncateDate((Date)date);
        if (this.getDateFrom() == null) {
            filter1.getFilterItems().add(new FilterItemInfo("IssueDate", (Object)transferDate, CompareType.LESS_EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("RepaymentDate", (Object)transferDate, CompareType.GREATER));
            filter1.getFilterItems().add(new FilterItemInfo("RepaymentDate", null, CompareType.EQUALS));
            filter1.setMaskString("#0 and (#1 or #2)");
        } else {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
            filterCollection.add(new FilterItemInfo("ExpiredDate", (Object)this.getDateFrom(), CompareType.GREATER_EQUALS));
        }
        if (this.getBankIdSet() != null && this.getBankIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Institution.id", (Object)this.getBankIdSet(), CompareType.INCLUDE));
        }
        if (this.getCurrencyIdSet() != null && this.getCurrencyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Currency.id", (Object)this.getCurrencyIdSet(), CompareType.INCLUDE));
        }
        if (this.getTypeIdSet() != null && this.getTypeIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("ntType.id", (Object)this.getTypeIdSet(), CompareType.INCLUDE));
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        }
        if (this.getTypeSet() != null && this.getTypeSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Type.id", (Object)this.getTypeSet(), CompareType.INCLUDE));
        }
        if (this.getCurrencySet() != null && this.getCurrencySet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Currency.id", (Object)this.getCurrencySet(), CompareType.INCLUDE));
        }
        if (this.getGaranteeTypeSet() != null && this.getGaranteeTypeSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("GaranteeType.id", (Object)this.getGaranteeTypeSet(), CompareType.INCLUDE));
        }
        if (!FMHelper.isEmpty((String)this.getNtypeid())) {
            filterCollection.add(new FilterItemInfo("ntType.id", (Object)this.getNtypeid()));
        }
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            BigDecimal bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterCollection.add(new FilterItemInfo("Amount", (Object)this.getAmount().multiply(bdUnit), CompareType.GREATER_EQUALS));
        }
        if (this.getBillMediumEnum() != null) {
            filterCollection.add(new FilterItemInfo("billMedium", (Object)new Integer(this.getBillMediumEnum().getValue()), CompareType.EQUALS));
        }
        filter2.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(8), CompareType.NOTEQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(4), CompareType.NOTEQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(10), CompareType.NOTEQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(4), CompareType.NOTEQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("transferDate", (Object)transferDate, CompareType.GREATER));
        if (this.getDateFrom() == null) {
            filter2.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(9), CompareType.NOTEQUALS));
            filter2.setMaskString("(#0 and #1 and #2 and #5) or (#4 and #3)");
        } else {
            filter2.setMaskString("(#0 and #1 and #2) or (#4 and #3)");
        }
        if (!this.isContainEntrustBill) {
            filterCollection.add(new FilterItemInfo("makeType", (Object)new Integer(2), CompareType.NOTEQUALS));
        }
        try {
            filter.mergeFilter(filter1, "AND");
            filter.mergeFilter(filter2, "AND");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        switch (this.getDimType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("Institution.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("Currency.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            case 4: {
                sorter.add(new SorterItemInfo("GaranteeType.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Set getBankIdSet() {
        return this.bankIdSet;
    }

    public void setBankIdSet(Set bankIdSet) {
        this.bankIdSet = bankIdSet;
    }

    public Set getCurrencyIdSet() {
        return this.currencyIdSet;
    }

    public void setCurrencyIdSet(Set currencyIdSet) {
        this.currencyIdSet = currencyIdSet;
    }

    public Set getTypeIdSet() {
        return this.typeIdSet;
    }

    public void setTypeIdSet(Set typeIdSet) {
        this.typeIdSet = typeIdSet;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Set getCurrencySet() {
        return this.currencySet;
    }

    public void setCurrencySet(Set currencySet) {
        this.currencySet = currencySet;
    }

    public Set getGaranteeTypeSet() {
        return this.garanteeTypeSet;
    }

    public void setGaranteeTypeSet(Set garanteeTypeSet) {
        this.garanteeTypeSet = garanteeTypeSet;
    }

    public Set getTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(Set typeSet) {
        this.typeSet = typeSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getDimType() {
        return this.dimType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unit1);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unit1 = unit == null ? -1 : unit.getValue();
    }

    public String getNtypeid() {
        return this.ntypeid;
    }

    public void setNtypeid(String ntypeid) {
        this.ntypeid = ntypeid;
    }

    public BillMediumEnum getBillMediumEnum() {
        return BillMediumEnum.getEnum(this.billMedium);
    }

    public void setBillMediumEnum(BillMediumEnum billMediumEnum) {
        this.billMedium = billMediumEnum == null ? -1 : billMediumEnum.getValue();
    }

    public int getBillMedium() {
        return this.billMedium;
    }

    public void setBillMedium(int billMedium) {
        this.billMedium = billMedium;
    }

    public boolean isContainEntrustBill() {
        return this.isContainEntrustBill;
    }

    public void setContainEntrustBill(boolean isContainEntrustBill) {
        this.isContainEntrustBill = isContainEntrustBill;
    }
}

