/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.GuaranteeApplyInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.AssureAmountTypeCollection;
import com.kingdee.eas.fm.fs.AssureAmountTypeFactory;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.AssureSourceEnum;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.IAssureAmount;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableApplyBillFactory;
import com.kingdee.eas.fm.nt.PayableApplyBillInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractAssureAmountEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AssureAmountEditUI
extends AbstractAssureAmountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AssureAmountEditUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo currentCurrency;
    private PayableBillInfo payableBill;
    private PayableApplyBillInfo payableApplyBill;
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    private boolean isNeedAudit;

    public AssureAmountEditUI() throws Exception {
        IContextHelper ch = ContextHelperFactory.getRemoteInstance();
        this.currentCompany = ch.getCurrentCompany();
        this.isNeedAudit = ch.getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), selectors);
        this.currentCurrency = info.getBaseCurrency();
    }

    @Override
    public void loadFields() {
        block19: {
            this.initUI();
            super.loadFields();
            if (this.txtAssureRate.getValue() == null) {
                this.txtAssureRate.setValue((Object)new Integer(0));
            }
            FMClientHelper.setSelectObject((KDComboBox)this.kdCombCreditCurrency, (Object)this.editData.getCreditCurrency());
            FMClientHelper.setSelectObject((KDComboBox)this.kdCombCurrency, (Object)this.editData.getCurrency());
            FMClientHelper.initReadNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtAssureNo, (String)this.currentCompany.getId().toString());
            CurrencyInfo creditCurrency = (CurrencyInfo)this.kdCombCreditCurrency.getSelectedItem();
            if (creditCurrency == null) {
                this.txtreturnQuota.setPrecision(this.currentCurrency.getPrecision());
            } else {
                this.txtreturnQuota.setPrecision(creditCurrency.getPrecision());
            }
            CurrencyInfo currency = (CurrencyInfo)this.kdCombCurrency.getSelectedItem();
            if (currency != null) {
                this.txtamount.setPrecision(currency.getPrecision());
                try {
                    this.txtlocalCurExRate.setPrecision(FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)currency.getId().toString(), null, (Date)new Date()));
                }
                catch (Exception e1) {
                    this.handUIExceptionAndAbort(e1);
                }
            }
            this.getPayableBill();
            if (this.payableBill != null && this.payableBill.getBalance() != null) {
                this.txtamount.setMaximumValue((Comparable)this.payableBill.getBalance());
            }
            if (FMHelper.isInstanceof((String)this.editData.getSourceBillId(), BankFactorInfo.class)) {
                this.editData.setAssureSource(AssureSourceEnum.BANKFACTOR);
            }
            if (!(this.editData.getAssureSource().equals((Object)AssureSourceEnum.GUARANTEE) || this.editData.getAssureSource().equals((Object)AssureSourceEnum.LC) || this.editData.getAssureSource().equals((Object)AssureSourceEnum.BANKFACTOR))) {
                this.getPayableApplyBill();
            }
            this.txtlocalAmt.setPrecision(this.currentCurrency.getPrecision());
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                try {
                    if (FMHelper.isInstanceof((String)this.editData.getSourceBillId(), PayableBillInfo.class)) {
                        FinUtils.initExchangeRate((BasicFormattedTextField)this.txtlocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)this.payableBill.getCurrency(), (CurrencyInfo)this.currentCurrency, (Date)this.editData.getBizDate());
                        break block19;
                    }
                    if (FMHelper.isInstanceof((String)this.editData.getSourceBillId(), PayableApplyBillInfo.class)) {
                        PayableApplyBillInfo paybaleApplyBIllinifo = PayableApplyBillFactory.getRemoteInstance().getPayableApplyBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getSourceBillId()));
                        FinUtils.initExchangeRate((BasicFormattedTextField)this.txtlocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)paybaleApplyBIllinifo.getCurrency(), (CurrencyInfo)this.currentCurrency, (Date)this.editData.getBizDate());
                        break block19;
                    }
                    FinUtils.initExchangeRate((BasicFormattedTextField)this.txtlocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)this.editData.getCurrency(), (CurrencyInfo)this.currentCurrency, (Date)this.editData.getBizDate());
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            } else {
                this.txtlocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
                try {
                    if (currency != null) {
                        FinUtils.initExchangeRate((BasicFormattedTextField)this.txtlocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCurrency, (Date)this.editData.getBizDate());
                    }
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            }
        }
        this.storeFields();
        this.initOldData(this.getDataObject());
        if (this.editData.getPayAcct() != null) {
            this.prmtpayAcct.setData((Object)this.editData.getPayAcct());
            this.prmtpayAcct.setText(this.editData.getPayAcct().getName());
        }
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> btpeditparameter = new HashMap<String, String>();
        btpeditparameter.put("TargetBillType", "AssureAmount");
        billEdit.createFrom(null, btpeditparameter);
    }

    private PayableBillInfo getPayableBill() {
        AssureAmountInfo info = (AssureAmountInfo)this.getDataObject();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        if (info.getSourceBillId() != null) {
            try {
                this.payableBill = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getSourceBillId())), sic);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UuidException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.payableBill;
    }

    public PayableApplyBillInfo getPayableApplyBill() {
        AssureAmountInfo info = (AssureAmountInfo)this.getDataObject();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        if (info.getSourceBillId() != null) {
            try {
                this.payableApplyBill = PayableApplyBillFactory.getRemoteInstance().getPayableApplyBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId().toString()));
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UuidException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.payableApplyBill;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        super.onLoad();
        this.menuItemCopyLine.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionAddNew.setVisible(true);
        this.actionEdit.setVisible(true);
        this.actionSave.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        AssureAmountInfo info = (AssureAmountInfo)this.getDataObject();
        this.onloadPayableApplyBill(info);
        if (this.editData.getAssureSource() == AssureSourceEnum.MANUAL) {
            this.txtpayablebill.setEnabled(true);
            this.kdCombCurrency.setEnabled(true);
            this.txtseq.setEnabled(true);
        } else {
            this.txtpayablebill.setEnabled(false);
        }
        if (FMHelper.isInstanceof((String)this.editData.getSourceBillId(), BankFactorInfo.class)) {
            this.editData.setAssureSource(AssureSourceEnum.BANKFACTOR);
            this.comboSource.setSelectedIndex(5);
            this.txtpayablebill.setEnabled(false);
            try {
                FMClientHelper.initComboCurrency((KDComboBox)this.kdCombCurrency, (boolean)true, (String)this.getOprtState());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    protected void initUI() {
        try {
            FinUtils.initCurrencyComboBox((KDComboBox)this.kdCombCreditCurrency);
            FinUtils.initCurrencyComboBox((KDComboBox)this.kdCombCurrency);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        NTHelper.initAccountBankPromt(this.prmtassureAcct);
        NTHelper.initAccountBankPromt(this.prmtpayAcct);
        this.kdCombCreditCurrency.setEnabled(false);
        this.comboSource.setEnabled(false);
        this.txtamount.setHorizontalAlignment(4);
        this.txtseq.setHorizontalAlignment(4);
        this.txtlocalCurExRate.setHorizontalAlignment(4);
        this.txtlocalCurExRate.setRemoveingZeroInDispaly(false);
        this.txtlocalAmt.setHorizontalAlignment(4);
        this.txtlocalAmt.setRemoveingZeroInDispaly(false);
        this.txtcreditCurExRate.setHorizontalAlignment(4);
        this.txtreturnQuota.setHorizontalAlignment(4);
        this.txtAssureRate.setDataType(4);
        this.txtAssureRate.setMinimumValue((Comparable)new BigDecimal("0"));
        this.txtAssureRate.setMaximumValue((Comparable)new BigDecimal("1"));
        this.txtAssureRate.setPrecision(4);
        this.txtAssureRate.setRemoveingZeroInDispaly(false);
        this.txtAssureRate.setHorizontalAlignment(4);
        this.txtamount.setPrecision(2);
        this.txtamount.setRemoveingZeroInDispaly(false);
        this.txtAssureNo.setRequired(true);
        this.prmtAssureType.setRequired(true);
        this.txtAssureRate.setRequired(true);
        if (this.editData.getAssureSource() == AssureSourceEnum.PAYABLEBILL && 0L == this.editData.getSeq()) {
            this.pkBizDate.setEnabled(false);
            this.prmtAssureType.setEnabled(false);
            this.txtseq.setEnabled(false);
            this.txtamount.setEnabled(false);
            this.txtAssureRate.setEnabled(false);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AssureAmountFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        AssureAmountInfo info = (AssureAmountInfo)dataObject;
        info.setCompany(this.currentCompany);
        if (this.getBOTPViewStatus() == 1) {
            if (this.isFromApplyBill(info)) {
                info.setSeq(1L);
                info.setAssureSource(AssureSourceEnum.PAYABLEBILLREQ);
                info.setCompany(this.currentCompany);
                info.setCurrency(this.contextHelp.getCurrentCompany().getBaseCurrency());
                info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
            }
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            if (FMHelper.isInstanceof((String)info.getSourceBillId(), BankFactorInfo.class)) {
                info.setSeq(1L);
            }
        }
        super.setDataObject((IObjectValue)info);
    }

    protected void initDataStatus() {
        AssureAmountInfo info;
        if (this.getBOTPViewStatus() == 1 && this.isFromApplyBill(info = (AssureAmountInfo)this.getDataObject())) {
            this.getPayableApplyBill();
        }
        if (this.getOprtState().endsWith(OprtState.EDIT)) {
            info = (AssureAmountInfo)this.getDataObject();
            this.getPayableBill();
            if (!info.isFivouchered() && info.getAssureSource().equals((Object)AssureSourceEnum.PAYABLEBILL)) {
                long maxSeq = 0L;
                try {
                    maxSeq = AssureAmountFactory.getRemoteInstance().getMaxSeq(info.getSourceBillId());
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
                if (this.payableBill.getBillState().equals((Object)PayableBillStateEnum.CASH) || info.getSeq() < maxSeq) {
                    this.txtamount.setEnabled(false);
                    this.pkBizDate.setEnabled(false);
                    this.txtlocalCurExRate.setEnabled(false);
                    this.txtDescription.setEnabled(false);
                }
            }
        }
        super.initDataStatus();
        this.actionRemove.setVisible(false);
        if (this.getBOTPViewStatus() == 1) {
            this.txtseq.setEnabled(false);
        } else {
            this.txtseq.setEnabled(true);
        }
        if (this.getOprtState().endsWith(OprtState.VIEW)) {
            this.actionEdit.setEnabled(false);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        AssureAmountInfo objectValue = new AssureAmountInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        String sourceBillType = (String)this.getUIContext().get("sourceBillType");
        this.payableBill = new PayableBillInfo();
        if (sourceBillType != null && sourceBillType.equals("payableBill")) {
            this.payableBill = (PayableBillInfo)this.getUIContext().get("payableBill");
            objectValue.setPayablebill(this.payableBill.getNumber());
            objectValue.setSourceBillId(this.payableBill.getId().toString());
            objectValue.setIsInCredit(this.payableBill.isIsInCredit());
            objectValue.setCreditLimit(this.payableBill.getCreditLimit());
            objectValue.setCreditCurrency(this.payableBill.getCreditCurrency());
            objectValue.setCreditCurExRate(this.payableBill.getCreditCurExRate());
            objectValue.setAssureRate(this.payableBill.getAssureProportion());
            objectValue.setAssureSource(AssureSourceEnum.PAYABLEBILL);
            objectValue.setCurrency(this.payableBill.getCurrency());
            objectValue.setSourceAmount(this.payableBill.getAmount());
            try {
                objectValue.setSeq(AssureAmountFactory.getRemoteInstance().getMaxSeq(this.payableBill.getId().toString()) + 1L);
            }
            catch (Exception e) {
                objectValue.setSeq(1L);
                this.handUIExceptionAndAbort(e);
            }
        } else if (sourceBillType != null && sourceBillType.equals("guarantee")) {
            GuaranteeApplyInfo info = (GuaranteeApplyInfo)this.getUIContext().get("guarantee");
            objectValue.setSourceBillId(info.getId().toString());
            objectValue.setPayablebill(info.getNumber());
            objectValue.setCurrency(info.getGuaranCurrency());
            objectValue.setAmount(info.getGuanCurGuan());
            objectValue.setSourceAmount(info.getAmount());
            if (!FMHelper.isEmpty((Object)info.getGuanRate())) {
                objectValue.setAssureRate(info.getGuanRate().multiply(new BigDecimal("0.01")));
            }
            objectValue.setAssureSource(AssureSourceEnum.GUARANTEE);
            objectValue.setSeq(1L);
        } else if (sourceBillType != null && sourceBillType.equals("LetterOfCreditApply")) {
            objectValue.setAssureSource(AssureSourceEnum.LC);
            objectValue.setSourceAmount((BigDecimal)this.getUIContext().get("sourceAmount"));
            objectValue.setPayablebill((String)this.getUIContext().get("payablebill"));
            objectValue.setSeq(1L);
            objectValue.setPayAcct((AccountBankInfo)this.getUIContext().get("payAccount"));
            objectValue.setSourceBillId((String)this.getUIContext().get("LetterOfCreditApplyId"));
            objectValue.setCurrency(this.currentCurrency);
        } else {
            objectValue.setCurrency(this.currentCurrency);
            objectValue.setAssureSource(AssureSourceEnum.MANUAL);
            this.payableBill.setCurrency(this.currentCurrency);
            objectValue.setAmount(Constants.ZERO);
        }
        objectValue.setIsGenePayBill(false);
        objectValue.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        return objectValue;
    }

    @Override
    protected void kdCombCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.kdCombCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.txtamount.setPrecision(currency.getPrecision());
        this.txtlocalCurExRate.setPrecision(FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)currency.getId().toString(), null, (Date)new Date()));
        this.txtlocalAmt.setPrecision(this.currentCurrency.getPrecision());
        try {
            AssureAmountInfo info = (AssureAmountInfo)this.getDataObject();
            if (info != null) {
                FinUtils.initExchangeRate((BasicFormattedTextField)this.txtlocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCurrency, (Date)info.getBizDate());
            }
        }
        catch (EASBizException e1) {
            this.kdCombCurrency.setSelectedItem(null);
            throw e1;
        }
        this.calLocalAmount();
        this.txtlocalCurExRate.setEnabled(true);
        CurrencyInfo creditCurrency = (CurrencyInfo)this.kdCombCreditCurrency.getSelectedItem();
        if (currency.getId() != null && creditCurrency != null && creditCurrency.getId() != null && !currency.getId().toString().equals(creditCurrency.getId().toString())) {
            this.txtcreditCurExRate.setEnabled(true);
        }
    }

    private void calLocalAmount() {
        BigDecimal bdAmount = this.txtamount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtlocalCurExRate.getBigDecimalValue();
        BigDecimal result = Constants.ZERO;
        if (bdAmount != null && bdLocalExRate != null) {
            result = bdAmount.multiply(bdLocalExRate);
        }
        this.txtlocalAmt.setValue((Object)result);
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        this.calLocalAmount();
        if (e.getNewValue() == null) {
            this.txtamount.setValue((Object)Constants.ZERO);
        }
        if (this.txtcreditCurExRate.getBigDecimalValue() != null && this.txtcreditCurExRate.getBigDecimalValue().compareTo(Constants.ZERO) != 0) {
            this.txtreturnQuota.setValue((Object)this.txtamount.getBigDecimalValue().multiply(this.txtcreditCurExRate.getBigDecimalValue()));
        }
    }

    @Override
    protected void txtlocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calLocalAmount();
        if (e.getNewValue() == null) {
            this.txtlocalCurExRate.setValue((Object)Constants.ZERO);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BigDecimal amount;
        if (this.payableApplyBill != null && (amount = this.txtamount.getBigDecimalValue()) != null && (amount.compareTo(Constants.ZERO) <= 0 || amount.compareTo(this.payableApplyBill.getApplyAmount()) > 0)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"137_AssureAmountEditUI"));
            SysUtil.abort();
        }
        super.verifyInput(e);
        if (this.payableBill != null && this.payableBill.getIssueDate() != null) {
            BigDecimal amount2;
            Date bizDate = this.pkBizDate.getSqlDate();
            Date issueDate = this.payableBill.getIssueDate();
            Date expriedDate = this.payableBill.getExpiredDate();
            bizDate = DateTimeUtils.truncateDate((Date)bizDate);
            issueDate = DateTimeUtils.truncateDate((Date)issueDate);
            expriedDate = DateTimeUtils.truncateDate((Date)expriedDate);
            if (bizDate.before(issueDate) || bizDate.after(expriedDate)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"138_AssureAmountEditUI"));
                SysUtil.abort();
            }
            if ((amount2 = this.txtamount.getBigDecimalValue()) != null) {
                if (this.editData.getId() == null) {
                    if (amount2.compareTo(Constants.ZERO) <= 0 || amount2.compareTo(this.payableBill.getBalance()) > 0) {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"139_AssureAmountEditUI"));
                        SysUtil.abort();
                    }
                } else if (amount2.compareTo(Constants.ZERO) <= 0 || amount2.compareTo(this.payableBill.getBalance().add(amount2)) > 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"139_AssureAmountEditUI"));
                    SysUtil.abort();
                }
            }
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.kdCombCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtAssureType);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtamount);
        if (!FMHelper.isInstanceof((String)this.editData.getSourceBillId(), PayableBillInfo.class) || 0L != this.editData.getSeq()) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtseq);
        }
        if (this.txtAssureNo.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtAssureNo);
        }
        if (this.txtDescription.getText().length() > 500) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"425_AssureAmountEditUI"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assureAcct.*"));
        sic.add(new SelectorItemInfo("payAcct.*"));
        sic.add(new SelectorItemInfo("creditLimit.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("creditCurrency.*"));
        sic.add(new SelectorItemInfo("bizData.*"));
        sic.add(new SelectorItemInfo("sourceAmount"));
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isFivouchered()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"140_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getAssureState() != AssureStateEnum.SAVED) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"141_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getAssureSource() == AssureSourceEnum.MANUAL || this.editData.getAssureSource() == AssureSourceEnum.PAYABLEBILLREQ || this.editData.getAssureSource() == AssureSourceEnum.GUARANTEE || this.editData.getAssureSource() == AssureSourceEnum.LC) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"142_AssureAmountEditUI"));
            SysUtil.abort();
        }
        CurrencyInfo currency = (CurrencyInfo)this.kdCombCurrency.getSelectedItem();
        try {
            if (currency != null) {
                FinUtils.initExchangeRate((BasicFormattedTextField)this.txtlocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCurrency, (Date)this.editData.getBizDate());
            }
        }
        catch (Exception en) {
            this.handUIExceptionAndAbort(en);
        }
        this.txtAssureNo.setEnabled(true);
        this.txtAssureNo.setEditable(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isFivouchered()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"145_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getAssureState() != AssureStateEnum.SAVED) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"146_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getCashier() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"147_AssureAmountEditUI"));
            return;
        }
        if (this.editData.getAssureSource() == AssureSourceEnum.MANUAL) {
            super.actionRemove_actionPerformed(e);
        } else {
            PayableBillInfo payableInfo = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.editData.getSourceBillId())));
            if (!payableInfo.getBillState().equals((Object)PayableBillStateEnum.SUBMIT)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"148_AssureAmountEditUI"));
                SysUtil.abort();
            }
            if (this.editData.getAssureSource().equals((Object)AssureSourceEnum.PAYABLEBILL)) {
                long maxSeq = ((IAssureAmount)this.getBizInterface()).getMaxSeq(this.editData.getSourceBillId());
                if (this.editData.getSeq() != maxSeq) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"149_AssureAmountEditUI"));
                    SysUtil.abort();
                }
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("sourceBillType", null);
        super.actionSubmit_actionPerformed(e);
        if (!FMHelper.isEmpty(this.getUIContext().get("fmtype")) && this.getUIContext().get("fmtype").equals("createTo")) {
            this.getUIWindow().close();
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.idList.remove("total", true);
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.idList.remove("total", true);
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.idList.remove("total", true);
        super.actionLast_actionPerformed(e);
    }

    private void onloadPayableApplyBill(AssureAmountInfo info) {
        if (this.getBOTPViewStatus() == 1 && this.isFromApplyBill(info)) {
            this.txtseq.setValue((Object)new Long(1L));
            this.txtseq.setEnabled(false);
            this.comboSource.setSelectedIndex(4);
            this.kdCombCurrency.setSelectedItem((Object)this.contextHelp.getCurrentCompany().getBaseCurrency());
            this.kdCombCurrency.setEnabled(true);
            try {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"001"));
                SelectorItemCollection sic = new SelectorItemCollection();
                evi.setFilter(filter);
                AssureAmountTypeCollection coll = AssureAmountTypeFactory.getRemoteInstance().getAssureAmountTypeCollection(evi);
                if (coll.size() > 0) {
                    this.prmtAssureType.setData((Object)coll.get(0));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isFromApplyBill(AssureAmountInfo billInfo) {
        String sourceBillId = billInfo.getSourceBillId();
        return FMHelper.isInstanceof((String)sourceBillId, PayableApplyBillInfo.class);
    }

    @Override
    protected void txtAssureRate_dataChanged(DataChangeEvent e) throws Exception {
        AssureAmountInfo info = (AssureAmountInfo)this.getDataObject();
        if (this.getOprtState() == OprtState.ADDNEW && info.getSourceAmount() != null && this.txtAssureRate.getBigDecimalValue() != null) {
            BigDecimal assureRate = this.txtAssureRate.getBigDecimalValue();
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtamount, (Number)assureRate.multiply(info.getSourceAmount()));
        }
    }

    protected boolean isPerTitleAuto() {
        return false;
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }
}

