/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractAssureAmountFilterUI;
import com.kingdee.eas.fm.nt.client.AssureAmountFilterParam;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssureAmountFilterUI
extends AbstractAssureAmountFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AssureAmountFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        AssureAmountFilterParam param = new AssureAmountFilterParam();
        param.setBeginDate(this.kdpDateFrom.getSqlDate());
        param.setEndDate(this.kdpDateTo.getSqlDate());
        if (this.txtPayableNumber.getText() != null && !this.txtPayableNumber.getText().trim().equals("")) {
            param.setPayableBillNumber(this.txtPayableNumber.getText());
        } else {
            param.setPayableBillNumber(null);
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        HashSet<Integer> isState = new HashSet<Integer>();
        if (this.isSave.isSelected()) {
            isState.add(new Integer(AssureStateEnum.SAVED.getValue()));
        }
        if (this.isPaied.isSelected()) {
            isState.add(new Integer(AssureStateEnum.PAIED.getValue()));
        }
        if (this.isCancelled.isSelected()) {
            isState.add(new Integer(AssureStateEnum.CANCELLED.getValue()));
        }
        if (this.isReturned.isSelected()) {
            isState.add(new Integer(AssureStateEnum.RETURNED.getValue()));
        }
        param.setIsState(isState);
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        AssureAmountFilterParam fparam = (AssureAmountFilterParam)((Object)param);
        this.setCompanyIdSet(fparam.getCompanyIdSet());
        this.kdpDateFrom.setValue((Object)fparam.getBeginDate());
        this.kdpDateTo.setValue((Object)fparam.getEndDate());
        this.txtPayableNumber.setText(fparam.getPayableBillNumber());
        Set isState = fparam.getIsState();
        Object[] states = isState.toArray();
        this.isSave.setSelected(false);
        this.isPaied.setSelected(false);
        this.isCancelled.setSelected(false);
        for (int i = 0; i < states.length; ++i) {
            if (Integer.parseInt(states[i].toString()) == AssureStateEnum.SAVED.getValue()) {
                this.isSave.setSelected(true);
            }
            if (Integer.parseInt(states[i].toString()) == AssureStateEnum.PAIED.getValue()) {
                this.isPaied.setSelected(true);
            }
            if (Integer.parseInt(states[i].toString()) == AssureStateEnum.CANCELLED.getValue()) {
                this.isCancelled.setSelected(true);
            }
            if (Integer.parseInt(states[i].toString()) != AssureStateEnum.RETURNED.getValue()) continue;
            this.isReturned.setSelected(true);
        }
    }

    protected void init() throws Exception {
        super.init();
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.kdpDateFrom.getValue(), (Date)this.kdpDateTo.getValue());
        return super.verify();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.kdpDateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.kdpDateTo.setValue((Object)DateUtil.getDayEnd());
        this.txtPayableNumber.setText(null);
        this.isSave.setSelected(true);
        this.isPaied.setSelected(true);
        this.isCancelled.setSelected(false);
        this.isReturned.setSelected(false);
    }

    protected Class getParamClass() {
        return AssureAmountFilterParam.class;
    }
}

