/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.GuaranteeApplyInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.client.BankFactorEditUI;
import com.kingdee.eas.fm.ctl.client.GuaranteeApplyEditUI;
import com.kingdee.eas.fm.ctl.client.LetterOfGuaranteeEditUI;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.LoanEditUI;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.nt.AssureAmountCollection;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillInfo;
import com.kingdee.eas.fm.nt.AssureSourceEnum;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.IAssureAmount;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyInfo;
import com.kingdee.eas.fm.nt.PayableApplyBillFactory;
import com.kingdee.eas.fm.nt.PayableApplyBillInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractAssureAmountListUI;
import com.kingdee.eas.fm.nt.client.AssureAmountEditUI;
import com.kingdee.eas.fm.nt.client.AssureAmountFilterUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditApplyEditUI;
import com.kingdee.eas.fm.nt.client.PayableApplyBillEditUI;
import com.kingdee.eas.fm.nt.client.PayableBillEditUI;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssureAmountListUI
extends AbstractAssureAmountListUI {
    private static final Logger logger = CoreUIObject.getLogger(AssureAmountListUI.class);
    private AssureAmountFilterUI filterUI;
    private IKDTablePrecisionFormater precFormater = null;
    private IKDTablePrecisionFormater creditPrecFormater = null;
    private Map currencyCache = new HashMap();
    private boolean isNeedAudit;
    protected CompanyOrgUnitInfo currentCompany;
    protected BillBaseInfo billInfo;
    static final String FROM_INFO = "fromInfo";

    public AssureAmountListUI() throws Exception {
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        this.currentCompany = contextHelper.getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.isNeedAudit = contextHelper.getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        this.precFormater = new DefaultKDTablePrecisionFormater();
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider("currency.id"));
        this.creditPrecFormater = new DefaultKDTablePrecisionFormater();
        this.creditPrecFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider("creditCurrency.id"));
    }

    public void onLoad() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.precFormater.init(this.getMainTable(), new String[]{"amount"});
        this.creditPrecFormater.init(this.getMainTable(), new String[]{"returnQuota"});
        this.billInfo = (BillBaseInfo)this.getUIContext().get(FROM_INFO);
        if (this.billInfo != null) {
            this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
        }
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        this.actionAddNew.setVisible(true);
        this.actionEdit.setVisible(true);
        this.actionLocate.setVisible(false);
        this.actionRevoke.setEnabled(false);
        if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            this.tblMain.getColumn("payablebill").setStat(true);
            IRow rowLongTime = this.tblMain.getGroupManager().getStatRowTemplate(0);
            rowLongTime.getCell("payablebill").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"150_AssureAmountListUI"));
            rowLongTime.getCell("amount").setExpressions("SUM");
            rowLongTime.getCell("localAmt").setExpressions("SUM");
            rowLongTime.setStat(true);
            rowLongTime.getStyleAttributes().isLocked();
            rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowLongTime.getCell("payablebill").getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowLongTime.getCell("amount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowLongTime.getCell("localAmt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        }
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"localAmt", (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.tblMain.getColumn("localCurExRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
        this.tblMain.getColumn("creditCurExRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
        if (this.billInfo != null) {
            this.actionAppoin.setVisible(true);
            this.actionQuery.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionView.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionRefresh.setVisible(false);
            this.actionViewSource.setVisible(false);
            this.actionTraceDown.setVisible(false);
            this.actionBook.setVisible(false);
            this.actionCancelBook.setVisible(false);
            this.actionCasPayment.setVisible(false);
            this.actionRevoke.setVisible(false);
            this.actionReturn.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
        }
    }

    public void refreshList() throws Exception {
        super.refreshList();
    }

    public void applyTableSetting(String tableParams) {
        super.applyTableSetting(tableParams);
        try {
            this.refresh(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.refresh(e);
        this.processPrecision();
    }

    protected void initListener() {
        super.initListener();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.refreshList();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(true);
        this.actionViewSource.setEnabled(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionViewSource.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.actionEdit.setVisible(true);
        this.actionCasPayment.setEnabled(false);
        this.actionCancelCasPayment.setEnabled(false);
        this.actionRevoke.setEnabled(false);
        this.actionCancelRevoke.setEnabled(false);
        this.actionBook.setEnabled(false);
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCasPayment.setIcon(EASResource.getIcon((String)"imgTbtn_particular"));
        this.actionRevoke.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_showbusiness"));
        this.actionReturn.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwriting"));
        if (this.billInfo != null) {
            this.actionAddNew.setVisible(false);
            this.actionView.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
        }
    }

    public void initDapButtons() {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.processPrecision();
        this.initWorkButton();
        String pk = null;
        pk = this.getSelectedKeyValue();
        if (pk == null || pk.equals("total")) {
            return;
        }
        if (pk != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo = this.getViewInfo(pk);
            Object paymentBillInfo = null;
            AssureAmountInfo info = AssureAmountFactory.getRemoteInstance().getAssureAmountInfo((IObjectPK)new ObjectUuidPK(pk));
            if (AssureStateEnum.SAVED.equals((Object)info.getAssureState())) {
                this.actionCasPayment.setEnabled(true);
            }
            if (AssureStateEnum.PAIED.equals((Object)info.getAssureState())) {
                this.actionCancelCasPayment.setEnabled(true);
                this.actionRevoke.setEnabled(true);
            }
            if (AssureStateEnum.CANCELLED.equals((Object)info.getAssureState())) {
                this.actionCancelRevoke.setEnabled(true);
            }
            if (AssureStateEnum.PAIED.equals((Object)info.getAssureState()) && !info.isIsGenePayBill() && info.getCashier() == null) {
                this.actionBook.setEnabled(true);
            }
        } else {
            SysUtil.abort();
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        super.tblMain_tableSelectChanged(e);
        String id = this.getSelectedKeyValue();
        if (id == null || id.equals("total")) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionBook.setEnabled(false);
            this.actionCancelBook.setEnabled(false);
            return;
        }
        AssureAmountInfo bill = ((IAssureAmount)this.getBizInterface()).getAssureAmountInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionVoucher.setEnabled(!bill.isFivouchered());
        this.actionDelVoucher.setEnabled(bill.isFivouchered());
        if (bill.getAssureState() == AssureStateEnum.CANCELLED) {
            this.actionReturn.setEnabled(true);
        } else {
            this.actionReturn.setEnabled(false);
        }
        IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"151_AssureAmountListUI") + val));
        }
        if (bill != null && val == 0) {
            boolean isCanBook;
            int rowNum = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            if (rowNum < 0) {
                return;
            }
            Object cashName = this.tblMain.getRow(rowNum).getCell("cashier").getValue();
            boolean bl = isCanBook = AssureStateEnum.PAIED.equals((Object)bill.getAssureState()) && !bill.isIsGenePayBill();
            if (isCanBook) {
                if (cashName != null) {
                    this.actionBook.setEnabled(false);
                    this.actionCancelBook.setEnabled(true);
                } else {
                    this.actionBook.setEnabled(true);
                    this.actionCancelBook.setEnabled(false);
                }
            }
        } else {
            this.actionBook.setEnabled(false);
            this.actionCancelBook.setEnabled(false);
        }
        this.billInfo = (BillBaseInfo)this.getUIContext().get(FROM_INFO);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (this.billInfo != null && selectRows.length == 1) {
            this.actionAppoin.setVisible(true);
            this.actionAppoin.setEnabled(true);
        } else {
            this.actionAppoin.setEnabled(false);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AssureAmountFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected String getEditUIName() {
        return AssureAmountEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AssureAmountFactory.getRemoteInstance();
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"payablebill"};
    }

    @Override
    public void actionViewSource_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 0) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(0));
            IRow row = this.tblMain.getRow(selectBlock.getTop());
            if (row.getCell("sourceBillId").getValue() == null) {
                return;
            }
            String id = row.getCell("sourceBillId").getValue().toString();
            if (id == null) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = null;
            if (BOSUuid.read((String)id).getType().equals((Object)new PayableBillInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(PayableBillEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (BOSUuid.read((String)id).getType().equals((Object)new PayableApplyBillInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(PayableApplyBillEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (BOSUuid.read((String)id).getType().equals((Object)new LetterOfCreditApplyInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LetterOfCreditApplyEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (BOSUuid.read((String)id).getType().equals((Object)new BankFactorInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(BankFactorEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (BOSUuid.read((String)id).getType().equals((Object)new LetterOfGuaranteeInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LetterOfGuaranteeEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (BOSUuid.read((String)id).getType().equals((Object)new GuaranteeApplyInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(GuaranteeApplyEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (BOSUuid.read((String)id).getType().equals((Object)new LoanInfo().getBOSType())) {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LoanEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }
            if (uiWindow != null) {
                uiWindow.show();
            }
            this.refreshList();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assureAcct.*"));
        sic.add(new SelectorItemInfo("payAcct.*"));
        sic.add(new SelectorItemInfo("creditLimit.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("creditCurrency.*"));
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.equals("total")) {
            return;
        }
        AssureAmountInfo bill = ((IAssureAmount)this.getBizInterface()).getAssureAmountInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (bill.isFivouchered()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"140_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (bill.getAssureState() != AssureStateEnum.SAVED) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"141_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (bill.getCashier() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"152_AssureAmountListUI"));
            return;
        }
        if (bill.getAssureSource() == AssureSourceEnum.MANUAL || bill.getAssureSource() == AssureSourceEnum.PAYABLEBILLREQ || bill.getAssureSource() == AssureSourceEnum.GUARANTEE || bill.getAssureSource() == AssureSourceEnum.LC || bill.getAssureSource() == AssureSourceEnum.PAYABLEBILL && 0L == bill.getSeq()) {
            if (bill.getSourceBillId() != null && bill.getAssureSource() == AssureSourceEnum.MANUAL) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"575_AppoinAssure"));
                SysUtil.abort();
            }
            if (bill.getAssureSource() == AssureSourceEnum.PAYABLEBILLREQ) {
                PayableApplyBillInfo applyInfo = PayableApplyBillFactory.getRemoteInstance().getPayableApplyBillInfo((IObjectPK)new ObjectUuidPK(bill.getSourceBillId()));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)applyInfo.getId().toString()));
                if (PayableBillFactory.getRemoteInstance().exists(filter)) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"108_HASDESTNOEDITANDREMOVE"));
                    SysUtil.abort();
                }
            }
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"142_AssureAmountEditUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        PayableBillCollection coll;
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.equals("total")) {
            return;
        }
        AssureAmountInfo bill = ((IAssureAmount)this.getBizInterface()).getAssureAmountInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (bill.isFivouchered()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"145_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (bill.getAssureState() != AssureStateEnum.SAVED) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"146_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (bill.getCashier() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"147_AssureAmountEditUI"));
            SysUtil.abort();
        }
        if (FMHelper.isInstanceof((String)bill.getSourceBillId(), PayableBillInfo.class)) {
            PayableBillInfo payableInfo = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(bill.getSourceBillId()), this.getSic4Payable());
            if (this.hasDest(payableInfo)) {
                MsgBox.showWarning((String)this.getResource("470_HasDestNoRemove"));
                SysUtil.abort();
            }
        } else if (FMHelper.isInstanceof((String)bill.getSourceBillId(), PayableApplyBillInfo.class) && (coll = PayableBillFactory.getRemoteInstance().getPayableBillCollection(ConvertUtils.newEV((Object[])new Object[]{ConvertUtils.include((String)"sourceBillId", (Object)bill.getSourceBillId()), this.getSic4Payable()}))) != null && coll.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"108_HASDESTNOEDITANDREMOVE"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    protected SelectorItemCollection getSic4Payable() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billState");
        return sic;
    }

    private boolean hasDest(PayableBillInfo payableInfo) {
        return PayableBillStateEnum.CASH == payableInfo.getBillState() || PayableBillStateEnum.ABANDON == payableInfo.getBillState() || PayableBillStateEnum.AbandonByHand == payableInfo.getBillState() || PayableBillStateEnum.Discount == payableInfo.getBillState() || PayableBillStateEnum.TranLoan == payableInfo.getBillState();
    }

    private String getResource(String keyName) {
        return EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)keyName);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    protected boolean isFootVisible() {
        return false;
    }

    protected String[] getNotOrderColumns() {
        String[] list = new String[this.tblMain.getColumnCount() - 1];
        int s = 0;
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            String colKey = this.tblMain.getColumn(i).getKey();
            if (colKey.equals("payablebill")) continue;
            list[s++] = colKey;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        super.actionBook_actionPerformed(e);
        IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (val != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"154_AssureAmountListUI"));
            SysUtil.abort();
        }
        ArrayList idlist = this.getSelectedIdValues();
        HashSet<String> idSet = new HashSet<String>(idlist);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        AssureAmountCollection coll = AssureAmountFactory.getRemoteInstance().getAssureAmountCollection(view);
        idSet.clear();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            AssureAmountInfo info = (AssureAmountInfo)it.next();
            if (info.getPayAcct() == null || info.getPayAcct().getId() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"155_AssureAmountListUI"));
                continue;
            }
            if (info.getAssureAcct() == null || info.getAssureAcct().getId() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"156_AssureAmountListUI"));
                continue;
            }
            if (info.getCurrency() != null && !info.getCurrency().equals((Object)info.getPayAcct().getCurrency()) && info.getPayAcct().isIsByCurrency()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"157_AssureAmountListUI"));
                continue;
            }
            if (info.getCurrency() != null && !info.getCurrency().equals((Object)info.getAssureAcct().getCurrency()) && info.getAssureAcct().isIsByCurrency()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"158_AssureAmountListUI"));
                continue;
            }
            if (info.getCashier() != null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"159_AssureAmountListUI"));
                return;
            }
            idSet.add(info.getId().toString());
        }
        if (idSet.size() > 0) {
            ArApRecPayHelper.requestMutex((CoreUI)this, idSet);
            try {
                ((IAssureAmount)this.getBizInterface()).book(idSet);
            }
            finally {
                ArApRecPayHelper.releaseMutex(idSet);
            }
            this.refresh(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (val != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"154_AssureAmountListUI"));
            SysUtil.abort();
        }
        ArrayList idlist = this.getSelectedIdValues();
        HashSet<String> idSet = new HashSet<String>(idlist);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        AssureAmountCollection coll = AssureAmountFactory.getRemoteInstance().getAssureAmountCollection(view);
        idSet.clear();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            AssureAmountInfo info = (AssureAmountInfo)it.next();
            if (info.getCashier() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"160_AssureAmountListUI"));
                continue;
            }
            idSet.add(info.getId().toString());
        }
        if (idSet.size() > 0) {
            ArApRecPayHelper.requestMutex((CoreUI)this, idSet);
            try {
                ((IAssureAmount)this.getBizInterface()).cancelBook(idSet);
            }
            finally {
                ArApRecPayHelper.releaseMutex(idSet);
            }
            this.refresh(e);
        }
    }

    protected int queryCurrencyPrecision(String curId) throws EASBizException, BOSException {
        if (this.currencyCache.containsKey(curId)) {
            Integer intPrec = (Integer)this.currencyCache.get(curId);
            return intPrec;
        }
        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(curId));
        Integer intPrec = new Integer(cur.getPrecision());
        this.currencyCache.put(curId, intPrec);
        return intPrec;
    }

    private void processPrecision() {
        try {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.isStat()) {
                    IRow rowUpOne = this.tblMain.getRow(i - 1);
                    if (EmptyUtil.isEmpty((Object)rowUpOne.getCell("id").getValue())) continue;
                    String formatString = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision((String)rowUpOne.getCell("currency.id").getValue()));
                    String formatString2 = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision(this.baseCurrencyCommon.getId().toString()));
                    row.getCell("amount").getStyleAttributes().setNumberFormat(formatString);
                    row.getCell("localAmt").getStyleAttributes().setNumberFormat(formatString2);
                    continue;
                }
                if (EmptyUtil.isEmpty((Object)row.getCell("id").getValue())) continue;
                String formatString = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision((String)row.getCell("currency.id").getValue()));
                String formatString2 = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision(this.baseCurrencyCommon.getId().toString()));
                row.getCell("amount").getStyleAttributes().setNumberFormat(formatString);
                row.getCell("localAmt").getStyleAttributes().setNumberFormat(formatString2);
                if (row.getCell("creditCurrency.id").getValue() != null) {
                    String formatString3 = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision((String)row.getCell("creditCurrency.id").getValue()));
                    row.getCell("returnQuota").getStyleAttributes().setNumberFormat(formatString3);
                } else {
                    row.getCell("returnQuota").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
                }
                if (row.getCell("assureRate").getValue() == null) continue;
                row.getCell("assureRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        IRow rowLongTime = this.tblMain.getGroupManager().getStatRowTemplate(0);
        rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
        this.processPrecision();
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0 || this.tblMain.getRow(selectRows[0]).getCell("id").getValue() == null || ((String)this.tblMain.getRow(selectRows[0]).getCell("id").getValue()).equals("total")) {
            return;
        }
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0 || this.tblMain.getRow(selectRows[0]).getCell("id").getValue() == null || ((String)this.tblMain.getRow(selectRows[0]).getCell("id").getValue()).equals("total")) {
            return;
        }
        super.actionView_actionPerformed(e);
    }

    protected int getIdListModel() {
        return 0;
    }

    protected void initTableParams() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.setEditable(false);
    }

    @Override
    public void actionCasPayment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int state = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"161_AssureAmountListUI"));
        ArrayList idList = this.getSelectedIdValues();
        ArrayList idlist = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idlist);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        CoreBillBaseCollection coll = AssureAmountFactory.getRemoteInstance().getCoreBillBaseCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            AssureAmountInfo info = (AssureAmountInfo)coll.get(i);
            if (AssureStateEnum.SAVED.equals((Object)info.getAssureState())) continue;
            String failDetail = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"589_AssureAmountListUI") + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"590_AssureAmountListUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"591_AssureAmountListUI"), (String)failDetail, (int)2);
            SysUtil.abort();
            this.refresh(e);
        }
        if (state == 0) {
            FMClientHelper.generateDestBillAss((CoreBillListUI)this, (String)new AssureAmountInfo().getBOSType().toString(), (String)new PaymentBillInfo().getBOSType().toString(), (CoreBillBaseCollection)coll);
        } else if (state == 1) {
            this.CasPayment(idSet);
        } else if (state == 2) {
            SysUtil.abort();
        }
        this.initWorkButton();
        this.refresh(e);
    }

    @Override
    public void actionCancelCasPayment_actionPerformed(ActionEvent e) throws Exception {
        String pk = this.getSelectedKeyValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo = this.getViewInfo(pk);
        PaymentBillInfo paymentBillInfo = null;
        if (PaymentBillFactory.getRemoteInstance().getPaymentBillCollection(viewInfo) != null) {
            paymentBillInfo = PaymentBillFactory.getRemoteInstance().getPaymentBillCollection(viewInfo).get(0);
        }
        if (paymentBillInfo != null) {
            BOSObjectType TransUpBillInfo_Type = new TransUpBillInfo().getBOSType();
            String sourceBillId = paymentBillInfo.getSourceBillId();
            if (!FMHelper.isEmpty((String)sourceBillId)) {
                BOSUuid sbid = BOSUuid.read((String)sourceBillId);
                if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType())) {
                    throw new RecPayException(RecPayException.CANNOTDELETEPAYFORSOURCE);
                }
                if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                    throw new RecPayException(RecPayException.AGENTPAYBILLNOTDELETE);
                }
                if (TransUpBillInfo_Type.equals((Object)sbid.getType())) {
                    throw new RecPayException(RecPayException.PAYMENTBILLDELETEERROR, new Object[]{paymentBillInfo.getNumber()});
                }
            }
            PaymentBillFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(paymentBillInfo.getId()));
        }
        this.CancelCasPayment(e);
        this.initWorkButton();
        this.refresh(e);
    }

    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.Revoke(e);
        this.initWorkButton();
        this.refresh(e);
    }

    @Override
    public void actionCancelRevoke_actionPerformed(ActionEvent e) throws Exception {
        this.CancelRevoke(e);
        this.initWorkButton();
        this.refresh(e);
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        if (pk == null) {
            return;
        }
        AssureAmountInfo info = AssureAmountFactory.getRemoteInstance().getAssureAmountInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (info.getAssureState() != AssureStateEnum.CANCELLED) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"430_AssureAmountBillListUI"));
            this.refresh(e);
            SysUtil.abort();
        }
        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new AssureAmountInfo().getBOSType().toString(), (String)new AssureAmountReturnBillInfo().getBOSType().toString(), (String)this.getSelectedKeyValue());
    }

    private EntityViewInfo getViewInfo(String pk) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)pk));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    private void CancelCasPayment(ActionEvent e) {
        String pk = this.getSelectedKeyValue();
        try {
            ((IAssureAmount)this.getBizInterface()).CancelCasPayment((IObjectPK)new ObjectUuidPK(pk));
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void CasPayment(Set idSet) {
        try {
            ((IAssureAmount)this.getBizInterface()).batchCasPayment(idSet);
            this.refreshList();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void Revoke(ActionEvent e) {
        String pk = this.getSelectedKeyValue();
        try {
            ((IAssureAmount)this.getBizInterface()).Revoke((IObjectPK)new ObjectUuidPK(pk));
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void CancelRevoke(ActionEvent e) {
        String pk = this.getSelectedKeyValue();
        try {
            BankFactorInfo bankFactorInfo;
            AssureAmountInfo assureAmountInfo = AssureAmountFactory.getRemoteInstance().getAssureAmountInfo((IObjectPK)new ObjectUuidPK(pk));
            String sourceBillID = assureAmountInfo.getSourceBillId();
            if (FMHelper.isInstanceof((String)sourceBillID, BankFactorInfo.class) && (bankFactorInfo = BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectUuidPK(sourceBillID))).getLoanAmount().compareTo(Constants.ZERO) > 0 && bankFactorInfo.getLoanBalance().compareTo(Constants.ZERO) == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"162_AssureAmountListUI"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        try {
            ((IAssureAmount)this.getBizInterface()).CancelRevoke((IObjectPK)new ObjectUuidPK(pk));
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    protected void execQuery() {
        Map botpCtx;
        if (this.getBOTPViewStatus() == 1 && (botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER")) != null) {
            String targetBillType = (String)botpCtx.get("TargetBillType");
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            FilterInfo filter = new FilterInfo();
            if (targetBillType != null) {
                if (targetBillType.equals("PaymentBill")) {
                    filter.getFilterItems().add(new FilterItemInfo("assureState", (Object)new Integer(1), CompareType.NOTEQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("assureState", (Object)new Integer(2), CompareType.NOTEQUALS));
                }
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    SysUtil.abort((Throwable)e);
                }
                this.tblMain.getSelectManager().setSelectMode(2);
            }
        }
        super.execQuery();
    }

    public void getBillIdList(List idList, List entriesList) {
        super.getBillIdList(idList, entriesList);
        Iterator iterator = idList.iterator();
        while (iterator.hasNext()) {
            Object id = iterator.next();
            if (!EmptyUtil.isEmpty(id)) continue;
            iterator.remove();
        }
    }

    @Override
    public void actionAppoin_actionPerformed(ActionEvent e) throws Exception {
        this.billInfo = (BillBaseInfo)this.getUIContext().get(FROM_INFO);
        String id = this.getSelectedKeyValue();
        PayableBillFactory.getRemoteInstance().appointAssure((PayableBillInfo)this.billInfo, id);
        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"574_AppoinAssureSuccess"));
        this.getUIWindow().close();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            AssureAmountListUI.this.processPrecision();
        }
    }
}

