/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillFactory;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillInfo;
import com.kingdee.eas.fm.nt.AssureAmountReturnStateEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.client.AbstractAssureAmountReturnBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class AssureAmountReturnBillEditUI
extends AbstractAssureAmountReturnBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AssureAmountReturnBillEditUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo currentCurrency;

    public AssureAmountReturnBillEditUI() throws Exception {
        IContextHelper ch = ContextHelperFactory.getRemoteInstance();
        this.currentCompany = ch.getCurrentCompany();
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), selectors);
        this.currentCurrency = info.getBaseCurrency();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        }
        FMClientHelper.initReadNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)this.editData.getCurrency());
        try {
            FinUtils.initExchangeRate((BasicFormattedTextField)this.txtRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)this.editData.getCurrency(), (CurrencyInfo)this.currentCurrency, (Date)this.editData.getCreateDate());
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.calcTotalAmount();
        this.calcLocalAmount();
        this.storeFields();
        this.initOldData(this.getDataObject());
        this.actionAttachment.setVisible(false);
    }

    @Override
    protected void pkReturnDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcAssureInterest();
    }

    @Override
    protected void txtInterestRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcAssureInterest();
    }

    @Override
    protected void txtRate_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            this.txtRate.setValue((Object)Constants.ZERO);
        }
        this.calcLocalAmount();
    }

    @Override
    protected void txtAssureInterest_dataChanged(DataChangeEvent e) throws Exception {
        this.calcTotalAmount();
    }

    @Override
    protected void combCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.combCurrency.getSelectedItem();
        CurrencyInfo baseCur = FMClientHelper.getCurrencyInfo((BOSUuid)this.currentCompany.getBaseCurrency().getId());
        if (currency == null) {
            return;
        }
        AssureAmountReturnBillInfo info = (AssureAmountReturnBillInfo)this.getDataObject();
        if (info != null) {
            FinUtils.initExchangeRate((BasicFormattedTextField)this.txtRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.currentCurrency, (Date)info.getCreateDate());
        }
        this.txtAssureAmount.setPrecision(currency.getPrecision());
        this.txtTotalAmount.setPrecision(currency.getPrecision());
        this.txtAssureInterest.setPrecision(currency.getPrecision());
        this.txtRate.setPrecision(currency.getPrecision());
        this.txtLocalCurAmount.setPrecision(baseCur.getPrecision());
    }

    @Override
    protected void txtTotalAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcLocalAmount();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.getUIWindow().close();
        }
    }

    private void calcAssureInterest() {
        Date returnDate = DateTimeUtils.truncateDate((Date)this.pkReturnDate.getSqlDate());
        Date outDate = DateTimeUtils.truncateDate((Date)this.pkOutDate.getSqlDate());
        BigDecimal assureAmount = this.txtAssureAmount.getBigDecimalValue();
        BigDecimal interestRate = this.txtInterestRate.getBigDecimalValue();
        if (returnDate == null || outDate == null || assureAmount == null || interestRate == null) {
            return;
        }
        BigDecimal dateDiff = new BigDecimal(DateUtil.getDiffDays((Date)outDate, (Date)returnDate) - 1);
        BigDecimal assureInterest = assureAmount.multiply(interestRate).multiply(dateDiff).divide(new BigDecimal(360), this.txtAssureInterest.getPrecision()).divide(new BigDecimal(100), this.txtAssureInterest.getPrecision());
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtAssureInterest, (Number)assureInterest);
    }

    private void calcLocalAmount() {
        BigDecimal bdAmount = this.txtTotalAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtRate.getBigDecimalValue();
        BigDecimal result = Constants.ZERO;
        if (bdAmount != null && bdLocalExRate != null) {
            result = bdAmount.multiply(bdLocalExRate);
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalCurAmount, (Number)result);
    }

    private void calcTotalAmount() {
        BigDecimal assureInterest = this.txtAssureInterest.getBigDecimalValue();
        BigDecimal assureAmount = this.txtAssureAmount.getBigDecimalValue();
        if (assureInterest == null || assureAmount == null) {
            return;
        }
        BigDecimal totalAmount = assureInterest.add(assureAmount);
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtTotalAmount, (Number)totalAmount);
    }

    protected IObjectValue createNewData() {
        AssureAmountReturnBillInfo info = new AssureAmountReturnBillInfo();
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setReturnDate(new Date());
        info.setCreateDate(new Date());
        info.setReturnState(AssureAmountReturnStateEnum.SUBMIT);
        info.setInterestRate(Constants.ZERO);
        info.setAssureInterest(Constants.ZERO);
        info.setIsGenRec(false);
        info.setFivouchered(false);
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        if (this.txtNumber.getText().length() > 80) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"437_AssureAmountReturnBillEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.txtDescription.getText().length() > 200) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"428_AssureAmountReturnBillEditUI"));
            this.txtDescription.requestFocus();
            SysUtil.abort();
        }
        Date outDate = (Date)this.pkOutDate.getValue();
        Date returnDate = (Date)this.pkReturnDate.getValue();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AssureAmountReturnBillFactory.getRemoteInstance();
    }

    protected void initDataStatus() {
        this.initUI();
        super.initDataStatus();
    }

    protected void initUI() {
        this.pkOutDate.setEnabled(false);
        this.txtSourceBillNo.setEnabled(false);
        this.prmtAssureType.setEnabled(false);
        this.txtAssureAmount.setEnabled(false);
        this.combCurrency.setEnabled(false);
        this.txtTotalAmount.setEnabled(false);
        this.txtLocalCurAmount.setEnabled(false);
        try {
            FinUtils.initCurrencyComboBox((KDComboBox)this.combCurrency);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        NTHelper.initAccountBankPromt(this.prmtAssureAccount);
        NTHelper.initAccountBankPromt(this.prmtRecAccount);
        this.txtAssureAmount.setHorizontalAlignment(4);
        this.txtAssureAmount.setRemoveingZeroInDispaly(false);
        this.txtAssureAmount.setPrecision(5);
        this.txtInterestRate.setHorizontalAlignment(4);
        this.txtInterestRate.setRemoveingZeroInDispaly(false);
        this.txtInterestRate.setPrecision(5);
        this.txtInterestRate.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtAssureInterest.setHorizontalAlignment(4);
        this.txtAssureInterest.setRemoveingZeroInDispaly(false);
        this.txtAssureInterest.setPrecision(5);
        this.txtTotalAmount.setHorizontalAlignment(4);
        this.txtTotalAmount.setRemoveingZeroInDispaly(false);
        this.txtTotalAmount.setPrecision(5);
        this.txtRate.setHorizontalAlignment(4);
        this.txtRate.setRemoveingZeroInDispaly(false);
        this.txtRate.setPrecision(5);
        this.txtLocalCurAmount.setHorizontalAlignment(4);
        this.txtLocalCurAmount.setRemoveingZeroInDispaly(false);
        this.txtLocalCurAmount.setPrecision(5);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        try {
            if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW)) {
                this.setDefaultValue((AssureAmountReturnBillInfo)dataObject);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void setDefaultValue(AssureAmountReturnBillInfo info) {
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setReturnDate(new Date());
        info.setCreateDate(new Date());
        info.setReturnState(AssureAmountReturnStateEnum.SUBMIT);
        info.setInterestRate(Constants.ZERO);
        info.setAssureInterest(Constants.ZERO);
        info.setIsGenRec(false);
        info.setFivouchered(false);
    }
}

