/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.BizUnitControlUtilHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.BankDraftReqCollection;
import com.kingdee.eas.fm.nt.BankDraftReqFactory;
import com.kingdee.eas.fm.nt.BankDraftReqInfo;
import com.kingdee.eas.fm.nt.DeEnum;
import com.kingdee.eas.fm.nt.IBankDraftReq;
import com.kingdee.eas.fm.nt.INTType;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReqBillStateEnum;
import com.kingdee.eas.fm.nt.SameDifferEnum;
import com.kingdee.eas.fm.nt.client.AbstractBankDraftReqEditUI;
import com.kingdee.eas.fm.nt.client.BankDraftDataProvider;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BankDraftReqEditUI
extends AbstractBankDraftReqEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BankDraftReqEditUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    private boolean isCopy = false;
    private BizUnitControlUtilHelper bizUnitControlUtilHelper;
    private Locale locale = SysContext.getSysContext().getLocale();
    public static final String BankDraftReq_FILENAME = "/FM/NT/BankDraftReq";

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    @Override
    public void loadFields() {
        try {
            Map listeners = FMClientHelper.removeCompListeners((CoreUI)this);
            try {
                super.loadFields();
                UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtOrgUnit);
                FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgOutItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
                if (this.editData.getPayAmount().compareTo(new BigDecimal("0.00")) > 0) {
                    this.txtDamount.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtPayAmount.getNumberValue()), (boolean)true, (Locale)this.locale));
                }
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
                this.sysCurrencyHand();
                FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
                if ("EDIT".equals(this.getOprtState()) && ReqBillStateEnum.SUBMIT.getValue() == BankDraftReqFactory.getRemoteInstance().getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(this.editData.getId())).getBillState().getValue()) {
                    this.btnSave.setEnabled(false);
                }
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
            }
            finally {
                FMClientHelper.addCompListeners((CoreUI)this, (Map)listeners);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.txtDamount.setText("");
        }
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgOutItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("recAccountBank");
        sic.add("recPerson");
        sic.add("recBank");
        sic.add("bgOutItemID");
        sic.add("bgOutItemNumber");
        sic.add("bgOutItemName");
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        return sic;
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        super.onLoad();
        ExtendParser bankParser = new ExtendParser(this.prmtRecAccountBank);
        this.prmtRecAccountBank.setCommitParser((IParser)bankParser);
        this.prmtRecAccountBank.setMaxLength(80);
        ExtendParser bankParser2 = new ExtendParser(this.prmtRecBank);
        this.prmtRecBank.setCommitParser((IParser)bankParser2);
        this.prmtRecBank.setMaxLength(80);
        this.btnViewBdgBalance.setVisible(true);
        this.btnViewBdgBalance.setEnabled(true);
        this.actionViewBdgBalance.setVisible(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.cboCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    BankDraftReqEditUI.this.comboCurrency_itemStateChanged(e);
                }
                catch (Exception e1) {
                    BankDraftReqEditUI.this.handUIException(e1);
                }
            }
        });
        this.prmtRecPerson.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BankDraftReqEditUI.this.prmtRecPerson_dataChanged(e);
                }
                catch (Exception exc) {
                    BankDraftReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtRecAccountBank.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BankDraftReqEditUI.this.txtPayeeAccountBank_willShow(e);
                }
                catch (Exception exc) {
                    BankDraftReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtRecAccountBank.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BankDraftReqEditUI.this.txtPayeeAccountBank_dataChanged(e);
                }
                catch (Exception exc) {
                    BankDraftReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtPayAccountBank.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BankDraftReqEditUI.this.prmtPayAccountBank_dataChanged(e);
                }
                catch (Exception exc) {
                    BankDraftReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.txtPayAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BankDraftReqEditUI.this.txtPayAmount_focusLosted(e);
                }
                catch (Exception exc) {
                    BankDraftReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.txtExchangeRate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BankDraftReqEditUI.this.txtPayAmount_focusLosted(e);
                }
                catch (Exception exc) {
                    BankDraftReqEditUI.this.handUIException(exc);
                }
            }
        });
        this.menuItemTDPrint.setEnabled(false);
        this.menuItemTDPrintPreview.setEnabled(false);
        this.menuItemTDPrint.setVisible(false);
        this.menuItemTDPrintPreview.setVisible(false);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!currentCompany.isIsBizUnit()) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCopy.setEnabled(false);
        }
        if (this.getOprtState().endsWith(OprtState.VIEW)) {
            this.actionSubmitBank.setEnabled(true);
            this.actionSubmitBank.setVisible(true);
            this.actionAddNew.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCopy.setEnabled(false);
        } else {
            this.actionSubmitBank.setEnabled(false);
            this.actionSubmitBank.setVisible(false);
        }
        this.bizUnitControlUtilHelper = new BizUnitControlUtilHelper((Object)this, 5);
        this.bizUnitControlUtilHelper.resetActionWithBlackWhiteList();
        if (this.bizUnitControlUtilHelper.isBizUnit()) {
            this.menuEdit.setVisible(false);
            this.menuBiz.setVisible(false);
            this.MenuService.setVisible(false);
            this.actionPrint.setVisible(false);
            this.actionPrintPreview.setVisible(false);
        }
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
    }

    protected void initUIProp() throws Exception {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.txtPayAmount.setHorizontalAlignment(4);
        this.txtPayAmount.setPrecision(2);
        this.txtPayAmount.setRemoveingZeroInDispaly(false);
        this.txtPreBalanceAmt.setHorizontalAlignment(4);
        this.txtPreBalanceAmt.setPrecision(2);
        this.txtPreBalanceAmt.setRemoveingZeroInDispaly(false);
        this.txtNaturalAmt.setHorizontalAlignment(4);
        this.txtNaturalAmt.setPrecision(2);
        this.txtNaturalAmt.setRemoveingZeroInDispaly(false);
        this.pkPrePayerDate.setSupportedEmpty(false);
        this.pkReqState.setSupportedEmpty(false);
        this.txtExchangeRate.setDataType(1);
        this.cboNtType.setEnabled(true);
        this.cboNtType.setRequired(true);
        NTHelper.initCSF7((IUIObject)this, this.prmtRecPerson, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign");
        this.initComboNtType(this.cboNtType, null);
        this.initF7AccountBank(this.prmtPayAccountBank);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtPayerBank, (Boolean)Boolean.TRUE, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgOutItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.actionCreateFrom.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionCopyFrom.setVisible(false);
    }

    private void initF7AccountBank(KDBizPromptBox prmtPayAccountBank) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.contextHelp.getCurrentCompany().getId()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtPayAccountBank.setEntityViewInfo(evi);
    }

    private void initF7BgItem(KDBizPromptBox prmtBgItem) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isForFP", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("fpDirection", (Object)new Integer(FpCashDirectionEnum.output.getValue())));
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("fpDirection", (Object)new Integer(FpCashDirectionEnum.other.getValue())));
        try {
            filterInfo.mergeFilter(filterInfo2, "OR");
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmtBgItem.setEntityViewInfo(evi);
    }

    protected IObjectValue createNewData() {
        BankDraftReqInfo bankDraft = null;
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            bankDraft = new BankDraftReqInfo();
            try {
                BankDraftReqInfo oldInfo = (BankDraftReqInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                bankDraft = oldInfo.copy();
                bankDraft.setReqState(DateUtil.getDayBegin());
                bankDraft.setBankState(BankPayingBillStateEnum.OP);
                bankDraft.setIsDraw(false);
                bankDraft.setBillState(ReqBillStateEnum.SAVE);
                bankDraft.setAreaType(SameDifferEnum.DIFFER);
                bankDraft.setBankType(DeEnum.STRIDE);
                this.isCopy = true;
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        } else {
            bankDraft = new BankDraftReqInfo();
            bankDraft.setCreator(this.contextHelp.getCurrentUser());
            bankDraft.setCompany(this.contextHelp.getCurrentCompany());
            bankDraft.setClient(this.contextHelp.getCurrentCompany());
            bankDraft.setReqState(DateUtil.getDayBegin());
            bankDraft.setPrePayerDate(bankDraft.getReqState());
            bankDraft.setExchangeRate(new BigDecimal("1"));
            bankDraft.setPayAmount(new BigDecimal("0.00"));
            bankDraft.setNaturalAmt(new BigDecimal("0.00"));
            bankDraft.setPreBalanceAmt(new BigDecimal("0.00"));
            bankDraft.setAreaType(SameDifferEnum.DIFFER);
            bankDraft.setBankType(DeEnum.STRIDE);
            bankDraft.setBankState(BankPayingBillStateEnum.OP);
            bankDraft.setIsDraw(false);
            bankDraft.setBillState(ReqBillStateEnum.SAVE);
            bankDraft.setCurrency(this.contextHelp.getCurrentCompany().getBaseCurrency());
            NTTypeInfo ntTypeInfo = new NTTypeInfo();
            bankDraft.setNtType(ntTypeInfo);
        }
        return bankDraft;
    }

    private void initComboNtType(KDComboBox combo, BankDraftReqInfo info) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("isCash"));
        evi.getSelector().add(new SelectorItemInfo("superGroup"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Constants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("superGroup", (Object)new Integer(9)));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        INTType iNTType = NTTypeFactory.getRemoteInstance();
        NTTypeCollection coll = iNTType.getNTTypeCollection(evi);
        if (coll != null && coll.size() > 0) {
            combo.removeAllItems();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                combo.addItem((Object)coll.get(i));
                NTTypeInfo typeInfo = coll.get(i);
                if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
                    if (!typeInfo.getId().toString().equals("uciLciLYQI2zufiQoFpdIxyakBM=")) continue;
                    combo.setSelectedIndex(i);
                    continue;
                }
                if (!typeInfo.getId().toString().equals(info.getNtType().getId().toString())) continue;
                combo.setSelectedIndex(i);
            }
        }
    }

    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo info = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        this.txtPayAmount.setPrecision(info.getPrecision());
        this.txtPreBalanceAmt.setPrecision(info.getPrecision());
        this.txtPayAmount.setRemoveingZeroInDispaly(false);
        this.txtPreBalanceAmt.setRemoveingZeroInDispaly(false);
        int prec = CasRecPayHandler.getExRatePrec((String)info.getId().toString(), null, (CompanyOrgUnitInfo)this.currentCompany, (Date)((Date)this.pkReqState.getValue()));
        this.txtExchangeRate.setPrecision(prec);
        this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)info, null, (Date)((Date)this.pkReqState.getValue())));
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setRemoveingZeroInEdit(true);
        boolean isLocalCurrency = RecPayHandler.isLocalCurrency((CurrencyInfo)info, null);
        if (isLocalCurrency) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
        this.txtNaturalAmt.setValue((Object)this.getDecimal(this.txtPayAmount.getNumberValue()).multiply(this.getDecimal(this.txtExchangeRate.getNumberValue())));
    }

    private void sysCurrencyHand() throws Exception {
        CurrencyInfo info = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        this.txtPayAmount.setPrecision(info.getPrecision());
        this.txtPreBalanceAmt.setPrecision(info.getPrecision());
        this.txtPayAmount.setRemoveingZeroInDispaly(false);
        this.txtPreBalanceAmt.setRemoveingZeroInDispaly(false);
        int prec = CasRecPayHandler.getExRatePrec((String)info.getId().toString(), null, (CompanyOrgUnitInfo)this.currentCompany, (Date)((Date)this.pkReqState.getValue()));
        this.txtExchangeRate.setPrecision(prec);
        this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setRemoveingZeroInEdit(true);
        boolean isLocalCurrency = RecPayHandler.isLocalCurrency((CurrencyInfo)info, null);
        if (isLocalCurrency) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
        this.txtNaturalAmt.setValue((Object)this.editData.getPayAmount().multiply(this.editData.getExchangeRate()));
    }

    private BigDecimal getDecimal(Object o) {
        if (o != null) {
            return (BigDecimal)o;
        }
        return Constants.ZERO;
    }

    protected void prmtRecPerson_dataChanged(DataChangeEvent e) throws Exception {
        CustomerInfo cust;
        Object payee = this.prmtRecPerson.getValue();
        if (payee instanceof SupplierInfo) {
            SupplierInfo supplier = this.getSupplier(this.prmtRecPerson.getData());
            if (supplier != null) {
                SupplierInfo realSupplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                SupplierCompanyInfoInfo supplierCompany = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplier.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                if (supplierCompany != null) {
                    CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)this.currentCompany.getId().toString());
                    this.txtRecAccountBank.setText(bankInfo.getBankAccount());
                    this.prmtRecBank.setData((Object)bankInfo.getBank());
                } else {
                    this.txtRecAccountBank.setText(null);
                    this.prmtRecBank.setData(null);
                }
            }
        } else if (payee instanceof CustomerInfo && (cust = this.getCustomer(this.prmtRecPerson.getData())) != null) {
            CustomerInfo realCust = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(cust.getId()));
            CustomerCompanyInfoInfo custCompany = CustomerFactory.getRemoteInstance().getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(cust.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            if (custCompany != null) {
                CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)cust, (String)this.currentCompany.getId().toString());
                this.txtRecAccountBank.setText(bankInfo.getBankAccount());
                this.prmtRecBank.setData((Object)bankInfo.getBank());
            } else {
                this.txtRecAccountBank.setText(null);
                this.prmtRecBank.setData(null);
            }
        }
    }

    protected void txtPayeeAccountBank_willShow(SelectorEvent e) throws Exception {
        this.setPayeeAccountBank();
    }

    private void setPayeeAccountBank() throws BOSException, EASBizException {
        Object payer = this.prmtRecPerson.getValue();
        boolean isSupplier = false;
        boolean isCustomer = false;
        boolean isInnerSupplierOrCustomer = false;
        SupplierInfo supplier = null;
        CustomerInfo customer = null;
        if (payer instanceof CurrentInfo) {
            if (payer != null && ((CurrentInfo)payer).getId() != null) {
                String id = ((CurrentInfo)payer).getId().toString();
                if (BOSUuid.read((String)id).getType().equals((Object)new SupplierInfo().getBOSType())) {
                    isSupplier = true;
                    supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(id));
                    isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
                } else if (BOSUuid.read((String)id).getType().equals((Object)new CustomerInfo().getBOSType())) {
                    isCustomer = true;
                    customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(id));
                    isInnerSupplierOrCustomer = customer.isIsInternalCompany();
                }
            }
        } else if (payer instanceof SupplierInfo) {
            isSupplier = true;
            supplier = (SupplierInfo)payer;
            if (supplier != null) {
                supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
            }
        } else if (payer instanceof CustomerInfo) {
            isCustomer = true;
            customer = (CustomerInfo)payer;
            if (customer != null) {
                customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()));
                isInnerSupplierOrCustomer = customer.isIsInternalCompany();
            }
        }
        if (isSupplier && !isInnerSupplierOrCustomer) {
            this.initSupplierCompanyInfoBank((DataBaseInfo)supplier, this.prmtRecAccountBank);
        } else if (isCustomer && !isInnerSupplierOrCustomer) {
            this.initCustomerCompanyInfoBank((DataBaseInfo)customer, this.prmtRecAccountBank);
        } else {
            this.initPayeeAcctBankASAcctBank();
        }
    }

    private void initSupplierCompanyInfoBank(DataBaseInfo supply, KDBizPromptBox txtPayeeAccountBank) {
        txtPayeeAccountBank.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
        txtPayeeAccountBank.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (supply != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        txtPayeeAccountBank.setEntityViewInfo(view);
        txtPayeeAccountBank.setEditFormat("$bankAccount$");
        txtPayeeAccountBank.setDisplayFormat("$bankAccount$");
        txtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initCustomerCompanyInfoBank(DataBaseInfo customer, KDBizPromptBox txtPayeeAccountBank) {
        txtPayeeAccountBank.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
        txtPayeeAccountBank.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (customer != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customer.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        txtPayeeAccountBank.setEntityViewInfo(view);
        txtPayeeAccountBank.setEditFormat("$bankAccount$");
        txtPayeeAccountBank.setDisplayFormat("$bankAccount$");
        txtPayeeAccountBank.setCommitFormat("$bankAccount$");
        txtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayeeAcctBankASAcctBank() {
        Object payeeName = this.prmtRecPerson.getData();
        Object payeeType = this.prmtRecPerson.getValue();
        this.initPayeeAccountBankEV(payeeType, payeeName);
        this.prmtRecAccountBank.setEditFormat("$bankAccountNumber$");
        this.prmtRecAccountBank.setDisplayFormat("$bankAccountNumber$");
        this.prmtRecAccountBank.setCommitFormat("$simpleCode$;$number$;$name$;$bankAccountNumber$");
        this.prmtRecAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayeeAccountBankEV(Object payeeType, Object payeeName) {
        FilterInfo filterName;
        this.prmtRecAccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        String realPayeeName = "";
        if (payeeType instanceof SupplierInfo && !FMHelper.isEmpty((Object)payeeName)) {
            if (payeeName instanceof DataBaseInfo) {
                SupplierInfo supplierInfo = (SupplierInfo)payeeName;
                realPayeeName = supplierInfo.getName();
            }
            if (realPayeeName != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayeeName));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        if (payeeType instanceof CustomerInfo && !FMHelper.isEmpty((Object)payeeName)) {
            if (payeeName instanceof DataBaseInfo) {
                CustomerInfo customerInfo = (CustomerInfo)payeeName;
                realPayeeName = customerInfo.getName();
            }
            if (realPayeeName != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayeeName));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtRecAccountBank.setEntityViewInfo(evi);
        this.prmtRecAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    protected void txtPayeeAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue()) && e.getNewValue() instanceof AccountBankInfo) {
            AccountBankInfo acctbank = (AccountBankInfo)e.getNewValue();
            if (acctbank.getBank() != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("company.*");
                selector.add("bank.*");
                AccountBankInfo bank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctbank.getId()), selector);
                this.prmtRecBank.setData((Object)bank.getBank().toString());
            }
        } else if (e.getNewValue() != null && (e.getNewValue() instanceof SupplierCompanyBankInfo || e.getNewValue() instanceof CustomerCompanyBankInfo)) {
            CoreBaseInfo obj = (CoreBaseInfo)e.getNewValue();
            String bank = (String)obj.get("bank");
            this.prmtRecBank.setData((Object)bank);
        } else if (e.getNewValue() == null) {
            this.editData.setRecAccountBank(null);
            this.prmtRecBank.setData(null);
        }
    }

    private void prmtPayAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        Object o = e.getNewValue();
        if (null == o) {
            this.prmtPayerBank.setValue(null);
            return;
        }
        AccountBankInfo accountBankInfo = (AccountBankInfo)o;
        if (null != accountBankInfo) {
            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getBank().getId()));
            if (!bankInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
                this.prmtPayerBank.setData((Object)bankInfo);
            } else {
                this.prmtPayerBank.setData(null);
            }
        } else {
            this.prmtPayerBank.setData(null);
        }
    }

    private void txtPayAmount_focusLosted(DataChangeEvent e) throws Exception {
        Locale locale = SysContext.getSysContext().getLocale();
        String o = this.txtPayAmount.getValue().toString();
        this.txtNaturalAmt.setValue((Object)this.getDecimal(this.txtPayAmount.getNumberValue()).multiply(this.getDecimal(this.txtExchangeRate.getNumberValue())));
        this.txtDamount.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtPayAmount.getNumberValue()), (boolean)true, (Locale)locale));
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BankDraftReqInfo bankDraftReq = this.editData;
        bankDraftReq.setBillState(ReqBillStateEnum.SUBMIT);
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BankDraftReqCollection bd;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtPayAmount);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtPreBalanceAmt);
        Date op = (Date)this.pkPrePayerDate.getValue();
        Date rs = (Date)this.pkReqState.getValue();
        if (!rs.before(op)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"177_BankDraftReqEditUI"));
            SysUtil.abort();
        }
        if (null != this.editData.getUsage() && this.editData.getUsage().length() > 200) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"178_BankDraftReqEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getPayAmount().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"171_BankDraftEditUI"));
            SysUtil.abort();
        }
        if ("ADDNEW".equals(this.getOprtState()) && null != (bd = BankDraftReqFactory.getRemoteInstance().getBankDraftReqCollection("select * where number = '" + this.editData.getNumber() + "'")) && bd.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((String)this.prmtRecPerson.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"456_BankDraftEditUI"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BankDraftReqInfo bdri = this.editData;
        bdri = BankDraftReqFactory.getRemoteInstance().getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(bdri.getId()));
        if (bdri.getBillState() == ReqBillStateEnum.AUDIT || bdri.isIsDraw() || bdri.getBankState() == BankPayingBillStateEnum.OS) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"179_BankDraftReqEditUI"));
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BankDraftReqInfo bdrInfo = BankDraftReqFactory.getRemoteInstance().getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (bdrInfo.getBillState() == ReqBillStateEnum.AUDIT || bdrInfo.isIsDraw() || bdrInfo.getBankState() == BankPayingBillStateEnum.OS) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"180_BankDraftReqEditUI"));
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
            idList.add(this.editData.getId());
            if (idList == null || idList.size() == 0) {
                return;
            }
            BankDraftDataProvider data = new BankDraftDataProvider(idList);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.print(BankDraftReq_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
            idList.add(this.editData.getId());
            if (idList == null || idList.size() == 0) {
                return;
            }
            BankDraftDataProvider data = new BankDraftDataProvider(idList);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.printPreview(BankDraftReq_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.BankDraftReq", null, (IObjectValue)this.editData);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isCopy = true;
        this.checkModified();
        if (this.editData != null) {
            BankDraftReqInfo newEditData = this.editData.copy();
            newEditData.setReqState(DateUtil.getDayBegin());
            newEditData.setBankState(BankPayingBillStateEnum.OP);
            newEditData.setIsDraw(false);
            newEditData.setBillState(ReqBillStateEnum.SAVE);
            newEditData.setAreaType(SameDifferEnum.DIFFER);
            newEditData.setBankType(DeEnum.STRIDE);
            this.unLockUI();
            this.setOprtState("ADDNEW");
            this.setDataObject((IObjectValue)newEditData);
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    private SupplierInfo getSupplier(Object objCust) {
        if (objCust instanceof SupplierInfo) {
            return (SupplierInfo)objCust;
        }
        return null;
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankDraftReqFactory.getRemoteInstance();
    }

    @Override
    public void actionSubmitBank_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(this.editData.getId().toString());
            this.checkSelected();
            int size = idList.size();
            IBankDraftReq bankDraftReq = BankDraftReqFactory.getRemoteInstance();
            BankDraftReqInfo bdrInfo = null;
            for (int i = 0; i < size; ++i) {
                String id = (String)idList.get(i);
                bdrInfo = bankDraftReq.getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(id));
                if (bdrInfo.getBillState() != ReqBillStateEnum.AUDIT || bdrInfo.getBankState() != BankPayingBillStateEnum.OP && bdrInfo.getBankState() != BankPayingBillStateEnum.OF) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"183_BankDraftReqListUI"));
                    return;
                }
                try {
                    bankDraftReq.submitBank((IObjectPK)new ObjectUuidPK(id));
                    continue;
                }
                catch (Exception ep) {
                    MsgBox.showWarning((String)ep.getMessage());
                    SysUtil.abort();
                }
            }
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        }
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        BankDraftReqInfo info = (BankDraftReqInfo)this.getDataObject();
        boolean isCanEdit = false;
        try {
            if (info.getId() != null) {
                info = BankDraftReqFactory.getRemoteInstance().getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                this.initComboNtType(this.cboNtType, info);
                FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
            } else {
                this.initComboNtType(this.cboNtType, null);
            }
        }
        catch (Exception ep) {
            MsgBox.showWarning((String)ep.getMessage());
        }
        if (info.getBillState() != null && info.getBillState() != ReqBillStateEnum.AUDIT) {
            isCanEdit = true;
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionEdit.setEnabled(isCanEdit);
        }
    }
}

