/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterParamBase;
import com.kingdee.eas.fm.nt.ReqBillStateEnum;
import com.kingdee.util.DateTimeUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class BankDraftReqFilterParam
extends FMFilterParamBase {
    private Date startTime;
    private Date endTime;
    private Set bankids;
    private String currencyId;
    private ReqBillStateEnum billState;
    private static final long serialVersionUID = 7219049736379103096L;

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        if (null != this.startTime) {
            filterInfo.getFilterItems().add(new FilterItemInfo("reqState", (Object)DateTimeUtils.truncateDate((Date)this.startTime), CompareType.GREATER_EQUALS));
        }
        if (null != this.endTime) {
            filterInfo.getFilterItems().add(new FilterItemInfo("reqState", (Object)DateTimeUtils.truncateDate((Date)this.endTime), CompareType.LESS_EQUALS));
        }
        if (null != this.bankids && this.bankids.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("payerBank.id", (Object)this.getBankids(), CompareType.INCLUDE));
        }
        if (null != this.currencyId) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (null != this.billState) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(this.billState.getValue())));
        }
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (!FMHelper.isEmpty((Collection)this.getCompanyIdSet())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString(), CompareType.EQUALS));
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return new SorterItemCollection();
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Set getBankids() {
        return this.bankids;
    }

    public void setBankids(Set bankids) {
        this.bankids = bankids;
    }

    public ReqBillStateEnum getBillState() {
        return this.billState;
    }

    public void setBillState(ReqBillStateEnum billState) {
        this.billState = billState;
    }
}

