/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.nt.ReqBillStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractBankDraftReqFilterUI;
import com.kingdee.eas.fm.nt.client.BankDraftReqFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class BankDraftReqFilterUI
extends AbstractBankDraftReqFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BankDraftReqFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comboCurrency);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboBillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.startTime.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.endTime.setValue((Object)new Date());
        this.comboBillState.addItems(ReqBillStateEnum.getEnumList().toArray());
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtPayerBank);
        super.init();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.startTime.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.endTime.setValue((Object)new Date());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboBillState, (Object)FMSysDefinedEnum.SELECT_ALL);
        this.prmtPayerBank.setData(null);
    }

    public Object getParam() {
        BankDraftReqFilterParam param = new BankDraftReqFilterParam();
        if (null != this.startTime.getValue()) {
            param.setStartTime((Date)this.startTime.getValue());
        }
        if (null != this.endTime.getValue()) {
            param.setEndTime((Date)this.endTime.getValue());
        }
        if (null != this.prmtPayerBank.getValue()) {
            param.setBankids(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtPayerBank)));
        }
        if (FMSysDefinedEnum.SELECT_ALL == this.comboCurrency.getSelectedItem()) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (FMSysDefinedEnum.SELECT_ALL == this.comboBillState.getSelectedItem()) {
            param.setBillState(null);
        } else {
            param.setBillState((ReqBillStateEnum)((Object)this.comboBillState.getSelectedItem()));
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        return param;
    }

    public void setParam(Object param) {
        BankDraftReqFilterParam filterParam = (BankDraftReqFilterParam)((Object)param);
        try {
            this.prmtPayerBank.setData((Object)this.getBaseInfoFromIdSet(filterParam.getBankids()));
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.startTime.setValue((Object)filterParam.getStartTime());
        this.endTime.setValue((Object)filterParam.getEndTime());
        if (null == filterParam.getCurrencyId()) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            CurrencyInfo currencyInfo = FMClientHelper.getCurrencyInfo((BOSUuid)BOSUuid.read((String)filterParam.getCurrencyId()));
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
        }
        if (null == filterParam.getBillState()) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillState, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            this.comboBillState.setSelectedItem((Object)filterParam.getBillState());
        }
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
    }

    public boolean verify() {
        Date start = (Date)this.startTime.getValue();
        Date end = (Date)this.endTime.getValue();
        if (start == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"440_BankDraftReqFilterUI"));
            SysUtil.abort();
        }
        if (end == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"441_BankDraftReqFilterUI"));
            SysUtil.abort();
        }
        if (end.before(start)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"181_BankDraftReqFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return BankDraftReqFilterParam.class;
    }
}

