/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.nt.BankDraftReqCollection;
import com.kingdee.eas.fm.nt.BankDraftReqFactory;
import com.kingdee.eas.fm.nt.BankDraftReqInfo;
import com.kingdee.eas.fm.nt.IBankDraftReq;
import com.kingdee.eas.fm.nt.ReqBillStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractBankDraftReqListUI;
import com.kingdee.eas.fm.nt.client.BankDraftDataProvider;
import com.kingdee.eas.fm.nt.client.BankDraftReqEditStateUI;
import com.kingdee.eas.fm.nt.client.BankDraftReqEditUI;
import com.kingdee.eas.fm.nt.client.BankDraftReqFilterParam;
import com.kingdee.eas.fm.nt.client.BankDraftReqFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BankDraftReqListUI
extends AbstractBankDraftReqListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankDraftReqListUI.class);
    FMFilterBaseUI filterUI = null;
    private String[] amountFields = new String[]{"payAmount", "preBalanceAmt"};
    public static final String OPER_COPY = "COPY";
    FillListener fillListener = new FillListener();
    public static final String BankDraftReq_FILENAME = "/FM/NT/BankDraftReq";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.btnViewBdgBalance.setVisible(true);
        this.btnViewBdgBalance.setEnabled(true);
        this.actionViewBdgBalance.setVisible(true);
        this.menuItemAntiAudit.setEnabled(true);
        this.menuItemCopy.setEnabled(true);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionUnAudit.setVisible(false);
            this.actionSubmitBank.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
        }
    }

    private void setListUITablePrecision(int start, int end) {
        int comPre = 2;
        try {
            CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrencyCommon.getId()));
            comPre = currencyInfo.getPrecision();
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        for (int i = start; i <= end; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell("currency.precision");
            if (cell != null && cell.getValue() != null) {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            for (int j = 0; j < this.amountFields.length; ++j) {
                FMARAPUtil.setPrecision((ICell)row.getCell(this.amountFields[j]), (int)precision);
            }
            int prec = CasRecPayHandler.getExRatePrec((String)row.getCell("currency.id").getValue().toString(), null, (CompanyOrgUnitInfo)this.currentCompanyCommon, (Date)((Date)row.getCell("reqState").getValue()));
            FMARAPUtil.setPrecision((ICell)row.getCell("exchangeRate"), (int)prec);
            FMARAPUtil.setPrecision((ICell)row.getCell("naturalAmt"), (int)comPre);
            row.getCell("payAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("naturalAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("preBalanceAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new BankDraftReqFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return BankDraftReqEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankDraftReqFactory.getRemoteInstance();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        BankDraftDataProvider data = new BankDraftDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(BankDraftReq_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        BankDraftDataProvider data = new BankDraftDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(BankDraftReq_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        HashSet idSet = new HashSet(idList);
        BankDraftReqCollection col = this.getBankDraftReqColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            BankDraftReqInfo info = col.get(i);
            if (info.getBillState() != ReqBillStateEnum.SAVE && info.getBillState() != ReqBillStateEnum.AUDIT) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"9_BankDraftReqControllerBean"));
            SysUtil.abort();
        }
        BankDraftReqFactory.getRemoteInstance().batchAudit(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"182_BankDraftReqListUI"));
        this.refresh(e);
    }

    @Override
    public void actionSubmitBank_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        int size = idList.size();
        IBankDraftReq bankDraftReq = BankDraftReqFactory.getRemoteInstance();
        BankDraftReqInfo bdrInfo = null;
        for (int i = 0; i < size; ++i) {
            String id = (String)idList.get(i);
            bdrInfo = bankDraftReq.getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(id));
            if (bdrInfo.getBillState() != ReqBillStateEnum.AUDIT || bdrInfo.getBankState() != BankPayingBillStateEnum.OP && bdrInfo.getBankState() != BankPayingBillStateEnum.OF) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"183_BankDraftReqListUI"));
                return;
            }
            try {
                bankDraftReq.submitBank((IObjectPK)new ObjectUuidPK(id));
                continue;
            }
            catch (Exception ep) {
                MsgBox.showWarning((String)ep.getMessage());
                SysUtil.abort();
            }
        }
        FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        this.refresh(e);
    }

    protected void execQuery() {
        super.execQuery();
    }

    public FilterInfo getFilterInfo() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && "BankDraft".equals(targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(3)));
            filter.getFilterItems().add(new FilterItemInfo("isDraw", (Object)false));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompanyCommon.getId().toString()));
        }
        return filter;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        String currencyId = null;
        if (row != null) {
            try {
                currencyId = ((BankDraftReqFilterParam)this.getFilterParam()).getCurrencyId();
                if (currencyId == null) {
                    currencyId = this.currentCompanyCommon.getBaseCurrency().getId().toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            String numberFormat = FMClientHelper.getNumberFtm((int)2);
            if (currencyId != null) {
                numberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
            }
            row.getCell("payAmount").getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell("preBalanceAmt").getStyleAttributes().setNumberFormat(numberFormat);
            row.getCell("naturalAmt").getStyleAttributes().setNumberFormat(numberFormat);
        }
        return row;
    }

    protected BankDraftReqCollection getBankDraftReqColl(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return ((IBankDraftReq)this.getBizInterface()).getBankDraftReqCollection(evi);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        BankDraftReqCollection col = this.getBankDraftReqColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            ReqBillStateEnum billState;
            BankDraftReqInfo info = col.get(i);
            if (info.getBillState() == ReqBillStateEnum.SAVE || info.getBillState() == ReqBillStateEnum.SUBMIT) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"7_BankDraftReqControllerBean"));
                SysUtil.abort();
            }
            if (!((billState = info.getBillState()) != ReqBillStateEnum.AUDIT || info.isIsDraw() || info.getBankState() != BankPayingBillStateEnum.OP && info.getBankState() != BankPayingBillStateEnum.OF)) {
                BankDraftReqFactory.getRemoteInstance().batchAntiAudit(idSet);
                continue;
            }
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"8_BankDraftReqControllerBean"));
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"184_BankDraftReqListUI"));
        this.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BankDraftReqInfo bdrInfo = BankDraftReqFactory.getRemoteInstance().getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (bdrInfo.getBillState() == ReqBillStateEnum.AUDIT || bdrInfo.isIsDraw() || bdrInfo.getBankState() == BankPayingBillStateEnum.OS) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"185_BankDraftReqListUI"));
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BankDraftReqInfo bdrInfo = BankDraftReqFactory.getRemoteInstance().getBankDraftReqInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (bdrInfo.getBillState() == ReqBillStateEnum.AUDIT || bdrInfo.isIsDraw() || bdrInfo.getBankState() == BankPayingBillStateEnum.OS) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"186_BankDraftReqListUI"));
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)OPER_COPY, (Object)OPER_COPY);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("bankState").getValue()).getInt();
        if (state == 4) {
            this.actionEditState.setEnabled(true);
        } else {
            this.actionEditState.setEnabled(false);
        }
        super.tblMain_tableSelectChanged(e);
    }

    @Override
    public void actionEditState_actionPerformed(ActionEvent e) throws Exception {
        boolean flag;
        String msg;
        int result;
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        String uiName = BankDraftReqEditStateUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        BankPayingBillStateEnum updateState = ((BankDraftReqEditStateUI)uiWindow.getUIObject()).getResult();
        if (updateState == null) {
            return;
        }
        if (updateState == BankPayingBillStateEnum.OF && (result = MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"41_BankAgentPayBillListUI")))) == 2) {
            SysUtil.abort();
        }
        if (flag = BankDraftReqFactory.getRemoteInstance().editState(id, updateState)) {
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
            this.refresh(e);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            BankDraftReqListUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

