/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.client.AbstractCSF7UI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CSF7UISupplier
extends AbstractCSF7UI {
    private static final Logger logger = CoreUIObject.getLogger(CSF7UISupplier.class);
    private Object rstData;
    protected boolean isCanceled = true;
    public static final String EV = "ev";
    public static final String IS_ENABLED_MULTI_SELECTION = "isEnabledMultiSelection";
    String cuid = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString();

    public CSF7UISupplier() throws Exception {
        this.btnMaintain.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnMaintain.setEnabled(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtValue, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSF7UISupplier.this.launchQuickFilter();
            }
        });
    }

    @Override
    public void kdCustom_actionPerformed(ActionEvent e) {
        try {
            this.fillTable("");
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    @Override
    public void kdSupplier_actionPerformed(ActionEvent e) {
        try {
            this.fillTable("");
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected void initWorkButton() {
        this.actionQuery.setVisible(false);
        this.actionQueryScheme.setVisible(false);
        this.cboQuantity.setVisible(true);
        this.cboQuantity.setEnabled(true);
        this.contQuantity.setVisible(true);
        this.contQuantity.setEnabled(true);
    }

    private void refresh() throws BOSException {
        this.fillTable("");
    }

    @Override
    public void actionMaintain_actionPerformed(ActionEvent e) throws Exception {
        String uiName = "";
        try {
            uiName = this.kdCustom.isSelected() ? "com.kingdee.eas.basedata.master.cssp.client.CustomerInfoListUI" : "com.kingdee.eas.basedata.master.cssp.client.SupplierListUI";
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext);
            uiWindow.show();
            this.refresh();
        }
        catch (BOSException be) {
            ExceptionHandler.handle((Throwable)be);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.kdSupplier.setSelected(true);
        this.initCboQuantityItem();
        this.fillTable("");
        this.kdOk.setEnabled(true);
        this.kdCancel.setEnabled(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tblMain, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.tblMain.requestFocusInWindow();
        this.tblMain.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
        this.initWorkButton();
    }

    private void launchQuickFilter() {
        String sfilter = "";
        String[] sFields = null;
        try {
            String key = (String)this.cboKey.getSelectedItem();
            if (key.equals(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"236_CSF7UI"))) {
                sFields = new String[]{"a.fnumber", "a.fname_l2"};
            } else if (key.equals(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"62_ReceivableBillImportVerify"))) {
                sFields = new String[]{"a.fnumber"};
            } else if (key.equals(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"237_CSF7UI"))) {
                sFields = new String[]{"a.fname_l2"};
            } else if (key.equals(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"238_CSF7UI"))) {
                sFields = new String[]{"a.FSimpleName"};
            }
            String sValue = this.txtValue.getText().trim();
            if (sFields != null) {
                if (this.chkLike.isSelected()) {
                    sfilter = sfilter + " and (upper(" + sFields[0] + ") like '%" + sValue.toUpperCase() + "%'";
                    if (sFields.length == 2) {
                        sfilter = sfilter + " or upper(" + sFields[1] + ") like '%" + sValue.toUpperCase() + "%'";
                    }
                    sfilter = sfilter + ")";
                } else {
                    sfilter = sfilter + " and (" + sFields[0] + " = '" + sValue + "'";
                    if (sFields.length == 2) {
                        sfilter = sfilter + " or " + sFields[1] + " = '" + sValue + "'";
                    }
                    sfilter = sfilter + ")";
                }
            }
            if (sValue.equals("")) {
                sfilter = "";
            }
            this.fillTable(sfilter);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.buildRstValues();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.buildRstValues();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    private void buildRstValues() {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length < 1) {
            this.abort();
        }
        if (this.tblMain.getRow(rowID[0]) == null) {
            this.abort();
        }
        String id = this.tblMain.getRow(rowID[0]).getCell(0).getValue().toString();
        try {
            if (this.kdCustom.isSelected()) {
                ICustomer iAdr = CustomerFactory.getRemoteInstance();
                this.rstData = iAdr.getCustomerInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            } else {
                ISupplier iAdr = SupplierFactory.getRemoteInstance();
                this.rstData = iAdr.getSupplierInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            this.abort();
        }
    }

    private void fillTable(String sfilter) throws BOSException {
        int quantity = (Integer)this.cboQuantity.getSelectedItem();
        this.tblMain.removeRows(false);
        this.tblMain.checkParsed();
        String sql = "";
        String myFileter = "";
        String sTable = "";
        String sBosType = "";
        if (this.kdCustom.isSelected()) {
            sTable = "T_BD_Customer";
            sBosType = "BF0C040E";
        } else {
            sTable = "T_BD_Supplier";
            sBosType = "37C67DFC";
        }
        sql = "select top " + quantity + " fid,fname,fnumber,fsimplename,FMnemonicCode,typeName from ( \n select top " + quantity + " a.fid fid,a.fname_l2 fname,a.fnumber fnumber,a.fsimplename fsimplename,a.FMnemonicCode FMnemonicCode,b.fname_l2 typeName \n from " + sTable + " a left join  T_BD_CSSPGroup b on a.FBrowseGroupID=b.fid \n where a.FUsedStatus=1 and a.FControlUnitID = '" + this.cuid + "' " + sfilter + " union  select top " + quantity + " a.fid fid,a.fname_l2 fname,a.fnumber fnumber,a.fsimplename fsimplename,a.FMnemonicCode FMnemonicCode,b.fname_l2 typeName \n from " + sTable + " a left join  T_BD_CSSPGroup b on a.FBrowseGroupID=b.fid \n where a.FUsedStatus=1 and a.fid IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '" + sBosType + "' AND FAssignCUID = '" + this.cuid + "') " + sfilter + ") as a where 1=1 ";
        sql = sql + " ORDER BY a.fname ";
        IRowSet rs = null;
        try {
            rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        }
        catch (BOSException e) {
            if (!FMHelper.isEmpty((String)e.getMessage()) && e.getMessage().indexOf("fetched too much rows:") >= 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"rowsMoreThanMax"));
                return;
            }
            throw e;
        }
        try {
            int i = 0;
            IRow row = null;
            while (rs.next()) {
                row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)rs.getString("fid"));
                row.getCell("number").setValue((Object)rs.getString("fnumber"));
                row.getCell("name").setValue((Object)rs.getString("fname"));
                row.getCell("simpleName").setValue((Object)rs.getString("fsimplename"));
                row.getCell("alias").setValue((Object)rs.getString("FMnemonicCode"));
                row.getCell("typename").setValue((Object)rs.getString("typeName"));
                ++i;
            }
            logger.info((Object)("i =" + i));
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        this.launchQuickFilter();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CustomerFactory.getRemoteInstance();
    }

    public Object getRstData() {
        return this.rstData;
    }

    private void initCboQuantityItem() {
        this.cboQuantity.addItem((Object)100);
        this.cboQuantity.addItem((Object)200);
        this.cboQuantity.addItem((Object)500);
        this.cboQuantity.addItem((Object)1000);
        this.cboQuantity.setSelectedItem((Object)0);
    }
}

