/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractChequeApply2;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.fm.nt.client.util.ResultInfomation;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ChequeApplyUI
extends AbstractChequeApply2 {
    private UserInfo currentUser;
    private CompanyOrgUnitInfo currentCompany;
    private boolean isAbandon = false;
    private boolean isCompanyFilter;
    private boolean needAudit;
    private ChequeCollection editDatas = new ChequeCollection();
    private static final Color normal = new Color(0xF9F9F9);
    private static final Color must = new Color(0xF6F6BF);
    private static final Color disable = new Color(0xE8E8E3);

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboNTType, (Object)this.editData.getNtType());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.prmtactualBankAcct.setData(this.editData == null ? null : this.editData.getActualBankAcct());
        this.loadTableFields();
    }

    public void onLoad() throws Exception {
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        this.initParam();
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        this.initTable();
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        ChequeUtil.initComboNttype(this.comboNTType, false);
        this.prmtNumber.setEnabledMultiSelection(true);
        this.pkRemindDate.setRequired(false);
        super.onLoad();
        this.initMainTable();
        this.initListeners();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.f7Project);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAuditor);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtApplicant);
        this.prmtNumber.setSelectorCollection(ChequeUtil.getSelectors());
        ChequeUtil.initPrmtNumber(this.prmtNumber, "APPLY", false);
        if (this.editData.getCompany() != null) {
            F7SelectorFactory.initAdminOrgUnitWithRoot((IUIObject)this, (KDBizPromptBox)this.prmtDepartment, (CompanyOrgUnitInfo)this.editData.getCompany());
        } else {
            F7SelectorFactory.initAdminOrgUnit((IUIObject)this, (KDBizPromptBox)this.prmtDepartment, (boolean)false);
        }
        ChequeUtil.initCompanyOrgF7((IUIObject)this, this.prmtApplyCompany);
        this.initBankAcctFilter();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.updateTableForEdit();
        }
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        Object[] object = AccessHelper.getF7Data((KDBizPromptBox)this.prmtNumber);
        if (object == null || object.length == 0) {
            this.tblMain.removeRows();
            this.prmtPayAccountBank.setValue(null);
            this.prmtPayBank.setValue(null);
            this.prmtactualBankAcct.setEnabled(false);
        } else {
            this.prmtactualBankAcct.setEnabled(true);
        }
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isQuota");
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isTransfer");
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isLinear");
        this.menuTable1.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionCreateFrom.setVisible(false);
    }

    private void initParam() throws BOSException, EASBizException {
        Map map = this.getUIContext();
        this.isCompanyFilter = map.containsKey("NT028") ? ((Boolean)map.get("NT028")).booleanValue() : ContextHelperFactory.getRemoteInstance().getBooleanParam("NT028", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        this.needAudit = map.containsKey("NT029") ? ((Boolean)map.get("NT029")).booleanValue() : ContextHelperFactory.getRemoteInstance().getBooleanParam("NT029", null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.storeTableFields();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return ChequeUtil.getSelectors();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionAbandon.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    protected void initDataStatus() {
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            this.getDataForEdit();
        }
        super.initDataStatus();
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionTDPrintPreview.setVisible(true);
        this.prmtApplyCompany.setEnabled(false);
        this.prmtAuditor.setEnabled(!this.needAudit);
        ChequeInfo info = (ChequeInfo)this.getDataObject();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtPayAccountBank.setEnabled(info.getBankAcct() == null);
            this.prmtPayBank.setEnabled(info.getBank() == null);
            this.comboCurrency.setEnabled(info.getCurrency() == null);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            ChequeUtil.setComponentEnable((JComponent)((Object)this), false);
            this.tblMain.getStyleAttributes().setLocked(false);
            IKDComponent[] enableComps = new IKDComponent[]{this.pkIssueDate, this.pkExpiredDate};
            FMClientHelper.setCompEnable((IKDComponent[])enableComps, (boolean)true);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        int i;
        super.beforeStoreFields(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtNumber));
        if (ids == null || ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"numbermustneed"));
            SysUtil.abort();
        }
        if (this.pkApplyDate.getValue() == null) {
            throw new NTException(NTException.APPLYDATE_EMPTY);
        }
        if (this.pkExpiredDate.getValue() != null && this.pkIssueDate.getValue() != null && !((Date)this.pkExpiredDate.getValue()).after((Date)this.pkIssueDate.getValue())) {
            throw new NTException(NTException.EXPIREDATE_LESSTHAN_ISSUEDATE);
        }
        Date issueDate = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        Date applyDate = DateTimeUtils.truncateDate((Date)this.pkApplyDate.getSqlDate());
        if (this.pkRemindDate.getValue() != null && this.pkRemindDate.getSqlDate().before(applyDate)) {
            throw new NTException(NTException.DATE_GREATERTHAN_APPLYDATE);
        }
        for (i = 0; i < this.editDatas.size(); ++i) {
            String msg;
            Date purDate = this.editData.getPurDate();
            if (purDate != null && issueDate != null && purDate.after(issueDate)) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"188_ChequeApplyUI");
                msg = MessageFormat.format(msg, this.editDatas.get(i).getNumber());
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (purDate == null || applyDate == null || !purDate.after(applyDate)) continue;
            msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"189_ChequeApplyUI");
            msg = MessageFormat.format(msg, this.editDatas.get(i).getNumber());
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if (applyDate != null && issueDate != null && issueDate.compareTo(applyDate) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"190_ChequeApplyUI"));
            SysUtil.abort();
        }
        if (this.tblMain != null && this.tblMain.getRowCount() > 0) {
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                String msg;
                IRow row = this.tblMain.getRow(i);
                Object ceiling = row.getCell("ceiling").getValue();
                Object amount = row.getCell("amount").getValue();
                boolean isQuota = (Boolean)row.getCell("isQuota").getValue();
                String password = (String)row.getCell("password").getValue();
                if (isQuota) {
                    if (ceiling == null) {
                        throw new NTException(NTException.CEILING_EMPTY);
                    }
                    if (((BigDecimal)ceiling).compareTo(Constants.ZERO) <= 0) {
                        throw new NTException(NTException.CEILING_GREATERTHANZERO);
                    }
                } else if (amount == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"192_ChequeApplyUI");
                    msg = MessageFormat.format(msg, i + 1);
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                } else if (((BigDecimal)amount).compareTo(Constants.ZERO) <= 0) {
                    msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"193_ChequeApplyUI");
                    msg = MessageFormat.format(msg, i + 1);
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if (password == null || password.length() <= 80) continue;
                msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"194_ChequeApplyUI");
                msg = MessageFormat.format(msg, i + 1);
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        if (this.prmtAuditor.getData() != null && this.prmtApplicant.getData() != null && this.currentUser.getPerson() != null && (((PersonInfo)this.prmtAuditor.getData()).getId().toString().equals(this.currentUser.getPerson().getId().toString()) || ((PersonInfo)this.prmtAuditor.getData()).getId().toString().equals(((PersonInfo)this.prmtApplicant.getData()).getId().toString()))) {
            throw new NTException(NTException.NOT_SAME_PERSON);
        }
        AccountBankInfo account = (AccountBankInfo)this.prmtPayAccountBank.getValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        account = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(account.getId().toString()), sic);
        if (account.getCurrency() != null) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (!account.getCurrency().getId().toString().equals(currency.getId().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"CurrencyNotTheSame"));
                SysUtil.abort();
            }
        }
        boolean isManager = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT041", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        boolean feeTypeAndProject = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT040", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (this.prmtFeeType.getValue() != null && feeTypeAndProject) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7Project);
            if (isManager) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7ProjectManager);
            }
        }
        if (this.f7Project.getValue() != null) {
            if (isManager) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7ProjectManager);
            }
            if (feeTypeAndProject) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtFeeType);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ChequeInfo objectValue;
        ChequeAppRecInfo appRecInfo = new ChequeAppRecInfo();
        ArrayList selectIdList = (ArrayList)this.getUIContext().get("CHEQUEIDS");
        if (selectIdList != null && selectIdList.size() != 0) {
            EventListener[] listeners;
            this.editDatas = ChequeUtil.getChequeCollection(selectIdList);
            int l = this.editDatas.size();
            for (int i = 0; i < l; ++i) {
                this.editDatas.get(i).setIsQuota(true);
            }
            objectValue = this.editDatas.get(0);
            if (objectValue.getBankAcct() != null) {
                appRecInfo.setApplyCompany(objectValue.getBankAcct().getCompany());
            }
            if ((listeners = this.prmtNumber.getListeners(DataChangeListener.class)) != null && listeners.length > 0) {
                DataChangeListener dcl = (DataChangeListener)listeners[0];
                this.prmtNumber.removeDataChangeListener(dcl);
                this.prmtNumber.setValue((Object)this.editDatas.toArray());
                this.prmtNumber.addDataChangeListener(dcl);
            } else {
                this.prmtNumber.setValue((Object)this.editDatas.toArray());
            }
        } else {
            objectValue = new ChequeInfo();
            objectValue.setNtType((NTTypeInfo)this.comboNTType.getItemAt(0));
        }
        Date date = new Date();
        objectValue.setIssueDate(date);
        objectValue.setExpiredDate(DateTimeUtils.addDay((Date)date, (long)10L));
        appRecInfo.setApplyDate(date);
        appRecInfo.setRemindDate(date);
        objectValue.setApplyRec(appRecInfo);
        return objectValue;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.isSave()) {
            throw new NTException(NTException.ALREADY_SUBMIT);
        }
        ICheque iCheque = (ICheque)this.getBizInterface();
        iCheque.apply(this.editDatas);
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"BlankChequeApplySuccess"));
        this.showMessage();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        HashMap<String, String> mapPrint = new HashMap<String, String>();
        int count = this.tblMain.getRowCount();
        DecimalFormat format = new DecimalFormat("###,##0.00");
        for (int i = 0; i < count; ++i) {
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            idList.add(id);
            String number = this.tblMain.getRow(i).getCell("number").getValue().toString();
            String ceiling = null;
            if (this.tblMain.getRow(i).getCell("ceiling").getValue() != null) {
                BigDecimal ceilingAmount = (BigDecimal)this.tblMain.getRow(i).getCell("ceiling").getValue();
                ceiling = format.format(ceilingAmount);
            }
            mapPrint.put(number, ceiling);
        }
        this.TDPrintAtApply(idList, mapPrint);
        super.actionTDPrint_actionPerformed(e);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            idList.add(id);
        }
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        super.actionTDPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionAbandon_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbandon_actionPerformed(e);
        if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"SaveBeforeAbandon"));
            return;
        }
        int result1 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.gnt.GntResource", (String)"isCanceled"));
        if (result1 == 0) {
            if (this.isAbandon) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"RepeatSummit"));
                return;
            }
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow r = this.tblMain.getRow(i);
                set.add(r.getCell("id").getValue().toString());
            }
            ChequeFactory.getRemoteInstance().abandon(set);
            this.isAbandon = true;
        }
    }

    @Override
    protected void comboNTType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboNTType_itemStateChanged(e);
        this.editDatas.clear();
        this.prmtNumber.setValue(null);
        this.tblMain.removeRows();
    }

    @Override
    protected void prmtNumber_preChange(PreChangeEvent e) throws Exception {
        super.prmtNumber_preChange(e);
        Object c = e.getData();
        if (c != null) {
            ResultInfomation result;
            ChequeCollection coll = new ChequeCollection();
            if (c instanceof Object[]) {
                Object[] cc = (Object[])c;
                for (int i = 0; i < cc.length; ++i) {
                    coll.add((ChequeInfo)cc[i]);
                }
            } else {
                coll.add((ChequeInfo)c);
            }
            if (!this.getOprtState().equals(OprtState.VIEW) && !(result = ChequeUtil.checkChequeApplyValid(coll)).isEqual()) {
                MsgBox.showInfo((String)result.getResult());
                e.setResult(-1);
            }
        }
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtNumber_dataChanged(e);
        this.editDatas.clear();
        Object[] object = AccessHelper.getF7Data((KDBizPromptBox)this.prmtNumber);
        if (object == null || object.length == 0) {
            this.tblMain.removeRows();
            this.prmtPayAccountBank.setValue(null);
            this.prmtPayBank.setValue(null);
            this.prmtactualBankAcct.setEnabled(false);
            return;
        }
        this.prmtactualBankAcct.setEnabled(true);
        for (int i = 0; i < object.length; ++i) {
            ChequeInfo chequeInfo = (ChequeInfo)object[i];
            if (chequeInfo.getState().equals((Object)ChequeStatusEnum.NEW)) {
                chequeInfo.setIsQuota(true);
            }
            this.editDatas.add(chequeInfo);
        }
        ChequeInfo info = this.editDatas.get(0);
        if (info.getApplyRec() == null) {
            Date date = new Date();
            info.setIssueDate(date);
            info.setExpiredDate(DateTimeUtils.addDay((Date)date, (long)10L));
            ChequeAppRecInfo appRecInfo = new ChequeAppRecInfo();
            info.setApplyRec(appRecInfo);
            appRecInfo.setApplyDate(date);
            appRecInfo.setRemindDate(date);
        }
        this.setDataObject((IObjectValue)info);
        this.loadFields();
        this.comboCurrency.setEnabled(info.getCurrency() == null);
        this.prmtPayAccountBank.setEnabled(info.getBankAcct() == null);
        this.setSave(false);
        this.isAbandon = false;
    }

    @Override
    protected void prmtNumber_willCommit(CommitEvent e) throws Exception {
        super.prmtNumber_willCommit(e);
        NTTypeInfo nttype = (NTTypeInfo)this.comboNTType.getSelectedItem();
        if (nttype != null) {
            FilterItemInfo filterItem = new FilterItemInfo("nttype.id", (Object)nttype.getId().toString(), CompareType.EQUALS);
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNumber, (FilterItemInfo)filterItem);
            this.prmtNumber.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtNumber_willShow(SelectorEvent e) throws Exception {
        super.prmtNumber_willShow(e);
        NTTypeInfo nttype = (NTTypeInfo)this.comboNTType.getSelectedItem();
        if (nttype != null) {
            FilterItemInfo filterItem = new FilterItemInfo("nttype.id", (Object)nttype.getId().toString(), CompareType.EQUALS);
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNumber, (FilterItemInfo)filterItem);
            this.prmtNumber.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtPayAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayAccountBank_dataChanged(e);
        if (e.getNewValue() == null) {
            if (this.prmtactualBankAcct.getData() == null) {
                this.prmtApplyCompany.setValue(null);
            }
            this.comboCurrency.setEnabled(true);
            return;
        }
        AccountBankInfo accout = (AccountBankInfo)e.getNewValue();
        if (this.prmtactualBankAcct.getData() == null) {
            CompanyOrgUnitInfo company = accout.getCompany();
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
            this.prmtApplyCompany.setValue((Object)company);
            this.editData.getApplyRec().setApplyCompany(company);
        }
        CurrencyInfo currency = accout.getCurrency();
        if (this.editData.getCurrency() == null) {
            if (currency != null) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
                this.comboCurrency.setEnabled(false);
            } else {
                this.comboCurrency.setEnabled(true);
            }
        } else {
            this.comboCurrency.setEnabled(false);
        }
    }

    @Override
    protected void prmtApplyCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtApplyCompany_dataChanged(e);
        if (e.getNewValue() == null) {
            this.prmtApplicant.setEnabled(false);
            this.prmtDepartment.setEnabled(false);
            return;
        }
        this.prmtApplicant.setEnabled(true);
        this.prmtDepartment.setEnabled(true);
        ChequeUtil.setComponentsValueNull(new IKDComponent[]{this.prmtDepartment, this.prmtApplicant, this.prmtAuditor, this.f7Project, this.f7ProjectManager});
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
        F7SelectorFactory.initAdminOrgUnitWithRoot((IUIObject)this, (KDBizPromptBox)this.prmtDepartment, (CompanyOrgUnitInfo)company);
    }

    @Override
    protected void pkApplyDate_dataChanged(DataChangeEvent e) throws Exception {
        this.pkRemindDate.setValue(this.pkApplyDate.getValue());
        if (this.pkIssueDate.getTimestamp() != null && this.pkApplyDate.getValue() != null) {
            this.pkExpiredDate.setValue((Object)DateTimeUtils.addDay((Date)this.pkApplyDate.getTimestamp(), (long)10L));
        }
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkIssueDate_dataChanged(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.pkRemindDate.setValue(e.getNewValue());
        }
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        super.tblMain_editStarting(e);
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (e.getColIndex() == this.tblMain.getColumnIndex("oppAcct")) {
            this.prmtOppAcct_WillShow(row);
        } else if (e.getColIndex() == this.tblMain.getColumnIndex("payee")) {
            this.prmtPayee_WillShow(row);
        } else if (e.getColIndex() == this.tblMain.getColumnIndex("turnInAcct")) {
            this.prmtTurnInAcct_WillShow(row);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        String usage;
        if (e.getValue() == null) {
            return;
        }
        super.tblMain_editStopped(e);
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("ceiling")) {
            BigDecimal amount = (BigDecimal)row.getCell("ceiling").getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(Constants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell("ceiling").setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("usage") && (usage = (String)row.getCell("usage").getValue()) != null && usage.length() > 100) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource.UsageTooLong"));
            this.showMessage();
            row.getCell("usage").setValue((Object)usage.substring(0, 99));
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("isMe")) {
            this.chkIsMe_DataChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("isQuota")) {
            this.chkIsQuota_DataChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("payee")) {
            this.prmtPayeeName_DataChanged(row);
        }
    }

    @Override
    protected void f7Project_dataChanged(DataChangeEvent e) throws Exception {
        super.f7Project_dataChanged(e);
        ProjectInfo project = (ProjectInfo)this.f7Project.getValue();
        if (project == null) {
            this.f7ProjectManager.setValue(null);
        } else if (project.getPrjManager() != null) {
            ObjectUuidPK objPk = new ObjectUuidPK(project.getPrjManager().getId());
            PersonInfo bill = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)objPk);
            this.f7ProjectManager.setValue((Object)bill);
        }
    }

    @Override
    protected void prmtApplicant_willCommit(CommitEvent e) throws Exception {
        this.prmtApplicant_willEvent((EventObject)e);
    }

    @Override
    protected void prmtApplicant_willShow(SelectorEvent e) throws Exception {
        this.prmtApplicant_willEvent((EventObject)e);
    }

    private void prmtApplicant_willEvent(EventObject e) throws Exception {
        AdminOrgUnitInfo adminOrgUnitInfo;
        if (ChequeUtil.checkApplyCompanyNotNull(this.prmtApplyCompany, e) && (adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtDepartment.getData()) != null) {
            PersonPromptBox selector = (PersonPromptBox)this.prmtApplicant.getSelector();
            if (selector == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("All_Admins", "YES");
                selector = new PersonPromptBox((IUIObject)this, map);
            }
            selector.showAllChildren();
            selector.setHasCUDefaultFilter(false);
            selector.setExpandAdmin(adminOrgUnitInfo.getId().toString());
            this.prmtApplicant.setSelector((KDPromptSelector)selector);
        }
    }

    @Override
    protected void prmtDepartment_willCommit(CommitEvent e) throws Exception {
        super.prmtDepartment_willCommit(e);
    }

    @Override
    protected void prmtDepartment_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue())) {
            this.prmtApplicant.setData(null);
        } else if (e.getNewValue() == null) {
            this.prmtApplicant.setData(null);
        }
    }

    @Override
    protected void prmtDepartment_willShow(SelectorEvent e) throws Exception {
        super.prmtDepartment_willShow(e);
    }

    @Override
    protected void prmtPayBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayBank_dataChanged(e);
    }

    @Override
    protected void prmtPayAccountBank_willCommit(CommitEvent e) throws Exception {
        super.prmtPayAccountBank_willCommit(e);
        this.initBankAcctFilter();
    }

    @Override
    protected void prmtPayAccountBank_willShow(SelectorEvent e) throws Exception {
        super.prmtPayAccountBank_willShow(e);
        this.initBankAcctFilter();
    }

    private void storeTableFields() throws EASBizException, BOSException {
        this.editDatas.clear();
        int l = this.tblMain.getRowCount();
        if (l > 0) {
            for (int i = 0; i < l; ++i) {
                IRow row = this.tblMain.getRow(i);
                ChequeInfo info = (ChequeInfo)row.getUserObject();
                this.insertIntoCheInfo(info, row);
            }
        } else {
            String id = (String)this.getUIContext().get("ID");
            if (!EmptyUtil.isEmpty((String)id)) {
                SelectorItemCollection sic = super.getSelectors();
                sic.add(new SelectorItemInfo("applyRec"));
                ChequeInfo chequeInfo = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
                IRow row = this.tblMain.addRow();
                this.insertIntoCheInfo(chequeInfo, row);
            }
        }
    }

    private void insertIntoCheInfo(ChequeInfo info, IRow row) {
        ChequeAppRecInfo applyRec = info.getApplyRec();
        if (applyRec == null) {
            applyRec = new ChequeAppRecInfo();
        }
        info.setIssueDate(this.editData.getIssueDate());
        info.setExpiredDate(this.editData.getExpiredDate());
        info.setCurrency(this.editData.getCurrency());
        info.setProject(this.editData.getProject());
        info.setProjectManager(this.editData.getProjectManager());
        info.setFeeTypeID(this.editData.getFeeTypeID());
        info.setBank(this.editData.getBank());
        info.setBankAcct(this.editData.getBankAcct());
        info.setActualBankAcct((AccountBankInfo)this.prmtactualBankAcct.getData());
        if (this.editData.getApplyRec() != null) {
            applyRec.setApplyCompany(this.editData.getApplyRec().getApplyCompany());
            applyRec.setDepartment(this.editData.getApplyRec().getDepartment());
            applyRec.setApplicant(this.editData.getApplyRec().getApplicant());
            applyRec.setApplyDate(this.editData.getApplyRec().getApplyDate());
            applyRec.setRemindDate(this.editData.getApplyRec().getRemindDate());
        }
        applyRec.setCeiling((BigDecimal)row.getCell("ceiling").getValue());
        info.setUsage((String)row.getCell("usage").getValue());
        info.setAmount((BigDecimal)row.getCell("amount").getValue());
        info.setKeeper((PersonInfo)row.getCell("keeper").getValue());
        info.setIsQuota((Boolean)row.getCell("isQuota").getValue());
        info.setIsTransfer((Boolean)row.getCell("isTransfer").getValue());
        info.setIsLineation((Boolean)row.getCell("isLinear").getValue());
        info.setIsOwnReceive((Boolean)row.getCell("isMe").getValue());
        info.setPassword((String)row.getCell("password").getValue());
        Object payee = row.getCell("payee").getValue();
        if (payee instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo com = (CompanyOrgUnitInfo)payee;
            info.setPayeeName(com.getName());
        } else if (payee instanceof SupplierInfo) {
            SupplierInfo supplier = (SupplierInfo)payee;
            info.setPayeeName(supplier.getName());
        } else if (payee instanceof String) {
            info.setPayeeName((String)payee);
        }
        info.setPayeeAcctBank((String)row.getCell("payeeBank").getValue());
        info.setPayeeAcctNumber((String)row.getCell("payeeBankAcct").getValue());
        info.setOppAccount((AccountViewInfo)row.getCell("oppAcct").getValue());
        info.setTurnInAcctBank((AccountBankInfo)row.getCell("turnInAcct").getValue());
        info.setApplyRec(applyRec);
        this.editDatas.add(info);
    }

    private void initTable() {
        this.tblMain.checkParsed();
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)false, null);
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isQuota");
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isTransfer");
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isLinear");
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isMe");
        int pre = FMClientHelper.getLocalCurPre();
        RecChequeUtil.initFormattedTextCell(this.tblMain, "ceiling", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "amount", pre);
        KDBizPromptBox prmtPayee = RecChequeUtil.initF7Cell(this.tblMain, "payee");
        KDBizPromptBox prmtTurnInAcct = RecChequeUtil.initF7Cell(this.tblMain, "turnInAcct");
        KDBizPromptBox prmtOppAcct = RecChequeUtil.initF7Cell(this.tblMain, "oppAcct");
        ChequeUtil.setSupplierF7((CoreUIObject)this, prmtPayee, this.currentCompany);
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)prmtTurnInAcct, null);
        RecChequeUtil.initTextColumn(this.tblMain, "password");
        RecChequeUtil.initTextColumn(this.tblMain, "usage");
        RecChequeUtil.initTextColumn(this.tblMain, "keeper");
    }

    private void loadTableFields() {
        this.tblMain.removeRows();
        if (this.editDatas != null && this.editDatas.size() > 0) {
            int l = this.editDatas.size();
            for (int i = 0; i < l; ++i) {
                IRow row = this.tblMain.addRow();
                ChequeInfo info = this.editDatas.get(i);
                row.getCell("id").setValue((Object)info.getId());
                row.getCell("usage").setValue((Object)info.getUsage());
                row.getCell("amount").setValue((Object)info.getAmount());
                row.getCell("number").setValue((Object)info.getNumber());
                row.getCell("keeper").setValue((Object)info.getKeeper());
                row.getCell("isQuota").setValue((Object)info.isIsQuota());
                row.getCell("isTransfer").setValue((Object)info.isIsTransfer());
                row.getCell("isLinear").setValue((Object)info.isIsLineation());
                row.getCell("password").setValue((Object)info.getPassword());
                row.getCell("payee").setValue((Object)info.getPayeeName());
                row.getCell("payeeBankAcct").setValue((Object)info.getPayeeAcctNumber());
                row.getCell("payeeBank").setValue((Object)info.getPayeeAcctBank());
                row.getCell("isMe").setValue((Object)info.isIsOwnReceive());
                row.getCell("oppAcct").setValue((Object)info.getOppAccount());
                row.getCell("turnInAcct").setValue((Object)info.getTurnInAcctBank());
                ChequeAppRecInfo applyRec = info.getApplyRec();
                if (applyRec != null) {
                    row.getCell("ceiling").setValue((Object)applyRec.getCeiling());
                }
                row.getCell("keeper").getStyleAttributes().setLocked(true);
                int precision = FMClientHelper.getLocalCurPre();
                if (info.getCurrency() != null) {
                    precision = info.getCurrency().getPrecision();
                }
                row.getCell("amount").getStyleAttributes().setNumberFormat(RecChequeUtil.getKDTCurrencyFormat(precision));
                row.getCell("ceiling").getStyleAttributes().setNumberFormat(RecChequeUtil.getKDTCurrencyFormat(precision));
                row.setUserObject((Object)info);
            }
            if (this.editData.getNtType().isCommonCheque()) {
                this.tblMain.getColumn("isLinear").getStyleAttributes().setLocked(false);
                this.tblMain.getColumn("isLinear").getStyleAttributes().setBackground(normal);
            } else {
                this.tblMain.getColumn("isLinear").getStyleAttributes().setLocked(true);
                this.tblMain.getColumn("isLinear").getStyleAttributes().setBackground(disable);
            }
            this.updateTableFieldStatue();
        }
    }

    private void updateIsMeFieldStatus(IRow row, boolean isEvent) {
        ICell cPayeeBank = row.getCell("payeeBank");
        ICell cPayeeBankAcct = row.getCell("payeeBankAcct");
        ICell cPayee = row.getCell("payee");
        ICell cIsMe = row.getCell("isMe");
        ICell cTurnInAcct = row.getCell("turnInAcct");
        ICell cOppAcct = row.getCell("oppAcct");
        boolean isCash = ((NTTypeInfo)this.comboNTType.getSelectedItem()).isIsCash();
        boolean isMe = (Boolean)cIsMe.getValue();
        cTurnInAcct.getStyleAttributes().setLocked(true);
        cTurnInAcct.getStyleAttributes().setBackground(disable);
        cPayee.getStyleAttributes().setLocked(true);
        cPayee.getStyleAttributes().setBackground(disable);
        cPayeeBank.getStyleAttributes().setLocked(true);
        cPayeeBank.getStyleAttributes().setBackground(disable);
        cPayeeBankAcct.getStyleAttributes().setLocked(true);
        cPayeeBankAcct.getStyleAttributes().setBackground(disable);
        cOppAcct.getStyleAttributes().setLocked(false);
        cOppAcct.getStyleAttributes().setBackground(normal);
        if (isEvent) {
            cTurnInAcct.setValue(null);
            cPayee.setValue(null);
            cPayeeBank.setValue(null);
            cPayeeBankAcct.setValue(null);
            cOppAcct.setValue(null);
        }
        if (isMe) {
            cTurnInAcct.getStyleAttributes().setLocked(isCash);
            cTurnInAcct.getStyleAttributes().setBackground(isCash ? disable : normal);
            if (this.prmtApplyCompany.getValue() == null) {
                cPayee.setValue(null);
            } else {
                cPayee.setValue((Object)ChequeUtil.getRightCompany(this.prmtApplyCompany).getName());
            }
        } else {
            cPayee.getStyleAttributes().setLocked(false);
            cPayee.getStyleAttributes().setBackground(normal);
            cPayeeBank.getStyleAttributes().setLocked(false);
            cPayeeBank.getStyleAttributes().setBackground(normal);
            cPayeeBankAcct.getStyleAttributes().setLocked(false);
            cPayeeBankAcct.getStyleAttributes().setBackground(normal);
        }
    }

    private void updateIsQuotaFieldStatus(IRow row, boolean isEvent) {
        ICell cAmount = row.getCell("amount");
        ICell cCeiling = row.getCell("ceiling");
        ICell cIsQuota = row.getCell("isQuota");
        ChequeInfo info = (ChequeInfo)row.getUserObject();
        boolean isQuota = (Boolean)cIsQuota.getValue();
        if (isQuota) {
            cAmount.getStyleAttributes().setLocked(true);
            cAmount.getStyleAttributes().setBackground(disable);
            if (isEvent) {
                cAmount.setValue(null);
            }
            cCeiling.getStyleAttributes().setLocked(false);
            cCeiling.getStyleAttributes().setBackground(must);
        } else {
            cCeiling.getStyleAttributes().setLocked(true);
            cCeiling.getStyleAttributes().setBackground(disable);
            if (isEvent) {
                cCeiling.setValue(null);
            }
            cAmount.getStyleAttributes().setLocked(info.getAmount() != null);
            cAmount.getStyleAttributes().setBackground(must);
        }
    }

    private void updateTableFieldStatue() {
        int l = this.tblMain.getRowCount();
        for (int i = 0; i < l; ++i) {
            IRow row = this.tblMain.getRow(i);
            this.updateIsMeFieldStatus(row, false);
            this.updateIsQuotaFieldStatus(row, false);
        }
    }

    private void TDPrintAtApply(List idList, HashMap mapPrint) {
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            SysUtil.abort();
        }
        Object[] ids = mapPrint.keySet().toArray();
        StringBuffer info = new StringBuffer();
        if (ids.length > 0) {
            String chequeHeader = EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"forPrintCheque");
            info.append(chequeHeader + "\n");
        }
        String number = EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"number");
        String ceiling = EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ceiling");
        for (int i = 0; i < ids.length; ++i) {
            info.append(number);
            info.append(":  " + ids[i].toString()).append("     ");
            info.append(ceiling);
            info.append(mapPrint.get(ids[i].toString())).append(";\n");
        }
        int result1 = MsgBox.showConfirm2((String)info.toString());
        if (result1 == 0) {
            ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), true);
        }
    }

    private void prmtOppAcct_WillShow(IRow row) throws EASBizException, BOSException {
        CurrencyInfo currency = this.comboCurrency.getSelectedItem() == null || this.comboNTType.getSelectedItem() == null ? FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany) : (CurrencyInfo)this.comboCurrency.getSelectedItem();
        NTTypeInfo ntType = (NTTypeInfo)this.comboNTType.getSelectedItem();
        ICell cIsMe = row.getCell("isMe");
        boolean isCash = ntType.isIsCash();
        boolean isMe = (Boolean)cIsMe.getValue();
        CompanyOrgUnitInfo applyCompany = ChequeUtil.getRightCompany(this.prmtApplyCompany);
        KDBizPromptBox box = (KDBizPromptBox)this.tblMain.getEditManager().getEditorComponent();
        RecChequeUtil.initPrmtAcctView((IUIObject)this, box, applyCompany, currency.getId().toString(), isCash && isMe);
    }

    private void prmtPayee_WillShow(IRow row) throws EASBizException, BOSException {
        KDBizPromptBox box = (KDBizPromptBox)this.tblMain.getEditManager().getEditorComponent();
        CompanyOrgUnitInfo company = ChequeUtil.getRightCompany(this.prmtApplyCompany);
        ChequeUtil.setSupplierF7((CoreUIObject)this, box, company);
    }

    private void chkIsMe_DataChanged(IRow row) {
        this.updateIsMeFieldStatus(row, true);
    }

    private void chkIsQuota_DataChanged(IRow row) {
        this.updateIsQuotaFieldStatus(row, true);
    }

    private void prmtPayeeName_DataChanged(IRow row) throws Exception {
        ICell cPayee = row.getCell("payee");
        ICell cPayeeBank = row.getCell("payeeBank");
        ICell cPayeeBankAcct = row.getCell("payeeBankAcct");
        Object s = cPayee.getValue();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
        if (company == null) {
            company = this.currentCompany;
        }
        if (s instanceof SupplierInfo) {
            CSBankInfo cs = FMHelper.getCSBankInfo(null, (Object)s, (String)company.getId().toString());
            cPayeeBank.setValue((Object)cs.getBank());
            cPayeeBankAcct.setValue((Object)cs.getBankAccount());
        }
    }

    private void prmtTurnInAcct_WillShow(IRow row) {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
        KDBizPromptBox box = (KDBizPromptBox)this.tblMain.getEditManager().getEditorComponent();
        if (company == null) {
            company = this.currentCompany;
        }
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)box, (CompanyOrgUnitInfo)company);
    }

    private void getDataForEdit() {
        ArrayList<String> selectIdList = (ArrayList<String>)this.getUIContext().get("CHEQUEIDS");
        if ((selectIdList == null || selectIdList.size() == 0) && "FINDVIEW".equals(this.getOprtState()) && this.getUIContext().get("ID") != null && this.getUIContext().get("ID") instanceof String) {
            String ID = (String)this.getUIContext().get("ID");
            selectIdList = new ArrayList<String>();
            selectIdList.add(ID);
        }
        if (selectIdList != null && selectIdList.size() != 0) {
            this.editDatas = ChequeUtil.getChequeCollection(selectIdList);
            this.editData = this.editDatas.get(0);
            EventListener[] listeners = this.prmtNumber.getListeners(DataChangeListener.class);
            if (listeners != null && listeners.length > 0) {
                DataChangeListener dcl = (DataChangeListener)listeners[0];
                this.prmtNumber.removeDataChangeListener(dcl);
                this.prmtNumber.setValue((Object)this.editDatas.toArray());
                this.prmtNumber.addDataChangeListener(dcl);
            } else {
                this.prmtNumber.setValue((Object)this.editDatas.toArray());
            }
        }
    }

    private void updateTableForEdit() {
        if (this.tblMain.getRow(0) != null) {
            this.tblMain.getRow(0).getCell("isQuota").getStyleAttributes().setLocked(true);
            this.tblMain.getRow(0).getCell("number").getStyleAttributes().setLocked(true);
            this.tblMain.getRow(0).getCell("isTransfer").getStyleAttributes().setLocked(true);
            this.tblMain.getRow(0).getCell("isLinear").getStyleAttributes().setLocked(true);
            this.tblMain.getRow(0).getCell("password").getStyleAttributes().setLocked(true);
            this.tblMain.getRow(0).getCell("keeper").getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void prmtactualBankAcct_willCommit(CommitEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    @Override
    protected void prmtactualBankAcct_willShow(SelectorEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    private void initPrmtActualBankAcct() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.editData.getKeepCompany().getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtactualBankAcct.setEntityViewInfo(evi);
        Object currencyInfo = this.comboCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtactualBankAcct.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        this.prmtactualBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtactualBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            AccountBankInfo accout = (AccountBankInfo)this.prmtPayAccountBank.getData();
            if (accout != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
                this.prmtApplyCompany.setValue((Object)company);
                this.editData.getApplyRec().setApplyCompany(company);
            } else {
                this.prmtApplyCompany.setValue(null);
            }
        } else {
            this.prmtApplyCompany.setValue((Object)this.editData.getKeepCompany());
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblMain.getColumn("payee").getColumnIndex() && CoreBaseInfo.class.isInstance(e.getValue())) {
            SupplierInfo supply = (SupplierInfo)e.getValue();
            SupplierCompanyInfoInfo company = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supply.getId().toString()));
            this.tblMain.getRow(rowIndex).getCell("payeeBank").setValue((Object)company.getBankName());
            this.tblMain.getRow(rowIndex).getCell("payeeBankAcct").setValue((Object)company.getBankAccount());
        }
        if (colIndex == this.tblMain.getColumn("isMe").getColumnIndex()) {
            this.ckIsOwnReceive_ValueChanged(e);
        }
    }

    private void ckIsOwnReceive_ValueChanged(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        this.tblMain.getRow2(rowIndex).getCell(colIndex).setValue(e.getValue());
        this.resetPayeeRelatedComps(rowIndex);
    }

    private void resetPayeeRelatedComps(int rowNumber) {
        if (this.tblMain.getRowCount3() == 0) {
            return;
        }
        IRow row = this.tblMain.getRow2(rowNumber);
        boolean isCash = ((NTTypeInfo)this.comboNTType.getSelectedItem()).isIsCash();
        boolean isOwnReceive = false;
        if (row.getCell("isMe").getValue() != null) {
            isOwnReceive = (Boolean)row.getCell("isMe").getValue();
        }
        ICell cellF7TurnInAcct = row.getCell("turnInAcct");
        ICell payeeName = row.getCell("payee");
        ICell payeeBank = row.getCell("payeeBank");
        ICell payeeBankAccount = row.getCell("payeeBankAcct");
        cellF7TurnInAcct.getStyleAttributes().setLocked(true);
        payeeName.getStyleAttributes().setLocked(true);
        payeeBank.getStyleAttributes().setLocked(true);
        ChequeUtil.setComponentsValueNull(new ICell[]{cellF7TurnInAcct, payeeName, payeeBank, payeeBankAccount});
        if (isOwnReceive) {
            if (!isCash) {
                cellF7TurnInAcct.getStyleAttributes().setLocked(false);
                KDTDefaultCellEditor editorTurnInAcct = new KDTDefaultCellEditor((IKDEditor)this.f7TurnInAcct);
                payeeBankAccount.setEditor((ICellEditor)editorTurnInAcct);
            } else {
                cellF7TurnInAcct.getStyleAttributes().setLocked(true);
                payeeBankAccount.getStyleAttributes().setLocked(true);
            }
            if (this.prmtApplyCompany.getValue() != null) {
                payeeName.setValue((Object)this.prmtApplyCompany.getValue().toString());
            } else {
                payeeName.setValue(null);
            }
        } else {
            payeeName.getStyleAttributes().setLocked(false);
            payeeBank.getStyleAttributes().setLocked(false);
            payeeBankAccount.getStyleAttributes().setLocked(false);
            KDTDefaultCellEditor editorBankAccount = new KDTDefaultCellEditor((IKDEditor)this.txtPayeeBankAccount);
            payeeBankAccount.setEditor((ICellEditor)editorBankAccount);
        }
    }

    @Override
    protected void f7OppAccountView_willCommit(CommitEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        this.setOppAccountView(this.f7OppAccountView);
    }

    @Override
    protected void f7OppAccountView_willShow(SelectorEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        this.setOppAccountView(this.f7OppAccountView);
    }

    @Override
    protected void f7TurnInAcct_willCommit(CommitEvent e) throws Exception {
        this.initF7TurnInAcct();
    }

    @Override
    protected void f7TurnInAcct_willShow(SelectorEvent e) throws Exception {
        this.initF7TurnInAcct();
    }

    @Override
    protected void prmtPayeeName_willShow(SelectorEvent e) throws Exception {
        if (this.prmtApplyCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyCompanyNull"));
            e.setCanceled(true);
            return;
        }
    }

    @Override
    protected void prmtPayeeName_dataChanged(DataChangeEvent e) throws Exception {
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        if (CoreBaseInfo.class.isInstance(e.getNewValue())) {
            SupplierInfo supply = (SupplierInfo)e.getNewValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("bankName");
            sic.add("bankAccount");
            CompanyOrgUnitInfo applyCompany = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
            SupplierCompanyInfoInfo company = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supply.getId().toString()), (IObjectPK)new ObjectUuidPK(applyCompany.getId()), sic);
            if (company != null) {
                CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supply, (String)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
                if (bankInfo != null) {
                    row.getCell("payeeBank").setValue((Object)bankInfo.getBank());
                    row.getCell("payeeBankAcct").setValue((Object)bankInfo.getBankAccount());
                } else {
                    row.getCell("payeeBank").setValue(null);
                    row.getCell("payeeBankAcct").setValue(null);
                }
                KDBizPromptBox txtpbAccount = new KDBizPromptBox();
                txtpbAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
                txtpbAccount.setEditFormat("$bankAccount$");
                txtpbAccount.setDisplayFormat("$bankAccount$");
                txtpbAccount.addDataChangeListener(new DataChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dataChanged(DataChangeEvent e) {
                        try {
                            KDBizPromptBox pbac = (KDBizPromptBox)e.getSource();
                            Object o = e.getNewValue();
                            if (o instanceof SupplierCompanyBankInfo) {
                                pbac.setValue((Object)((SupplierCompanyBankInfo)e.getNewValue()).getBankAccount());
                                int activeRowNumber2 = ChequeApplyUI.this.tblMain.getSelectManager().getActiveRowIndex();
                                IRow row2 = ChequeApplyUI.this.tblMain.getRow2(activeRowNumber2);
                                row2.getCell("payeeBank").setValue((Object)((SupplierCompanyBankInfo)e.getNewValue()).getBank());
                            }
                        }
                        catch (Exception exception) {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                });
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                txtpbAccount.setEntityViewInfo(evi);
                KDTDefaultCellEditor editorBankAccount = new KDTDefaultCellEditor((IKDEditor)txtpbAccount);
                row.getCell("payeeBankAcct").setEditor((ICellEditor)editorBankAccount);
            }
        }
    }

    private void initF7TurnInAcct() {
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        if (activeRowNumber == -1) {
            return;
        }
        boolean isCash = ((NTTypeInfo)this.comboNTType.getSelectedItem()).isIsCash();
        boolean isOwnReceive = false;
        if (row.getCell("isMe").getValue() != null) {
            isOwnReceive = (Boolean)row.getCell("isMe").getValue();
        }
        if (this.prmtPayAccountBank.getValue() != null) {
            AccountBankInfo account = (AccountBankInfo)this.prmtPayAccountBank.getValue();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
            if (!"VIEW".equals(this.oprtState) && this.editData != null) {
                this.f7TurnInAcct.getQueryAgent().resetRuntimeEntityView();
                this.f7TurnInAcct.setEntityViewInfo(ChequeUtil.getInAcctBank(isOwnReceive, isCash, account.getId().toString(), company.getId().toString()));
            }
        }
    }

    private void initBankAcctFilter() throws BOSException {
        Object bankInfo;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        if (this.isCompanyFilter) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtPayAccountBank.setEntityViewInfo(evi);
        Object currencyInfo = this.comboCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtPayAccountBank.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        if ((bankInfo = this.prmtPayBank.getValue()) instanceof BankInfo) {
            FilterInfo bankFilter = new FilterInfo();
            bankFilter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)((BankInfo)bankInfo).getId()));
            this.prmtPayAccountBank.getEntityViewInfo().getFilter().mergeFilter(bankFilter, "AND");
        }
        this.prmtPayAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void setOppAccountView(KDBizPromptBox F7) throws EASBizException, BOSException {
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = info.getId().toString();
        CompanyOrgUnitInfo applyCompany = ChequeUtil.getRightCompany(this.prmtApplyCompany);
        boolean isCash = ((NTTypeInfo)this.comboNTType.getSelectedItem()).isIsCash();
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        boolean isMe = (Boolean)row.getCell("isMe").getValue();
        AccountPromptBox account = this.getOppAcctSelector(applyCompany, currencyId, isMe, isCash);
        F7.setSelector((KDPromptSelector)account);
        F7.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo oppAcctEV = ChequeUtil.getOppAcctEV(applyCompany, currencyId, isMe, isCash, true);
        F7.setEntityViewInfo(oppAcctEV);
        F7.setCommitFormat("$number$;$name$");
        F7.setDisplayFormat("$number$ $name$");
        F7.setEditFormat("$number$");
    }

    private AccountPromptBox getOppAcctSelector(CompanyOrgUnitInfo applyCompany, String currencyId, boolean isMe, boolean isCash) throws EASBizException, BOSException {
        EntityViewInfo oppAcctEV = ChequeUtil.getOppAcctEV(applyCompany, currencyId, isMe, isCash, false);
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, applyCompany, oppAcctEV.getFilter(), false, true);
        return acctPromptBox;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "issueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "ActionSubmit"};
    }
}

