/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.CodeGenerter;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractChequeBookInUI;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class ChequeBookInUI
extends AbstractChequeBookInUI {
    private CompanyOrgUnitInfo currentCompany;
    private UserInfo currentUser;
    private boolean isBookThenDistribute;
    private boolean isCompanyFilter;

    public void onLoad() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.isBookThenDistribute = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT003", null);
        this.isCompanyFilter = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT028", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        ((DefaultComboBoxModel)this.comboCurrency.getModel()).addElement(null);
        ChequeUtil.initComboNttype(this.comboNTType, true);
        ChequeUtil.initPerson((IUIObject)this, this.f7Keeper);
        ChequeUtil.initAdminOrgUnit((IUIObject)this, this.f7KeepDepartment);
        ChequeUtil.initCompanyOrgF7((IUIObject)this, this.prmtKeepCompany);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        SpinnerNumberModel sm = new SpinnerNumberModel(1, 0, 9999, 1);
        this.spinStartNum.setModel((SpinnerModel)sm);
        SpinnerNumberModel count = new SpinnerNumberModel(1, 1, 100, 1);
        this.spinCount.setModel((SpinnerModel)count);
        super.onLoad();
        String changeLine = this.txtRemark.getText().replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        this.txtRemark.setText(changeLine);
        this.prmtBookCompany.setEnabled(false);
        this.chkIsDistribute.setSelected(this.isBookThenDistribute);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        ChequeInfo objectValue = new ChequeInfo();
        objectValue.setCreator(this.currentUser);
        objectValue.setPurDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setCompany(this.currentCompany);
        if (!this.isBookThenDistribute) {
            objectValue.setKeepCompany(this.currentCompany);
        }
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Pattern pc;
        Matcher mc;
        String rule;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        Object value = this.prmtBankAcct.getValue();
        if (value instanceof AccountBankInfo) {
            AccountBankInfo acct = (AccountBankInfo)value;
            BankInfo bank = (BankInfo)this.prmtBank.getValue();
            if (!acct.getBank().getId().equals((Object)bank.getId())) {
                throw new NTException(NTException.BANKNOTMATCH);
            }
        }
        if ((rule = this.txtCodeRule.getText()) == null || rule.trim().equals("")) {
            throw new NTException(NTException.CODERULE_NOT_NULL);
        }
        if (rule != null && rule.indexOf("*") < 0) {
            throw new NTException(NTException.CODERULE_HASONESTAR);
        }
        String number = rule + this.spinCount.getIntegerVlaue();
        if (number.length() > 80) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"NumberTooLong"));
            SysUtil.abort();
        }
        if (!(mc = (pc = Pattern.compile("[^\\*]*\\*+[^\\*]*")).matcher(rule)).matches()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"197_ChequeBookInUI"));
            this.txtCodeRule.requestFocus();
            SysUtil.abort();
        }
        int count = this.spinCount.getIntegerVlaue();
        int beginIndex = this.spinStartNum.getIntegerVlaue();
        int start = rule.indexOf("*");
        int end = rule.lastIndexOf("*");
        int starCount = end - start + 1;
        int maxNumber = 1;
        for (int i = 0; i < starCount; ++i) {
            maxNumber *= 10;
        }
        if (beginIndex + count > maxNumber) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"198_ChequeBookInUI"));
            this.txtCodeRule.requestFocus();
            SysUtil.abort();
        }
        Object keeper = this.f7Keeper.getData();
        Object keepDepartment = this.f7KeepDepartment.getData();
        Object keepCompany = this.prmtKeepCompany.getData();
        if (this.chkIsDistribute.isSelected()) {
            if (keepCompany == null && keepDepartment == null && keeper == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"199_ChequeBookInUI"));
                SysUtil.abort();
            } else if (keepCompany == null && keepDepartment != null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"200_ChequeBookInUI"));
                SysUtil.abort();
            } else if ((keepCompany == null || keepDepartment == null) && keeper != null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"201_ChequeBookInUI"));
                SysUtil.abort();
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        boolean checkIsDump = this.checkIsDump();
        boolean byDupNumber = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT002", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (checkIsDump && byDupNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"NumberDupMsg"));
            return;
        }
        if (checkIsDump && !byDupNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"ChequeNumDup"));
            return;
        }
        this.doAddBatch();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"BlankChequeAddSuccess"));
        this.showMessage();
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        AccountBankInfo bankAcct = (AccountBankInfo)e.getNewValue();
        if (bankAcct == null) {
            return;
        }
        if (bankAcct.getCurrency() == null) {
            this.comboCurrency.setEnabled(true);
        } else {
            CurrencyInfo currency = bankAcct.getCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
            this.comboCurrency.setEnabled(false);
        }
        this.prmtBank.setValue((Object)bankAcct.getBank());
    }

    @Override
    protected void prmtBankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAcct_willCommit(e);
        this.initPrmtBankAcct();
    }

    @Override
    protected void prmtBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAcct_willShow(e);
        this.initPrmtBankAcct();
    }

    @Override
    protected void prmtBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBank_dataChanged(e);
    }

    @Override
    protected void prmtKeepCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtKeepCompany_dataChanged(e);
        this.f7KeepDepartment.setValue(null);
    }

    @Override
    protected void prmtKeepCompany_preChange(PreChangeEvent e) throws Exception {
        super.prmtKeepCompany_preChange(e);
        Object value = e.getData();
        if (value instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)value;
            if (info.isIsBizUnit()) {
                e.setResult(1);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"OrgTypeError"));
                e.setResult(-1);
            }
        } else {
            e.setResult(-1);
        }
    }

    @Override
    protected void f7KeepDepartment_dataChanged(DataChangeEvent e) throws Exception {
        super.f7KeepDepartment_dataChanged(e);
        this.f7Keeper.setValue(null);
    }

    @Override
    protected void f7Keeper_willShow(SelectorEvent e) throws Exception {
        this.f7Keeper.setRefresh(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        map.put("0", "2");
        PersonPromptBox select = new PersonPromptBox((IUIObject)this, map);
        select.setHasCUDefaultFilter(false);
        select.setIsDefaultFilterFieldsEnabled(true);
        Object department = this.f7KeepDepartment.getValue();
        Object company = this.prmtKeepCompany.getValue();
        if (department instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)department;
            select.setExpandAdmin(adminOrgUnitInfo.getId().toString());
            select.setCU(adminOrgUnitInfo.getCU().getId().toString());
        } else if (company instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyInfo;
            CompanyOrgUnitInfo parent = companyInfo = (CompanyOrgUnitInfo)company;
            while (companyInfo != null && !companyInfo.isIsAdminOrgUnit()) {
                companyInfo = parent = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getParent().getId()));
            }
            if (companyInfo != null) {
                select.setExpandAdmin(companyInfo.getId().toString());
                select.setCU(companyInfo.getCU().getId().toString());
            }
        }
        this.f7Keeper.setSelector((KDPromptSelector)select);
        this.f7Keeper.getQueryAgent().resetRuntimeEntityView();
        super.f7Keeper_willShow(e);
    }

    private boolean checkIsDump() throws BOSException, EASBizException {
        boolean bool = false;
        String codeRule = this.txtCodeRule.getText();
        int count = Integer.parseInt(this.spinCount.getValue().toString());
        int beginIndex = Integer.parseInt(this.spinStartNum.getValue().toString());
        CodeGenerter codeGen = new CodeGenerter();
        codeGen.setBeginIndex(beginIndex);
        codeGen.setCount(count);
        codeGen.setCodeRule(codeRule);
        String[] numbers = new String[count];
        for (int i = 0; i < count; ++i) {
            numbers[i] = codeGen.nextNumber();
        }
        ICheque cheque = ChequeFactory.getRemoteInstance();
        bool = this.prmtBankAcct.getData() != null ? cheque.checkDup(numbers, ((CoreBaseInfo)this.prmtBankAcct.getData()).getId(), ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId(), ((CoreBaseInfo)this.comboNTType.getSelectedItem()).getId()) : cheque.checkDup(numbers, null, ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId(), ((CoreBaseInfo)this.comboNTType.getSelectedItem()).getId());
        return bool;
    }

    private void doAddBatch() throws Exception, BOSException, EASBizException {
        ChequeCollection collection = new ChequeCollection();
        String codeRule = this.txtCodeRule.getText();
        int count = Integer.parseInt(this.spinCount.getValue().toString());
        int beginIndex = Integer.parseInt(this.spinStartNum.getValue().toString());
        String batch = new Long(System.currentTimeMillis()).toString();
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBankAcct.getData();
        CodeGenerter codeGen = new CodeGenerter();
        codeGen.setBeginIndex(beginIndex);
        codeGen.setCount(count);
        codeGen.setCodeRule(codeRule);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        NTTypeInfo nttype = (NTTypeInfo)this.comboNTType.getSelectedItem();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)nttype.getId().toString()));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getRemoteInstance().getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        for (int i = 0; i < count; ++i) {
            ChequeInfo item = new ChequeInfo();
            item.setState(ChequeStatusEnum.NEW);
            item.setIsAbandon(false);
            item.setIsApply(false);
            item.setAmount(null);
            item.setBatch(batch);
            item.setPurDate(DateUtil.getDayBegin((Date)this.pkPurDate.getTimestamp()));
            item.setNtType(nttype);
            item.setBankAcct(accountBankInfo);
            item.setBankAcctOld(accountBankInfo);
            item.setBankAcctDistr(accountBankInfo);
            item.setBank((BankInfo)this.prmtBank.getValue());
            item.setCompany(this.currentCompany);
            item.setCurrency(this.comboCurrency.getSelectedIndex() == -1 ? null : (CurrencyInfo)this.comboCurrency.getSelectedItem());
            item.setNumber(codeGen.nextNumber());
            item.setKeepDepartment((AdminOrgUnitInfo)this.f7KeepDepartment.getValue());
            item.setKeeper((PersonInfo)this.f7Keeper.getValue());
            item.setKeepCompany((CompanyOrgUnitInfo)this.prmtKeepCompany.getValue());
            item.setIsOwnReceive(true);
            item.setSettleNumber(item.getNumber());
            item.setSettleType(type);
            item.setDistribute(this.chkIsDistribute.isSelected());
            collection.add(item);
        }
        ICheque iCheque = (ICheque)this.getBizInterface();
        iCheque.addBatch(collection);
    }

    private void initPrmtBankAcct() {
        BankInfo bank = (BankInfo)this.prmtBank.getValue();
        CompanyOrgUnitInfo company = this.isCompanyFilter ? this.currentCompany : null;
        ChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtBankAcct, company, bank, null);
        this.prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
    }
}

