/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeHelper;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractChequeEditUI;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.ReceiptBillUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ChequeEditUI
extends AbstractChequeEditUI {
    private final IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
    private final CompanyOrgUnitInfo currentCompany = this.localInstance.getCurrentCompany();
    private final UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
    private final boolean isBookable;
    private boolean isCompanyFilter;

    public ChequeEditUI() throws Exception {
        int val = this.localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        this.isBookable = val == 0 && this.currentCompany.isIsBizUnit();
        this.isCompanyFilter = this.localInstance.getBooleanParam("NT028", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_post"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionUnionSearch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_linkviewbill"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.chkIsMe.setSelected(this.editData.isIsOwnReceive());
        try {
            this.chkIsMe_itemStateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.f7TurnInAcct.setValue((Object)this.editData.getTurnInAcctBank());
        if (!this.editData.isIsOwnReceive()) {
            this.txtPayeeName.setText(this.editData.getPayeeName());
        }
        this.f7OppAccountView.setValue((Object)this.editData.getOppAccount());
        this.txtPayeeAcctBank.setText(this.editData.getPayeeAcctBank());
        this.txtPayeeAcctNumber.setText(this.editData.getPayeeAcctNumber());
        this.f7Project.setValue((Object)this.editData.getProject());
        this.f7ProjectManager.setValue((Object)this.editData.getProjectManager());
        this.prmtFeeType.setValue((Object)this.editData.getFeeTypeID());
        if (this.editData.getApplyRec() != null && this.editData.getApplyRec().getCreator() != null) {
            this.prmtCreator.setValue((Object)this.editData.getApplyRec().getCreator());
        }
        this.txtPayeeName.setText(this.editData.getPayeeName());
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        if (this.chkIsMe.isSelected() && this.prmtApplyCompany.getValue() != null) {
            this.txtPayeeName.setValue((Object)this.prmtApplyCompany.getValue().toString());
        }
        this.setDatePickerValues();
    }

    public void onLoad() throws Exception {
        boolean editApplyCheque;
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        this.txtAmount.setNegatived(false);
        this.txtCeiling.setNegatived(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtCeiling);
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        super.onLoad();
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.txtPayeeName, this.currentCompany);
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.f7TurnInAcct);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.f7Project);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAuditor);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtReimburser);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtApplicant);
        CurrencyInfo infos = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (infos != null) {
            CurrencyInfo infosss = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            this.txtAmount.setPrecision(infosss.getPrecision());
        }
        this.prmtApplyCompany.setEnabled(false);
        CompanyOrgUnitInfo applyCompany = (CompanyOrgUnitInfo)this.prmtApplyCompany.getData();
        if (applyCompany != null) {
            FilterItemInfo filterComapny = new FilterItemInfo("company.id", (Object)applyCompany.getId().toString());
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.f7TurnInAcct, (FilterItemInfo)filterComapny);
        }
        this.setEnabledComps(this.editData);
        boolean isEdit = this.getUIContext().get("EDIT") != null;
        boolean realEdit = this.getOprtState().equals(OprtState.EDIT) && isEdit;
        boolean bl = editApplyCheque = realEdit && this.editData.isIsApply();
        if (!editApplyCheque) {
            this.dpReimburseDate.setRequired(true);
            this.pkIssueDate.setRequired(true);
            this.pkExpiredDate.setRequired(true);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        ChequeUtil.updateEditUITitle((CoreUIObject)this, this.resHelper.getString("this.title"), isEdit);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        Object pbfro = this.getUIContext().get("PaymentBillForReimburse");
        if (pbfro != null) {
            PaymentBillInfo pbInfo = (PaymentBillInfo)pbfro;
            this.chkIsMe.setSelected(false);
            this.prmtBankAcct.setDataNoNotify((Object)pbInfo.getPayerAccountBank());
            if (!FMHelper.isEmpty((CoreBaseInfo)pbInfo.getPayerAccountBank())) {
                this.prmtApplyCompany.setValue((Object)pbInfo.getPayerAccountBank().getCompany());
            }
            this.prmtBankAcct.setEnabled(false);
            this.dpReimburseDate.setValue((Object)new Date());
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)pbInfo.getCurrency());
            this.txtAmount.setValue((Object)pbInfo.getActPayAmt());
            this.txtAmount.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.txtPayeeName.setValue((Object)pbInfo.getPayeeName());
            this.txtPayeeName.setEnabled(false);
            this.txtPayeeAcctNumber.setText(pbInfo.getPayeeAccountBank());
            this.txtPayeeAcctNumber.setEnabled(false);
            this.txtPayeeAcctBank.setText(pbInfo.getPayeeBank());
            this.txtPayeeAcctBank.setEnabled(false);
            this.txtUsage.setText(pbInfo.getUsage());
            this.txtDescription.setText(pbInfo.getDescription());
            if (this.pkApplyDate.getValue() == null) {
                this.pkApplyDate.setValue((Object)new Date());
            }
        }
        this.setBankAcctBysupplier();
        ExtendParser txtPayeeBankAcctNumParser = new ExtendParser(this.txtPayeeAcctNumber);
        this.txtPayeeAcctNumber.setCommitParser((IParser)txtPayeeBankAcctNumParser);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setIsOwnReceive(this.chkIsMe.isSelected());
        this.editData.setPayeeName(this.txtPayeeName.getText());
        this.editData.setPayeeAcctNumber(this.txtPayeeAcctNumber.getText());
        this.editData.setPayeeAcctBank(this.txtPayeeAcctBank.getText());
        this.editData.setTurnInAcctBank((AccountBankInfo)this.f7TurnInAcct.getValue());
        this.editData.setUsage(this.txtUsage.getText());
        this.editData.setDescription(this.txtDescription.getText());
        this.editData.setIssueDate(this.pkIssueDate.getSqlDate());
        this.editData.setExpiredDate(this.pkExpiredDate.getSqlDate());
        Object pSup = this.txtPayeeName.getData();
        if (pSup instanceof SupplierInfo) {
            SupplierInfo ps = (SupplierInfo)pSup;
            this.editData.setPayeeSupplier(ps);
        }
    }

    public boolean isModify() {
        if (this.getOprtState().equals("FINDVIEW")) {
            return false;
        }
        return super.isModify();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("applyRec.department.id"));
        sic.add(new SelectorItemInfo("applyRec.department.name"));
        sic.add(new SelectorItemInfo("applyRec.department.number"));
        sic.add(new SelectorItemInfo("applyRec.applicant.id"));
        sic.add(new SelectorItemInfo("applyRec.applicant.name"));
        sic.add(new SelectorItemInfo("applyRec.applicant.number"));
        sic.add(new SelectorItemInfo("applyRec.auditor.id"));
        sic.add(new SelectorItemInfo("applyRec.auditor.name"));
        sic.add(new SelectorItemInfo("applyRec.auditor.number"));
        sic.add(new SelectorItemInfo("applyRec.reimburser.id"));
        sic.add(new SelectorItemInfo("applyRec.reimburser.name"));
        sic.add(new SelectorItemInfo("applyRec.reimburser.number"));
        sic.add(new SelectorItemInfo("applyRec.creator.id"));
        sic.add(new SelectorItemInfo("applyRec.creator.name"));
        sic.add(new SelectorItemInfo("applyRec.creator.number"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.isCash"));
        sic.add(new SelectorItemInfo("turnInAcctBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("turnInAcctBank.id"));
        sic.add(new SelectorItemInfo("turnInAcctBank.number"));
        sic.add(new SelectorItemInfo("turnInAcctBank.name"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("applyRec.*"));
        sic.add(new SelectorItemInfo("settleType.*"));
        sic.add(new SelectorItemInfo("keepCompany.cu"));
        sic.add(new SelectorItemInfo("keepCompany.id"));
        sic.add(new SelectorItemInfo("keepCompany.name"));
        sic.add(new SelectorItemInfo("keepCompany.number"));
        sic.add(new SelectorItemInfo("journal.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.number"));
        sic.add(new SelectorItemInfo("actualBankAcct.name"));
        sic.add(new SelectorItemInfo("actualBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("keeper.id"));
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ChequeInfo info = (ChequeInfo)this.getDataObject();
        this.actionEdit.setVisible(false);
        this.actionBook.setVisible(this.isBookable);
        this.actionCancelBook.setVisible(this.isBookable);
        this.actionBook.setEnabled(ChequeHelper.isCanRecord(info));
        this.actionCancelBook.setEnabled(ChequeHelper.isCanCancelRecord(info));
        this.actionAbandon.setEnabled(ChequeHelper.isCanAbandon(info));
        this.actionAntiAbandon.setEnabled(ChequeHelper.isCanCancelAbandon(info));
        if (info == null || this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        this.pkApplyDate.setEnabled(false);
        if (info.getState() == ChequeStatusEnum.APPLIED) {
            this.prmtReimburser.setData(this.prmtApplicant.getData());
            this.prmtDepartment.setEnabled(false);
            this.prmtApplicant.setEnabled(false);
            this.pkApplyDate.setEnabled(false);
            this.pkRemindDate.setEnabled(info.getApplyRec().getRemindDate() == null);
            this.txtCeiling.setEnabled(false);
            this.pkExpiredDate.setEnabled(info.getExpiredDate() == null);
        } else if (info.getState() == ChequeStatusEnum.NEW) {
            this.pkApplyDate.setEnabled(true);
            this.pkRemindDate.setEnabled(false);
            this.pkApplyDate.setValue(this.pkIssueDate.getValue());
            this.pkRemindDate.setValue(this.pkIssueDate.getValue());
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            this.prmtCreator.setData((Object)user.getPerson());
            info.setApplyRec(new ChequeAppRecInfo());
        } else if (info.getState() == ChequeStatusEnum.WRITTEN_OFF) {
            FMClientHelper.setCompEnable((IKDComponent[])new IKDComponent[]{this.pkApplyDate, this.pkRemindDate, this.txtCeiling, this.pkApplyDate, this.pkRemindDate, this.txtAmount}, (boolean)false);
        }
        if (info.getBankAcct() != null) {
            this.prmtBankAcct.setEnabled(false);
        } else {
            this.prmtBankAcct.setEnabled(true);
        }
        this.prmtactualBankAcct.setEnabled(true);
        if (info.getProject() != null) {
            this.f7Project.setEnabled(false);
            this.f7ProjectManager.setEnabled(false);
            this.prmtFeeType.setEnabled(false);
        }
        if (!info.getNtType().isCommonCheque()) {
            this.cbIsLine.setEnabled(false);
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("FINDVIEW".equals(this.oprtState)) {
            this.lockUIForViewStatus();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ChequeInfo objectValue = new ChequeInfo();
        objectValue.setCompany(this.currentCompany);
        objectValue.setCreator(this.currentUser);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        boolean editApplyCheque;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        boolean EditNotRemburse = this.getUIContext().get("EDIT") != null;
        boolean realEdit = this.getOprtState().equals(OprtState.EDIT) && EditNotRemburse;
        boolean bl = editApplyCheque = realEdit && this.editData.isIsApply();
        if (!editApplyCheque) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpReimburseDate);
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        }
        Date applyDate = DateTimeUtils.truncateDate((Date)((Date)this.pkApplyDate.getValue()));
        if (this.pkApplyDate.getValue() != null && this.editData.getPurDate() != null && ((Date)this.pkApplyDate.getValue()).before(this.editData.getPurDate())) {
            throw new NTException(NTException.APPLYDATEMUSTAFTERPURDATE);
        }
        if (!editApplyCheque) {
            Date reimburseDate = DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue()));
            Date issueDate = DateTimeUtils.truncateDate((Date)((Date)this.pkIssueDate.getValue()));
            Date expireDate = DateTimeUtils.truncateDate((Date)((Date)this.pkExpiredDate.getValue()));
            if (!expireDate.after(issueDate)) {
                throw new NTException(NTException.EXPIREDATE_LESSTHAN_ISSUEDATE);
            }
            if (applyDate.after(reimburseDate)) {
                throw new NTException(NTException.REIMBURSEDATAAFTERISSUEDATE);
            }
        }
        Date issueDate = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        Date reimburseDate = DateTimeUtils.truncateDate((Date)this.dpReimburseDate.getSqlDate());
        if (reimburseDate != null && issueDate != null && issueDate.after(reimburseDate)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"202_ChequeEditUI"));
            SysUtil.abort();
        }
        if (applyDate != null && issueDate != null && applyDate.after(issueDate)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"203_ChequeEditUI"));
            SysUtil.abort();
        }
        PersonInfo person = this.currentUser.getPerson();
        if (!this.prmtAuditor.getText().equals("") && person != null && ((PersonInfo)this.prmtAuditor.getData()).getId().toString().equals(person.getId().toString())) {
            throw new NTException(NTException.NOT_SAME_PERSON);
        }
        if (!this.prmtApplicant.getText().equals("") && !this.prmtAuditor.getText().equals("") && ((PersonInfo)this.prmtAuditor.getData()).getId().toString().equals(((PersonInfo)this.prmtApplicant.getData()).getId().toString())) {
            throw new NTException(NTException.NOT_SAME_PERSON);
        }
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        BigDecimal ceiling = this.txtCeiling.getBigDecimalValue();
        if (amount != null && amount.compareTo(Constants.ZERO) <= 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_ZERO);
        }
        if (amount != null && ceiling != null && amount.compareTo(ceiling) > 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_CEILING);
        }
        boolean isManager = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT041", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        boolean feeTypeAndProject = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT040", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (this.prmtFeeType.getValue() != null && feeTypeAndProject) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7Project);
            if (isManager) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7ProjectManager);
            }
        }
        if (this.f7Project.getValue() != null) {
            if (isManager) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7ProjectManager);
            }
            if (feeTypeAndProject) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtFeeType);
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean EditNotRemburse;
        boolean oprtAll;
        String personId;
        this.checkFinalCheckout();
        PersonInfo curPerson = ContextHelperFactory.getRemoteInstance().getCurrentUser().getPerson();
        String string = personId = curPerson != null ? curPerson.getId().toString() : "";
        if (curPerson == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"OPRTPERMIT"));
            SysUtil.abort();
        }
        boolean viewAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT004", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        boolean bl = oprtAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT005", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
        if (!(viewAll && oprtAll || personId == null || this.editData.getKeeper() != null && personId.equals(this.editData.getKeeper().getId().toString()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"SAMEPERSON"));
            SysUtil.abort();
        }
        boolean bl2 = EditNotRemburse = this.getUIContext().get("EDIT") != null;
        if (this.getOprtState().equals(OprtState.EDIT) && EditNotRemburse) {
            this.editData.setWriteOffEdit(true);
            super.actionSubmit_actionPerformed(e);
            if (this.editData.getState().equals((Object)ChequeStatusEnum.APPLIED)) {
                ChequeUtil.setComponentEnable((JComponent)((Object)this), false);
                FMClientHelper.setCompEnable((IKDComponent[])this.getApplyEnabledComps(), (boolean)true);
            } else if (this.editData.getState().equals((Object)ChequeStatusEnum.WRITTEN_OFF)) {
                ChequeUtil.setComponentEnable((JComponent)((Object)this), false);
                FMClientHelper.setCompEnable((IKDComponent[])this.getReimburseEnabledComps(), (boolean)true);
            }
            if (this.editData.getNtType().isIsCash()) {
                this.txtPayeeName.setEnabled(false);
            }
        } else {
            this.storeFields();
            this.editData.setWriteOffEdit(true);
            this.actionWriteOff_actionPerformed(e);
            this.doAfterSubmit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            Object pbfro = this.getUIContext().get("PaymentBillForReimburse");
            if (pbfro != null) {
                // empty if block
            }
        }
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
    }

    protected void showSubmitSuccess() {
        Object pbfro = this.getUIContext().get("PaymentBillForReimburse");
        if (pbfro != null) {
            return;
        }
        super.showSubmitSuccess();
    }

    @Override
    public void actionWriteOff_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.doWriteOff();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"ChequeWriteOffSuccess"));
        this.setIsShowTextOnly(true);
        this.showMessage();
        Object pbfro = this.getUIContext().get("PaymentBillForReimburse");
        if (pbfro != null) {
            PaymentBillInfo pbInfo = (PaymentBillInfo)pbfro;
            PaymentBillFactory.getRemoteInstance().chequeReimburse(this.editData.getId().toString(), pbInfo.getId().toString());
        }
    }

    @Override
    public void actionUnionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionSearch_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        if (!this.editData.isIsVC()) {
            throw new NTException(NTException.NOTJOURNALEXIST);
        }
        if (this.editData.getJournal() == null || this.editData.getJournal().getId() == null) {
            throw new NTException(NTException.NOTJOURNALEXIST);
        }
        FMClientHelper.viewJournal((CoreUIObject)this, (String)this.editData.getJournal().getId().toString(), null);
    }

    @Override
    public void actionTDPreView_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData.getId().toString() != null) {
            if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
                return;
            }
            if (this.editData.getState() != ChequeStatusEnum.WRITTEN_OFF && this.editData.getState() != ChequeStatusEnum.APPLIED) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"StatusLimited"));
                return;
            }
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        super.actionTDPreView_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData.getId().toString() != null) {
            if (!(this.isSave() || this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals("FINDVIEW"))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
                return;
            }
            if (this.editData.getState() != ChequeStatusEnum.WRITTEN_OFF && this.editData.getState() != ChequeStatusEnum.APPLIED) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"StatusLimited"));
                return;
            }
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        super.actionTDPrint_actionPerformed(e);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.editData.getId().toString());
        ((ICheque)this.getBizInterface()).book(ids);
        this.editData = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors());
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionBook);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnSubmit.setEnabled(false);
        }
        this.actionBook.setEnabled(false);
        this.actionCancelBook.setEnabled(true);
        FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.editData.getId().toString());
        ((ICheque)this.getBizInterface()).cancelBook(ids);
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionCancelBook);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnSubmit.setEnabled(false);
        }
        this.actionBook.setEnabled(true);
        this.actionCancelBook.setEnabled(false);
    }

    @Override
    protected void prmtApplyCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtApplyCompany_dataChanged(e);
        if (e.getNewValue() == null) {
            this.prmtApplicant.setEnabled(false);
            this.prmtDepartment.setEnabled(false);
            this.txtPayeeName.setEnabled(false);
            this.f7TurnInAcct.setEnabled(false);
            return;
        }
        this.prmtApplicant.setEnabled(true);
        this.prmtDepartment.setEnabled(true);
        ChequeUtil.setComponentsValueNull(new IKDComponent[]{this.prmtDepartment, this.prmtAuditor, this.txtPayeeName, this.f7TurnInAcct, this.f7OppAccountView, this.txtPayeeAcctBank, this.txtPayeeAcctNumber, this.f7Project, this.f7ProjectManager});
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.*"));
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        company.setCU(info.getCU());
        F7SelectorFactory.initAdminOrgUnitWithRoot((IUIObject)this, (KDBizPromptBox)this.prmtDepartment, (CompanyOrgUnitInfo)company);
        FilterItemInfo filterComapny = new FilterItemInfo("company.id", (Object)company.getId().toString());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.f7TurnInAcct, (FilterItemInfo)filterComapny);
        if (this.chkIsMe.isSelected()) {
            this.txtPayeeName.setValue((Object)company.getName());
            this.txtPayeeName.setEnabled(false);
            this.chkIsMe_actionPerformed(null);
        } else {
            this.txtPayeeName.setValue(null);
            this.txtPayeeName.setEnabled(true);
        }
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.txtPayeeName, company);
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        if (e.getNewValue() == null) {
            if (this.prmtactualBankAcct.getData() == null) {
                this.prmtApplyCompany.setValue(null);
            }
            this.txtPayeeName.setValue(null);
            this.f7OppAccountView.setValue(null);
            this.comboCurrency.setEnabled(true);
            return;
        }
        this.comboCurrency.setEnabled(false);
        if (e.getNewValue() instanceof AccountBankInfo) {
            CurrencyInfo currency;
            AccountBankInfo accout = (AccountBankInfo)e.getNewValue();
            accout = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accout.getId()));
            if (this.prmtactualBankAcct.getData() == null) {
                ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
                this.prmtApplyCompany.setValue((Object)company);
            }
            if ((currency = accout.getCurrency()) == null) {
                this.comboCurrency.setEnabled(true);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
                this.comboCurrency.setEnabled(false);
            }
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCurrency_itemStateChanged(e);
        Object c = this.comboCurrency.getSelectedItem();
        if (c instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)c;
            this.txtAmount.setPrecision(info.getPrecision());
            this.txtCeiling.setPrecision(info.getPrecision());
        }
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.pkIssueDate.getTimestamp() != null && (this.editData.getState() == ChequeStatusEnum.NEW || this.editData.getState() == ChequeStatusEnum.STORE)) {
            if (this.pkExpiredDate.isEnabled()) {
                this.pkExpiredDate.setValue((Object)DateTimeUtils.addDay((Date)this.pkIssueDate.getTimestamp(), (long)10L));
            }
            this.pkRemindDate.setValue(this.pkIssueDate.getValue());
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo curInfo;
        BigDecimal value = this.txtAmount.getBigDecimalValue();
        if (value == null) {
            return;
        }
        if (value.compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtAmount.setValue((Object)Constants.ZERO);
            this.txtCapitalization.setText(null);
            this.txtCeiling.setValue((Object)Constants.ZERO);
            SysUtil.abort();
        }
        if ((curInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem()) == null && (curInfo = this.editData.getCurrency()) == null) {
            return;
        }
        String amount = FMClientHelper.getChineseFormat((BigDecimal)this.txtAmount.getBigDecimalValue());
        this.txtCapitalization.setText(amount);
        this.getDataObject().put("capitalization", (Object)amount);
        if (this.editData.getState() == ChequeStatusEnum.NEW) {
            this.txtCeiling.setValue((Object)this.txtAmount.getBigDecimalValue());
        }
    }

    @Override
    protected void txtCeiling_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal value = this.txtCeiling.getBigDecimalValue();
        if (value == null) {
            return;
        }
        if (value.compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtCeiling.setValue((Object)Constants.ZERO);
            SysUtil.abort();
        }
    }

    @Override
    protected void chkIsMe_itemStateChanged(ItemEvent e) throws Exception {
        ChequeInfo cheque = (ChequeInfo)this.getDataObject();
        if (cheque == null) {
            return;
        }
        boolean isCash = cheque.getNtType().isIsCash();
        boolean isMe = this.chkIsMe.isSelected();
        EntityViewInfo oppAcctEV = this.getOppAcctEV(isMe, isCash);
        this.f7OppAccountView.setEntityViewInfo(oppAcctEV);
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, this.currentCompany, oppAcctEV.getFilter(), false, true);
        this.f7OppAccountView.setSelector((KDPromptSelector)acctPromptBox);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
        if (company == null) {
            company = this.currentCompany;
        }
        if (cheque.getBankAcct() != null && !"VIEW".equals(this.oprtState)) {
            this.f7TurnInAcct.setEntityViewInfo(ChequeUtil.getInAcctBank(isMe, isCash, cheque.getBankAcct().getId().toString(), company.getId().toString()));
        }
        this.f7TurnInAcct.setEnabled(false);
        this.txtPayeeName.setEnabled(false);
        this.txtPayeeAcctBank.setEnabled(false);
        this.txtPayeeAcctNumber.setEnabled(false);
        this.f7TurnInAcct.setValue(null);
        this.txtPayeeName.setText(null);
        this.f7OppAccountView.setValue(null);
        this.txtPayeeAcctBank.setText(null);
        this.txtPayeeAcctNumber.setText(null);
        if (this.chkIsMe.isSelected()) {
            if (!isCash) {
                this.f7TurnInAcct.setEnabled(true);
            }
            if (this.prmtApplyCompany.getValue() == null) {
                this.txtPayeeName.setText(null);
            } else {
                this.txtPayeeName.setText(ChequeUtil.getRightCompany(this.prmtApplyCompany).getName());
            }
        } else {
            this.txtPayeeName.setEnabled(true);
            this.txtPayeeAcctBank.setEnabled(true);
            this.txtPayeeAcctNumber.setEnabled(true);
        }
    }

    @Override
    protected void f7TurnInAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.f7TurnInAcct_dataChanged(e);
        AccountBankInfo info = (AccountBankInfo)this.f7TurnInAcct.getValue();
        if (info == null) {
            return;
        }
        IAccountBank acctBank = AccountBankFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("account.*");
        AccountBankInfo acctbankinfo = acctBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getId()), selector);
        this.f7OppAccountView.setValue((Object)acctbankinfo.getAccount());
    }

    @Override
    protected void f7Project_dataChanged(DataChangeEvent e) throws Exception {
        super.f7Project_dataChanged(e);
        ProjectInfo project = (ProjectInfo)this.f7Project.getValue();
        if (project == null) {
            this.f7ProjectManager.setValue(null);
        } else if (project.getPrjManager() != null) {
            ObjectUuidPK objPk = new ObjectUuidPK(project.getPrjManager().getId().toString());
            PersonInfo bill = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)objPk);
            this.f7ProjectManager.setValue((Object)bill);
        }
    }

    @Override
    protected void prmtApplicant_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtApplicant_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof PersonInfo) {
            PersonInfo person = (PersonInfo)newValue;
            AdminOrgUnitInfo org = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(person.getId());
            if (org != null) {
                this.prmtDepartment.setValue((Object)org);
            }
        }
    }

    @Override
    protected void txtPayeeName_dataChanged(DataChangeEvent e) throws Exception {
        super.txtPayeeName_dataChanged(e);
        this.setBankAcctBysupplier();
    }

    private void setBankAcctBysupplier() throws Exception {
        SupplierInfo supplier = this.getSupplier(this.txtPayeeName.getData());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
        if (supplier != null) {
            ReceiptBillUtil.setBankAcctBySupplier(supplier, this.txtPayeeAcctNumber, this.txtPayeeAcctBank);
        }
    }

    @Override
    protected void f7OppAccountView_willShow(SelectorEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        this.setOppAccountView(this.f7OppAccountView);
    }

    @Override
    protected void f7OppAccountView_willCommit(CommitEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        this.setOppAccountView(this.f7OppAccountView);
    }

    private EntityViewInfo getOppAcctEV(boolean isMe, boolean isCash) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String cuid = this.currentCompany.getCU().getId().toString();
        ev.setFilter(filter);
        if (isMe && isCash) {
            filter.getFilterItems().add(new FilterItemInfo("iscash", (Object)Constants.TRUE));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cuid));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Constants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        return ev;
    }

    @Override
    protected void dpReimburseDate_dataChanged(DataChangeEvent e) throws Exception {
        super.dpReimburseDate_dataChanged(e);
        Date reimburseDate = DateTimeUtils.truncateDate((Date)((Date)e.getNewValue()));
        if (!this.editData.isIsApply()) {
            this.pkRemindDate.setValue((Object)reimburseDate);
        }
    }

    @Override
    protected void prmtDepartment_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtDepartment_dataChanged(e);
    }

    @Override
    protected void txtPayeeName_willShow(SelectorEvent e) throws Exception {
        if (this.prmtApplyCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyCompanyNull"));
            e.setCanceled(true);
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.txtPayeeName, company);
        this.txtPayeeName.setCurrentCtrlUnit(company.getCU());
        this.txtPayeeName.getQueryAgent().resetRuntimeEntityView();
        super.txtPayeeName_willShow(e);
    }

    @Override
    protected void prmtApplicant_willCommit(CommitEvent e) throws Exception {
        this.prmtApplicant_willEvent((EventObject)e);
    }

    @Override
    protected void prmtApplicant_willShow(SelectorEvent e) throws Exception {
        this.prmtApplicant_willEvent((EventObject)e);
    }

    private void prmtApplicant_willEvent(EventObject e) throws Exception {
        AdminOrgUnitInfo adminOrgUnitInfo;
        if (ChequeUtil.checkApplyCompanyNotNull(this.prmtApplyCompany, e) && (adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtDepartment.getData()) != null) {
            PersonPromptBox selector = (PersonPromptBox)this.prmtApplicant.getSelector();
            if (selector == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("All_Admins", "YES");
                selector = new PersonPromptBox((IUIObject)this, map);
            }
            selector.showAllChildren();
            selector.setHasCUDefaultFilter(false);
            selector.setExpandAdmin(adminOrgUnitInfo.getId().toString());
            this.prmtApplicant.setSelector((KDPromptSelector)selector);
        }
    }

    @Override
    protected void prmtDepartment_willCommit(CommitEvent e) throws Exception {
        super.prmtDepartment_willCommit(e);
    }

    @Override
    protected void prmtDepartment_willShow(SelectorEvent e) throws Exception {
        super.prmtDepartment_willShow(e);
    }

    @Override
    protected void prmtBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAcct_willShow(e);
        this.initBankAcctFilter();
    }

    @Override
    protected void prmtBankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAcct_willCommit(e);
        this.initBankAcctFilter();
    }

    private void setDatePickerValues() {
        boolean EditNotRemburse;
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.dpReimburseDate.setValue((Object)this.editData.getReimburseDate());
            this.pkIssueDate.setValue((Object)this.editData.getIssueDate());
            this.pkExpiredDate.setValue((Object)this.editData.getExpiredDate());
            if (this.editData.getApplyRec() != null) {
                this.pkApplyDate.setValue((Object)this.editData.getApplyRec().getApplyDate());
                this.pkRemindDate.setValue((Object)this.editData.getApplyRec().getRemindDate());
            }
        } else {
            if (this.pkIssueDate.getTimestamp() == null) {
                this.pkIssueDate.setValue((Object)DateTimeUtils.truncateDate((Date)new Date()));
                this.pkExpiredDate.setValue((Object)DateTimeUtils.addDay((Date)this.pkIssueDate.getTimestamp(), (long)10L));
            }
            if (this.dpReimburseDate.getValue() == null) {
                this.dpReimburseDate.setValue((Object)new Date());
            }
            if (this.editData.getApplyRec() != null) {
                if (this.editData.getApplyRec().getRemindDate() == null) {
                    this.pkRemindDate.setValue((Object)new Date());
                } else {
                    this.pkRemindDate.setValue((Object)this.editData.getApplyRec().getRemindDate());
                }
                if (this.editData.getApplyRec().getApplyDate() == null) {
                    this.pkApplyDate.setValue((Object)new Date());
                } else {
                    this.pkApplyDate.setValue((Object)this.editData.getApplyRec().getApplyDate());
                }
                this.prmtReimburser.setValue((Object)this.editData.getApplyRec().getReimburser());
            } else {
                this.pkRemindDate.setValue((Object)new Date());
                this.pkApplyDate.setValue((Object)new Date());
            }
        }
        boolean bl = EditNotRemburse = this.getUIContext().get("EDIT") != null;
        if (this.getOprtState().equals(OprtState.EDIT) && EditNotRemburse && this.editData.getState().equals((Object)ChequeStatusEnum.APPLIED)) {
            this.dpReimburseDate.setValue(null);
        }
    }

    private void initBankAcctFilter() throws BOSException {
        Object bankInfo;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        if (this.isCompanyFilter) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBankAcct.setEntityViewInfo(evi);
        Object currencyInfo = this.comboCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtBankAcct.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        if ((bankInfo = this.prmtBank.getValue()) instanceof BankInfo) {
            FilterInfo bankFilter = new FilterInfo();
            bankFilter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)((BankInfo)bankInfo).getId()));
            this.prmtBankAcct.getEntityViewInfo().getFilter().mergeFilter(bankFilter, "AND");
        }
        this.prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private void doWriteOff() throws Exception, BOSException, EASBizException {
        ICheque iCheque = (ICheque)this.getBizInterface();
        ChequeInfo chequeInfo = this.editData;
        chequeInfo.setIssueDate((Date)this.pkIssueDate.getValue());
        chequeInfo.setExpiredDate((Date)this.pkExpiredDate.getValue());
        chequeInfo.setAmount(this.txtAmount.getBigDecimalValue());
        chequeInfo.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        chequeInfo.setUsage(this.txtUsage.getText());
        chequeInfo.setPayeeName(this.txtPayeeName.getText());
        chequeInfo.setDescription(this.txtDescription.getText());
        chequeInfo.setCapitalization(this.txtCapitalization.getText());
        chequeInfo.setPayeeAcctBank(this.txtPayeeAcctBank.getText());
        chequeInfo.setPayeeAcctNumber(this.txtPayeeAcctNumber.getText());
        chequeInfo.setReimburseDate(DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue())));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)chequeInfo.getNtType().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection coll = SettlementTypeFactory.getRemoteInstance().getCollection(view);
        if (coll.size() > 0) {
            chequeInfo.setSettleType((SettlementTypeInfo)coll.get(0));
        } else {
            chequeInfo.setSettleType(null);
        }
        chequeInfo.setIsOwnReceive(this.chkIsMe.isSelected());
        chequeInfo.setTurnInAcctBank((AccountBankInfo)this.f7TurnInAcct.getValue());
        chequeInfo.setOppAccount((AccountViewInfo)this.f7OppAccountView.getValue());
        chequeInfo.setProject((ProjectInfo)this.f7Project.getValue());
        chequeInfo.setProjectManager((PersonInfo)this.f7ProjectManager.getValue());
        if (this.prmtFeeType.getValue() != null) {
            chequeInfo.setFeeTypeID((FeeTypeInfo)this.prmtFeeType.getValue());
        }
        if (this.editData.getState() == ChequeStatusEnum.NEW) {
            ChequeAppRecInfo recInfo = new ChequeAppRecInfo();
            recInfo.setApplicant((PersonInfo)this.prmtApplicant.getData());
            recInfo.setAuditor((PersonInfo)this.prmtAuditor.getData());
            recInfo.setDepartment((AdminOrgUnitInfo)this.prmtDepartment.getData());
            recInfo.setRemindDate((Date)this.pkRemindDate.getValue());
            recInfo.setApplyDate((Date)this.pkApplyDate.getValue());
            recInfo.setReimburser((PersonInfo)this.prmtReimburser.getData());
            recInfo.setCeiling(this.txtCeiling.getBigDecimalValue());
            recInfo.setApplyCompany((CompanyOrgUnitInfo)this.prmtApplyCompany.getValue());
            chequeInfo.setApplyRec(recInfo);
        } else if (this.editData.getState() == ChequeStatusEnum.APPLIED) {
            chequeInfo.getApplyRec().setReimburser((PersonInfo)this.prmtReimburser.getData());
            chequeInfo.getApplyRec().setApplyCompany((CompanyOrgUnitInfo)this.prmtApplyCompany.getValue());
        } else if (this.editData.getState() == ChequeStatusEnum.WRITTEN_OFF) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)this.getUIContext().get("ID"))));
            ChequeInfo tempInfo = (ChequeInfo)ChequeFactory.getRemoteInstance().getValue((IObjectPK)pk);
            chequeInfo.setApplyRec(tempInfo.getApplyRec());
        }
        chequeInfo.setWriteOffEdit(true);
        iCheque.writeOff(chequeInfo);
        this.editData.setState(ChequeStatusEnum.WRITTEN_OFF);
    }

    private SupplierInfo getSupplier(Object objCust) {
        if (objCust instanceof SupplierInfo) {
            return (SupplierInfo)objCust;
        }
        return null;
    }

    private IKDComponent[] getApplyEnabledComps() {
        return new IKDComponent[]{this.chkIsMe, this.pkIssueDate, this.pkExpiredDate, this.txtUsage, this.txtDescription, this.f7OppAccountView};
    }

    private IKDComponent[] getReimburseEnabledComps() {
        return new IKDComponent[]{this.chkIsMe, this.pkIssueDate, this.pkExpiredDate, this.txtUsage, this.txtDescription, this.f7OppAccountView};
    }

    private AccountPromptBox getOppAcctSelector(CompanyOrgUnitInfo applyCompany, String currencyId, boolean isMe, boolean isCash) throws EASBizException, BOSException {
        EntityViewInfo oppAcctEV = ChequeUtil.getOppAcctEV(applyCompany, currencyId, isMe, isCash, false);
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, applyCompany, oppAcctEV.getFilter(), false, true);
        return acctPromptBox;
    }

    private void setOppAccountView(KDBizPromptBox F7) throws EASBizException, BOSException {
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        CompanyOrgUnitInfo applyCompany = ChequeUtil.getRightCompany(this.prmtApplyCompany);
        boolean isCash = ((NTTypeInfo)this.prmtNtType.getData()).isIsCash();
        boolean isMe = this.chkIsMe.isSelected();
        AccountPromptBox account = this.getOppAcctSelector(applyCompany, info.getId().toString(), isMe, isCash);
        F7.setSelector((KDPromptSelector)account);
        F7.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        F7.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo oppAcctEV = ChequeUtil.getOppAcctEV(applyCompany, info.getId().toString(), isMe, isCash, true);
        F7.setEntityViewInfo(oppAcctEV);
        F7.setCommitFormat("$number$");
        F7.setDisplayFormat("$number$ $name$");
        F7.setEditFormat("$number$");
    }

    private void setEnabledComps(ChequeInfo chequeInfo) {
        boolean EditNotRemburse;
        boolean bl = EditNotRemburse = this.getUIContext().get("EDIT") != null;
        if (this.getOprtState().equals(OprtState.EDIT) && EditNotRemburse) {
            if (chequeInfo.getState().equals((Object)ChequeStatusEnum.APPLIED)) {
                ChequeUtil.setComponentEnable((JComponent)((Object)this), false);
                FMClientHelper.setCompEnable((IKDComponent[])this.getApplyEnabledComps(), (boolean)true);
            } else if (chequeInfo.getState().equals((Object)ChequeStatusEnum.WRITTEN_OFF)) {
                ChequeUtil.setComponentEnable((JComponent)((Object)this), false);
                FMClientHelper.setCompEnable((IKDComponent[])this.getReimburseEnabledComps(), (boolean)true);
            }
            if (chequeInfo.getNtType().isIsCash()) {
                this.txtPayeeName.setEnabled(false);
            }
        } else if (chequeInfo.getState().equals((Object)ChequeStatusEnum.APPLIED)) {
            IKDComponent[] applyComps = new IKDComponent[]{this.pkApplyDate, this.txtCeiling};
            FMClientHelper.setCompEnable((IKDComponent[])applyComps, (boolean)false);
            if (!chequeInfo.isIsQuota()) {
                this.txtAmount.setEnabled(false);
            }
        }
    }

    @Override
    protected void prmtactualBankAcct_willCommit(CommitEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    @Override
    protected void prmtactualBankAcct_willShow(SelectorEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    private void initPrmtActualBankAcct() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.editData.getKeepCompany().getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtactualBankAcct.setEntityViewInfo(evi);
        Object currencyInfo = this.comboCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtactualBankAcct.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        this.prmtactualBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtactualBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            AccountBankInfo accout = (AccountBankInfo)this.prmtBankAcct.getData();
            if (accout != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
                this.prmtApplyCompany.setValue((Object)company);
            } else {
                this.prmtApplyCompany.setValue(null);
            }
        } else {
            this.prmtApplyCompany.setValue((Object)this.editData.getKeepCompany());
        }
    }

    @Override
    protected void txtPayeeAcctNumber_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyBankInfo bankInfo;
        Object o = this.txtPayeeAcctNumber.getData();
        if (o instanceof SupplierCompanyBankInfo && (bankInfo = (SupplierCompanyBankInfo)o) != null) {
            this.txtPayeeAcctBank.setText(bankInfo.getBank());
        }
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)this.editData.getIssueDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

