/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterParamBase;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ChequeFilterParam
extends FMFilterParamBase {
    private static final long serialVersionUID = -8739466305556319934L;
    FilterInfo treeFilter;
    private Date starttime;
    private Date endtime;
    private Set bankids;
    private boolean isByIssueDate;
    private String batch;
    private Set nttypeSet = new HashSet();
    private int statues1;
    private Set typeIds;
    boolean viewMyNote = false;
    boolean containVCCheque = true;

    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public FilterInfo getFilter() {
        PersonInfo person;
        CompanyOrgUnitInfo companyif;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo filterCompany = new FilterInfo();
        if (!FMHelper.isEmpty((String)this.getBatch())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("batch", (Object)this.getBatch(), CompareType.EQUALS));
            return filterInfo;
        }
        if (this.isByIssueDate) {
            filterInfo.getFilterItems().add(new FilterItemInfo("issueDate", (Object)DateTimeUtils.truncateDate((Date)this.starttime), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("issueDate", (Object)DateTimeUtils.truncateDate((Date)this.endtime), CompareType.LESS_EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("purDate", (Object)DateTimeUtils.truncateDate((Date)this.starttime), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("purDate", (Object)DateTimeUtils.truncateDate((Date)this.endtime), CompareType.LESS_EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("ntType.group", (Object)this.nttypeSet, CompareType.INCLUDE));
        if (!FMHelper.isEmpty((Collection)this.getBankids())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.getBankids(), CompareType.INCLUDE));
        }
        if (!this.isContainVCCheque()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isVC", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        if (!FMHelper.isEmpty((Collection)this.getTypeIds())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)this.getTypeIds(), CompareType.INCLUDE));
        }
        if (this.getStatues() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(this.statues1)));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)(companyif = SysContext.getSysContext().getCurrentFIUnit())) && !FMHelper.isEmpty((Collection)this.getCompanyIdSet())) {
            filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (FMHelper.isEmpty((Collection)this.getCompanyIdSet())) {
            filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyif.getId().toString(), CompareType.EQUALS));
        }
        if (!FMHelper.isEmpty((Collection)this.getCompanyIdSet())) {
            filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
            filterCompany.getFilterItems().add(new FilterItemInfo("keepCompany.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
            filterCompany.getFilterItems().add(new FilterItemInfo("applyRec.applyCompany.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
            filterCompany.setMaskString("(#0 or #1 or #2)");
        }
        if (this.viewMyNote && (person = ContextHelperFactory.getRemoteInstance().getCurrentUser().getPerson()) != null && this.isKeeperIn(person.getId().toString())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)person.getId().toString()));
        }
        if (filterCompany != null) {
            try {
                filterInfo.mergeFilter(filterCompany, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return this.mergeFilter(filterInfo, this.getTreeFilter());
    }

    private boolean isKeeperIn(String personId) {
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)("select fid from t_nt_cheque  where fkeeperid='" + personId + "'")).executeSQL();
            return rs.next();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection selectcollection = new SorterItemCollection();
        selectcollection.add(new SorterItemInfo("Batch"));
        selectcollection.add(new SorterItemInfo("number"));
        return selectcollection;
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Date endtime) {
        this.endtime = endtime;
    }

    public Set getTypeIds() {
        return this.typeIds;
    }

    public void setTypeIds(Set NTTypeIds) {
        this.typeIds = NTTypeIds;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date starttime) {
        this.starttime = starttime;
    }

    public Set getBankids() {
        return this.bankids;
    }

    public void setBankids(Set bankids) {
        this.bankids = bankids;
    }

    public boolean isByIssueDate() {
        return this.isByIssueDate;
    }

    public void setByIssueDate(boolean isByIssueDate) {
        this.isByIssueDate = isByIssueDate;
    }

    public void setContainVCCheque(boolean containVCCheque) {
        this.containVCCheque = containVCCheque;
    }

    public boolean isContainVCCheque() {
        return this.containVCCheque;
    }

    public ChequeStatusEnum getStatues() {
        return ChequeStatusEnum.getEnum(this.statues1);
    }

    public void setStatues(ChequeStatusEnum statues) {
        this.statues1 = statues != null ? statues.getValue() : -1;
    }

    public ChequeFilterParam() {
        this.nttypeSet.add(new Integer(1));
        this.nttypeSet.add(new Integer(11));
        this.viewMyNote = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT004", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
    }

    public ChequeFilterParam(boolean viewMyNote) {
        this.nttypeSet.add(new Integer(1));
        this.nttypeSet.add(new Integer(11));
        this.viewMyNote = viewMyNote;
    }

    public FilterInfo getTreeFilter() {
        return this.treeFilter;
    }

    public void setTreeFilter(FilterInfo filter) {
        this.treeFilter = filter;
    }

    public FilterInfo mergeFilter(FilterInfo filter1, FilterInfo filter2) {
        if (filter2 == null || filter2.getFilterItems().size() == 0) {
            return filter1;
        }
        try {
            filter1.mergeFilter(filter2, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter1;
    }
}

