/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.client.AbstractChequeFilterUI;
import com.kingdee.eas.fm.nt.client.ChequeFilterParam;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class ChequeFilterUI
extends AbstractChequeFilterUI {
    private boolean viewMyNote = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT004", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void init() throws Exception {
        super.init();
        this.starttime.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.endtime.setValue((Object)DateUtil.getEndDayOfCurMonth());
        this.starttime.setSupportedEmpty(false);
        this.endtime.setSupportedEmpty(false);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("group", (Object)new Integer(11), CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ChequeUtil.initPrmtNttype(this.prmtNTType);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.f7Bank);
        DefaultComboBoxModel<ChequeStatusEnum> ntdmode = new DefaultComboBoxModel<ChequeStatusEnum>();
        List nttypelist = ChequeStatusEnum.getEnumList();
        for (ChequeStatusEnum ntEnum : nttypelist) {
            ntdmode.addElement(ntEnum);
        }
        ntdmode.addElement((ChequeStatusEnum)FMSysDefinedEnum.SELECT_ALL);
        this.cboState.setModel(ntdmode);
        this.cboState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public void clear() {
        super.clear();
        this.starttime.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.endtime.setValue((Object)DateUtil.getEndDayOfCurMonth());
        this.cboState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.rbtByPurDate.setSelected(true);
        this.rbtByIssueDate.setSelected(false);
        this.cbContainVCCheque.setSelected(true);
        this.f7Bank.setValue(null);
        this.prmtNTType.setValue(null);
        try {
            super.init();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected Class getParamClass() {
        return ChequeFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public Object getParam() {
        ChequeFilterParam chequeFilter = new ChequeFilterParam(this.viewMyNote);
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            chequeFilter.setCompanyIdSet(this.getCompanyIdSet());
        }
        chequeFilter.setStarttime((java.util.Date)this.starttime.getValue());
        chequeFilter.setEndtime((java.util.Date)this.endtime.getValue());
        chequeFilter.setContainVCCheque(this.cbContainVCCheque.isSelected());
        if (this.prmtNTType.getData() != null && !FMHelper.isEmpty((Object[])((Object[])this.prmtNTType.getData()))) {
            chequeFilter.setTypeIds(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtNTType)));
        }
        if (this.rbtByIssueDate.isSelected()) {
            chequeFilter.setByIssueDate(true);
        }
        chequeFilter.setBankids(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.f7Bank)));
        if (this.cboState.getSelectedItem() != null) {
            if (this.cboState.getSelectedItem() instanceof ChequeStatusEnum) {
                chequeFilter.setStatues((ChequeStatusEnum)((Object)this.cboState.getSelectedItem()));
            } else {
                chequeFilter.setStatues(null);
            }
        }
        return chequeFilter;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        ChequeFilterParam ChequeFilter = (ChequeFilterParam)((Object)param);
        this.setCompanyIdSet(ChequeFilter.getCompanyIdSet());
        try {
            this.f7Bank.setData((Object)this.getBaseInfoFromIdSet(ChequeFilter.getBankids()));
            this.prmtNTType.setData((Object)this.getBaseInfoFromIdSet(ChequeFilter.getTypeIds()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.rbtByIssueDate.setSelected(ChequeFilter.isByIssueDate());
        this.rbtByPurDate.setSelected(!ChequeFilter.isByIssueDate());
        this.starttime.setValue((Object)ChequeFilter.getStarttime());
        this.endtime.setValue((Object)ChequeFilter.getEndtime());
        this.cbContainVCCheque.setSelected(ChequeFilter.isContainVCCheque());
        ChequeStatusEnum s = ChequeFilter.getStatues();
        if (s == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboState, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboState, (Object)((Object)s));
        }
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.starttime);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.endtime);
        Date dateFrom = this.starttime.getSqlDate();
        Date dateTo = this.endtime.getSqlDate();
        if (dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"EndTimeBiggerThanStartTime"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

