/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFacadeFactory;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeHelper;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractChequeListUI;
import com.kingdee.eas.fm.nt.client.ChequeApplyUI;
import com.kingdee.eas.fm.nt.client.ChequeBookInUI;
import com.kingdee.eas.fm.nt.client.ChequeEditUI;
import com.kingdee.eas.fm.nt.client.ChequeFilterParam;
import com.kingdee.eas.fm.nt.client.ChequeFilterUI;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.ChequeVCChooseUI;
import com.kingdee.eas.fm.nt.client.ChequeWriteOffUI;
import com.kingdee.eas.fm.nt.client.DistributeUI;
import com.kingdee.eas.fm.nt.client.TeleOrderApplyUI;
import com.kingdee.eas.fm.nt.client.util.ChequeCollEqulsVerifier;
import com.kingdee.eas.fm.nt.client.util.ChequeListHandler;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.MyVOComparator;
import com.kingdee.eas.fm.nt.client.util.ResultInfomation;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ChequeListUI
extends AbstractChequeListUI {
    private static final Logger logger = CoreUIObject.getLogger(ChequeListUI.class);
    private final CompanyOrgUnitInfo curCompany;
    private final UserInfo curUser;
    private final PersonInfo curPerson;
    private final int bookByBill;
    private final boolean bySettleNumber;
    private final boolean operateAll;
    private final boolean isTreeView;
    private final boolean viewAll;
    private final boolean needAudit;
    private final boolean isCompanyFilter;
    private final ChequeListHandler handler;
    private ChequeFilterUI filterUI = null;

    public ChequeListUI() throws Exception {
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        this.curCompany = contextHelper.getCurrentCompany();
        this.curUser = contextHelper.getCurrentUser();
        this.curPerson = this.curUser.getPerson();
        HashMap map = ChequeFacadeFactory.getRemoteInstance().getChequeParam((IObjectValue)this.curCompany);
        this.bookByBill = (Integer)map.get("bookByBill");
        this.bySettleNumber = (Boolean)map.get("bySettleNumber");
        this.isTreeView = (Boolean)map.get("isTreeView");
        this.viewAll = (Boolean)map.get("viewMyOwn") == false;
        this.needAudit = (Boolean)map.get("needAudit");
        this.isCompanyFilter = (Boolean)map.get("isCompanyFilter");
        boolean oprtMyOwn = (Boolean)map.get("oprtMyOwn");
        this.operateAll = !oprtMyOwn && this.curPerson != null;
        this.handler = new ChequeListHandler(this.isTreeView, this.operateAll);
        this.tblMain.addKDTDataFillListener((KDTDataFillListener)new FillListener());
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bankAcct.id"));
        sic.add(new SelectorItemInfo("bankAcct.name"));
        sic.add(new SelectorItemInfo("bankAcct.number"));
        sic.add(new SelectorItemInfo("bankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("bankAcct.account"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("applyRec.*"));
        sic.add(new SelectorItemInfo("journal.*"));
        sic.add(new SelectorItemInfo("keepDepartment.id"));
        sic.add(new SelectorItemInfo("keepDepartment.name"));
        sic.add(new SelectorItemInfo("keeper.id"));
        sic.add(new SelectorItemInfo("keeper.name"));
        sic.add(new SelectorItemInfo("settleType.id"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("turnInAcctBank.*"));
        sic.add(new SelectorItemInfo("oppAccount.*"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("projectManager.id"));
        sic.add(new SelectorItemInfo("projectManager.name"));
        sic.add(new SelectorItemInfo("signer.id"));
        sic.add(new SelectorItemInfo("signer.name"));
        sic.add(new SelectorItemInfo("feeTypeID.id"));
        sic.add(new SelectorItemInfo("feeTypeID.name"));
        sic.add(new SelectorItemInfo("actualBankAcct.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.name"));
        sic.add(new SelectorItemInfo("actualBankAcct.number"));
        sic.add(new SelectorItemInfo("actualBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("actualBankAcct.account"));
        sic.add(new SelectorItemInfo("actualBankAcct.account.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.account.number"));
        sic.add(new SelectorItemInfo("actualBankAcct.account.name"));
        sic.add("bankAcct.account.id");
        sic.add("bankAcct.account.number");
        sic.add("bankAcct.account.name");
        return sic;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ChequeFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initActionStatus();
        if (this.isTreeView) {
            this.treeBank.setModel(this.handler.getTree(this.mainQuery));
            FMClientHelper.goLeaf((KDTree)this.treeBank);
            this.treeBank.setCollapsePathDisabled(false);
            this.treeBank.setRootVisible(false);
            this.treeBank.setShowsRootHandles(true);
        }
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FilterParam filterParam = (FilterParam)this.getUIContext().get("param");
        if (filterParam != null) {
            param = filterParam;
            super.executeQuery(param);
            return;
        }
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)this.treeBank.getLastSelectedPathComponent();
        if (selectedNode == null) {
            super.executeQuery(param);
            return;
        }
        FilterInfo filterInfo = this.handler.buildFilter(selectedNode.getUserObject(), this.treeBank);
        ChequeFilterParam chequeParam = (ChequeFilterParam)param;
        chequeParam.setTreeFilter(filterInfo);
        super.executeQuery((FilterParam)chequeParam);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddBatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_particular"));
        this.actionApply.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.actionAntiApply.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        this.actionReimburse.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.actionAntiReimburse.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.actionWriteOff.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_attributeset"));
        this.actionVC.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.actionAntiVC.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.actionAbandon.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_blankout"));
        this.actionAntiAbandon.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fblankout"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionUnionSearch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.actionDistribute.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_distribute"));
        this.actionAntiDistribute.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionCancelAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnApplyGroup.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnApplyGroup.addAssistMenuItem((Action)((Object)this.actionApply));
        this.btnApplyGroup.addAssistMenuItem((Action)((Object)this.actionTeleApply));
        this.toolBar.remove((Component)this.btnAttachment);
    }

    protected void execQuery() {
        String targetBillType;
        Map botpCtx;
        if (this.getBOTPViewStatus() == 1 && (botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER")) != null && (targetBillType = (String)botpCtx.get("TargetBillType")) != null && targetBillType.equals("PaymentBill")) {
            FilterInfo btpFilter = ((EntityViewInfo)this.getUIContext().get("BOTPFilter")).getFilter();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAcct.company.id", (Object)this.curCompany.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("actualBankAcct.company.id", (Object)this.curCompany.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("applyRec.id", null, CompareType.EMPTY));
            filter.getFilterItems().add(new FilterItemInfo("applyRec.applyCompany.id", (Object)this.curCompany.getId(), CompareType.EQUALS));
            filter.setMaskString("(#0 or #1) and (#2 or #3)");
            try {
                btpFilter.mergeFilter(filter, "and");
                this.mainQuery.getFilter().mergeFilter(btpFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!this.viewAll) {
            FilterInfo filter = new FilterInfo();
            if (this.curUser.getPerson() == null) {
                filter.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)this.curUser.getId(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)this.curPerson.getId(), CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("keeper.id", null, CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
            FilterInfo filterInfo = this.mainQuery.getFilter();
            if (filterInfo != null) {
                try {
                    filterInfo.mergeFilter(filter, "AND");
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            } else {
                this.mainQuery.setFilter(filter);
            }
        }
        super.execQuery();
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.isTreeView) {
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeBank.getLastSelectedPathComponent();
            if (treeNode != null) {
                this.treeBank.setSelectionNode(treeNode);
                this.executeQuery(this.getFilterParam());
            }
        } else {
            super.refresh(e);
        }
    }

    @Override
    protected String getEditUIName() {
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ntType.*");
        ChequeInfo chequeinfo = new ChequeInfo();
        try {
            chequeinfo = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, sic);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (chequeinfo.getNtType().getGroup() == NTTypeGroupEnum.CHEQUE) {
            return ChequeApplyUI.class.getName();
        }
        return TeleOrderApplyUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> selectIdList = new ArrayList<String>();
        selectIdList.add(this.getSelectedKeyValue());
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(selectIdList);
        this.handler.checkKeeper(cqCollection);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"CHEQUEIDS", selectIdList);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        ChequeInfo cheque = cqCollection.get(0);
        uiWindow = cheque.getNtType().getGroup().equals((Object)NTTypeGroupEnum.CHEQUE) ? UIFactory.createUIFactory((String)this.getEditUIModal()).create(ChequeApplyUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(TeleOrderApplyUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        this.isDoRefresh(uiWindow);
        uiWindow.show();
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ChequeInfo chequeInfo = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk);
        this.handler.checkKeeper((PersonInfo)chequeInfo.get("keeper"));
        if (chequeInfo.getPaymentBillNum() != null) {
            throw new NTException(NTException.HASLINKBILL);
        }
        if (chequeInfo.isFiVouchered()) {
            throw new NTException(NTException.CHEQUEISFIVOUCHERED);
        }
        if (chequeInfo.isIsVC()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"204_ChequeListUI"));
            SysUtil.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    @Override
    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBatch_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ChequeBookInUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        this.isDoRefresh(uiWindow);
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("keepCompany.id");
        select.add("applyRec.applyCompany.id");
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ChequeInfo chequeInfo = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        this.checkHasLinkBill(chequeInfo);
        this.handler.checkKeeper(chequeInfo.getKeeper());
        if (!ChequeUtil.checkCurCompanyIsValid(chequeInfo)) {
            throw new NTException(NTException.NOT_CURRENT_COMPANY_CQ);
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"DeleteTotalCheque")) == 0) {
            MutexUtils.setMutex((CoreUI)this, (String)this.getSelectedKeyValue());
            try {
                ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue(" select id, batch where id = '" + this.tblMain.getRow(selectRow).getCell("id").getValue() + "'");
                IObjectPK[] arrayPK = this.getBizInterface().getPKList(" select id where batch ='" + info.getBatch() + "'");
                this.getBizInterface().delete(arrayPK);
                this.pubFireVOChangeListener(this.getSelectedKeyValue());
            }
            catch (ObjectNotFoundException onfe) {
                logger.error((Object)onfe.getMessage(), (Throwable)onfe);
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            catch (Throwable e1) {
                logger.error((Object)e1.getMessage(), e1);
                this.handUIException(e1);
                this.abort();
            }
            finally {
                MutexUtils.releaseMutex((String)this.getSelectedKeyValue());
            }
        } else {
            return;
        }
        this.refresh(e);
        String strDeleteSuccessfully = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"cm44");
        MsgBox.showInfo((Component)((Object)this), (String)strDeleteSuccessfully);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.tblMain.getPrintManager().setExpandedOnly(false);
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.tblMain.getPrintManager().setExpandedOnly(false);
        int count = this.tblMain.getRowCount();
        if (count == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"nummsg"));
            return;
        }
        super.actionTDPrint_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.tblMain.getPrintManager().setExpandedOnly(false);
        int count = this.tblMain.getRowCount();
        if (count == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"nummsg"));
            return;
        }
        super.actionTDPrintPreview_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionAntiApply_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ICheque iCheque = (ICheque)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk);
        this.checkHasLinkBill(info);
        this.handler.checkKeeper(info.getKeeper());
        if (!ChequeUtil.checkCurCompanyIsValid(info)) {
            MutexUtils.releaseMutex((List)this.getSelectedIdValues());
            throw new NTException(NTException.NOT_CURRENT_COMPANY_CQ);
        }
        if (info.getState() != ChequeStatusEnum.APPLIED && info.getState() != ChequeStatusEnum.APPLYING) {
            MutexUtils.releaseMutex((List)this.getSelectedIdValues());
            throw new NTException(NTException.SELECT_APPLIED_CQ);
        }
        if (info.getPaymentBillNum() != null) {
            MutexUtils.releaseMutex((List)this.getSelectedIdValues());
            throw new NTException(NTException.REFTOPMTCANTDO);
        }
        if (info.isIsAudit()) {
            MutexUtils.releaseMutex((List)this.getSelectedIdValues());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"205_ChequeListUI"));
            SysUtil.abort();
        }
        iCheque.antiApply(info);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"ChequeAntiApplySuccess"));
        this.showMessage();
        this.refresh(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionApply_actionPerformed(ActionEvent e) throws Exception {
        ChequeInfo cheque;
        this.checkSelected();
        ArrayList selectIdList = this.getSelectedIdValues();
        ChequeCollection chqColl = ChequeUtil.getChequeCollection(selectIdList);
        ResultInfomation result = ChequeUtil.checkChequeApplyValid(chqColl);
        if (!result.isEqual()) {
            MsgBox.showInfo((String)result.getResult());
            SysUtil.abort();
        }
        this.handler.checkKeeper(chqColl);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"CHEQUEIDS", (Object)selectIdList);
        uiContext.put((Object)"NT028", (Object)this.isCompanyFilter);
        uiContext.put((Object)"NT029", (Object)this.needAudit);
        IUIWindow uiWindow = null;
        if (this.getApplyUIName().equals(TeleOrderApplyUI.class.getName())) {
            uiContext.put((Object)"ID", null);
            uiContext.put((Object)"CHEQUEIDS", null);
        }
        boolean isCheque = (cheque = chqColl.get(0)).getNtType().getGroup() == NTTypeGroupEnum.CHEQUE;
        boolean isApplied = cheque.getState().equals((Object)ChequeStatusEnum.APPLIED);
        if (isApplied && isCheque) {
            if (cheque.isIsQuota()) throw new NTException(NTException.SELECT_BLANK_CHEQUE);
            uiContext.put((Object)"EDIT", (Object)Constants.TRUE);
            this.prepareUIContext(uiContext, e);
            uiContext.put((Object)"ID", (Object)chqColl.get(0).getId().toString());
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ChequeApplyUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        } else if (isApplied && !isCheque) {
            this.prepareUIContext(uiContext, e);
            uiContext.put((Object)"ID", (Object)chqColl.get(0).getId().toString());
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TeleOrderApplyUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        } else {
            this.prepareUIContext(uiContext, e);
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ChequeApplyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        }
        this.isDoRefresh(uiWindow);
        uiWindow.show();
    }

    @Override
    public void actionReimburse_actionPerformed(ActionEvent e) throws Exception {
        IContextHelper iCtxHelper;
        String recBillStatus;
        super.actionReimburse_actionPerformed(e);
        this.checkSelected();
        ArrayList selectIdList = this.getSelectedIdValues();
        ChequeCollection chqColl = ChequeUtil.getChequeCollection(selectIdList);
        this.handler.checkKeeper(chqColl);
        ResultInfomation result = ChequeUtil.checkChequeWriteOffValid(chqColl);
        if (!result.isEqual()) {
            MsgBox.showInfo((String)result.getResult());
            SysUtil.abort();
        }
        if ((recBillStatus = (iCtxHelper = ContextHelperFactory.getRemoteInstance()).getStringParam("NT050", null)) != null && recBillStatus.equals("true")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"isBillDestroy"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"CHEQUEIDS", (Object)selectIdList);
        uiContext.put((Object)"NT028", (Object)this.isCompanyFilter);
        uiContext.put((Object)"NT029", (Object)this.needAudit);
        IUIWindow uiWindow = null;
        if (chqColl.size() == 1) {
            boolean isReimburse;
            ChequeInfo info = chqColl.get(0);
            if (this.needAudit && ChequeStatusEnum.APPLIED.equals((Object)info.getState()) && !info.isIsAudit()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"206_ChequeListUI"));
                this.abort();
            }
            if (isReimburse = info.getState().equals((Object)ChequeStatusEnum.WRITTEN_OFF)) {
                uiContext.put((Object)"EDIT", (Object)Constants.TRUE);
            }
            this.prepareUIContext(uiContext, e);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ChequeEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        } else {
            if (this.needAudit) {
                int l = chqColl.size();
                for (int i = 0; i < l; ++i) {
                    ChequeInfo info = chqColl.get(i);
                    if (!ChequeStatusEnum.APPLIED.equals((Object)info.getState()) || info.isIsAudit()) continue;
                    String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"207_ChequeListUI");
                    msg = MessageFormat.format(msg, info.getNumber());
                    MsgBox.showInfo((String)msg);
                    this.abort();
                }
            }
            this.prepareUIContext(uiContext, e);
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ChequeWriteOffUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        }
        this.isDoRefresh(uiWindow);
        uiWindow.show();
    }

    @Override
    public void actionAntiReimburse_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiReimburse_actionPerformed(e);
        this.checkSelected();
        ArrayList selectIdList = this.getSelectedIdValues();
        ChequeCollection chqColl = ChequeUtil.getChequeCollection(selectIdList);
        this.handler.checkKeeper(chqColl);
        this.handler.checkCanAntiReimburse(chqColl);
        HashSet set = new HashSet(selectIdList);
        ChequeFactory.getRemoteInstance().antiReimburse(set);
        this.refresh(e);
    }

    @Override
    public void actionTeleApply_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectIdList = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(selectIdList);
        this.handler.checkKeeper(cqCollection);
        ChequeInfo info = cqCollection.get(0);
        NTTypeInfo nt = info.getNtType();
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && info.getPaymentBillNum() != null) {
            throw new NTException(NTException.REFTOPMTCANTDO);
        }
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && info.getJournal() != null) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"209_ChequeListUI")});
        }
        if (nt != null && nt.getGroup().equals((Object)NTTypeGroupEnum.TELE_ORDER) && info.isIsVC()) {
            throw new NTException(NTException.CHEQUEISVC);
        }
        if (info.getState() == ChequeStatusEnum.APPLIED && !info.isFiVouchered()) {
            if (this.getApplyUIName().equals(ChequeApplyUI.class.getName())) {
                uiContext.put((Object)"ID", null);
                uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TeleOrderApplyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            } else {
                uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TeleOrderApplyUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            }
        } else {
            ResultInfomation result = ChequeUtil.checkChequeApplyValid(cqCollection);
            if (!result.isEqual()) {
                MsgBox.showInfo((String)result.getResult());
                SysUtil.abort();
            }
            if (this.getApplyUIName().equals(ChequeApplyUI.class.getName())) {
                uiContext.put((Object)"ID", null);
            }
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TeleOrderApplyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        }
        this.isDoRefresh(uiWindow);
        uiWindow.show();
    }

    @Override
    public void actionUnionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionSearch_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, this.getSelectors());
        if ("NE9M9QEREADgAAhvwKgSFRyakBM=".equals(info.getNtType().getId().toString())) {
            if (info.getCashier() == null || "".equals(info.getCashier())) {
                throw new NTException(NTException.NOTBOOK);
            }
        } else if (!info.isIsVC()) {
            throw new NTException(NTException.NOTJOURNALEXIST);
        }
        if (info.getJournal() == null || info.getJournal().getId() == null) {
            throw new NTException(NTException.NOTJOURNALEXIST);
        }
        if (!JournalFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(info.getJournal().getId()))) {
            this.refreshList();
            throw new NTException(NTException.JOURNAL_CHANGED);
        }
        FMClientHelper.viewJournal((CoreUIObject)this, (String)info.getJournal().getId().toString(), (CompanyOrgUnitInfo)this.curCompany);
    }

    @Override
    public void actionVC_actionPerformed(ActionEvent e) throws Exception {
        super.actionVC_actionPerformed(e);
        this.checkSelected();
        HashSet setFailure = new HashSet();
        ArrayList listSuccess = new ArrayList();
        ArrayList idList = this.getSelectedIdValues();
        HashMap filterMap = new HashMap();
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(idList);
        this.handler.checkKeeper(cqCollection);
        this.doVC(e, setFailure, listSuccess, idList, filterMap);
        if (filterMap.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"cheques", filterMap);
            uiContext.put((Object)"mapFailure", setFailure);
            uiContext.put((Object)"listSuccess", listSuccess);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChequeVCChooseUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else if (filterMap.size() == 0) {
            String info1 = MessageFormat.format(this.getString("VCSuccess"), listSuccess.size());
            StringBuffer info2 = new StringBuffer(128);
            Object[] ids = setFailure.toArray();
            if (ids.length > 0) {
                info2.append(this.getString("NotVCCheque") + "\n");
            }
            for (int i = 0; i < ids.length; ++i) {
                Map mapFailure = (Map)ids[i];
                String number = (String)mapFailure.keySet().iterator().next();
                info2.append(this.getString("ntType") + ":  " + mapFailure.get(number) + "     " + this.getString("number") + number + ";\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)info1.toString(), (String)info2.toString(), (int)1);
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiVC_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiVC_actionPerformed(e);
        this.checkSelected();
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            return;
        }
        ArrayList idList = this.getSelectedIdValues();
        HashMap<String, String> mapFailure = new HashMap<String, String>();
        ArrayList<String> listSuccess = new ArrayList<String>();
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(idList);
        this.handler.checkKeeper(cqCollection);
        Iterator iterator = idList.iterator();
        while (iterator.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iterator.next().toString()));
            SelectorItemCollection select = new SelectorItemCollection();
            select.add("*");
            select.add("journal.*");
            select.add("ntType.*");
            select.add("keepCompany.id");
            select.add("applyRec.applyCompany.id");
            select.add("applyRec.applyCompany.name");
            ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
            if (idList.size() == 1) {
                if (!ChequeUtil.checkCurCompanyIsValid(info)) {
                    throw new NTException(NTException.NOT_CURRENT_COMPANY_CQ);
                }
                if (!info.isIsVC()) {
                    throw new NTException(NTException.SELECT_VC_CQ);
                }
                if (info.getJournal().getBillType() == BillTypeEnum.Cheque && info.getJournal().getBillId() != null) {
                    throw new NTException(NTException.NOTVCJOURNALBILLCHEQUE);
                }
                if (info.getJournal().isIsOnlineVCCheque()) {
                    throw new NTException(NTException.NOTANTIBYHAND);
                }
                if (info.getPaymentBillNum() != null) {
                    throw new NTException(NTException.REFTOPMTCANTDO);
                }
            } else {
                if (!ChequeUtil.checkCurCompanyIsValid(info)) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    continue;
                }
                if (!info.isIsVC()) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    continue;
                }
                if (info.getJournal().getBillType() == BillTypeEnum.Cheque && info.getJournal().getBillId() != null) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    continue;
                }
                if (info.getJournal().isIsOnlineVCCheque()) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    continue;
                }
                if (info.getPaymentBillNum() != null) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    continue;
                }
            }
            ((ICheque)this.getBizInterface()).antiVC(info.getId().toString());
            listSuccess.add(info.getNumber());
        }
        this.showMessage();
        StringBuffer info = new StringBuffer(128);
        info.append(this.getString("antiVCSuccess"));
        info.append(listSuccess.size());
        info.append(this.getString("piece"));
        info.append("\n");
        Object[] ids = mapFailure.keySet().toArray();
        if (ids.length > 0) {
            info.append(this.getString("NOT_anti_VC"));
            info.append("\n");
        }
        for (int i = 0; i < ids.length; ++i) {
            info.append(this.getString("ntType"));
            info.append(":  ");
            info.append(mapFailure.get(ids[i].toString()));
            info.append("    ");
            info.append(this.getString("number"));
            info.append(ids[i].toString());
            info.append(";\n");
        }
        MsgBox.showInfo((String)info.toString());
        this.refresh(e);
    }

    @Override
    public void actionAbandon_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setStatic(1);
        this.refresh(e);
    }

    @Override
    public void actionAntiAbandon_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setStatic(2);
        this.refresh(e);
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        String[] properties;
        MyVOComparator comparator;
        ChequeCollEqulsVerifier verifier;
        ResultInfomation result;
        super.actionDistribute_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"NT028", (Object)this.isCompanyFilter);
        uiContext.put((Object)"currentCompany", (Object)this.currentCompanyCommon);
        Object[] updateIds = this.getSelectedIdValues().toArray(new String[0]);
        if (FMHelper.isEmpty((Object[])updateIds)) {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DistributeUI.class.getName(), (Map)uiContext, null, "ADDNEW");
            uiWindow.show();
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("nttype.id");
        view.getSelector().add("bankacct.id");
        view.getSelector().add("bank.id");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])updateIds), CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("state", (Object)new Integer(0)));
        filterItems.add(new FilterItemInfo("isAbandon", (Object)Constants.FALSE));
        view.setFilter(filter);
        ChequeCollection coll = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        if (coll == null || coll.size() != updateIds.length) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"distributeCond"));
            SysUtil.abort();
        }
        if (!(result = (verifier = new ChequeCollEqulsVerifier(comparator = new MyVOComparator(properties = new String[]{"bank", "bankAcct", "ntType"}))).verifyEquals(coll)).isEqual()) {
            MsgBox.showInfo((String)result.getResult());
            SysUtil.abort();
        }
        uiContext.put((Object)"CHEQUEIDS", (Object)updateIds);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DistributeUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionAntiDistribute_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiDistribute_actionPerformed(e);
        ArrayList list = new ArrayList(this.getSelectedIdValues());
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(list);
        this.handler.checkKeeper(cqCollection);
        String[] updateIds = this.getSelectedIdValues().toArray(new String[0]);
        try {
            ChequeFactory.getRemoteInstance().cancelDistribute(FMHelper.asSet((String[])updateIds));
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"antiDistribute_Success"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionBatchAntiDistribute_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchAntiDistribute_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        ChequeInfo cheque = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(id));
        this.handler.checkKeeper(cheque.getKeeper());
        ChequeFactory.getRemoteInstance().batchCancelDistribute(id);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"antiDistribute_Success"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        ArrayList selectedKeyValues = new ArrayList(this.getSelectedIdValues());
        if (selectedKeyValues == null) {
            return;
        }
        HashSet ids = new HashSet(selectedKeyValues);
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(selectedKeyValues);
        this.handler.checkKeeper(cqCollection);
        ((ICheque)this.getBizInterface()).book(ids);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"ChequeBook_Success"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        ArrayList selectedKeyValues = this.getSelectedIdValues();
        if (selectedKeyValues == null) {
            return;
        }
        HashSet ids = new HashSet(selectedKeyValues);
        ChequeCollection cqCollection = ChequeUtil.getChequeCollection(selectedKeyValues);
        this.handler.checkKeeper(cqCollection);
        ((ICheque)this.getBizInterface()).cancelBook(ids);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"ChequeCancelBook_Success"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("ntType.*");
        select.add("bankAcct.company");
        select.add("actualBankAcct.company");
        ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        this.handler.checkKeeper(info.getKeeper());
        if (info.getPaymentBillNum() != null) {
            throw new NTException(NTException.HASLINKBILL);
        }
        if (info.isIsAbandon()) {
            throw new NTException(NTException.CHEQUEISABADON);
        }
        if (info.isFiVouchered()) {
            throw new NTException(NTException.CHEQUEISFIVOUCHERED);
        }
        if (info.getActualBankAcct() != null && info.getActualBankAcct().getCompany() != null ? !this.currentCompanyCommon.getId().equals((Object)info.getActualBankAcct().getCompany().getId()) : info.getBankAcct() != null && info.getBankAcct().getCompany() != null && !this.currentCompanyCommon.getId().equals((Object)info.getBankAcct().getCompany().getId())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"210_ChequeListUI")});
        }
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new ChequeInfo().getBOSType().toString(), (String)new PaymentBillInfo().getBOSType().toString(), (String)id);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        String per;
        super.actionAudit_actionPerformed(e);
        this.checkSelected();
        if (!this.needAudit) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        ICheque cheque = ChequeFactory.getRemoteInstance();
        ChequeInfo info = cheque.getChequeInfo((IObjectPK)pk);
        String string = per = this.curPerson != null ? this.curPerson.getId().toString() : null;
        if (this.curPerson == null || per == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"OPRTPERMIT"));
            SysUtil.abort();
        }
        if (!info.getState().equals((Object)ChequeStatusEnum.APPLIED) && !info.getState().equals((Object)ChequeStatusEnum.APPLYING) || info.isIsAudit()) {
            throw new NTException(NTException.CHEQUEAUDITERROR);
        }
        ObjectUuidPK auditorID = new ObjectUuidPK(per);
        cheque.audit((IObjectPK)pk, (IObjectPK)auditorID);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"211_ChequeListUI"));
        this.refreshList();
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAudit_actionPerformed(e);
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        ICheque cheque = ChequeFactory.getRemoteInstance();
        ChequeInfo info = cheque.getChequeInfo((IObjectPK)pk);
        if (!info.getState().equals((Object)ChequeStatusEnum.APPLIED) || !info.isIsAudit()) {
            throw new NTException(NTException.CHEQUECANCELAUDITERROR);
        }
        cheque.cancelAudit((IObjectPK)pk);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"212_ChequeListUI"));
        this.refreshList();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (!this.curCompany.isIsBizUnit()) {
            this.setBizActionState(false);
            return;
        }
        String selectedKeyValue = this.getSelectedKeyValue();
        if (selectedKeyValue == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ntType.*");
        sic.add("ntType.group.*");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)selectedKeyValue));
        ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, sic);
        this.actionDistribute.setEnabled(ChequeHelper.isCanDistribute(info));
        this.actionCreateTo.setEnabled(ChequeHelper.isCanCreateTo(info));
        this.actionBook.setEnabled(ChequeHelper.isCanRecord(info));
        this.actionCancelBook.setEnabled(ChequeHelper.isCanCancelRecord(info));
        this.actionReimburse.setEnabled(ChequeHelper.isCanWriteOff(info));
        this.actionAntiReimburse.setEnabled(ChequeHelper.isCanCancelWriteOff(info));
        this.actionAntiAbandon.setEnabled(ChequeHelper.isCanCancelAbandon(info));
        this.actionVC.setEnabled(ChequeHelper.isCanVC(info));
        this.actionAntiVC.setEnabled(NTTypeGroupEnum.CHEQUE.equals((Object)info.getNtType().getGroup()) && info.isIsVC());
        this.btnApply.setEnabled(ChequeHelper.isCanApply(info));
        this.menuItemApply.setEnabled(ChequeHelper.isCanApply(info));
        this.actionAudit.setEnabled(this.needAudit && (info.getState().equals((Object)ChequeStatusEnum.APPLIED) || info.getState().equals((Object)ChequeStatusEnum.APPLYING)) && !info.isIsAudit() && NTTypeGroupEnum.CHEQUE.equals((Object)info.getNtType().getGroup()));
        this.actionCancelAudit.setEnabled(info.isIsAudit() && NTTypeGroupEnum.CHEQUE.equals((Object)info.getNtType().getGroup()));
    }

    @Override
    protected void treeBank_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e == null) {
            return;
        }
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        this.refreshTableHead(e);
        FMFilterBaseUI filterUI = this.getFilterUI();
        FilterParam param = null;
        if (filterUI != null) {
            param = (FilterParam)filterUI.getParam();
        }
        this.executeQuery(param);
    }

    private void initActionStatus() {
        this.menuItemVoucher.setVisible(true);
        this.menuItemDelVoucher.setVisible(true);
        this.btnVoucher.setVisible(true);
        this.actionNextPerson.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionBook.setVisible(false);
        this.actionCancelBook.setVisible(false);
        if (this.bookByBill == 0 && this.curCompany.isIsBizUnit()) {
            this.actionBook.setVisible(true);
            this.actionCancelBook.setVisible(true);
        }
        if (!this.curCompany.isIsBizUnit()) {
            this.setBizActionState(false);
        }
    }

    private String getApplyUIName() {
        if (this.isTreeView) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeBank.getSelectionPath().getPathComponent(1);
            int group = Integer.parseInt(node.getUserObject().toString());
            if (group == 1) {
                return ChequeApplyUI.class.getName();
            }
            return TeleOrderApplyUI.class.getName();
        }
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ChequeInfo chequeinfo = new ChequeInfo();
        try {
            chequeinfo = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, this.getSelectors());
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (chequeinfo.getNtType().getGroup() == NTTypeGroupEnum.CHEQUE) {
            return ChequeApplyUI.class.getName();
        }
        return TeleOrderApplyUI.class.getName();
    }

    private void doVC(ActionEvent e, Set setFailure, ArrayList listSuccess, ArrayList idList, Map filterMap) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("journal.*");
        select.add("ntType.*");
        select.add("keepCompany.id");
        select.add("bankAcct.company.id");
        select.add("applyRec.applyCompany.id");
        select.add("applyRec.applyCompany.name");
        view.getSelector().addObjectCollection((IObjectCollection)select);
        ChequeCollection coll = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> mapFailure = new HashMap<String, String>();
            ChequeInfo info = (ChequeInfo)iterator.next();
            String id = info.getId().toString();
            String currentCompanyId = this.curCompany.getId().toString();
            String companyId = info.getCompany().getId().toString();
            String keepCompanyId = null;
            if (info.getKeepCompany() != null) {
                keepCompanyId = info.getKeepCompany().getId().toString();
            }
            String bankCompanyId = null;
            if (info.getBankAcct() != null && info.getBankAcct().getCompany() != null) {
                bankCompanyId = info.getBankAcct().getCompany().getId().toString();
            }
            if (idList.size() == 1) {
                if (!(currentCompanyId.equals(companyId) || currentCompanyId.equals(keepCompanyId) || currentCompanyId.equals(bankCompanyId))) {
                    throw new NTException(NTException.NOT_CURRENT_COMPANY_CQ);
                }
                if (info.getState() != ChequeStatusEnum.WRITTEN_OFF) {
                    throw new NTException(NTException.SELECT_WRITEOFF_CQ);
                }
                if (info.isIsAbandon()) {
                    throw new NTException(NTException.SELECT_WRITEOFF_CQ);
                }
                if (info.getNtType().getGroup() != NTTypeGroupEnum.CHEQUE) {
                    throw new NTException(NTException.SELECT_WRITEOFF_CQ);
                }
                if (info.getPaymentBillNum() != null) {
                    throw new NTException(NTException.REFTOPMTCANTDO);
                }
                if (info.isIsVC()) {
                    throw new NTException(NTException.CHEQUEISVC);
                }
                if (info.getJournal() != null) {
                    throw new NTException(NTException.CHEQUEISVC);
                }
                if (info.isFiVouchered()) {
                    throw new NTException(NTException.CHEQUEISFIVOUCHERED);
                }
            } else {
                if (info.isIsVC()) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    setFailure.add(mapFailure);
                    continue;
                }
                if (!(currentCompanyId.equals(companyId) || currentCompanyId.equals(keepCompanyId) || currentCompanyId.equals(bankCompanyId))) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    setFailure.add(mapFailure);
                    continue;
                }
                if (info.getState() != ChequeStatusEnum.WRITTEN_OFF) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    setFailure.add(mapFailure);
                    continue;
                }
                if (info.isIsAbandon()) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    setFailure.add(mapFailure);
                    continue;
                }
                if (info.getPaymentBillNum() != null) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    setFailure.add(mapFailure);
                    continue;
                }
                if (info.getJournal() != null) {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                    setFailure.add(mapFailure);
                    continue;
                }
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)info.getBankAcct().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)info.getAmount()));
            filterInfo.getFilterItems().add(new FilterItemInfo("ticketNumber", null));
            if (this.bySettleNumber) {
                IQueryExecutor query = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.JournalVCQuery"));
                EntityViewInfo view2 = new EntityViewInfo();
                view2.setFilter(filterInfo);
                query.setObjectView(view2);
                String sql = query.getSQL();
                StringBuffer sb = new StringBuffer(128);
                sb.append("select  id   from (");
                sb.append(sql);
                sb.append(") t ");
                sb.append(" where charindex(settlementNumber,'");
                sb.append(info.getNumber());
                sb.append("') >0");
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
            }
            view = new EntityViewInfo();
            view.setFilter(filterInfo);
            JournalCollection journalColl = JournalFactory.getRemoteInstance().getJournalCollection(view);
            if (journalColl.size() == 0) {
                mapFailure.put(info.getNumber(), info.getNtType().getName());
            } else if (journalColl.size() == 1) {
                JournalInfo jInfo = journalColl.get(0);
                if (jInfo != null) {
                    ((ICheque)this.getBizInterface()).vc(info.getId().toString(), jInfo);
                    listSuccess.add(info.getNumber());
                    this.refresh(e);
                } else {
                    mapFailure.put(info.getNumber(), info.getNtType().getName());
                }
            } else if (journalColl.size() > 1) {
                filterMap.put(id, filterInfo);
            }
            if (mapFailure.size() <= 0) continue;
            setFailure.add(mapFailure);
        }
    }

    private void setStatic(int number) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("applyRec.applyCompany.id");
        select.add("applyRec.applyCompany.name");
        ChequeInfo info = (ChequeInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        this.handler.checkKeeper(info.getKeeper());
        if (ChequeUtil.checkCurCompanyIsValid(info)) {
            ICheque icheque = ChequeFactory.getRemoteInstance();
            switch (number) {
                case 1: {
                    if (!info.getState().equals((Object)ChequeStatusEnum.Canceled)) {
                        boolean canExecute = true;
                        if (!EmptyUtil.isEmpty((String)info.getPaymentBillNum()) || info.isIsVC() || info.isFiVouchered()) {
                            int res = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"confirmAbandon"));
                            canExecute = res == 0;
                        }
                        if (canExecute) {
                            icheque.abandon((IObjectPK)new ObjectUuidPK(info.getId()), info);
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"chequefour"));
                            this.refreshList();
                        }
                        SysUtil.abort();
                        break;
                    }
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"chequetwo"));
                    SysUtil.abort();
                    break;
                }
                case 2: {
                    if (ChequeStatusEnum.Canceled.equals((Object)info.getState())) {
                        icheque.antiAbandon((IObjectPK)new ObjectUuidPK(info.getId()), info);
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"chequefive"));
                        break;
                    }
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"chequethree"));
                    SysUtil.abort();
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"chequeone"));
        }
    }

    private void refreshTableHead(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode oldNodeType;
        TreePath oldPath = e.getOldLeadSelectionPath();
        TreePath newPath = e.getNewLeadSelectionPath();
        if (newPath == null || oldPath == null) {
            this.handler.buildChequeHead(this.tblMain);
            return;
        }
        DefaultKingdeeTreeNode newNodeType = (DefaultKingdeeTreeNode)newPath.getPathComponent(1);
        if (newNodeType.equals(oldNodeType = (DefaultKingdeeTreeNode)oldPath.getPathComponent(1))) {
            return;
        }
        int nttype = Integer.parseInt(newNodeType.getUserObject().toString());
        this.handler.builderHeader(nttype, this.tblMain);
    }

    private void checkHasLinkBill(ChequeInfo info) throws Exception {
        if (!EmptyUtil.isEmpty((String)info.getPaymentBillNum())) {
            throw new NTException(NTException.HASLINKBILL);
        }
    }

    private String getString(String name) {
        return EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)name);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("applyRec.department.id"));
        sic.add(new SelectorItemInfo("applyRec.department.name"));
        sic.add(new SelectorItemInfo("applyRec.department.number"));
        sic.add(new SelectorItemInfo("applyRec.applicant.id"));
        sic.add(new SelectorItemInfo("applyRec.applicant.name"));
        sic.add(new SelectorItemInfo("applyRec.applicant.number"));
        sic.add(new SelectorItemInfo("applyRec.auditor.id"));
        sic.add(new SelectorItemInfo("applyRec.auditor.name"));
        sic.add(new SelectorItemInfo("applyRec.auditor.number"));
        sic.add(new SelectorItemInfo("applyRec.reimburser.id"));
        sic.add(new SelectorItemInfo("applyRec.reimburser.name"));
        sic.add(new SelectorItemInfo("applyRec.reimburser.number"));
        sic.add(new SelectorItemInfo("applyRec.creator.id"));
        sic.add(new SelectorItemInfo("applyRec.creator.name"));
        sic.add(new SelectorItemInfo("applyRec.creator.number"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.isCash"));
        sic.add(new SelectorItemInfo("turnInAcctBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("turnInAcctBank.id"));
        sic.add(new SelectorItemInfo("turnInAcctBank.number"));
        sic.add(new SelectorItemInfo("turnInAcctBank.name"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("applyRec.*"));
        sic.add(new SelectorItemInfo("settleType.*"));
        sic.add(new SelectorItemInfo("actualBankAcct.account.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.account.number"));
        sic.add(new SelectorItemInfo("actualBankAcct.account.name"));
        return sic;
    }

    @Override
    public void initUIContentLayout() {
        if (this.isTreeView) {
            this.setBounds(new Rectangle(10, 10, 1013, 600));
            this.setLayout((LayoutManager)new KDLayout());
            this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 600));
            this.kDSplitPane1.setBounds(new Rectangle(12, 14, 984, 573));
            this.add((Component)this.kDSplitPane1, new KDLayout.Constraints(12, 14, 984, 573, 15));
            this.kDSplitPane1.add((Component)this.tblMain, (Object)"right");
            this.kDSplitPane1.add((Component)this.treeViewBank, (Object)"left");
            this.treeViewBank.setTree(this.treeBank);
        } else {
            this.setBounds(new Rectangle(10, 10, 1013, 600));
            this.setLayout((LayoutManager)new KDLayout());
            this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 600));
            this.tblMain.setBounds(new Rectangle(10, 10, 993, 580));
            this.add((Component)this.tblMain, new KDLayout.Constraints(10, 10, 993, 580, 15));
            this.remove((Component)this.kDSplitPane1);
        }
    }

    private void setBizActionState(boolean state) {
        Action[] actions = new Action[]{this.actionBook, this.actionDistribute, this.actionAntiDistribute, this.actionBatchAntiDistribute, this.actionApply, this.actionAntiApply, this.actionTeleApply, this.actionWriteOff, this.actionReimburse, this.actionAntiReimburse, this.actionVC, this.actionAntiVC, this.actionAbandon, this.actionAntiAbandon, this.actionVoucher, this.actionDelVoucher, this.actionAddBatch, this.actionCreateTo, this.actionRemove};
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setEnabled(state);
        }
        this.btnApplyGroup.setEnabled(state);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "issueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionCancelAudit"};
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent arg0) {
            int count = ChequeListUI.this.tblMain.getRowCount3();
            for (int i = 0; i <= count; ++i) {
                this.formateLine(i);
            }
        }

        private void formateLine(int i) {
            IRow row = ChequeListUI.this.tblMain.getRow(i);
            if (row == null) {
                return;
            }
            String numberFmt = null;
            if (row != null && row.getCell("currency.id").getValue() != null) {
                String currencyId = (String)row.getCell("currency.id").getValue();
                numberFmt = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
                row.getCell("Amount").getStyleAttributes().setNumberFormat(numberFmt);
                row.getCell("ApplyRec.ceiling").getStyleAttributes().setNumberFormat(numberFmt);
                row.getCell("BankAcct").getStyleAttributes().setNumberFormat("@");
                row.getCell("payeeBankAccount").getStyleAttributes().setNumberFormat("@");
                row.getCell("IssueDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
                row.getCell("ExpiredDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            }
        }
    }
}

