/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.client.AbstractChequeSummaryFilterUI;
import com.kingdee.eas.fm.nt.client.ChequeSummaryFilterParam;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;

public class ChequeSummaryFilterUI
extends AbstractChequeSummaryFilterUI {
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkPurDateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkPurDateTo.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.prmtBank.setValue(null);
        this.prmtNttype.setValue(null);
        this.chkDispTotal.setSelected(false);
    }

    public Object getParam() {
        ChequeSummaryFilterParam param = new ChequeSummaryFilterParam();
        if (!FMHelper.isEmpty((Object[])this.getCompanyIds())) {
            param.setCompanyIds(this.getCompanyIds());
        }
        if (this.prmtBank.getData() != null && !FMHelper.isEmpty((Object[])((Object[])this.prmtBank.getData()))) {
            param.setBankIds(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBank));
        }
        if (this.pkPurDateFrom.getValue() != null) {
            param.setPurDateFrom(DateTimeUtils.truncateDate((Date)((Date)this.pkPurDateFrom.getValue())));
        }
        if (this.pkPurDateTo.getValue() != null) {
            param.setPurDateTo(DateTimeUtils.truncateDate((Date)((Date)this.pkPurDateTo.getValue())));
        }
        if (this.prmtNttype.getData() != null && !FMHelper.isEmpty((Object[])((Object[])this.prmtNttype.getData()))) {
            param.setTypeIds(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtNttype));
        }
        param.setShowTotal(this.chkDispTotal.isSelected());
        return param;
    }

    public void setParam(Object param) {
        SelectorItemCollection selectors;
        EntityViewInfo view;
        if (param == null) {
            return;
        }
        ChequeSummaryFilterParam para = (ChequeSummaryFilterParam)param;
        this.setCompanyIds(para.getCompanyIds());
        if (FMHelper.isEmpty((Object[])para.getBankIds())) {
            this.prmtBank.setData(null);
        } else {
            view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])para.getBankIds()), CompareType.INCLUDE));
            selectors = view.getSelector();
            selectors.add("id");
            selectors.add("number");
            selectors.add("name");
            BankCollection banks = null;
            try {
                banks = BankFactory.getRemoteInstance().getBankCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.prmtBank.setData((Object)banks.toArray());
        }
        if (FMHelper.isEmpty((Object[])para.getTypeIds())) {
            this.prmtNttype.setData(null);
        } else {
            view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])para.getTypeIds()), CompareType.INCLUDE));
            selectors = view.getSelector();
            selectors.add("id");
            selectors.add("number");
            selectors.add("name");
            NTTypeCollection coll = null;
            try {
                coll = NTTypeFactory.getRemoteInstance().getNTTypeCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.prmtNttype.setData((Object)coll.toArray());
        }
        this.pkPurDateFrom.setValue((Object)para.getPurDateFrom());
        this.pkPurDateTo.setValue((Object)para.getPurDateTo());
        this.chkDispTotal.setSelected(para.isShowTotal());
    }

    public boolean verify() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany()) && FMHelper.isEmpty((Object[])this.getCompanyIds())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"noCompany"));
            return false;
        }
        return super.verify();
    }

    protected void init() throws Exception {
        super.init();
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        ChequeUtil.initPrmtNttype(this.prmtNttype);
    }

    @Override
    protected void pkPurDateFrom_dataChanged(DataChangeEvent e) throws Exception {
        super.pkPurDateFrom_dataChanged(e);
        if (e.getNewValue() != null) {
            Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)e.getNewValue()));
            this.pkPurDateTo.setMinimumDate(DateUtil.getNextDay((Date)dateFrom));
        }
    }

    protected Class getParamClass() {
        return ChequeSummaryFilterParam.class;
    }
}

