/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ChequeSummaryUIHandler {
    public static final String COL_KEY_COMPANY = "company.name";
    public static final String COL_KEY_KEEPCOMPANY = "keepCompany.name";
    public static final String COL_KEY_APLLYCOMPANY = "applyCompany.name";
    public static final String COL_KEY_BANK = "bank.name";
    public static final String COL_KEY_BANKACCT = "bankAcct.name";
    public static final String COL_KEY_PURDATE = "purDate";
    public static final String COL_KEY_NTTYPE = "ntType.name";
    public static final String COL_KEY_BATCH = "batch";
    public static final String COL_KEY_CURRENCY = "currency.name";
    public static final String COL_KEY_PAPERCOUNT = "paperCount";
    public static final String COL_KEY_HASSTORE = "hasStore";
    public static final String COL_KEY_HASUSED = "hasUsed";
    public static final String COL_KEY_HASWRITTEOFF = "hasWriteOff";
    public static final String COL_KEY_HASJOURNAL = "hasJournal";
    public static final String COL_KEY_HASABANDON = "hasAbandon";
    public static final String COL_KEY_NOTUSED = "notUsed";
    public static final String COL_KEY_AMOUNT = "amount";
    public static final String SQL_GROUP_CLAUSE = "BATCH,BANKNAME, PURDATE, NTTYPENAME, COMPANYNAME,KEEPCOMPANYNAME,APPLYCOMPANYNAME, BANKACCTNAME,  CURRENCYNAME, CURRENCYID";
    public static final String SQL_GROUP_CLAUSE_TOTAL = "CURRENCYNAME, CURRENCYID";
    public static final int NTTYPE_CHEQUE_GROUP = 1;
    private static ChequeSummaryUIHandler instance;

    private ChequeSummaryUIHandler() {
    }

    public static ChequeSummaryUIHandler getInstance() {
        if (instance == null) {
            instance = new ChequeSummaryUIHandler();
        }
        return instance;
    }

    public void fillData(KDTable table, IMetaDataPK mainQueryPK, EntityViewInfo view, boolean isShowTotal) throws Exception {
        BigInteger verifiedCount;
        IRowSet rs = this.getRowSet(mainQueryPK, view, isShowTotal);
        IRow row = null;
        BigInteger paperCountSum = new BigInteger("0");
        BigInteger appliedCountSum = new BigInteger("0");
        BigInteger verifiedCountSum = new BigInteger("0");
        BigInteger abandonCountSum = new BigInteger("0");
        BigInteger newCountSum = new BigInteger("0");
        String totalTxt = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"total");
        boolean isOnlyUnion = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        ArrayList currencySumList = new ArrayList();
        while (rs.next()) {
            String company = rs.getString("COMPANYNAME");
            if (!FMHelper.isEmpty((String)company)) {
                row = table.addRow();
                row.getCell(COL_KEY_COMPANY).setValue((Object)company);
                row.getCell(COL_KEY_KEEPCOMPANY).setValue((Object)rs.getString("KEEPCOMPANYNAME"));
                row.getCell(COL_KEY_APLLYCOMPANY).setValue((Object)rs.getString("APPLYCOMPANYNAME"));
                row.getCell(COL_KEY_BANK).setValue((Object)rs.getString("BANKNAME"));
                row.getCell(COL_KEY_BANKACCT).setValue((Object)rs.getString("BANKACCTNAME"));
                row.getCell(COL_KEY_PURDATE).setValue((Object)rs.getDate("PURDATE"));
                row.getCell(COL_KEY_NTTYPE).setValue((Object)rs.getString("NTTYPENAME"));
                row.getCell(COL_KEY_BATCH).setValue((Object)rs.getString("BATCH"));
                row.getCell(COL_KEY_CURRENCY).setValue((Object)rs.getString("CURRENCYNAME"));
                String string = rs.getString("CURRENCYID");
                BigInteger paperCount = rs.getBigDecimal(COL_KEY_PAPERCOUNT).toBigInteger();
                row.getCell(COL_KEY_PAPERCOUNT).setValue((Object)paperCount);
                BigInteger storeCount = rs.getBigDecimal("storeCount").toBigInteger();
                row.getCell(COL_KEY_HASSTORE).setValue((Object)storeCount);
                BigInteger appliedCount = rs.getBigDecimal("appliedCount").toBigInteger();
                row.getCell(COL_KEY_HASUSED).setValue((Object)appliedCount);
                BigInteger writeOffCount = rs.getBigDecimal("writeOffCount").toBigInteger();
                row.getCell(COL_KEY_HASWRITTEOFF).setValue((Object)writeOffCount);
                verifiedCount = rs.getBigDecimal("verifiedCount").toBigInteger();
                row.getCell(COL_KEY_HASJOURNAL).setValue((Object)verifiedCount);
                BigInteger abandonCount = rs.getBigDecimal("abandonCount").toBigInteger();
                row.getCell(COL_KEY_HASABANDON).setValue((Object)abandonCount);
                BigInteger newCount = rs.getBigDecimal("newCount").toBigInteger();
                row.getCell(COL_KEY_NOTUSED).setValue((Object)newCount);
                BigDecimal amount = rs.getBigDecimal(COL_KEY_AMOUNT);
                ICell amountCell = row.getCell(COL_KEY_AMOUNT);
                amountCell.setValue((Object)amount);
                if (!FMHelper.isEmpty((String)string)) {
                    FMClientHelper.currencyFormat((BOSUuid)BOSUuid.read((String)string), (ICell)amountCell);
                } else {
                    FMClientHelper.setActualDigitNumberFormat((ICell)amountCell);
                }
                paperCountSum = paperCountSum.add(paperCount);
                appliedCountSum = appliedCountSum.add(appliedCount);
                verifiedCountSum = verifiedCountSum.add(verifiedCount);
                abandonCountSum = abandonCountSum.add(abandonCount);
                newCountSum = newCountSum.add(newCount);
                continue;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("CURRENCYNAME", rs.getString("CURRENCYNAME"));
            hashMap.put("CURRENCYID", rs.getString("CURRENCYID"));
            hashMap.put(COL_KEY_AMOUNT, rs.getBigDecimal(COL_KEY_AMOUNT));
            hashMap.put(COL_KEY_PAPERCOUNT, rs.getBigDecimal(COL_KEY_PAPERCOUNT).toBigInteger());
            hashMap.put("appliedCount", rs.getBigDecimal("appliedCount").toBigInteger());
            hashMap.put("writeOffCount", rs.getBigDecimal("writeOffCount").toBigInteger());
            hashMap.put("verifiedCount", rs.getBigDecimal("verifiedCount").toBigInteger());
            hashMap.put("abandonCount", rs.getBigDecimal("abandonCount").toBigInteger());
            hashMap.put("newCount", rs.getBigDecimal("newCount").toBigInteger());
            hashMap.put("storeCount", rs.getBigDecimal("storeCount").toBigInteger());
            currencySumList.add(hashMap);
        }
        if (isShowTotal && table.getRowCount() > 0) {
            for (Map map : currencySumList) {
                row = table.addRow();
                if (isOnlyUnion) {
                    row.getCell(COL_KEY_COMPANY).setValue((Object)totalTxt);
                } else {
                    row.getCell(COL_KEY_BANK).setValue((Object)totalTxt);
                }
                row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                row.getCell(COL_KEY_CURRENCY).setValue(map.get("CURRENCYNAME"));
                String currencyId = (String)map.get("CURRENCYID");
                BigInteger paperCount = (BigInteger)map.get(COL_KEY_PAPERCOUNT);
                row.getCell(COL_KEY_PAPERCOUNT).setValue((Object)paperCount);
                BigInteger storeCount = (BigInteger)map.get("storeCount");
                row.getCell(COL_KEY_HASSTORE).setValue((Object)storeCount);
                BigInteger appliedCount = (BigInteger)map.get("appliedCount");
                row.getCell(COL_KEY_HASUSED).setValue((Object)appliedCount);
                verifiedCount = (BigInteger)map.get("verifiedCount");
                row.getCell(COL_KEY_HASJOURNAL).setValue((Object)verifiedCount);
                BigInteger writeOffCount = (BigInteger)map.get("writeOffCount");
                row.getCell(COL_KEY_HASWRITTEOFF).setValue((Object)writeOffCount);
                BigInteger abandonCount = (BigInteger)map.get("abandonCount");
                row.getCell(COL_KEY_HASABANDON).setValue((Object)abandonCount);
                BigInteger newCount = (BigInteger)map.get("newCount");
                row.getCell(COL_KEY_NOTUSED).setValue((Object)newCount);
                BigDecimal amount = (BigDecimal)map.get(COL_KEY_AMOUNT);
                ICell amountCell = row.getCell(COL_KEY_AMOUNT);
                amountCell.setValue((Object)amount);
                if (!FMHelper.isEmpty((String)currencyId)) {
                    FMClientHelper.currencyFormat((BOSUuid)BOSUuid.read((String)currencyId), (ICell)amountCell);
                    continue;
                }
                FMClientHelper.setActualDigitNumberFormat((ICell)amountCell);
            }
        }
    }

    private IRowSet getRowSet(IMetaDataPK mainQueryPK, EntityViewInfo view, boolean isShowTotal) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)view.clone();
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        SQLUtil sqlBuilder = new SQLUtil();
        sqlBuilder.appendSql("SELECT ");
        sqlBuilder.appendSql(SQL_GROUP_CLAUSE);
        sqlBuilder.appendSql(", COUNT(*) paperCount, ");
        sqlBuilder.appendSql("sum(case when ");
        sqlBuilder.appendSql("a.State =");
        sqlBuilder.appendParam((Object)new Integer(0));
        sqlBuilder.appendSql(" then 1 else 0 end) storeCount, ");
        sqlBuilder.appendSql("sum(case when ");
        sqlBuilder.appendSql("a.State =");
        sqlBuilder.appendParam((Object)new Integer(2));
        sqlBuilder.appendSql(" then 1 else 0 end) appliedCount, ");
        sqlBuilder.appendSql("sum(case when ");
        sqlBuilder.appendSql("a.State =");
        sqlBuilder.appendParam((Object)new Integer(3));
        sqlBuilder.appendSql(" and a.isVC = 0");
        sqlBuilder.appendSql(" then 1 else 0 end) writeOffCount, ");
        sqlBuilder.appendSql("sum(case when ");
        sqlBuilder.appendSql("a.isVC=");
        sqlBuilder.appendParam((Object)new Integer(1));
        sqlBuilder.appendSql(" then 1 else 0 end) verifiedCount, ");
        sqlBuilder.appendSql("sum(case when ");
        sqlBuilder.appendSql("a.State =");
        sqlBuilder.appendParam((Object)new Integer(5));
        sqlBuilder.appendSql(" then 1 else 0 end) abandonCount, ");
        sqlBuilder.appendSql("sum(case when a.State =");
        sqlBuilder.appendParam((Object)new Integer(1));
        sqlBuilder.appendSql(" then 1 else 0 end) newCount, ");
        sqlBuilder.appendSql("SUM(amount) amount ");
        sqlBuilder.appendSql("FROM (");
        sqlBuilder.appendSql(sql);
        sqlBuilder.appendSql(") a ");
        sqlBuilder.appendSql(" GROUP BY ");
        sqlBuilder.appendSql(SQL_GROUP_CLAUSE);
        String detailSql = sqlBuilder.getSql();
        if (isShowTotal) {
            sqlBuilder.appendSql("\n UNION ALL \n");
            sqlBuilder.appendSql("SELECT ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) BATCH, ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) BANKNAME, ");
            sqlBuilder.appendSql("TO_Date(NULL) PURDATE, ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) NTTYPENAME, ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) COMPANYNAME, ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) KEEPCOMPANYNAME, ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) APPLYCOMPANYNAME, ");
            sqlBuilder.appendSql("TO_NVARCHAR(NULL) BANKACCTNAME, ");
            sqlBuilder.appendSql(SQL_GROUP_CLAUSE_TOTAL);
            sqlBuilder.appendSql(", SUM(paperCount) paperCount, ");
            sqlBuilder.appendSql("SUM(storeCount) storeCount, ");
            sqlBuilder.appendSql("SUM(appliedCount) appliedCount, ");
            sqlBuilder.appendSql("SUM(writeOffCount) writeOffCount, ");
            sqlBuilder.appendSql("SUM(verifiedCount) verifiedCount, ");
            sqlBuilder.appendSql("SUM(abandonCount) abandonCount, ");
            sqlBuilder.appendSql("SUM(newCount) newCount, ");
            sqlBuilder.appendSql("SUM(amount) amount ");
            sqlBuilder.appendSql("FROM (");
            sqlBuilder.appendSql(detailSql);
            sqlBuilder.getParamaters().addAll(sqlBuilder.getParamaters());
            sqlBuilder.appendSql(") s");
            sqlBuilder.appendSql(" GROUP BY ");
            sqlBuilder.appendSql(SQL_GROUP_CLAUSE_TOTAL);
        }
        String sql1 = "select * from (" + sqlBuilder.getSql() + ") aa order by batch";
        return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql1, sqlBuilder.getParamaters().toArray());
    }

    public void initMainTalbe(KDTable table) {
        table.getColumn(0).setMergeable(true);
        table.getColumn(1).setMergeable(true);
        table.getColumn(2).setMergeable(true);
        table.getColumn(3).setMergeable(true);
        table.getColumn(4).setMergeable(true);
        table.getColumn(5).setMergeable(true);
        table.getColumn(6).setMergeable(true);
        table.getDataRequestManager().setDataRequestMode(0);
        table.getGroupManager().setTotalize(true);
        table.getColumn(0).setStat(true);
        IRow row0 = table.getGroupManager().getStatRowTemplate(0);
        row0.getCell(9).setExpressions("SUM");
        row0.getCell(10).setExpressions("SUM");
        row0.getCell(11).setExpressions("SUM");
        row0.getCell(12).setExpressions("SUM");
        row0.getCell(13).setExpressions("SUM");
        row0.getCell(14).setExpressions("SUM");
        row0.getCell(15).setExpressions("SUM");
        row0.getCell(16).setExpressions("SUM");
        row0.getCell(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(10).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(11).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(12).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(14).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(15).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(16).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(COL_KEY_BATCH).getStyleAttributes().setNumberFormat("@");
        row0.getCell(COL_KEY_BANKACCT).getStyleAttributes().setNumberFormat("@");
        row0.getCell(COL_KEY_PURDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }
}

