/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractChequeWriteOff2;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.fm.nt.client.util.ResultInfomation;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;

public class ChequeWriteOffUI
extends AbstractChequeWriteOff2 {
    private boolean isCompanyFilter;
    private boolean needAudit;
    private CompanyOrgUnitInfo keepCompany = null;
    boolean isModify = true;

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeTableFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.dpReimburseDate.setValue((Object)DateTimeUtils.truncateDate((Date)new Date()));
    }

    public void onLoad() throws Exception {
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        this.initParam();
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        this.prmtactualBankAcct.setEnabled(false);
        super.onLoad();
        this.initMainTable();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.initListeners();
        this.fillPrmtNumberWhenOnLoad();
        this.prmtNumber.setEnabledMultiSelection(true);
        this.prmtNumber.setSelectorCollection(ChequeUtil.getSelectors());
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.f7TurnInAcct);
        this.prmtReimburser.setValue((Object)this.userinfo.getPerson());
        this.actionAntiReimburse.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        this.tblMain.getSelectManager().setSelectMode(1);
    }

    private void initParam() throws BOSException, EASBizException {
        Map map = this.getUIContext();
        this.isCompanyFilter = map.containsKey("NT028") ? ((Boolean)map.get("NT028")).booleanValue() : ContextHelperFactory.getRemoteInstance().getBooleanParam("NT028", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        this.needAudit = map.containsKey("NT029") ? ((Boolean)map.get("NT029")).booleanValue() : ContextHelperFactory.getRemoteInstance().getBooleanParam("NT029", null);
    }

    protected void initUIProp() throws Exception {
        ChequeUtil.initComboNttype(this.cmbNttype, false);
        FMClientHelper.initComboCurrency((KDComboBox)this.cmbCurrency, (boolean)true);
    }

    protected void initPropEvi() throws Exception {
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtReimburser);
        this.initPayBankAccount();
        this.prmtProjectManager.setEnabled(true);
        this.prmtProjectManager.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionAntiReimburse.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.menuWorkflow.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
    }

    protected IObjectValue createNewData() {
        return new ChequeInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtReimburser);
        if (this.tblMain == null || this.tblMain.getRowCount() == 0) {
            return;
        }
        IRow rowHead = this.tblMain.getHeadRow(0);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            String password = (String)row.getCell("password").getValue();
            if (password != null && password.length() > 80) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"194_ChequeApplyUI");
                msg = MessageFormat.format(msg, i + 1);
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            String[] verifyColumns = new String[]{"applyDate", "expiredDate", "issueDate", "reimburseAmount", "remindDate"};
            for (int j = 0; j < verifyColumns.length; ++j) {
                if (row.getCell(verifyColumns[j]).getValue() != null) continue;
                throw new NTException(NTException.COLUMNNOTNULL, new Object[]{rowHead.getCell(verifyColumns[j]).getValue()});
            }
            boolean isManager = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT041", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            boolean nt040 = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT040", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            if (this.prmtFeeType.getValue() != null) {
                if (nt040) {
                    FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtProject);
                }
                if (isManager) {
                    FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtProjectManager);
                }
            }
            if (this.prmtProject.getValue() != null) {
                if (nt040) {
                    FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtFeeType);
                }
                if (isManager) {
                    FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtProjectManager);
                }
            }
            BigDecimal ceilingAmount = (BigDecimal)row.getCell("ceiling").getValue();
            BigDecimal reimbuseValue = (BigDecimal)row.getCell("reimburseAmount").getValue();
            if (reimbuseValue != null && reimbuseValue.compareTo(Constants.ZERO) <= 0) {
                throw new NTException(NTException.REIMBURSEAMOUNTMUSTBIGERTHANZERO);
            }
            if (ceilingAmount != null && ceilingAmount.compareTo(reimbuseValue) == -1) {
                throw new NTException(NTException.REIMBURSEAMOUNTTOOBIG);
            }
            Date applyDate = DateTimeUtils.truncateDate((Date)((Date)row.getCell("applyDate").getValue()));
            Date expireDate = DateTimeUtils.truncateDate((Date)((Date)row.getCell("expiredDate").getValue()));
            Date issueDate = DateTimeUtils.truncateDate((Date)((Date)row.getCell("issueDate").getValue()));
            Date reimburseDate = DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue()));
            if (applyDate != null && applyDate.after(reimburseDate)) {
                throw new NTException(NTException.REIMBURSEDATAAFTERISSUEDATE);
            }
            if (!expireDate.after(issueDate)) {
                throw new NTException(NTException.EXPIREDATE_LESSTHAN_ISSUEDATE);
            }
            if (applyDate == null || issueDate == null || !applyDate.after(issueDate)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"190_ChequeApplyUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        IContextHelper iCtxHelper = ContextHelperFactory.getRemoteInstance();
        String recBillStatus = iCtxHelper.getStringParam("NT050", null);
        if (recBillStatus != null && recBillStatus.equals("true")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"isBillDestroy"));
            return;
        }
        if (this.isSave()) {
            throw new NTException(NTException.ALREADY_SUBMIT);
        }
        this.storeFields();
        this.doWriteOff();
        this.setSave(true);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"ChequeWriteOffSuccess"));
        this.showMessage();
        this.isModify = false;
    }

    @Override
    public void actionAntiReimburse_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiReimburse_actionPerformed(e);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            idSet.add(((ChequeInfo)this.tblMain.getRow(i).getUserObject()).getId().toString());
        }
        try {
            ChequeFactory.getRemoteInstance().antiReimburse(idSet);
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            idList.add(id);
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), true);
        super.actionTDPrint_actionPerformed(e);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            idList.add(id);
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        super.actionTDPrintPreview_actionPerformed(e);
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtNumber_dataChanged(e);
        Set chequeIDs = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtNumber));
        ArrayList list = new ArrayList(chequeIDs);
        if (list.size() == 0) {
            this.tblMain.removeRows();
            this.prmtPayAccoutBank.setValue(null);
            this.prmtPayAccoutBank.setEnabled(false);
            this.prmtPayBank.setValue(null);
            this.prmtactualBankAcct.setEnabled(false);
            return;
        }
        this.prmtPayAccoutBank.setEnabled(true);
        this.prmtactualBankAcct.setEnabled(true);
        Object[] object = AccessHelper.getF7Data((KDBizPromptBox)this.prmtNumber);
        ChequeCollection chqCollection = new ChequeCollection();
        for (int i = 0; i < object.length; ++i) {
            chqCollection.add((ChequeInfo)object[i]);
        }
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            try {
                ResultInfomation result = ChequeUtil.checkChequeWriteOffValid(chqCollection);
                if (!result.isEqual()) {
                    MsgBox.showInfo((Component)((Object)this), (String)result.getResult());
                    this.prmtNumber.setValue(e.getOldValue());
                    SysUtil.abort();
                }
            }
            catch (NTException e1) {
                this.prmtNumber.setValue(e.getOldValue());
                throw e1;
            }
            finally {
                MutexUtils.releaseMutex(list);
            }
        }
        this.reSetComponentsEnable(chqCollection.get(0));
        this.reFillCompnentsValue(chqCollection);
        this.setSave(false);
    }

    @Override
    protected void cmbNttype_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbNttype_itemStateChanged(e);
        this.filterNTTypePrmtNumber();
    }

    private void filterNTTypePrmtNumber() throws Exception {
        NTTypeInfo nttype = (NTTypeInfo)this.cmbNttype.getSelectedItem();
        FilterItemInfo filterNtType = new FilterItemInfo("ntType.id", (Object)nttype.getId().toString());
        this.prmtNumber.setValue(null);
        if (this.prmtNumber.getEntityViewInfo() == null) {
            ChequeUtil.initPrmtNumber(this.prmtNumber, "WRITEOFF", this.needAudit);
        }
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNumber, (FilterItemInfo)filterNtType);
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.resetPayeeRelatedComps(i);
        }
    }

    @Override
    protected void prmtApplyCompany_dataChanged(DataChangeEvent e) throws Exception {
        int i;
        super.prmtApplyCompany_dataChanged(e);
        if (e.getNewValue() == null) {
            this.prmtProject.setValue(null);
            this.prmtProject.setEnabled(false);
            this.f7TurnInAcct.setEnabled(false);
            return;
        }
        this.prmtProject.setEnabled(true);
        this.prmtApplicant.setEnabled(true);
        this.prmtDepartment.setEnabled(true);
        this.f7TurnInAcct.setEnabled(true);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
        FilterItemInfo filterComapny = new FilterItemInfo("company.id", (Object)company.getId().toString());
        ChequeUtil.setComponentsValueNull(new IKDComponent[]{this.prmtDepartment, this.prmtPayeeName, this.f7TurnInAcct, this.f7OppAccountView, this.txtPayeeBank, this.txtPayeeBankAccount, this.prmtProject, this.prmtProjectManager});
        F7SelectorFactory.initAdminOrgUnitWithRoot((IUIObject)this, (KDBizPromptBox)this.prmtDepartment, (CompanyOrgUnitInfo)company);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.f7TurnInAcct, (FilterItemInfo)filterComapny);
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.prmtPayeeName, company);
        if (this.tblMain.getRowCount3() == 0) {
            return;
        }
        for (i = 0; i < this.tblMain.getRowCount3(); ++i) {
            ChequeInfo cheque;
            boolean isOwnReceive = (Boolean)this.tblMain.getRow(i).getCell("isOwnReceive").getValue();
            if (isOwnReceive && this.prmtApplyCompany.getValue() != null) {
                this.tblMain.getRow(i).getCell("payeeName").setValue((Object)company.getName());
            }
            if ((cheque = (ChequeInfo)this.tblMain.getRow(i).getUserObject()).isIsApply()) continue;
            this.tblMain.getRow(i).getCell("department").setValue(null);
            this.tblMain.getRow(i).getCell("applier").setValue(null);
            this.tblMain.getRow(i).getCell("usage").setValue(null);
        }
        for (i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.resetPayeeRelatedComps(i);
        }
    }

    @Override
    protected void prmtPayBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayBank_dataChanged(e);
    }

    @Override
    protected void prmtApplicant_willCommit(CommitEvent e) throws Exception {
        if (this.prmtApplyCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyCompanyNull"));
            e.setCanceled(true);
            return;
        }
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        Object department = this.tblMain.getRow2(activeRowNumber).getCell("department").getValue();
        if (department == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyDeptNull"));
            e.setCanceled(true);
            return;
        }
        this.reSetApplicantSelector();
    }

    @Override
    protected void prmtApplicant_willShow(SelectorEvent e) throws Exception {
        if (this.prmtApplyCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyCompanyNull"));
            e.setCanceled(true);
            return;
        }
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        Object department = this.tblMain.getRow2(activeRowNumber).getCell("department").getValue();
        if (department == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyDeptNull"));
            e.setCanceled(true);
            return;
        }
        this.reSetApplicantSelector();
    }

    @Override
    protected void prmtDepartment_dataChanged(DataChangeEvent e) throws Exception {
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        this.tblMain.getRow2(activeRowNumber).getCell("applier").setValue(null);
    }

    @Override
    protected void prmtPayeeName_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        if (CoreBaseInfo.class.isInstance(e.getNewValue())) {
            SupplierInfo supply = (SupplierInfo)e.getNewValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("bankName");
            sic.add("bankAccount");
            CompanyOrgUnitInfo applyCompany = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
            SupplierCompanyInfoInfo company = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supply.getId().toString()), (IObjectPK)new ObjectUuidPK(applyCompany.getId()), sic);
            if (company != null) {
                CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supply, (String)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
                if (bankInfo != null) {
                    row.getCell("payeeBank").setValue((Object)bankInfo.getBank());
                    row.getCell("payeeBankAccount").setValue((Object)bankInfo.getBankAccount());
                } else {
                    row.getCell("payeeBank").setValue(null);
                    row.getCell("payeeBankAccount").setValue(null);
                }
                KDBizPromptBox txtpbAccount = new KDBizPromptBox();
                txtpbAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
                txtpbAccount.setEditFormat("$bankAccount$");
                txtpbAccount.setDisplayFormat("$bankAccount$");
                txtpbAccount.addDataChangeListener(new DataChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dataChanged(DataChangeEvent e) {
                        try {
                            KDBizPromptBox pbac = (KDBizPromptBox)e.getSource();
                            Object o = e.getNewValue();
                            if (o instanceof SupplierCompanyBankInfo) {
                                pbac.setValue((Object)((SupplierCompanyBankInfo)e.getNewValue()).getBankAccount());
                                int activeRowNumber2 = ChequeWriteOffUI.this.tblMain.getSelectManager().getActiveRowIndex();
                                IRow row2 = ChequeWriteOffUI.this.tblMain.getRow2(activeRowNumber2);
                                row2.getCell("payeeBank").setValue((Object)((SupplierCompanyBankInfo)e.getNewValue()).getBank());
                            }
                        }
                        catch (Exception exception) {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                });
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                txtpbAccount.setEntityViewInfo(evi);
                KDTDefaultCellEditor editorBankAccount = new KDTDefaultCellEditor((IKDEditor)txtpbAccount);
                row.getCell("payeeBankAccount").setEditor((ICellEditor)editorBankAccount);
            }
        }
    }

    @Override
    protected void prmtPayeeName_willShow(SelectorEvent e) throws Exception {
        if (this.prmtApplyCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"ApplyCompanyNull"));
            e.setCanceled(true);
            return;
        }
    }

    @Override
    protected void dpReimburseDate_dataChanged(DataChangeEvent e) throws Exception {
        super.dpReimburseDate_dataChanged(e);
        if (this.dpReimburseDate.getValue() == null) {
            return;
        }
        Date reimburseDate = DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue()));
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            ChequeInfo cheque = (ChequeInfo)this.tblMain.getRow(i).getUserObject();
            if (cheque.isIsApply()) continue;
            this.tblMain.getRow(i).getCell("remindDate").setValue((Object)reimburseDate);
        }
    }

    @Override
    protected void prmtPayAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currency;
        if (e.getNewValue() == null) {
            this.prmtApplyCompany.setValue(null);
            this.cmbCurrency.setEnabled(true);
            return;
        }
        AccountBankInfo accout = (AccountBankInfo)e.getNewValue();
        if (this.prmtactualBankAcct.getData() == null) {
            ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId().toString());
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
            this.prmtApplyCompany.setValue((Object)company);
        }
        if ((currency = accout.getCurrency()) != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)currency);
            this.cmbCurrency.setEnabled(false);
        } else {
            this.cmbCurrency.setEnabled(true);
        }
    }

    @Override
    protected void prmtProject_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtProject_dataChanged(e);
        ProjectInfo project = (ProjectInfo)this.prmtProject.getValue();
        if (project != null) {
            PersonInfo bill = null;
            if (project.getPrjManager() != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(project.getPrjManager().getId().toString());
                bill = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)objPk);
                this.prmtProjectManager.setValue((Object)bill);
            }
        } else {
            this.prmtProjectManager.setValue(null);
        }
    }

    @Override
    protected void cmbCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbCurrency_itemStateChanged(e);
        this.updateAmountFiled();
    }

    @Override
    protected void f7OppAccountView_willCommit(CommitEvent e) throws Exception {
        if (this.cmbCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        this.setOppAccountView(this.f7OppAccountView);
    }

    @Override
    protected void f7OppAccountView_willShow(SelectorEvent e) throws Exception {
        if (this.cmbCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        this.setOppAccountView(this.f7OppAccountView);
    }

    @Override
    protected void f7TurnInAcct_willCommit(CommitEvent e) throws Exception {
        this.initF7TurnInAcct();
    }

    @Override
    protected void f7TurnInAcct_willShow(SelectorEvent e) throws Exception {
        this.initF7TurnInAcct();
    }

    @Override
    protected void prmtPayAccoutBank_willShow(SelectorEvent e) throws Exception {
        super.prmtPayAccoutBank_willShow(e);
        this.initBankAcctFilter();
    }

    @Override
    protected void prmtPayAccoutBank_willCommit(CommitEvent e) throws Exception {
        super.prmtPayAccoutBank_willCommit(e);
        this.initBankAcctFilter();
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblMain.getColumn("payeeName").getColumnIndex() && CoreBaseInfo.class.isInstance(e.getValue())) {
            SupplierInfo supply = (SupplierInfo)e.getValue();
            SupplierCompanyInfoInfo company = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supply.getId().toString()));
            this.tblMain.getRow(rowIndex).getCell("payeeBank").setValue((Object)company.getBankName());
            this.tblMain.getRow(rowIndex).getCell("payeeBankAccount").setValue((Object)company.getBankAccount());
        }
        if (colIndex == this.tblMain.getColumn("isOwnReceive").getColumnIndex()) {
            this.ckIsOwnReceive_ValueChanged(e);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        String isowen;
        Date issueDate;
        super.tblMain_editStopped(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblMain.getColumn("reimburseAmount").getColumnIndex()) {
            BigDecimal amount = (BigDecimal)this.tblMain.getRow(rowIndex).getCell("reimburseAmount").getValue();
            ChequeInfo cheque = (ChequeInfo)this.tblMain.getRow(rowIndex).getUserObject();
            if (!cheque.isIsApply()) {
                this.tblMain.getRow(rowIndex).getCell("ceiling").setValue((Object)amount);
            }
        }
        if (colIndex == this.tblMain.getColumn("issueDate").getColumnIndex() && (issueDate = (Date)this.tblMain.getRow(rowIndex).getCell("issueDate").getValue()) != null) {
            this.tblMain.getRow(rowIndex).getCell("remindDate").setValue((Object)issueDate);
            Date expireDate = DateTimeUtils.addDay((Date)issueDate, (long)10L);
            this.tblMain.getRow(rowIndex).getCell("expiredDate").setValue((Object)expireDate);
            ChequeInfo cheque = (ChequeInfo)this.tblMain.getRow(rowIndex).getUserObject();
            if (!cheque.isIsApply()) {
                this.tblMain.getRow(rowIndex).getCell("applyDate").setValue((Object)issueDate);
            }
        }
        if (colIndex == this.tblMain.getColumn("isOwnReceive").getColumnIndex() && (isowen = this.tblMain.getRow(rowIndex).getCell("isOwnReceive").getValue().toString()).equals("true")) {
            this.tblMain.getRow(rowIndex).getCell(colIndex + 2).getStyleAttributes().setLocked(true);
            this.tblMain.getRow(rowIndex).getCell(colIndex + 4).getStyleAttributes().setLocked(false);
        }
    }

    private AccountPromptBox getOppAcctSelector(CompanyOrgUnitInfo applyCompany, String currencyId, boolean isMe, boolean isCash) throws EASBizException, BOSException {
        EntityViewInfo oppAcctEV = ChequeUtil.getOppAcctEV(applyCompany, currencyId, isMe, isCash, false);
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, applyCompany, oppAcctEV.getFilter(), false, true);
        return acctPromptBox;
    }

    private void setOppAccountView(KDBizPromptBox F7) throws EASBizException, BOSException {
        CurrencyInfo info = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        String currencyId = info.getId().toString();
        CompanyOrgUnitInfo applyCompany = ChequeUtil.getRightCompany(this.prmtApplyCompany);
        boolean isCash = ((NTTypeInfo)this.cmbNttype.getSelectedItem()).isIsCash();
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        boolean isMe = (Boolean)row.getCell("isOwnReceive").getValue();
        AccountPromptBox account = this.getOppAcctSelector(applyCompany, currencyId, isMe, isCash);
        F7.setSelector((KDPromptSelector)account);
        F7.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo oppAcctEV = ChequeUtil.getOppAcctEV(applyCompany, currencyId, isMe, isCash, true);
        F7.setEntityViewInfo(oppAcctEV);
        F7.setCommitFormat("$number$;$name$");
        F7.setDisplayFormat("$number$ $name$");
        F7.setEditFormat("$number$");
    }

    private void ckIsOwnReceive_ValueChanged(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        this.tblMain.getRow2(rowIndex).getCell(colIndex).setValue(e.getValue());
        this.resetPayeeRelatedComps(rowIndex);
    }

    private void doWriteOff() {
        ChequeCollection coll = new ChequeCollection();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            coll.add((ChequeInfo)this.tblMain.getRow(i).getUserObject());
        }
        try {
            ChequeFactory.getRemoteInstance().reimburse((IObjectCollection)coll);
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
        this.setSave(true);
    }

    public boolean isModify() {
        if (!this.isModify) {
            return false;
        }
        return super.isModify();
    }

    private void resetPayeeRelatedComps(int rowNumber) {
        if (this.tblMain.getRowCount3() == 0) {
            return;
        }
        IRow row = this.tblMain.getRow2(rowNumber);
        boolean isCash = ((NTTypeInfo)this.cmbNttype.getSelectedItem()).isIsCash();
        boolean isOwnReceive = false;
        if (row.getCell("isOwnReceive").getValue() != null) {
            isOwnReceive = (Boolean)row.getCell("isOwnReceive").getValue();
        }
        ICell cellF7TurnInAcct = row.getCell("turnInAccount");
        ICell payeeName = row.getCell("payeeName");
        ICell payeeBank = row.getCell("payeeBank");
        ICell payeeBankAccount = row.getCell("payeeBankAccount");
        cellF7TurnInAcct.getStyleAttributes().setLocked(true);
        payeeName.getStyleAttributes().setLocked(true);
        payeeBank.getStyleAttributes().setLocked(true);
        ChequeUtil.setComponentsValueNull(new ICell[]{cellF7TurnInAcct, payeeName, payeeBank, payeeBankAccount});
        if (isOwnReceive) {
            if (!isCash) {
                cellF7TurnInAcct.getStyleAttributes().setLocked(false);
                KDTDefaultCellEditor editorTurnInAcct = new KDTDefaultCellEditor((IKDEditor)this.f7TurnInAcct);
                payeeBankAccount.setEditor((ICellEditor)editorTurnInAcct);
            } else {
                cellF7TurnInAcct.getStyleAttributes().setLocked(true);
                payeeBankAccount.getStyleAttributes().setLocked(true);
            }
            if (this.prmtApplyCompany.getValue() != null) {
                payeeName.setValue((Object)this.prmtApplyCompany.getValue().toString());
            } else {
                payeeName.setValue(null);
            }
        } else {
            payeeName.getStyleAttributes().setLocked(false);
            payeeBank.getStyleAttributes().setLocked(false);
            payeeBankAccount.getStyleAttributes().setLocked(false);
            KDTDefaultCellEditor editorBankAccount = new KDTDefaultCellEditor((IKDEditor)this.txtPayeeBankAccount);
            payeeBankAccount.setEditor((ICellEditor)editorBankAccount);
        }
    }

    private void storeTableFields() {
        CurrencyInfo curInfo = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        if (curInfo == null) {
            return;
        }
        String iso = curInfo.getIsoCode();
        NTNumberFormat f = NTNumberFormat.getInstance(iso);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            BigDecimal amount;
            IRow row = this.tblMain.getRow(i);
            ChequeInfo cheque = (ChequeInfo)row.getUserObject();
            if (cheque.getApplyRec() == null) {
                cheque.setApplyRec(new ChequeAppRecInfo());
            }
            if ((amount = (BigDecimal)row.getCell("reimburseAmount").getValue()) != null && amount.compareTo(Constants.ZERO) > 0) {
                cheque.setAmount(amount);
                String captital = f.format(amount);
                cheque.setCapitalization(captital);
            }
            if (row.getCell("payeeName").getValue() != null) {
                cheque.setPayeeName(row.getCell("payeeName").getValue().toString());
            }
            if (row.getCell("payeeBank").getValue() != null) {
                cheque.setPayeeAcctBank(row.getCell("payeeBank").getValue().toString());
            }
            if (row.getCell("payeeBankAccount").getValue() != null) {
                cheque.setPayeeAcctNumber(row.getCell("payeeBankAccount").getValue().toString());
            }
            if (row.getCell("oppAccount").getValue() != null) {
                cheque.setOppAccount((AccountViewInfo)row.getCell("oppAccount").getValue());
            }
            if (row.getCell("usage").getValue() != null) {
                cheque.setUsage((String)row.getCell("usage").getValue());
            }
            if (row.getCell("turnInAccount").getValue() != null) {
                cheque.setTurnInAcctBank((AccountBankInfo)row.getCell("turnInAccount").getValue());
            }
            if (row.getCell("issueDate").getValue() != null) {
                cheque.setIssueDate(DateTimeUtils.truncateDate((Date)((Date)row.getCell("applyDate").getValue())));
            }
            cheque.setExpiredDate((Date)row.getCell("expiredDate").getValue());
            if (row.getCell("applyDate").getValue() != null) {
                cheque.getApplyRec().setApplyDate((Date)row.getCell("applyDate").getValue());
            }
            cheque.getApplyRec().setRemindDate(DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue())));
            cheque.setIsLineation(Boolean.valueOf(row.getCell("cbIsLine").getValue().toString()));
            cheque.setIsTransfer(Boolean.valueOf(row.getCell("cbCanTrans").getValue().toString()));
            cheque.setIsOwnReceive(Boolean.valueOf(row.getCell("isOwnReceive").getValue().toString()));
            if (row.getCell("applier").getValue() != null) {
                cheque.getApplyRec().setApplicant((PersonInfo)row.getCell("applier").getValue());
            }
            if (row.getCell("ceiling").getValue() != null) {
                cheque.getApplyRec().setCeiling((BigDecimal)row.getCell("ceiling").getValue());
            }
            if (row.getCell("department").getValue() != null) {
                cheque.getApplyRec().setDepartment((AdminOrgUnitInfo)row.getCell("department").getValue());
            }
            cheque.setFeeTypeID((FeeTypeInfo)this.prmtFeeType.getValue());
            cheque.setProject((ProjectInfo)this.prmtProject.getValue());
            cheque.setProjectManager((PersonInfo)this.prmtProjectManager.getValue());
            cheque.setBankAcct((AccountBankInfo)this.prmtPayAccoutBank.getValue());
            cheque.setCurrency((CurrencyInfo)this.cmbCurrency.getSelectedItem());
            cheque.getApplyRec().setReimburser((PersonInfo)this.prmtReimburser.getValue());
            cheque.setReimburseDate(DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue())));
            cheque.getApplyRec().setApplyCompany((CompanyOrgUnitInfo)this.prmtApplyCompany.getValue());
            cheque.setPassword((String)row.getCell("password").getValue());
            cheque.setActualBankAcct((AccountBankInfo)this.prmtactualBankAcct.getData());
        }
    }

    private void fillPrmtNumberWhenOnLoad() throws Exception {
        ArrayList selectIdList = (ArrayList)this.getUIContext().get("CHEQUEIDS");
        if (selectIdList != null && selectIdList.size() != 0) {
            ChequeCollection coll = ChequeUtil.getChequeCollection(selectIdList);
            FMClientHelper.setSelectObject((KDComboBox)this.cmbNttype, (Object)coll.get(0).getNtType());
            this.filterNTTypePrmtNumber();
            this.prmtNumber.setValue((Object)coll.toArray());
            if (!FMHelper.isEmpty((Object)this.prmtNumber.getValue())) {
                this.prmtNumber_dataChanged(null);
            }
            this.reFillCompnentsValue(coll);
            this.prmtactualBankAcct.setEnabled(true);
        } else {
            this.filterNTTypePrmtNumber();
        }
    }

    private void initBankAcctFilter() throws BOSException {
        Object bankInfo;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        if (this.isCompanyFilter) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtPayAccoutBank.setEntityViewInfo(evi);
        Object currencyInfo = this.cmbCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtPayAccoutBank.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        if ((bankInfo = this.prmtPayBank.getValue()) instanceof BankInfo) {
            FilterInfo bankFilter = new FilterInfo();
            bankFilter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)((BankInfo)bankInfo).getId()));
            this.prmtPayAccoutBank.getEntityViewInfo().getFilter().mergeFilter(bankFilter, "AND");
        }
        this.prmtPayAccoutBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initF7TurnInAcct() {
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        if (activeRowNumber == -1) {
            return;
        }
        boolean isCash = ((NTTypeInfo)this.cmbNttype.getSelectedItem()).isIsCash();
        boolean isOwnReceive = false;
        if (row.getCell("isOwnReceive").getValue() != null) {
            isOwnReceive = (Boolean)row.getCell("isOwnReceive").getValue();
        }
        if (this.prmtPayAccoutBank.getValue() != null) {
            AccountBankInfo account = (AccountBankInfo)this.prmtPayAccoutBank.getValue();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtApplyCompany.getValue();
            if (!"VIEW".equals(this.oprtState) && this.editData != null) {
                this.f7TurnInAcct.getQueryAgent().resetRuntimeEntityView();
                this.f7TurnInAcct.setEntityViewInfo(ChequeUtil.getInAcctBank(isOwnReceive, isCash, account.getId().toString(), company.getId().toString()));
            }
        }
    }

    private void reFillCompnentsValue(ChequeCollection editDatas) throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.fillAboveTableComponents(editDatas);
        this.fillTable(editDatas);
    }

    private void fillAboveTableComponents(ChequeCollection editDatas) {
        if (editDatas == null || editDatas.size() == 0) {
            return;
        }
        ChequeInfo info = editDatas.get(0);
        if (info.getBankAcct() == null) {
            this.prmtPayAccoutBank.setValue(null);
            this.prmtPayAccoutBank.setEnabled(true);
        } else {
            this.prmtPayAccoutBank.setValue((Object)info.getBankAcct());
            this.prmtPayAccoutBank.setEnabled(false);
        }
        this.keepCompany = info.getKeepCompany();
        this.prmtactualBankAcct.setValue((Object)info.getActualBankAcct());
        if (info.getActualBankAcct() != null) {
            this.prmtApplyCompany.setValue((Object)this.keepCompany);
        }
        this.prmtPayBank.setValue((Object)info.getBank());
        this.prmtProject.setValue((Object)info.getProject());
        this.prmtProjectManager.setValue((Object)info.getProjectManager());
        this.prmtFeeType.setValue((Object)info.getFeeTypeID());
        CurrencyInfo currency = info.getCurrency();
        if (currency == null) {
            currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
            if (currency == null) {
                this.tblMain.getColumn("reimburseAmount").getStyleAttributes().setNumberFormat("%r-[ ]0.00n");
                this.tblMain.getColumn("ceiling").getStyleAttributes().setNumberFormat("%r-[ ]0.00n");
            } else {
                String formatString = FMClientHelper.getNumberFtm((BOSUuid)currency.getId());
                this.tblMain.getColumn("reimburseAmount").getStyleAttributes().setNumberFormat(formatString);
                this.tblMain.getColumn("ceiling").getStyleAttributes().setNumberFormat(formatString);
            }
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)currency);
            String formatString = FMClientHelper.getNumberFtm((BOSUuid)currency.getId());
            this.tblMain.getColumn("reimburseAmount").getStyleAttributes().setNumberFormat(formatString);
            this.tblMain.getColumn("ceiling").getStyleAttributes().setNumberFormat(formatString);
        }
    }

    private void fillTable(ChequeCollection editDatas) {
        KDCheckBox check = null;
        if (this.dpReimburseDate.getValue() == null) {
            return;
        }
        Date reimburseDate = DateTimeUtils.truncateDate((Date)((Date)this.dpReimburseDate.getValue()));
        for (int i = 0; i < editDatas.size(); ++i) {
            ChequeInfo cheque = editDatas.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)cheque.getId().toString());
            row.getCell("number").setValue((Object)cheque.getNumber());
            if (cheque.getCurrency() != null) {
                row.getCell("currency").setValue((Object)cheque.getCurrency().getName());
            }
            check = new KDCheckBox();
            KDTDefaultCellEditor editorCKIsMe = new KDTDefaultCellEditor((JCheckBox)check);
            this.tblMain.getColumn("isOwnReceive").setEditor((ICellEditor)editorCKIsMe);
            row.getCell("isOwnReceive").setValue((Object)cheque.isIsOwnReceive());
            row.getCell("cbCanTrans").setValue((Object)cheque.isIsTransfer());
            row.getCell("cbIsLine").setValue((Object)cheque.isIsLineation());
            if (cheque.isIsOwnReceive()) {
                if (this.prmtApplyCompany.getValue() != null) {
                    row.getCell("payeeName").setValue((Object)this.prmtApplyCompany.getValue().toString());
                }
                row.getCell("payeeName").getStyleAttributes().setLocked(true);
                row.getCell("payeeBankAccount").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("payeeName").setValue((Object)cheque.getPayeeName());
            }
            row.getCell("payeeBank").setValue((Object)cheque.getPayeeAcctBank());
            row.getCell("payeeBankAccount").setValue((Object)cheque.getPayeeAcctNumber());
            row.getCell("oppAccount").setValue((Object)cheque.getOppAccount());
            row.getCell("turnInAccount").setValue((Object)cheque.getTurnInAcctBank());
            if (cheque.isIsOwnReceive() && !cheque.getNtType().isIsCash()) {
                row.getCell("turnInAccount").getStyleAttributes().setLocked(false);
            } else {
                row.getCell("turnInAccount").getStyleAttributes().setLocked(true);
            }
            if (cheque.getApplyRec() != null) {
                row.getCell("ceiling").setValue((Object)cheque.getApplyRec().getCeiling());
                row.getCell("applyDate").setValue((Object)cheque.getApplyRec().getApplyDate());
                row.getCell("issueDate").setValue((Object)cheque.getIssueDate());
                row.getCell("expiredDate").getStyleAttributes().setLocked(cheque.getExpiredDate() != null);
                row.getCell("expiredDate").setValue((Object)cheque.getExpiredDate());
                if (cheque.getApplyRec().getDepartment() != null) {
                    row.getCell("department").setValue((Object)cheque.getApplyRec().getDepartment());
                }
                if (cheque.getApplyRec().getApplicant() != null) {
                    row.getCell("applier").setValue((Object)cheque.getApplyRec().getApplicant());
                }
                row.getCell("remindDate").setValue((Object)cheque.getApplyRec().getRemindDate());
                row.getCell("remindDate").getStyleAttributes().setLocked(cheque.getApplyRec().getRemindDate() != null);
            } else {
                row.getCell("issueDate").setValue((Object)new Date());
                row.getCell("expiredDate").setValue((Object)DateTimeUtils.addDay((Date)new Date(), (long)10L));
                row.getCell("expiredDate").getStyleAttributes().setLocked(false);
                row.getCell("applyDate").setValue((Object)new Date());
                row.getCell("remindDate").setValue((Object)reimburseDate);
                row.getCell("remindDate").getStyleAttributes().setLocked(false);
            }
            if (cheque.getKeeper() != null) {
                row.getCell("keeper").setValue((Object)cheque.getKeeper().getName());
            }
            row.getCell("reimburseAmount").setValue((Object)cheque.getAmount());
            if (cheque.getAmount() != null && !cheque.getAmount().equals(Constants.ZERO)) {
                row.getCell("reimburseAmount").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("reimburseAmount").getStyleAttributes().setLocked(false);
            }
            row.getCell("password").setValue((Object)cheque.getPassword());
            row.getCell("usage").setValue((Object)cheque.getUsage());
            row.getCell("usage").getStyleAttributes().setLocked(false);
            row.setUserObject((Object)cheque);
        }
    }

    private void reSetApplicantSelector() {
        int activeRowNumber = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow2(activeRowNumber);
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)row.getCell("department").getValue();
        PersonPromptBox prmtApplicantPerson = new PersonPromptBox((IUIObject)this);
        prmtApplicantPerson.showAllChildren();
        if (adminOrgUnitInfo != null) {
            prmtApplicantPerson.setExpandAdmin(adminOrgUnitInfo.getId().toString());
            FilterItemInfo item = new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString());
            try {
                FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtApplicant, (FilterItemInfo)item);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.prmtApplicant.setSelector((KDPromptSelector)prmtApplicantPerson);
        this.prmtApplicant.setCommitFormat("$number$;$name$");
        this.prmtApplicant.setDisplayFormat("$name$");
        this.prmtApplicant.setEditFormat("$number$");
        this.prmtApplicant.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
    }

    private void initPayBankAccount() throws Exception {
        if (this.prmtPayAccoutBank.getData() != null) {
            this.prmtPayAccoutBank.setEnabled(false);
        }
    }

    private void reSetComponentsEnable(ChequeInfo cheque) throws Exception {
        int i;
        if (cheque == null) {
            return;
        }
        if (cheque.getBankAcct() != null) {
            this.prmtPayAccoutBank.setEnabled(false);
        }
        if (cheque.isIsApply()) {
            this.prmtApplyCompany.setEnabled(false);
            this.prmtPayAccoutBank.setEnabled(false);
            ChequeUtil.setColumnEnabled(this.tblMain, new String[]{"applier", "department", "applyDate", "ceiling", "usage"}, false);
        } else {
            this.prmtApplyCompany.setEnabled(false);
            ChequeUtil.setColumnEnabled(this.tblMain, new String[]{"applier", "department", "applyDate", "ceiling", "usage"}, true);
        }
        this.tblMain.getColumn("ceiling").getStyleAttributes().setLocked(true);
        NTTypeInfo nttype = (NTTypeInfo)this.cmbNttype.getSelectedItem();
        if (nttype.isCommonCheque()) {
            this.tblMain.getColumn("cbIsLine").getStyleAttributes().setLocked(false);
        } else {
            this.tblMain.getColumn("cbIsLine").getStyleAttributes().setLocked(true);
        }
        this.cmbCurrency.setEnabled(cheque.getCurrency() == null);
        for (i = 0; i < this.tblMain.getRowCount3(); ++i) {
            if (this.tblMain.getRow(i).getCell("isOwnReceive").getValue() == null) continue;
            Boolean isOwnRec = Boolean.valueOf(this.tblMain.getRow(i).getCell("isOwnReceive").getValue().toString());
            if (isOwnRec.equals(Boolean.TRUE)) {
                this.tblMain.getRow(i).getCell("payeeBank").getStyleAttributes().setLocked(true);
                this.tblMain.getRow(i).getCell("payeeBankAccount").getStyleAttributes().setLocked(true);
            } else {
                this.tblMain.getRow(i).getCell("payeeBank").getStyleAttributes().setLocked(false);
                this.tblMain.getRow(i).getCell("payeeBankAccount").getStyleAttributes().setLocked(false);
                this.tblMain.getRow(i).getCell("turnInAccount").getStyleAttributes().setLocked(true);
            }
            if (cheque.getUsage() == null) {
                this.tblMain.getRow(i).getCell("usage").getStyleAttributes().setLocked(false);
            }
            ChequeUtil.setColumnEnabled(this.tblMain, new String[]{"usage"}, false);
        }
        for (i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.resetPayeeRelatedComps(i);
        }
    }

    private void updateAmountFiled() {
        CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        if (currency != null) {
            int precision = currency.getPrecision();
            String currencyFormat = RecChequeUtil.getKDTCurrencyFormat(precision);
            String[] fields = new String[]{"reimburseAmount", "ceiling"};
            int l = this.tblMain.getRowCount();
            for (int r = 0; r < l; ++r) {
                IRow row = this.tblMain.getRow(r);
                for (int i = 0; i < fields.length; ++i) {
                    KDTDefaultCellEditor editor = (KDTDefaultCellEditor)this.tblMain.getColumn(fields[i]).getEditor();
                    KDFormattedTextField txt = (KDFormattedTextField)editor.getComponent();
                    txt.setPrecision(precision);
                    ICell cAmount = row.getCell(fields[i]);
                    cAmount.getStyleAttributes().setNumberFormat(currencyFormat);
                }
            }
        }
    }

    @Override
    protected void prmtactualBankAcct_willCommit(CommitEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    @Override
    protected void prmtactualBankAcct_willShow(SelectorEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    private void initPrmtActualBankAcct() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.keepCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtactualBankAcct.setEntityViewInfo(evi);
        Object currencyInfo = this.cmbCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtactualBankAcct.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        this.prmtactualBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtactualBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            AccountBankInfo accout = (AccountBankInfo)this.prmtPayAccoutBank.getData();
            if (accout != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
                this.prmtApplyCompany.setValue((Object)company);
            } else {
                this.prmtApplyCompany.setValue(null);
            }
        } else {
            this.prmtApplyCompany.setValue((Object)this.keepCompany);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "reimburseDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

