/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.DiscountApplyBillFactory;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.DiscountApplyBillStateEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractDiscountApplyBillBatchEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class DiscountApplyBillBatchEditUI
extends AbstractDiscountApplyBillBatchEditUI {
    private static final long serialVersionUID = 369288335366946908L;
    private static final Logger logger = CoreUIObject.getLogger(DiscountApplyBillBatchEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
    private UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private int curCurrencyPrecision = 2;
    private int baseCurrencyPrecision = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.nt.client.DiscountApplyClientResource";
    private IObjectCollection billCollection = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.billCollection = (IObjectCollection)this.getUIContext().get("ReceivableColl");
        super.onLoad();
        this.actionEdit.setVisible(false);
        this.initComponent();
        this.calcComponents(this.billCollection);
        this.fillTable(this.billCollection);
    }

    @Override
    protected IObjectValue createNewData() {
        DiscountApplyBillInfo info = new DiscountApplyBillInfo();
        info.setBizDate(new Timestamp(System.currentTimeMillis()));
        info.setBizValidDateStart(new Timestamp(System.currentTimeMillis()));
        info.setCompany(this.currentCompany);
        info.setCreator(this.userInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setIntRateTypeExp(IntRateTypeExpressionEnum.YEAR);
        info.setDiscountApplyAmt(Constants.ZERO);
        info.setLocalAmount(Constants.ZERO);
        info.setUsedAmt(Constants.ZERO);
        info.setUsedLocalAmt(Constants.ZERO);
        info.setConvertDays(360);
        info.setCurrency(this.baseCurrency);
        info.setIntRateTypeExp(IntRateTypeExpressionEnum.YEAR);
        info.setBillState(DiscountApplyBillStateEnum.SAVED);
        info.setIsWFAudit(false);
        info.setIsGenDiscountBill(false);
        info.setAttachNum(0);
        info.setCU(this.currentCompany.getCU());
        info.setDiscountRate(Constants.ZERO);
        info.setRate(Constants.ONE);
        return info;
    }

    private void initComponent() {
        this.pkbizDate.setSupportedEmpty(false);
        this.txtDiscountApplyAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscountApplyAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtConvertDays.setMinimumValue((Comparable)Constants.ZERO);
        this.txtConvertDays.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtConvertDays.setHorizontalAlignment(4);
        this.txtRate.setHorizontalAlignment(4);
        this.txtDiscountApplyAmt.setHorizontalAlignment(4);
        this.txtLocAmount.setHorizontalAlignment(4);
        this.txtDiscountRate.setHorizontalAlignment(4);
        this.txtDiscountApplyAmt.setRemoveingZeroInDispaly(false);
        this.txtLocAmount.setRemoveingZeroInDispaly(false);
        this.txtRate.setRemoveingZeroInDispaly(false);
    }

    private void calcComponents(IObjectCollection coll) throws Exception {
        ReceivableBillInfo billInfo = (ReceivableBillInfo)coll.getObject(0);
        if (billInfo.getCurrency() != null) {
            this.prmtCurrency.setValue((Object)billInfo.getCurrency());
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            String curCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)billInfo.getCurrency().getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            evi.setFilter(filterInfo);
            this.prmtAccountBank.setEntityViewInfo(evi);
            this.prmtCurrency.setEnabled(false);
        }
        this.comboBillMedium.setSelectedItem((Object)billInfo.getBillMedium());
        this.comboBillMedium.setEnabled(false);
        this.txtDiscountApplyAmt.setPrecision(this.curCurrencyPrecision);
        this.txtLocAmount.setPrecision(this.baseCurrencyPrecision);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        this.comboIntRateTypeExp.removeItem((Object)IntRateTypeExpressionEnum.DAY);
        this.setCostCenterF7();
    }

    private void fillTable(IObjectCollection coll) throws BOSException {
        String disBillId;
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        BigDecimal allBillAmt = Constants.ZERO;
        String numberLocFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.baseCurrencyPrecision);
        if (coll == null && !FMHelper.isEmpty((String)(disBillId = (String)this.getUIContext().get("disBillId")))) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("discountBill", (Object)disBillId));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("currency.*"));
            view.getSelector().add(new SelectorItemInfo("company.*"));
            view.getSelector().add(new SelectorItemInfo("ntType.*"));
            coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        }
        if (coll == null) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tblMain.addRow();
            this.fillDataByVo(coll.getObject(i), row);
            allBillAmt = allBillAmt.add((BigDecimal)row.getCell("billAmt").getValue());
        }
        IRow row = this.tblMain.addRow();
        row.getCell("draftNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("billAmt").setValue((Object)allBillAmt);
        row.getCell("billAmt").getStyleAttributes().setNumberFormat(numberLocFormat_AMT);
        FinHelper.setLockColumn((KDTable)this.tblMain, (String[])new String[]{"draftNumber", "ntType", "billAmt", "expiredDate", "issuesDate", "acceptorName", "holder.name", "bankReturnStatus", "bankReturnMsg", "drawerName"}, (boolean)true);
        this.txtDiscountApplyAmt.setValue((Object)allBillAmt);
        this.txtDiscountApplyAmt.setEnabled(false);
    }

    @Override
    protected void prmtAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAccountBank_dataChanged(e);
        AccountBankInfo accBankInfo = (AccountBankInfo)this.prmtAccountBank.getValue();
        if (accBankInfo == null) {
            this.prmtDiscountBank.setValue(null);
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("account.*");
        sic.add("bank.*");
        sic.add("innerAcct.*");
        accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId()), sic);
        this.prmtDiscountBank.setValue((Object)accBankInfo.getBank());
    }

    @Override
    protected void txtDiscountApplyAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtDiscountApplyAmt_dataChanged(e);
        this.setLocalAmt();
    }

    private void setLocalAmt() {
        if (this.txtRate.getBigDecimalValue() == null || this.txtDiscountApplyAmt.getBigDecimalValue() == null) {
            return;
        }
        this.txtLocAmount.setValue((Object)((BigDecimal)this.txtRate.getValue(BigDecimal.class)).multiply((BigDecimal)this.txtDiscountApplyAmt.getValue(BigDecimal.class)));
    }

    @Override
    protected void txtRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtRate_dataChanged(e);
        this.calcAmt();
    }

    private void calcAmt() {
        BigDecimal rate = this.txtRate.getBigDecimalValue();
        BigDecimal applyAmt = this.txtDiscountApplyAmt.getBigDecimalValue();
        if (rate != null && applyAmt != null) {
            this.txtLocAmount.setValue((Object)applyAmt.multiply(rate));
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currency != null) {
            Date date = this.pkbizDate.getSqlDate();
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.baseCurrency, (java.util.Date)date, null);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            String curCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency));
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", null));
            filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
            evi.setFilter(filterInfo);
            this.prmtAccountBank.setEntityViewInfo(evi);
        }
    }

    @Override
    protected void comboIntRateTypeExp_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExp.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtConvertDays.setValue((Object)new Integer(360));
            this.contdiscountRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"242_DiscountBillBatchEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtConvertDays.setValue((Object)new Integer(30));
            this.contdiscountRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"243_DiscountBillBatchEditUI"));
        }
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("NT031");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    private void fillDataByVo(IObjectValue vo, IRow row) {
        String numberLocFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.baseCurrencyPrecision);
        if (vo instanceof ReceivableBillInfo) {
            ReceivableBillInfo billInfo = (ReceivableBillInfo)vo;
            row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            row.getCell("draftNumber").setValue((Object)billInfo.getDraftNumber());
            row.getCell("ntType").setValue((Object)billInfo.getNtType());
            row.getCell("billAmt").setValue((Object)billInfo.getBillAmt());
            row.getCell("billAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("billAmt").getStyleAttributes().setNumberFormat(numberLocFormat_AMT);
            row.getCell("issuesDate").setValue((Object)billInfo.getIssuesDate());
            row.getCell("expiredDate").setValue((Object)billInfo.getExpiredDate());
            row.getCell("drawerName").setValue((Object)billInfo.getDrawerName());
            row.getCell("acceptorName").setValue((Object)billInfo.getAcceptorName());
            if (billInfo.getHolder() != null) {
                row.getCell("holder.name").setValue((Object)billInfo.getHolder().getName());
            }
            row.getCell("bankReturnStatus").setValue((Object)billInfo.getBankReturnStatus());
            row.getCell("bankReturnMsg").setValue((Object)billInfo.getBankReturnMsg());
            row.getCell("paperBillStatus").setValue((Object)billInfo.getElecBillStatus());
            row.getCell("id").setValue((Object)billInfo.getId());
        }
    }

    private void storeFields(DiscountApplyBillInfo applyBillInfo) {
        applyBillInfo.setNumber(this.txtNumber.getStringValue());
        applyBillInfo.setBizDate((java.util.Date)this.pkbizDate.getValue());
        applyBillInfo.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        applyBillInfo.setRate(this.txtRate.getBigDecimalValue());
        applyBillInfo.setDiscountApplyAmt(this.txtDiscountApplyAmt.getBigDecimalValue());
        applyBillInfo.setLocalAmount(this.txtLocAmount.getBigDecimalValue());
        applyBillInfo.setIntRateTypeExp((IntRateTypeExpressionEnum)this.comboIntRateTypeExp.getSelectedItem());
        applyBillInfo.setConvertDays(this.txtConvertDays.getIntegerValue());
        applyBillInfo.setBillMedium((BillMediumEnum)((Object)this.comboBillMedium.getSelectedItem()));
        applyBillInfo.setAccountBank((AccountBankInfo)this.prmtAccountBank.getValue());
        applyBillInfo.setDiscountBank((BankInfo)this.prmtDiscountBank.getValue());
        applyBillInfo.setDigest(this.txtDigest.getStringValue());
        applyBillInfo.setCreator(this.userInfo);
        applyBillInfo.setCostCenter((CostCenterOrgUnitInfo)this.prmtCostCenter.getValue());
        applyBillInfo.setCompany(this.currentCompany);
        applyBillInfo.setAuditor(null);
        applyBillInfo.setDiscountRate(this.txtDiscountRate.getBigDecimalValue());
        String billNumber = "";
        BigDecimal amt = Constants.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            ReceivableBillInfo receivableInfo = this.getReceivableBill(row.getCell("id").getValue().toString());
            if (receivableInfo == null) continue;
            applyBillInfo.getReceivableEntrys().add(receivableInfo);
            billNumber = billNumber + receivableInfo.getDraftNumber() + ",";
            amt = amt.add(receivableInfo.getBillAmt());
        }
        billNumber = billNumber.substring(0, billNumber.length() - 1);
        applyBillInfo.setDraftNumber(billNumber);
        applyBillInfo.setLocalAmount(amt);
    }

    private ReceivableBillInfo getReceivableBill(String id) {
        ReceivableBillInfo info = null;
        for (ReceivableBillInfo element : this.billCollection) {
            if (!id.equals(element.getId().toString())) continue;
            info = element;
        }
        return info;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doBizVerify();
        DiscountApplyBillInfo applyBillInfo = this.editData;
        this.storeFields(applyBillInfo);
        DiscountApplyBillFactory.getRemoteInstance().submit((CoreBaseInfo)applyBillInfo);
        this.initOldData((IObjectValue)this.editData);
        this.getUIWindow().close();
    }

    private void doBizVerify() {
        if (this.txtDiscountRate.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"3_DicountRate_Error"));
            this.txtDiscountRate.requestFocus();
            SysUtil.abort();
        }
    }

    public boolean destroyWindow() {
        if (!EmptyUtil.isEmpty((Object)this.billCollection)) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            for (int i = 0; i < this.billCollection.size(); ++i) {
                iMutex.releaseObjIDForUpdate(((ReceivableBillInfo)this.billCollection.getObject(i)).getId().toString());
            }
        }
        return super.destroyWindow();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    protected KDTable getDetailTable() {
        return null;
    }
}

