/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.nt.DiscountApplyBillCollection;
import com.kingdee.eas.fm.nt.DiscountApplyBillFactory;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.DiscountApplyBillStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractDiscountApplyBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscountApplyBillEditUI
extends AbstractDiscountApplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DiscountApplyBillEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
    private UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private int curCurrencyPrecision = 2;
    private int baseCurrencyPrecision = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.nt.client.DiscountApplyClientResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponent();
        this.calcComponents();
    }

    private void initComponent() {
        this.pkbizDate.setSupportedEmpty(false);
        this.pkbizValidDateStart.setSupportedEmpty(false);
        this.txtDiscountApplyAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscountApplyAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtConvertDays.setMinimumValue((Comparable)Constants.ZERO);
        this.txtConvertDays.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtDiscountRate.setPrecision(5);
        this.txtDiscountRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscountRate.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtConvertDays.setHorizontalAlignment(4);
        this.txtDiscountRate.setHorizontalAlignment(4);
        this.txtRate.setHorizontalAlignment(4);
        this.txtDiscountApplyAmt.setHorizontalAlignment(4);
        this.txtLocAmount.setHorizontalAlignment(4);
        this.txtUsedAmt.setHorizontalAlignment(4);
        this.txtUsedLocalAmt.setHorizontalAlignment(4);
        this.txtDiscountApplyAmt.setRemoveingZeroInDispaly(false);
        this.txtLocAmount.setRemoveingZeroInDispaly(false);
        this.txtUsedAmt.setRemoveingZeroInDispaly(false);
        this.txtUsedLocalAmt.setRemoveingZeroInDispaly(false);
        this.txtRate.setRemoveingZeroInDispaly(false);
        this.txtDiscountRate.setRemoveingZeroInDispaly(false);
    }

    @Override
    protected IObjectValue createNewData() {
        DiscountApplyBillInfo info = new DiscountApplyBillInfo();
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            try {
                DiscountApplyBillInfo oldInfo = (DiscountApplyBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                info = oldInfo.copy();
                info.setCompany(this.currentCompany);
                info.setCreator(this.userInfo);
                info.setCU(this.currentCompany.getCU());
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        } else {
            info.setBizDate(new Timestamp(System.currentTimeMillis()));
            info.setBizValidDateStart(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()));
            info.setCompany(this.currentCompany);
            info.setCreator(this.userInfo);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setIntRateTypeExp(IntRateTypeExpressionEnum.YEAR);
            info.setDiscountApplyAmt(Constants.ZERO);
            info.setLocalAmount(Constants.ZERO);
            info.setUsedAmt(Constants.ZERO);
            info.setUsedLocalAmt(Constants.ZERO);
            info.setConvertDays(360);
            info.setCurrency(this.baseCurrency);
            info.setIntRateTypeExp(IntRateTypeExpressionEnum.YEAR);
            info.setBillState(DiscountApplyBillStateEnum.SAVED);
            info.setIsWFAudit(false);
            info.setIsGenDiscountBill(false);
            info.setAttachNum(0);
            info.setCU(this.currentCompany.getCU());
            info.setDiscountRate(Constants.ZERO);
            info.setRate(Constants.ONE);
        }
        return info;
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("NT031");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void calcComponents() throws Exception {
        this.txtDiscountApplyAmt.setPrecision(this.curCurrencyPrecision);
        this.txtLocAmount.setPrecision(this.baseCurrencyPrecision);
        this.txtUsedAmt.setPrecision(this.curCurrencyPrecision);
        this.txtUsedLocalAmt.setPrecision(this.baseCurrencyPrecision);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtDepartment);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtOperator);
        this.comboIntRateTypeExp.removeItem((Object)IntRateTypeExpressionEnum.DAY);
        this.setCostCenterF7();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String curCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
        evi.setFilter(filterInfo);
        this.prmtAccountBank.setEntityViewInfo(evi);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        DiscountApplyBillInfo discountApplyInfo = (DiscountApplyBillInfo)this.getDataObject();
        boolean isSave = discountApplyInfo.getBillState() == DiscountApplyBillStateEnum.SAVED;
        this.actionSave.setVisible(isSave);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DiscountApplyBillFactory.getRemoteInstance();
    }

    @Override
    protected void comboIntRateTypeExp_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExp.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtConvertDays.setValue((Object)new Integer(360));
            this.contdiscountRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"242_DiscountBillBatchEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtConvertDays.setValue((Object)new Integer(30));
            this.contdiscountRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"243_DiscountBillBatchEditUI"));
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currency != null) {
            Date date = this.pkbizDate.getSqlDate();
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.baseCurrency, (java.util.Date)date, null);
        }
    }

    @Override
    protected void prmtAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAccountBank_dataChanged(e);
        AccountBankInfo accBankInfo = (AccountBankInfo)this.prmtAccountBank.getValue();
        if (accBankInfo == null) {
            this.prmtDiscountBank.setValue(null);
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("account.*");
        sic.add("bank.*");
        sic.add("innerAcct.*");
        accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId()), sic);
        this.prmtDiscountBank.setValue((Object)accBankInfo.getBank());
    }

    @Override
    protected void txtDiscountApplyAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtDiscountApplyAmt_dataChanged(e);
        this.setLocalAmt();
    }

    private void setLocalAmt() {
        if (this.txtRate.getBigDecimalValue() == null || this.txtDiscountApplyAmt.getBigDecimalValue() == null) {
            return;
        }
        this.txtLocAmount.setValue((Object)((BigDecimal)this.txtRate.getValue(BigDecimal.class)).multiply((BigDecimal)this.txtDiscountApplyAmt.getValue(BigDecimal.class)));
    }

    @Override
    protected void txtRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtRate_dataChanged(e);
        this.calcAmt();
    }

    private void calcAmt() {
        BigDecimal rate = this.txtRate.getBigDecimalValue();
        BigDecimal applyAmt = this.txtDiscountApplyAmt.getBigDecimalValue();
        BigDecimal usedAmt = this.txtUsedAmt.getBigDecimalValue();
        if (rate != null && applyAmt != null && usedAmt != null) {
            this.txtLocAmount.setValue((Object)applyAmt.multiply(rate));
            this.txtUsedLocalAmt.setValue((Object)usedAmt.multiply(rate));
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doBizVerify();
        super.actionSubmit_actionPerformed(e);
        this.afterSubmitAddNew();
    }

    private void doBizVerify() {
        java.util.Date endDate;
        java.util.Date startDate;
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, null, (KDBizPromptBox)this.prmtCurrency, null);
        if (this.pkbizValidDateEnd.getSqlDate() != null && (startDate = DateTimeUtils.truncateDate((java.util.Date)this.pkbizValidDateStart.getSqlDate())).compareTo(endDate = DateTimeUtils.truncateDate((java.util.Date)this.pkbizValidDateEnd.getSqlDate())) > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"1_ValidDateEnd_Error"));
            this.pkbizValidDateStart.requestFocus();
            SysUtil.abort();
        }
        if (this.txtDiscountApplyAmt.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"2_DiscountApplyAmt_Error"));
            this.txtDiscountApplyAmt.requestFocus();
            SysUtil.abort();
        }
        if (this.txtDiscountRate.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"3_DicountRate_Error"));
            this.txtDiscountRate.requestFocus();
            SysUtil.abort();
        }
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkEdit() throws Exception {
        String id = this.editData.getId().toString();
        if (id != null) {
            DiscountApplyBillInfo info;
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            DiscountApplyBillCollection discountApplyBillCol = this.getDiscountApplyCol(idSet);
            if (discountApplyBillCol != null && discountApplyBillCol.size() != 0 && (info = discountApplyBillCol.get(0)).getBillState() == DiscountApplyBillStateEnum.Audit) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"9_Audited_Bill_Edit_Error", (Object[])new Object[]{info.getNumber()}));
                SysUtil.abort();
            }
        }
    }

    private DiscountApplyBillCollection getDiscountApplyCol(Set idSet) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillCollection(evi);
    }
}

