/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.DiscountBillException;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractDiscountBillEditUI;
import com.kingdee.eas.fm.nt.client.IBotEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.SwingUtilities;

public class DiscountBillEditUI
extends AbstractDiscountBillEditUI
implements IBotEditUI {
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo bassCurrency;

    public DiscountBillEditUI() throws Exception {
        this.txtDiscountRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscountRate.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtDiscountInt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRealDiscountInt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtactRecvAmount.setMinimumValue((Comparable)Constants.ZERO);
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.isBuyerPayInt()) {
            this.txtDiscountRate.setValue((Object)Constants.ZERO);
            this.txtDiscountInt.setValue((Object)Constants.ZERO);
        }
        this.txtDiscountInt.setValue((Object)this.editData.getDiscountInt());
        if ("month".equals(this.editData.getIntRateTypeExp().getValue())) {
            this.contDiscountRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"594_DiscountBillEditUI"));
        }
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgInItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgOutItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgFeeItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[2]);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void setCostCenterF7() {
        CostCenterF7 costCenterF7 = new CostCenterF7((IUIObject)this);
        costCenterF7.disablePerm();
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("CS082");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    @Override
    public void storeFields() {
        super.storeFields();
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgInItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgOutItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgFeeItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[2]);
        super.storeFields();
    }

    @Override
    protected void chkbuyerPayInt_itemStateChanged(ItemEvent e) throws Exception {
        boolean isBuyerPay = this.chkbuyerPayInt.isSelected();
        if (isBuyerPay) {
            this.txtDiscountRate.setEnabled(false);
            this.txtDiscountRate.setValue((Object)Constants.ZERO);
            this.txtDiscountInt.setEnabled(false);
            this.txtDiscountInt.setValue((Object)Constants.ZERO);
            this.txtRealDiscountInt.setEnabled(false);
            this.txtRealDiscountInt.setValue((Object)Constants.ZERO);
        } else {
            this.txtDiscountRate.setEnabled(true);
            this.txtDiscountInt.setEnabled(true);
            this.txtRealDiscountInt.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        this.txtDiscountRate.setPrecision(5);
        this.txtbillAmount.setPrecision(4);
        this.txtactRecvAmount.setPrecision(4);
        this.txtDiscountInt.setPrecision(4);
        this.txtRealDiscountInt.setPrecision(4);
        super.onLoad();
        if (this.editData.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.editData.getCurrency().getId()));
            this.txtbillAmount.setPrecision(currency.getPrecision());
            this.txtactRecvAmount.setPrecision(currency.getPrecision());
            this.txtDiscountInt.setPrecision(currency.getPrecision());
            this.txtRealDiscountInt.setPrecision(currency.getPrecision());
        } else {
            this.txtbillAmount.setPrecision(2);
            this.txtactRecvAmount.setPrecision(2);
            this.txtDiscountInt.setPrecision(2);
            this.txtRealDiscountInt.setPrecision(2);
        }
        this.txtActRecvLocAmount.setDataType(1);
        this.txtDiscountLocInt.setDataType(1);
        this.txtLocAmount.setDataType(1);
        if (this.bassCurrency != null) {
            this.txtActRecvLocAmount.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
            this.txtDiscountLocInt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
            this.txtLocAmount.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
        } else {
            this.txtLocAmount.setPrecision(2);
            this.txtDiscountLocInt.setPrecision(2);
            this.txtActRecvLocAmount.setPrecision(2);
        }
        this.txtbillAmount.setHorizontalAlignment(4);
        this.txtLocAmount.setHorizontalAlignment(4);
        this.txtactRecvAmount.setHorizontalAlignment(4);
        this.txtDiscountInt.setHorizontalAlignment(4);
        this.txtRealDiscountInt.setHorizontalAlignment(4);
        this.txtDiscountRate.setHorizontalAlignment(4);
        this.txtConvertDays.setHorizontalAlignment(4);
        this.txtActRecvLocAmount.setHorizontalAlignment(4);
        this.txtDiscountLocInt.setHorizontalAlignment(4);
        this.txtbillAmount.setRemoveingZeroInDispaly(false);
        this.txtbillAmount.setRemoveingZeroInEdit(true);
        this.txtactRecvAmount.setRemoveingZeroInDispaly(false);
        this.txtactRecvAmount.setRemoveingZeroInEdit(true);
        this.txtDiscountInt.setRemoveingZeroInDispaly(false);
        this.txtDiscountInt.setRemoveingZeroInEdit(true);
        this.txtRealDiscountInt.setRemoveingZeroInDispaly(false);
        this.txtRealDiscountInt.setRemoveingZeroInEdit(true);
        this.txtActRecvLocAmount.setRemoveingZeroInDispaly(false);
        this.txtDiscountLocInt.setRemoveingZeroInDispaly(false);
        this.txtDiscountRate.setRemoveingZeroInDispaly(false);
        this.txtDiscountRate.setRemoveingZeroInEdit(true);
        this.txtactRecvAmount.setValue((Object)this.editData.getActRecvAmount());
        this.txtbillAmount.setValue((Object)this.editData.getBillAmount());
        this.txtDiscountInt.setValue((Object)this.editData.getDiscountInt());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        evi.setFilter(filterInfo);
        this.prmtrecvAccount.setEntityViewInfo(evi);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        this.setCostCenterF7();
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgInItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input}, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgOutItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output}, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgFeeItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgInItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgOutItem, (KDLabelContainer)this.contFundFlowItemRec, (FundFlowDirection)FundFlowDirection.OUT);
    }

    @Override
    protected void txtbillAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.txtactRecvAmount.setValue((Object)this.calcActRecvAmount());
    }

    @Override
    protected void txtDiscountInt_dataChanged(DataChangeEvent e) throws Exception {
        this.txtactRecvAmount.setValue((Object)this.calcActRecvAmount());
    }

    @Override
    protected void txtDiscountRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtactRecvAmount.setValue((Object)this.calcActRecvAmount());
    }

    @Override
    protected void prmtrecvAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo acctInfo = (AccountBankInfo)this.prmtrecvAccount.getValue();
        if (acctInfo == null) {
            this.prmtrecvAccountView.setValue(null);
            this.prmtDiscountBank.setValue(null);
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("account.*");
        sic.add("bank.*");
        acctInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctInfo.getId()), sic);
        this.prmtrecvAccountView.setValue((Object)acctInfo.getAccount());
        this.prmtDiscountBank.setValue((Object)acctInfo.getBank());
    }

    @Override
    protected void pkDiscountDate_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void pkmaturityDate_dataChanged(DataChangeEvent e) throws Exception {
    }

    private BigDecimal calcDiscountInt() {
        BigDecimal inTimeValue = this.txtbillAmount.getBigDecimalValue();
        BigDecimal discountRate = this.txtDiscountRate.getBigDecimalValue();
        Date matDate = (Date)this.pkmaturityDate.getValue();
        Date discountDate = (Date)this.pkDiscountDate.getValue();
        if (inTimeValue != null && discountRate != null && matDate != null && discountDate != null) {
            BigDecimal val = inTimeValue.multiply(discountRate).divide(new BigDecimal("360"), 4);
            long datediff = DateUtil.dateDiff((String)"d", (Date)discountDate, (Date)matDate);
            return val.multiply(new BigDecimal(datediff).abs());
        }
        return this.txtDiscountInt.getBigDecimalValue();
    }

    private BigDecimal calcActRecvAmount() {
        BigDecimal inTimeValue = this.txtbillAmount.getBigDecimalValue();
        BigDecimal discountInt = this.txtRealDiscountInt.getBigDecimalValue();
        if (inTimeValue != null && discountInt != null) {
            return inTimeValue.subtract(discountInt);
        }
        if (inTimeValue != null && discountInt == null) {
            return inTimeValue;
        }
        return this.txtactRecvAmount.getBigDecimalValue();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DiscountBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        return new DiscountBillInfo();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkDiscountDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtnoteBillNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtrecvAccount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkmaturityDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtrecvAccountView);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtDiscountBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtcurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtbillAmount);
        if (!this.chkbuyerPayInt.isSelected()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtDiscountRate);
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtDiscountInt);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtactRecvAmount);
        String srcBillId = this.getSrcBillId();
        if (srcBillId != null) {
            ReceivableBillInfo recvInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(srcBillId));
            Date recvDate = DateUtil.getDayBegin((Date)recvInfo.getTakeDate());
            Date discountDate = DateUtil.getDayBegin((Date)((Date)this.pkDiscountDate.getValue()));
            if (discountDate.before(recvDate)) {
                throw new DiscountBillException(DiscountBillException.DISCOUNTDATEMUSTLATERTHANRECVDATE);
            }
        }
        BigDecimal disInt = this.txtDiscountInt.getBigDecimalValue();
        BigDecimal billAmt = this.txtbillAmount.getBigDecimalValue();
        if (disInt != null && billAmt != null && disInt.compareTo(billAmt) > 0) {
            throw new DiscountBillException(DiscountBillException.DISINTCANNOTMORETHANBILLAMT);
        }
    }

    private String getSrcBillId() {
        return this.editData.getSourceBillId();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add(new SelectorItemInfo("bgInItemID"));
        sic.add(new SelectorItemInfo("bgInItemNumber"));
        sic.add(new SelectorItemInfo("bgInItemName"));
        sic.add(new SelectorItemInfo("bgOutItemID"));
        sic.add(new SelectorItemInfo("bgOutItemNumber"));
        sic.add(new SelectorItemInfo("bgOutItemName"));
        sic.add(new SelectorItemInfo("bgFeeItemID"));
        sic.add(new SelectorItemInfo("bgFeeItemNumber"));
        sic.add(new SelectorItemInfo("bgFeeItemName"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        sic.add(new SelectorItemInfo("discountInBank.*"));
        return sic;
    }

    @Override
    public void initDataObject(IObjectValue objValue) throws Exception {
        DiscountBillInfo billInfo = (DiscountBillInfo)objValue;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        billInfo.setCompany(currentCompany);
        billInfo.setCreator(currentUser);
        billInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        billInfo.setDiscountDate(DateUtil.getDayBegin());
        String srcBillId = billInfo.getSourceBillId();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("deliver.*");
        ReceivableBillInfo recvInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(srcBillId), sic);
        billInfo.setDeliver(recvInfo.getDeliver());
        billInfo.setExRate(recvInfo.getExchangeRate());
        billInfo.setDiscountRate(Constants.ZERO);
        billInfo.setLocalAmount(recvInfo.getNaturalAmt());
        billInfo.setIssureDate(recvInfo.getIssuesDate());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        DataObjectMutex mutextControl = new DataObjectMutex();
        mutextControl.releaseDataObjectLock(this.editData.getSourceBillId());
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        DataObjectMutex mutextControl = new DataObjectMutex();
        mutextControl.releaseDataObjectLock(this.editData.getSourceBillId());
        return b;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.setEnabled(true);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected String getTDFileName() {
        return "/FM/NT/Discount";
    }
}

