/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.EndorseException;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractEndorseNoteBillApproveUI;
import com.kingdee.eas.fm.nt.client.InEndorsementBillEditUI;
import com.kingdee.eas.fm.nt.client.ReceivableBillEditUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;

public class EndorseNoteBillApproveUI
extends AbstractEndorseNoteBillApproveUI {
    private InEndorsementBillEditUI endorEditUI;
    private ReceivableBillEditUI recvEditUI;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEndorseEditUI();
        this.initNoteBillEditUI();
    }

    private void initNoteBillEditUI() throws EASBizException, BOSException {
        String endorId = this.getUIContext().get("ID").toString();
        EndorsementBillInfo endorInfo = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(endorId));
        String noteBillId = endorInfo.getNoteBillId();
        UIContext noteBillUICtx = new UIContext((Object)this);
        noteBillUICtx.put((Object)"Owner", (Object)this);
        noteBillUICtx.put((Object)"ID", (Object)noteBillId);
        this.recvEditUI = (ReceivableBillEditUI)UIFactoryHelper.initUIObject((String)ReceivableBillEditUI.class.getName(), (Map)noteBillUICtx, null, (String)OprtState.VIEW);
        this.scrollPaneNoteBillUI.getViewport().removeAll();
        this.scrollPaneNoteBillUI.getViewport().add((Component)((Object)this.recvEditUI));
        this.scrollPaneNoteBillUI.setHorizontalScrollBarPolicy(30);
        this.scrollPaneNoteBillUI.setVerticalScrollBarPolicy(20);
    }

    private void initEndorseEditUI() throws UIException {
        String endorId = this.getUIContext().get("ID").toString();
        UIContext endorUICtx = new UIContext((Object)this);
        endorUICtx.put((Object)"Owner", (Object)this);
        endorUICtx.put((Object)"ID", (Object)endorId);
        this.endorEditUI = (InEndorsementBillEditUI)UIFactoryHelper.initUIObject((String)InEndorsementBillEditUI.class.getName(), (Map)endorUICtx, null, (String)OprtState.EDIT);
        this.scrollPaneEndoreseUI.getViewport().removeAll();
        this.scrollPaneEndoreseUI.getViewport().add((Component)((Object)this.endorEditUI));
        this.scrollPaneEndoreseUI.setHorizontalScrollBarPolicy(30);
        this.scrollPaneEndoreseUI.setVerticalScrollBarPolicy(20);
    }

    @Override
    public void actionViewEndorseList_actionPerformed(ActionEvent e) throws Exception {
        this.recvEditUI.showEndorseListing();
    }

    @Override
    public void storeFields() {
        if (this.endorEditUI != null) {
            EndorsementBillInfo endBillInfo = (EndorsementBillInfo)this.endorEditUI.getDataObject();
            this.checkBeforeStore(endBillInfo);
            this.endorEditUI.storeFields();
        }
    }

    private void checkBeforeStore(EndorsementBillInfo endBillInfo) {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean bCurCompIsInner = FSClientHelper.isClearingHouseCompanyId((String)currentCompany.getId().toString());
        if (!bCurCompIsInner) {
            return;
        }
        if (endBillInfo.getBankAccount() != null || endBillInfo.getInnerAccount() != null) {
            try {
                boolean dailySettled = EndorseNoteBillApproveUI.isDailySettled(new Date(), currentCompany.getId().toString());
                if (!dailySettled) {
                    throw new EndorseException(EndorseException.DAILYSETTLED);
                }
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    private static boolean isDailySettled(Date date, String companyId) throws EASBizException, BOSException {
        Date setlDate = DateUtil.getDayBegin((Date)FSHelper.getDailySettledDate(null, (String)companyId));
        return !DateUtil.getDayBegin((Date)date).after(setlDate);
    }

    public IObjectValue getDataObject() {
        if (this.endorEditUI != null) {
            return this.endorEditUI.getDataObject();
        }
        return super.getDataObject();
    }
}

