/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.EndorseException;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryFactory;
import com.kingdee.eas.fm.nt.EndorsementBillEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.IEndorsementBill;
import com.kingdee.eas.fm.nt.NTFacadeFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.NtUpgradeFacadeFactory;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractEndorsementBillListUI;
import com.kingdee.eas.fm.nt.client.DraftUpdateStatusListUI;
import com.kingdee.eas.fm.nt.client.EndorsementBillDataProvider;
import com.kingdee.eas.fm.nt.client.EndorsementBillFilterUI;
import com.kingdee.eas.fm.nt.client.InEndorsementBatchEditUI;
import com.kingdee.eas.fm.nt.client.InEndorsementBillEditUI;
import com.kingdee.eas.fm.nt.client.OutEndorsementBatchEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class EndorsementBillListUI
extends AbstractEndorsementBillListUI {
    protected EndorsementBillFilterUI filterUI;
    private CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean isShowEntry = false;
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    public EndorsementBillListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    private void format(String[] columns) {
        String numberFmt = FMClientHelper.getNumberFtm((int)4);
        for (int i = 0; i < columns.length; ++i) {
            IColumn col = this.tblMain.getColumn(this.tblMain.getColumnIndex(columns[i]));
            FMClientHelper.currencyFormat((String)numberFmt, (IColumn)col);
        }
    }

    protected String[] getPrecColName() {
        return new String[]{"endorseAmt", "fee", "billAmt", "endAmt"};
    }

    protected String getCurrencyIdColName() {
        return "CurrencyID";
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected String getEditUIName() {
        return InEndorsementBillEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemVoucher.setVisible(true);
        this.menuItemDelVoucher.setVisible(true);
        this.btnVoucher.setVisible(true);
        this.btnCommitToBE.setVisible(false);
        this.btnDelVoucher.setVisible(true);
        this.btnAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        this.tblMain.getColumn("feeRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
        this.tblMain.getColumn("confirmer.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("confirmDate").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("handler.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankAccount.bankAccountNumber").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("oppAccount").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("cashier").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bgInEnBgItemName").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("fundFlowItem").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("cashier").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("project.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costCenter").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isNoteCancel").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isCommitCancel").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("noteStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("cirStatus").getStyleAttributes().setHided(true);
        this.onshows();
    }

    public void onshows() {
        this.refreshEntry();
        this.tblMain.getColumn("endorseeBankName").setGroup(true);
        this.tblMain.getColumn("endorseeBankName").setMergeable(true);
        this.tblMain.getColumn("nttype").setMergeable(false);
        this.tblMain.getColumn("isCommitToBE").getStyleAttributes().setHided(true);
        this.initForUnion();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionCancelConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.actionCancelEndorse.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelwriteatback"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionUpgrade.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_upgrade"));
        this.actionWorkFlowG.setVisible(true);
        this.actionCommitToBE.setVisible(false);
        this.actionBatchCommitToBE.setVisible(false);
        this.actionSyncBeStatus.setVisible(false);
        this.actionSynForceStatus.setVisible(false);
        this.actionNoteCancle.setVisible(false);
        this.actionEditBeStatus.setVisible(false);
        this.actionReleaseFailedBill.setVisible(false);
        this.actionUpgrade.setEnabled(true);
        this.actionReleaseFailedBill.setVisible(false);
        this.actionReleaseFailedBill.setVisible(false);
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnNavInnerEreceipt.setEnabled(true);
        this.actionBitBack.setVisible(false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EndorsementBillFactory.getRemoteInstance();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        EndorsementBillDataProvider data = new EndorsementBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/EndorsementBill", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        EndorsementBillDataProvider data = new EndorsementBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/EndorsementBill", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        EndorsementBillInfo info = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(id));
        String editUIClass = info.getBillType() == EndorsementTypeEnum.IN ? InEndorsementBatchEditUI.class.getName() : OutEndorsementBatchEditUI.class.getName();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        uiCtx.put((Object)"EndorseId", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIClass, (Map)uiCtx, null, OprtState.VIEW);
        editUI.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String editUIClass;
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        EndorsementBillInfo info = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getBillType() == EndorsementTypeEnum.IN) {
            editUIClass = InEndorsementBatchEditUI.class.getName();
        } else {
            if (!FMHelper.isEmpty((String)info.getLinkbillId())) {
                throw new EndorseException(EndorseException.NOTEDIT);
            }
            editUIClass = OutEndorsementBatchEditUI.class.getName();
        }
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        uiCtx.put((Object)"EndorseId", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIClass, (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
        this.refresh(e);
    }

    @Override
    public void actionCancelEndorse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        EndorsementBillInfo endorseBill = ((IEndorsementBill)this.getBizInterface()).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (endorseBill.getState() != EndorseStateEnum.Submit || endorseBill.isFiVouchered() || endorseBill.isIsCommitToBE() && (!endorseBill.isIsCommitToBE() || !this.isBEAllFail(endorseBill, true))) {
            this.refreshList();
            SysUtil.abort();
        }
        EndorsementBillFactory.getRemoteInstance().cancelEndorse(BOSUuid.read((String)pk), false);
        this.refreshList();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        EndorsementBillInfo info;
        int i;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("fromCompany"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("rpBillId"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        ev.setSelector(sic);
        ev.setFilter(filterInfo);
        EndorsementBillCollection endorseColl = EndorsementBillFactory.getRemoteInstance().getEndorsementBillCollection(ev);
        StringBuffer errMsg = new StringBuffer();
        String RES_PATH = "com.kingdee.eas.fm.nt.EndorseException";
        for (i = 0; i < endorseColl.size(); ++i) {
            info = endorseColl.get(i);
            if (info.isFiVouchered()) {
                errMsg.append(info.getNumber() + ": " + EASResource.getString((String)RES_PATH, (String)"CannotVoucherTwice"));
                errMsg.append("\r\n");
            }
            if (!info.getFromCompany().getId().equals((Object)this.curCompany.getId())) {
                errMsg.append(info.getNumber() + ": " + EASResource.getString((String)RES_PATH, (String)"NoneSelfBillCannotVoucher"));
                errMsg.append("\r\n");
            }
            if (info.getBillType().equals((Object)EndorsementTypeEnum.IN) && info.getState().equals((Object)EndorseStateEnum.Save)) {
                errMsg.append(info.getNumber() + ": " + EASResource.getString((String)RES_PATH, (String)"ONLY_SAVE_BILL_CANOT_VOUCHER"));
                errMsg.append("\r\n");
            }
            if (info.getBillType().equals((Object)EndorsementTypeEnum.OUT) && (info.getState().equals((Object)EndorseStateEnum.Save) || info.getState().equals((Object)EndorseStateEnum.Confirmed))) {
                errMsg.append(info.getNumber() + ": " + EASResource.getString((String)RES_PATH, (String)"ONLY_SAVE_BILL_CANOT_VOUCHER"));
                errMsg.append("\r\n");
            }
            if (EmptyUtil.isEmpty((String)info.getRpBillId())) continue;
            errMsg.append(info.getNumber() + ": " + EASResource.getString((String)NTP_RES, (String)"hasGenPayment"));
            errMsg.append("\r\n");
        }
        if (!EmptyUtil.isEmpty((String)errMsg.toString())) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)NTP_RES, (String)"canNotVoucher"), (String)errMsg.toString(), (int)0);
            this.abort();
        } else {
            super.actionVoucher_actionPerformed(e);
            for (i = 0; i < endorseColl.size(); ++i) {
                info = endorseColl.get(i);
                IObjectPK pks = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"253_EndorsementBillListUI"), (BOSObjectType)new EndorsementBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)"nt_Endorsement_voucher");
                LogUtil.afterLog(null, (IObjectPK)pks);
            }
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        EndorsementBillInfo sourceBill = ((IEndorsementBill)this.getBizInterface()).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        IObjectPK pks = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"254_EndorsementBillListUI"), (BOSObjectType)new EndorsementBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"nt_Endorsement_Delvoucher");
        super.actionDelVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pks);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new EndorsementBillFilterUI(BillSourceEnum.BYHAND);
        }
        return this.filterUI;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        return sic;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("endorsedCompany.*"));
        sic.add(new SelectorItemInfo("confirmer.*"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("accountant.*"));
        sic.add(new SelectorItemInfo("innerAccount.*"));
        sic.add(new SelectorItemInfo("endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("fromCompany.*"));
        sic.add(new SelectorItemInfo("deliver.*"));
        sic.add(new SelectorItemInfo("endorsedCustomer.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.company.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.payee.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.payeeBank.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.payeeAccount.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.drawer.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.drawerAccount.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.acceptanceBank.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.deliver.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.currency.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.bankAccount.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.innerAccount.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.ntType.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.accountant.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.trusteeBank.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.trusteeCompany.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.notifyCompany.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.drawerSupp.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.acceptanceCust.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.acceptanceSupp.*"));
        return sic;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        boolean isRevEndorsement;
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.curCompany)) {
            return;
        }
        this.actionCancelEndorse.setEnabled(true);
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        EndorsementBillInfo sourceBill = ((IEndorsementBill)this.getBizInterface()).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), this.getSelectors());
        this.actionBook.setEnabled(sourceBill.getCashier() == null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && sourceBill.getBillType().equals((Object)EndorsementTypeEnum.IN));
        boolean isAudit = NTHelper.getParam4Boolean(null, "NT019", this.curCompany);
        if (isAudit) {
            this.actionCommitToBE.setEnabled(false);
            this.actionBatchCommitToBE.setEnabled(false);
            if (sourceBill.getState() == EndorseStateEnum.Confirmed) {
                this.actionAudit.setEnabled(false);
                this.actionUnAudit.setEnabled(false);
            } else if (sourceBill.getState() == EndorseStateEnum.Audited) {
                this.actionAudit.setEnabled(false);
                this.actionUnAudit.setEnabled(!sourceBill.isIsCommitToBE());
                this.actionCommitToBE.setEnabled(sourceBill.getBillMedium() == BillMediumEnum.ELECTRONIC && !sourceBill.isIsCommitToBE());
                this.actionBatchCommitToBE.setEnabled(sourceBill.getBillMedium() == BillMediumEnum.ELECTRONIC && !sourceBill.isIsCommitToBE());
            } else {
                this.actionAudit.setEnabled(true);
                this.actionUnAudit.setEnabled(false);
                this.actionBook.setEnabled(false);
            }
        } else {
            this.actionAudit.setEnabled(false);
            this.actionCommitToBE.setEnabled(false);
            this.actionBatchCommitToBE.setEnabled(false);
            if (sourceBill.getState() == EndorseStateEnum.Audited) {
                this.actionUnAudit.setEnabled(true);
            } else {
                this.actionUnAudit.setEnabled(false);
                this.actionCommitToBE.setEnabled(sourceBill.getBillMedium() == BillMediumEnum.ELECTRONIC && !sourceBill.isIsCommitToBE());
                this.actionBatchCommitToBE.setEnabled(sourceBill.getBillMedium() == BillMediumEnum.ELECTRONIC && !sourceBill.isIsCommitToBE());
            }
        }
        String curCompanyId = this.curCompany.getId().toString();
        boolean bl = isRevEndorsement = sourceBill.getFromCompany() != null && !sourceBill.getFromCompany().getId().toString().equals(curCompanyId);
        if (isRevEndorsement) {
            boolean isFromAudit;
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionViewDoProccess.setEnabled(false);
            this.actionAuditResult.setEnabled(false);
            this.actionCancelEndorse.setEnabled(false);
            this.actionTraceDown.setEnabled(false);
            this.actionTraceUp.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
            this.actionGenPayment.setEnabled(false);
            if (sourceBill.getBillType() == EndorsementTypeEnum.IN) {
                this.actionViewBgBalance.setEnabled(false);
            }
            if ((isFromAudit = NTHelper.getParam4Boolean(null, "NT019", sourceBill.getFromCompany())) && sourceBill.getState().getValue() == 1) {
                this.actionConfirm.setEnabled(false);
            }
        } else {
            if (sourceBill.isIsCommitToBE()) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
            }
            this.actionVoucher.setEnabled(FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !sourceBill.isFiVouchered());
            this.actionDelVoucher.setEnabled(sourceBill.isFiVouchered());
            this.actionViewDoProccess.setEnabled(true);
            this.actionAuditResult.setEnabled(true);
            if (sourceBill.getState() == EndorseStateEnum.Submit) {
                this.actionCancelEndorse.setEnabled(!sourceBill.isFiVouchered() && (!sourceBill.isIsCommitToBE() || sourceBill.isIsCommitToBE() && this.isBEAllFail(sourceBill, true)));
            } else {
                this.actionCancelEndorse.setEnabled(false);
            }
            this.actionTraceDown.setEnabled(true);
            this.actionTraceUp.setEnabled(true);
            this.actionViewBgBalance.setEnabled(true);
            this.actionEdit.setEnabled(FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !sourceBill.isFiVouchered() && FMHelper.isEmpty((CoreBaseInfo)sourceBill.getCashier()) && !sourceBill.isIsCommitToBE());
            this.actionEdit.setEnabled(!sourceBill.getState().equals((Object)EndorseStateEnum.Confirmed) && !sourceBill.isIsCommitToBE());
        }
        boolean isAllowConfirm = sourceBill.getEndorsedCompany() != null && sourceBill.getEndorsedCompany().getId().toString().equals(curCompanyId) && (sourceBill.getState() == EndorseStateEnum.Audited || sourceBill.getState() == EndorseStateEnum.Submit);
        this.actionConfirm.setEnabled(isAllowConfirm);
        boolean isFromAudit = NTHelper.getParam4Boolean(null, "NT019", sourceBill.getFromCompany());
        if (isFromAudit && sourceBill.getState().getValue() == 1) {
            this.actionConfirm.setEnabled(false);
        }
        boolean isAllowCancelConfirm = sourceBill.getState() == EndorseStateEnum.Confirmed;
        this.actionCancelConfirm.setEnabled(isAllowCancelConfirm);
        if (sourceBill.getState() == EndorseStateEnum.Audited) {
            this.actionEdit.setEnabled(false);
        }
        this.actionCancelBook.setEnabled(sourceBill.getBillType() == EndorsementTypeEnum.IN && sourceBill.getCashier() != null && FMHelper.isEmpty((String)sourceBill.getRpBillId()));
        this.btnWorkFlowG.setEnabled(true);
        if (this.actionUnAudit.isEnabled()) {
            EndorsementBillEntryInfo endorseEntryInfo = null;
            Iterator resCol = sourceBill.getEntrys().iterator();
            while (resCol.hasNext()) {
                endorseEntryInfo = (EndorsementBillEntryInfo)resCol.next();
                if (endorseEntryInfo.getReceivableBill().getBillState() != BillStateEnum.ABANDON) continue;
                this.actionUnAudit.setEnabled(false);
                break;
            }
        }
        boolean canRelease = false;
        if (sourceBill.isIsCommitToBE() && !this.isBEAllFail(sourceBill, true) && this.existBEFail(sourceBill)) {
            canRelease = true;
        }
        this.actionSyncBeStatus.setEnabled(sourceBill.isIsCommitToBE() && this.existProcessing(sourceBill));
        this.actionSynForceStatus.setEnabled(sourceBill.isIsCommitToBE() && this.existProcessing(sourceBill));
        this.actionNoteCancle.setEnabled(sourceBill.isIsCommitToBE());
        this.actionEditBeStatus.setEnabled(sourceBill.isIsCommitToBE() && this.existBEException(sourceBill));
        this.actionReleaseFailedBill.setEnabled(canRelease);
    }

    private boolean existBEFail(EndorsementBillInfo info) {
        boolean exist = false;
        EndorsementBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo endorsementBillEntryInfo = entrys.get(i);
            if (endorsementBillEntryInfo.getBankReturnStatus() == null || endorsementBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.COMMIT_FAIL && endorsementBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_FAIL) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean existProcessing(EndorsementBillInfo info) {
        boolean exist = false;
        EndorsementBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() == null || entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION && entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_PROCESSING && entry.getBankReturnStatus() != BankReturnStatusEnum.EB_PROCESSING) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean existBEException(EndorsementBillInfo info) {
        boolean exist = false;
        EndorsementBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo endorsementBillEntryInfo = entrys.get(i);
            if (endorsementBillEntryInfo.getBankReturnStatus() == null || endorsementBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean isBEAllFail(EndorsementBillInfo sourceBill, boolean rejected) {
        boolean flg = true;
        EndorsementBillEntryCollection entrys = sourceBill.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo endorsementBillEntryInfo = entrys.get(i);
            if (endorsementBillEntryInfo.getBankReturnStatus() != null) {
                if (rejected) {
                    if (endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    flg = false;
                    break;
                }
                if (endorsementBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) continue;
                flg = false;
                break;
            }
            flg = false;
            break;
        }
        return flg;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FilterInfo filter = param.getFilter();
        for (FilterItemInfo filterItem : filter.getFilterItems()) {
            Object obj;
            if (filterItem == null || filterItem.getPropertyName() == null || !"entrys.seq".equals(filterItem.getPropertyName()) || !((obj = filterItem.getCompareValue()) instanceof Integer)) continue;
            Integer cpInte = (Integer)obj;
            if (cpInte == 1) {
                this.isIsShowEntry(false);
                continue;
            }
            if (cpInte != 0) continue;
            this.isIsShowEntry(true);
        }
        super.executeQuery(param);
    }

    public boolean isIsShowEntry() {
        return this.isShowEntry;
    }

    public void isIsShowEntry(boolean isShowEntry) {
        this.isShowEntry = isShowEntry;
    }

    protected void refreshEntry() {
        String[] hideEntryRows = new String[]{"noteBillNumber", "nttype", "billAmt", "takeDate", "deliverName", "issuesDate", "expiredDate", "acceptanceBankName", "elecBillStatus", "bankReturnStatus", "bankReturnMsg", "isCommitCancel", "isNoteCancel"};
        int n = hideEntryRows.length;
        for (int i = 0; i < n; ++i) {
            if (this.tblMain.getColumn(hideEntryRows[i]) == null) continue;
            this.tblMain.getColumn(hideEntryRows[i]).getStyleAttributes().setHided(!this.isShowEntry);
        }
        this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isCommitCancel").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isNoteCancel").getStyleAttributes().setHided(true);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refreshEntry();
    }

    protected void execQuery() {
        FilterInfo filter;
        if (this.getBOTPViewStatus() == 1) {
            filter = NTHelper.mergeFilter4RPCreateFrom(this.curCompany, this.getUIContext(), "PaymentBill");
            if (filter != null) {
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0), CompareType.NOTEQUALS));
            if (filter != null) {
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        if (this.isShowEntry) {
            SorterItemInfo sorterType = new SorterItemInfo("NTTYPE.NAME");
            sorterType.setSortType(SortType.ASCEND);
            this.mainQuery.getSorter().add(sorterType);
        }
        SorterItemInfo sorterId = new SorterItemInfo("ID");
        this.mainQuery.getSorter().add(sorterId);
        sorterId.setSortType(SortType.ASCEND);
        super.execQuery();
        this.onshows();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        for (int i = 0; i < this.getPrecColName().length; ++i) {
            this.tblMain.getFootRow(0).getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
        }
        return row;
    }

    @Override
    public void actionCancelConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EndorsementBillFactory.getRemoteInstance().cancelConfirm(this.getSelectedKeyValue());
        EndorsementBillInfo info = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getSelectors());
        if (info != null) {
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)info.getEndorseDate());
        }
        this.refreshList();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.client.EndorseResource.CancelConfirmSuccess"));
        this.showMessage();
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId != null) {
                String[] formatCol = this.getPrecColName();
                for (int j = 0; j < formatCol.length; ++j) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
                }
            }
            if (row.getCell("rpbillid").getValue() != null) {
                row.getCell("rpbillid").setValue((Object)new Boolean(true));
                continue;
            }
            row.getCell("rpbillid").setValue((Object)new Boolean(false));
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        uiCtx.put((Object)"isFromWorkflow", (Object)new Boolean(true));
        uiCtx.put((Object)"endorseBillId", (Object)BOSUuid.read((String)id));
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InEndorsementBatchEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
        this.refreshList();
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)this.getSelectedKeyValue());
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().bookJouranl(id, "com.kingdee.eas.fm.nt.app.EndorseBillBookNotifyBuilder");
        this.refreshList();
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().cancelBookJouranl(id);
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)idList);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            EndorsementBillFactory.getRemoteInstance().batchAudit(new HashSet(idList));
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"255_EndorsementBillListUI"));
        this.refresh(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)idList);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            EndorsementBillFactory.getRemoteInstance().batchUnAudit(new HashSet(idList));
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"256_EndorsementBillListUI"));
        this.refresh(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCommitToBE_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                EndorsementBillInfo info;
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if ((info = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors())).isIsCommitToBE() && EndorsementBillListUI.existBEProcessing(info.getEntrys())) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"012_BE_PROCESSING_WAITING"));
                    SysUtil.abort();
                }
                int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
                boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
                if (EBSstatus != 1 || !isContain) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                    SysUtil.abort();
                }
                EndorsementBillFactory.getRemoteInstance().commitToBE((IObjectPK)new ObjectUuidPK(id));
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"044_COMMITTOBE_SUCCESS"));
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    private List getSelectedRows() {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        IBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                rows.add(row);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBatchCommitToBE_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashMap<Object, Object> numberMap = new HashMap<Object, Object>();
        List rows = this.getSelectedRows();
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            String id = (String)row.getCell("id").getValue();
            numberMap.put(row.getCell(this.getKeyFieldName()).getValue(), row.getCell("noteBillNumber").getValue());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        HashSet<String> idSet = new HashSet<String>();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            ArrayList<BankPayResult> resultLockList = new ArrayList<BankPayResult>();
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) {
                    BankPayResult resultInfo = new BankPayResult();
                    resultInfo.setId(idList.get(i).toString());
                    resultInfo.setNumber((String)numberMap.get(idList.get(i)));
                    resultInfo.setErrorDetail("\u5355\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01");
                    resultLockList.add(resultInfo);
                    continue;
                }
                idSet.add(idList.get(i).toString());
            }
            if (idSet.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"602_EndorsementBillListUI"));
                SysUtil.abort();
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entrys.*"));
            evi.setSelector(sic);
            EndorsementBillCollection endorseColl = EndorsementBillFactory.getRemoteInstance().getEndorsementBillCollection(evi);
            HashSet<String> canCommitIdSet = new HashSet<String>();
            boolean isAudit = NTHelper.getParam4Boolean(null, "NT019", this.curCompany);
            int count = endorseColl.size();
            for (int i = 0; i < count; ++i) {
                BankPayResult resultInfo;
                EndorsementBillInfo endorInfo = endorseColl.get(i);
                if (endorInfo.getState() != EndorseStateEnum.Audited && isAudit) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(endorInfo.getId().toString());
                    resultInfo.setNumber(endorInfo.getNumber());
                    resultInfo.setErrorDetail("\u5df2\u5ba1\u6279\u7684\u80cc\u4e66\u5355\u624d\u53ef\u4ee5\u63d0\u4ea4\u94f6\u4f01\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (endorInfo.isIsCommitToBE() && EndorsementBillListUI.existBEProcessing(endorInfo.getEntrys())) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(endorInfo.getId().toString());
                    resultInfo.setNumber(endorInfo.getNumber());
                    resultInfo.setErrorDetail("\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (endorInfo.isIsCommitToBE()) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(endorInfo.getId().toString());
                    resultInfo.setNumber(endorInfo.getNumber());
                    resultInfo.setErrorDetail("\u5df2\u63d0\u4ea4\u94f6\u4f01\u7684\u80cc\u4e66\u5355\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                canCommitIdSet.add(endorInfo.getId().toString());
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            ArrayList commitResult = EndorsementBillFactory.getRemoteInstance().batchCommitToBE(canCommitIdSet);
            commitResult.addAll(resultLockList);
            if (commitResult.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"044_COMMITTOBE_SUCCESS"));
            } else {
                StringBuffer errorDetail = new StringBuffer();
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"606_EndorsementBillListUI"));
                for (int j = 0; j < commitResult.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)commitResult.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    errorDetail.append(resultInfo.getNumber()).append(":  ");
                    errorDetail.append(resultInfo.getErrorDetail());
                    errorDetail.append("\n");
                }
                int all = idList.size();
                int error = commitResult.size();
                BigDecimal succ = new BigDecimal(all).subtract(new BigDecimal(error));
                MsgBox.showDetailAndOK(null, (String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"607_EndorsementBillListUI") + succ + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean") + error + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"608_EndorsementBillListUI")), (String)errorDetail.toString(), (int)0);
            }
        }
        finally {
            ArrayList list = new ArrayList(idSet);
            iMutex.batchReleaseObjIDForUpdate(list);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashMap<Object, Object> numberMap = new HashMap<Object, Object>();
        List rows = this.getSelectedRows();
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            numberMap.put(row.getCell(this.getKeyFieldName()).getValue(), row.getCell("noteBillNumber").getValue());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        HashSet idSet = new HashSet();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            ArrayList<BankPayResult> resultLockList = new ArrayList<BankPayResult>();
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) {
                    BankPayResult resultInfo = new BankPayResult();
                    resultInfo.setId(idList.get(i).toString());
                    resultInfo.setNumber((String)numberMap.get(idList.get(i)));
                    resultInfo.setErrorDetail("\u5355\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u6253\u56de");
                    resultLockList.add(resultInfo);
                    continue;
                }
                idSet.add(idList.get(i));
            }
            if (idSet.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"610_EndorsementBillListUI"));
                SysUtil.abort();
            }
            ArrayList commitResult = EndorsementBillFactory.getRemoteInstance().bitBack(idSet);
            commitResult.addAll(resultLockList);
            if (commitResult.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"611_EndorsementBillListUI"));
            } else {
                StringBuffer errorDetail = new StringBuffer();
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"606_EndorsementBillListUI"));
                for (int j = 0; j < commitResult.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)commitResult.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    errorDetail.append(resultInfo.getNumber()).append(":  ");
                    errorDetail.append(resultInfo.getErrorDetail());
                    errorDetail.append("\n");
                }
                int all = idList.size();
                int error = commitResult.size();
                BigDecimal succ = new BigDecimal(all).subtract(new BigDecimal(error));
                MsgBox.showDetailAndOK(null, (String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"612_EndorsementBillListUI") + succ + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean") + error + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"608_EndorsementBillListUI")), (String)errorDetail.toString(), (int)0);
            }
        }
        finally {
            ArrayList list = new ArrayList(idSet);
            iMutex.batchReleaseObjIDForUpdate(list);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSyncBeStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (boolResult.booleanValue()) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            IEndorsementBill iEndorsementBill = EndorsementBillFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            selectors.add("isCommitToBE");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            view.setSelector(selectors);
            EndorsementBillCollection colls = iEndorsementBill.getEndorsementBillCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                EndorsementBillInfo info = colls.get(i);
                if (info.isIsCommitToBE()) continue;
                MsgBox.showInfo((String)(info.getNumber() + EASResource.getString((String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            BatchExecuteResult result = (BatchExecuteResult)iEndorsementBill.syncBeStatus(idSet);
            NTPHelper.showActionResult((Component)((Object)this), result);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate((List)idList);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSynForceStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean is = false;
        try {
            is = iMutex.requestBizObjIDForUpdate("endorse");
            if (!is) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"613_EndorsementBillListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            IEndorsementBill iEndorsementBill = EndorsementBillFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            selectors.add("isCommitToBE");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            view.setSelector(selectors);
            EndorsementBillCollection colls = iEndorsementBill.getEndorsementBillCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                EndorsementBillInfo info = colls.get(i);
                if (info.isIsCommitToBE()) continue;
                MsgBox.showInfo((String)(info.getNumber() + EASResource.getString((String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            BatchExecuteResult result = (BatchExecuteResult)iEndorsementBill.syncBeForceStatus(idSet);
            NTPHelper.showActionResult((Component)((Object)this), result);
        }
        finally {
            if (is) {
                iMutex.releaseObjIDForUpdate("endorse");
            }
        }
        this.refreshList();
    }

    @Override
    public void actionNoteCancle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIDs = this.getSelectedIdValues();
        ArrayList entryIdList = this.getSelectedEntryIdValues();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        BatchExecuteResult result = (BatchExecuteResult)EndorsementBillFactory.getRemoteInstance().noteCancles(selectedIDs, new HashSet(entryIdList));
        NTPHelper.showActionResult((Component)((Object)this), result);
        this.refreshList();
    }

    private EndorsementBillEntryCollection getEndorseBillEntryColl(ArrayList idList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("parent.isCommitToBE"));
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.draftNumber"));
        sic.add(new SelectorItemInfo("receivableBill.holderAccount.*"));
        view.setSelector(sic);
        EndorsementBillEntryCollection coll = EndorsementBillEntryFactory.getRemoteInstance().getEndorsementBillEntryCollection(view);
        return coll;
    }

    @Override
    public void actionEditBeStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        EndorsementBillCollection coll = this.getEndorsementBillColl(idSet);
        if (!this.existBEException(coll)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"597_DiscountBillListUI"));
            SysUtil.abort();
        }
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", this.getBEExceptionColl(coll));
        String uiName = DraftUpdateStatusListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        List<Map<String, Object>> statusList = ((DraftUpdateStatusListUI)uiWindow.getUIObject()).getStatusList();
        if (statusList == null) {
            return;
        }
        BatchExecuteResult result = (BatchExecuteResult)EndorsementBillFactory.getRemoteInstance().updateEntryStatus(idList, statusList);
        NTPHelper.showActionResult((Component)((Object)this), result);
        this.refreshList();
    }

    private EndorsementBillCollection getEndorsementBillColl(Set idSet) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.setSelector(sic);
        EndorsementBillCollection coll = ((IEndorsementBill)this.getBizInterface()).getEndorsementBillCollection(view);
        return coll;
    }

    private boolean existBEException(EndorsementBillCollection coll) {
        EndorsementBillInfo info;
        boolean exist = false;
        for (int i = 0; i < coll.size() && !(exist = this.existBEException(info = coll.get(i))); ++i) {
        }
        return exist;
    }

    private List<Map<String, Object>> getBEExceptionColl(EndorsementBillCollection coll) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < coll.size(); ++i) {
            EndorsementBillInfo endorsementBillInfo = coll.get(i);
            EndorsementBillEntryCollection entrys = endorsementBillInfo.getEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                EndorsementBillEntryInfo entryInfo = entrys.get(j);
                if (entryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", entryInfo.getId().toString());
                map.put("draftNumber", entryInfo.getReceivableBill().getDraftNumber());
                list.add(map);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionReleaseFailedBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                EndorsementBillInfo info;
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if ((info = EndorsementBillFactory.getRemoteInstance().getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(id))).isIsCommitToBE() && !this.isBEAllFail(info, true) && this.existBEFail(info)) {
                    int failCnt = EndorsementBillFactory.getRemoteInstance().releaseFailedBill((IObjectPK)new ObjectUuidPK(id));
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"066_RELEASEFAILEDBILL_RESULT", (Object[])new String[]{String.valueOf(failCnt)}));
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"013_CONDITION_CAN_RELEASE"));
                    SysUtil.abort();
                }
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        String amtColumn = "endorseAmt";
        if (id == null) {
            return;
        }
        if (this.isIsShowEntry()) {
            amtColumn = "billAmt";
        }
        String msg = FMClientHelper.sumList((KDTable)this.tblMain, (String)"endorsementBill", (String)amtColumn);
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "noteBillNumber"};
        return locateNames;
    }

    public static boolean existBEProcessing(EndorsementBillEntryCollection entrys) {
        boolean exist = false;
        for (int i = 0; i < entrys.size(); ++i) {
            EndorsementBillEntryInfo endorsementBillEntryInfo = entrys.get(i);
            if (endorsementBillEntryInfo.getBankReturnStatus() != null && !endorsementBillEntryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.EB_PROCESSING) && !endorsementBillEntryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_PROCESSING) && !endorsementBillEntryInfo.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_EXCEPTION)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static boolean isBEAllProcessed(ReceivableBillCollection entrys) {
        boolean isProcessed = true;
        for (int i = 0; i < entrys.size(); ++i) {
            ReceivableBillInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() != null && (entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_SUCCESS) || entry.getBankReturnStatus().equals((Object)BankReturnStatusEnum.BANK_FAIL))) continue;
            isProcessed = false;
            break;
        }
        return isProcessed;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "endorseDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionCancelEndorse", "actionUnAudit"};
    }

    protected ArrayList getSelectedEntryIdValues() {
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain.setRowCount(this.getRowCountFromDB());
            this.tblMain.reLayoutAndPaint();
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)this.getEntriesPKName(), selectList, selectKeyIdFields);
    }

    public String getEntriesPKName() {
        return "entrys.id";
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        NtUpgradeFacadeFactory.getRemoteInstance().ntUpgrade();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"614_EndorsementBillListUI"));
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    private void initForUnion() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.curCompany)) {
            ItemAction[] actions = new ItemAction[]{this.actionCancelEndorse, this.actionCancelConfirm, this.actionConfirm, this.actionBook, this.actionCancelBook, this.actionAudit, this.actionUnAudit, this.actionCommitToBE, this.actionReleaseFailedBill, this.actionSyncBeStatus, this.actionEditBeStatus, this.actionNoteCancle, this.actionSynForceStatus, this.actionUpgrade, this.actionBatchCommitToBE, this.actionBitBack, this.actionEdit, this.actionVoucher, this.actionDelVoucher, this.actionWorkFlowG, this.actionWorkflowList, this.actionSendSmsMessage};
            FMClientHelper.setActionEnable((ItemAction[])actions, (boolean)false);
            Component[] components = this.menuWorkFlow.getPopupMenu().getComponents();
            int j = -1;
            for (int i = 0; i < components.length; ++i) {
                if ("menuItemPassHistory".equals(components[i].getName())) {
                    components[i].setEnabled(false);
                }
                if (!"menuItemSendSmsMessage".equals(components[i].getName())) continue;
                components[i].setEnabled(false);
            }
        }
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.curCompany)) {
            ItemAction[] actions = new ItemAction[]{this.actionVoucher, this.actionDelVoucher};
            FMClientHelper.setActionEnable((ItemAction[])actions, (boolean)false);
        }
    }

    @Override
    public void actionGenPayment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        if (!EmptyUtil.isEmpty(idSet) && idSet.size() > 1 && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NTP_RES, (String)"batchGenPayment")) != 0) {
            return;
        }
        Map ret = ((IEndorsementBill)this.getBizInterface()).genPayment(idSet);
        int successCount = idSet.size() - Integer.valueOf((String)ret.get("errCount"));
        int errCount = Integer.valueOf((String)ret.get("errCount"));
        String errMsg = (String)ret.get("errMsg");
        if (errCount == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"allDone"));
        } else {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)NTP_RES, (String)"summary", (Object[])new String[]{successCount + "", (String)ret.get("errCount")}), (String)errMsg, (int)0);
        }
        this.refreshList();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            EndorsementBillListUI.this.setListUITable(EndorsementBillListUI.this.tblMain, e);
        }
    }
}

