/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CompanyF7Factory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.EndorseFacadeFactory;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillCollection;
import com.kingdee.eas.fm.nt.EndorsementBillEntryInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractInEndorsementBatchEditUI;
import com.kingdee.eas.fm.nt.client.EndorseNoteBillApproveUI;
import com.kingdee.eas.fm.nt.client.EndorsementBillDataProvider;
import com.kingdee.eas.fm.nt.client.EndorsementBillFilterParam;
import com.kingdee.eas.fm.nt.client.EndorsementBillListUI;
import com.kingdee.eas.fm.nt.client.OutEndorsementBatchEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InEndorsementBatchEditUI
extends AbstractInEndorsementBatchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InEndorsementBatchEditUI.class);
    private IObjectCollection receivableCol = null;
    private CompanyOrgUnitInfo curCompany = null;
    private CompanyOrgUnitInfo endorCompany = null;
    private BigDecimal endorseAmt = Constants.ZERO;
    private int curCurrencyPrecision = 2;
    private EndorsementBillInfo editInfo = null;
    private static final String RESOURCE = "com.kingdee.eas.fm.nt.NtResource";
    private CurrencyInfo curCurrency = null;
    private int baseCurrencyPrecision = 2;
    private CurrencyInfo baseCurrencyInfo = null;
    private BillMediumEnum billMediumEnum = null;

    public InEndorsementBatchEditUI() throws Exception {
        this.curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrencyInfo = this.curCompany.getBaseCurrency();
        this.receivableCol = (IObjectCollection)this.getUIContext().get("ReceivableColl");
        this.baseCurrencyPrecision = FMClientHelper.getPrecOfCurrency((BOSUuid)this.curCompany.getBaseCurrency().getId());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        EndorsementBillInfo info = this.editData;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            info.getEntrys().clear();
        }
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtInEnBgItem, (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtRecBgItem, (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[1]);
        info.setProject((ProjectInfo)this.prmtProject.getData());
        info.setCostCenter((CostCenterOrgUnitInfo)this.prmtCostCenter.getData());
        info.setExRate(this.txtExRate.getBigDecimalValue());
        info.setLocalAmount(this.txtLocAmount.getBigDecimalValue());
        info.setEndorsedSupplier(this.getSupplier(this.prmtendorsee.getData()));
        info.setEndorsedCustomer(this.getCustomer(this.prmtendorsee.getData()));
        info.setEndorsee(this.prmtendorsee.getValue() == null ? null : this.prmtendorsee.getValue().toString());
        info.setEndorseDate((Date)this.pkendorseDate.getValue());
        info.setDescription(this.txtDescription.getText());
        info.setEndorsedCompany((CompanyOrgUnitInfo)this.prmtendorsee.getData());
        info.setFee(this.txtfee.getBigDecimalValue());
        info.setFeeRate(this.txtfeeRate.getBigDecimalValue());
        info.setIsTransfer(this.chkisTransfer.isSelected());
        info.setEndorsedCompany((CompanyOrgUnitInfo)this.prmtendorsee.getData());
        info.setEndorseeAccountName(this.prmtEndorseeAccount.getValue() == null ? null : this.prmtEndorseeAccount.getValue().toString());
        info.setEndorseeBankName(this.txtEndorseeBankName.getText());
        info.setEndorseeBankNum(this.txtEndorseeBankNum.getText());
        info.setOppAccount((AccountViewInfo)this.prmtOppAccount.getData());
        if (this.prmtbankAccount.getData() != null) {
            info.setBankAccount((AccountBankInfo)this.prmtbankAccount.getData());
        }
        if (this.prmtinnerAccount.getData() != null) {
            info.setInnerAccount((InnerAccountInfo)this.prmtinnerAccount.getData());
        }
        info.setBdgControlAmt(Constants.ONE);
        if (!this.getOprtState().equals(OprtState.EDIT)) {
            info.setCompany(this.curCompany);
            info.setEndorseDate((Date)this.pkendorseDate.getValue());
            info.setBillType(EndorsementTypeEnum.IN);
            info.setState(EndorseStateEnum.Save);
            info.setCreateTime(DateUtil.getTimeStampDayBegin());
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            info.setFromCompany(this.curCompany);
            String billNumber = "";
            BigDecimal amt = Constants.ZERO;
            BigDecimal locAmt = Constants.ZERO;
            for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
                IRow row = this.tblMain.getRow(i);
                ReceivableBillInfo receivableInfo = this.getReceivableBill(row.getCell("id").getValue().toString());
                if (receivableInfo == null) continue;
                receivableInfo.setEndorseBill(info);
                EndorsementBillEntryInfo entryInfo = new EndorsementBillEntryInfo();
                entryInfo.setReceivableBill(receivableInfo);
                info.getReceivableEntrys().add(receivableInfo);
                amt = amt.add(receivableInfo.getBillAmt());
                locAmt = locAmt.add((BigDecimal)row.getCell("naturalAmt").getValue());
                if ((billNumber + receivableInfo.getDraftNumber()).length() < 80) {
                    billNumber = billNumber + receivableInfo.getDraftNumber() + ";";
                }
                info.setCurrency(receivableInfo.getCurrency());
                info.setDeliver(receivableInfo.getDeliver());
                info.getEntrys().add(entryInfo);
            }
            billNumber = billNumber.substring(0, billNumber.length() - 1);
            info.setNoteBillNumber(billNumber);
            info.setEndorseAmt(amt);
        }
        this.initOldData(this.getDataObject());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.menuFile.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("currency.*");
        sic.add("endorsedCompany.*");
        sic.add("innerAccount.*");
        sic.add("bankAccount.*");
        sic.add("bankAccount.InnerAcct.name");
        sic.add("bankAccount.InnerAcct.number");
        sic.add("endorsedSupplier.*");
        sic.add("endorsedCustomer.*");
        sic.add("fromCompany.*");
        sic.add("fpItem.*");
        sic.add("oppAccount.*");
        sic.add("entrys.elecBillStatus");
        sic.add("entrys.bankReturnStatus");
        sic.add("entrys.bankReturnMsg");
        sic.add("entrys.isNoteCancel");
        sic.add("entrys.receivableBill.*");
        sic.add("entrys.receivableBill.ntType.*");
        sic.add("entrys.receivableBill.currency.*");
        sic.add("entrys.endorseAmt");
        sic.add("entrys.batchSeqID");
        sic.add("entrys.detailSeqID");
        sic.add("bgInEnBgItemID");
        sic.add("bgInEnBgItemNumber");
        sic.add("bgInEnBgItemName");
        sic.add("bgRecBgItemID");
        sic.add("bgRecBgItemNumber");
        sic.add("bgRecBgItemName");
        sic.add("project.id");
        sic.add("project.name");
        sic.add("project.number");
        sic.add("costCenter.id");
        sic.add("costCenter.name");
        sic.add("costCenter.number");
        sic.add("fundFlowItem");
        sic.add("mbgNumber");
        sic.add("mbgName");
        sic.add("fundFlowItemIn");
        sic.add("mbgNumberIn");
        sic.add("mbgNameIn");
        return sic;
    }

    private boolean isInMultiApproveUI() {
        Object object = this.getUIContext().get("Owner");
        if (object == null) {
            return false;
        }
        return object.getClass().equals(EndorseNoteBillApproveUI.class);
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected void prmtendorsee_dataChanged(DataChangeEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtendorsee.getData())) {
            this.txtEndorseeBankNum.setText("");
            this.txtEndorseeBankName.setText("");
            this.prmtEndorseeAccount.setValue(null);
            this.prmtbankAccount.setEnabled(true);
            this.prmtFundFlowItemRec.setEnabled(true);
            return;
        }
        CompanyOrgUnitInfo endorsedCompany = (CompanyOrgUnitInfo)this.prmtendorsee.getData();
        if (endorsedCompany != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)endorsedCompany.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.curCompany.getId().toString(), CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            this.prmtinnerAccount.setEntityViewInfo(entityViewInfo);
            InnerAccountInfo innerAccountInfo = (InnerAccountInfo)this.prmtinnerAccount.getValue();
            if (innerAccountInfo != null && innerAccountInfo.getApplyUnit() != null && !innerAccountInfo.getApplyUnit().getId().toString().equals(endorsedCompany.getId().toString())) {
                this.prmtinnerAccount.setValue(null);
            }
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtfeeRate.setValue((Object)Constants.ZERO);
            this.txtfee.setValue((Object)Constants.ZERO);
            this.prmtbankAccount.setData(null);
        }
        if (!this.isInMultiApproveUI()) {
            this.setComponentEnable();
        }
        String applyUnitId = endorsedCompany.getId().toString();
        if (this.isConfirm()) {
            applyUnitId = this.editInfo.getCompany().getId().toString();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("property.property", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)endorsedCompany.getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtEndorseeAccount.setEntityViewInfo(entityViewInfo);
    }

    @Override
    protected void prmtinnerAccount_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo endorsedCompany = (CompanyOrgUnitInfo)this.prmtendorsee.getData();
        if (endorsedCompany == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.curCompany.getId().toString(), CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            this.prmtinnerAccount.getQueryAgent().resetRuntimeEntityView();
            this.prmtinnerAccount.setEntityViewInfo(entityViewInfo);
        }
    }

    @Override
    protected void prmtEndorseeAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtEndorseeAccount.getData())) {
            this.txtEndorseeBankName.setText("");
            this.txtEndorseeBankNum.setText("");
            return;
        }
        if (this.prmtEndorseeAccount.getData() instanceof AccountBankInfo) {
            EntityViewInfo view;
            AccountBankInfo accountbankInfo = (AccountBankInfo)this.prmtEndorseeAccount.getData();
            accountbankInfo.getBank().getId().toString();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)accountbankInfo.getBank().getId().toString(), CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            BankCollection bankCollection = BankFactory.getRemoteInstance().getBankCollection(entityViewInfo);
            BankInfo bankInfo = bankCollection.get(0);
            boolean isBase = false;
            if (bankInfo.getAccountBank() != null) {
                if (BEBankFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()))) {
                    BEBankInfo beInfo = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                    this.txtEndorseeBankNum.setText(beInfo.getNumber());
                } else {
                    isBase = true;
                }
            } else {
                isBase = true;
            }
            if (isBase) {
                view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String name = bankInfo.getName();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)(name + "%"), CompareType.LIKE));
                view.setFilter(filter);
                BEBankCollection coll = BEBankFactory.getRemoteInstance().getBEBankCollection(view);
                if (coll.size() > 0) {
                    this.txtEndorseeBankNum.setText(coll.get(0).getNumber());
                }
            } else if (this.prmtEndorseeAccount.getData() instanceof String) {
                view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String name = (String)this.prmtEndorseeAccount.getData();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)(name + "%"), CompareType.LIKE));
                view.setFilter(filter);
                BEBankCollection coll = BEBankFactory.getRemoteInstance().getBEBankCollection(view);
                if (coll.size() > 0) {
                    this.txtEndorseeBankNum.setText(coll.get(0).getNumber());
                }
            }
            this.txtEndorseeBankName.setText(bankInfo.getName());
            this.txtEndorseeBankName.setEditable(false);
        }
    }

    @Override
    protected void prmtEndorseeAccount_willShow(SelectorEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtendorsee.getData())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"067_ENDORSECOMPANY_MUST"));
            e.setCanceled(true);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("endorseBillId") != null) {
            BOSUuid endorseBillId = (BOSUuid)this.getUIContext().get("endorseBillId");
            if (this.editInfo == null) {
                this.editInfo = (EndorsementBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(endorseBillId.toString()));
            }
            this.editInfo.setFeeRate(this.txtfeeRate.getBigDecimalValue());
            this.editInfo.setFee(this.txtfee.getBigDecimalValue());
            this.editInfo.setBankAccount((AccountBankInfo)this.prmtbankAccount.getValue());
            this.editInfo.setInnerAccount((InnerAccountInfo)this.prmtinnerAccount.getValue());
            boolean isCreateReceiving = false;
            boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, "NT014", this.editInfo.getEndorsedCompany());
            if (isNTAssociaWithRP) {
                int msg = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isGenReceivingBill4EndorseConfirm"));
                if (msg == 0) {
                    isCreateReceiving = true;
                } else if (msg == 2) {
                    SysUtil.abort();
                }
            }
            FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtRecBgItem, (CoreBaseInfo)this.editInfo, (FMBgItemProp)this.editInfo.getBgItemProps()[1]);
            this.checkFinalCheckout();
            this.editInfo.setCreateReceiving(isCreateReceiving);
            EndorseFacadeFactory.getRemoteInstance().inEndorseApprove(this.editInfo, ContextHelperFactory.getRemoteInstance().getCurrentUser().getId());
            this.actionConfirm.setEnabled(false);
        }
        this.getUIWindow().close();
    }

    private void calcFee() {
        BigDecimal feeRate = this.txtfeeRate.getBigDecimalValue();
        if (this.endorseAmt != null && feeRate != null) {
            this.txtfee.setValue((Object)this.endorseAmt.multiply(feeRate));
        }
    }

    private void calcFeeRate() {
        BigDecimal fee = this.txtfee.getBigDecimalValue();
        if (this.endorseAmt != null && fee != null && this.endorseAmt.compareTo(Constants.ZERO) > 0) {
            BigDecimal feeRate = fee.divide(this.endorseAmt, 5, 4);
            BigDecimal oldFeeRate = this.txtfeeRate.getBigDecimalValue();
            if (oldFeeRate == null || oldFeeRate.compareTo(feeRate) != 0) {
                this.txtfeeRate.setValue((Object)feeRate);
            }
        }
    }

    @Override
    protected void txtfeeRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtfeeRate_dataChanged(e);
        this.calcFee();
    }

    @Override
    protected void txtfee_dataChanged(DataChangeEvent e) throws Exception {
        super.txtfee_dataChanged(e);
        if (this.txtExRate.getBigDecimalValue() != null && e.getNewValue() != null) {
            this.txtLocFeeAmount.setValue((Object)((BigDecimal)e.getNewValue()).multiply(this.txtExRate.getBigDecimalValue()));
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkendorseDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtendorsee);
        Object owner = this.getUIContext().get("Owner");
        if (owner.getClass().getName().indexOf("4Elec") != -1 && this.comboBillMedium.getSelectedItem() == BillMediumEnum.ELECTRONIC) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtEndorseeAccount);
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtEndorseeBankNum);
        }
    }

    private void setCurCurrencyPrecision() {
        if (this.receivableCol == null || this.receivableCol.size() == 0) {
            return;
        }
        ReceivableBillInfo billInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
        this.curCurrencyPrecision = billInfo.getCurrency().getPrecision();
        this.curCurrency = billInfo.getCurrency();
    }

    public void onLoad() throws Exception {
        this.menuBar.setVisible(false);
        int locCurrencyFormat = FMClientHelper.getPrecOfCurrency((BOSUuid)this.curCompany.getBaseCurrency().getId());
        this.actionAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.receivableCol = (IObjectCollection)this.getUIContext().get("ReceivableColl");
        this.setCurCurrencyPrecision();
        this.txtfeeRate.setPrecision(4);
        this.txtfee.setPrecision(this.curCurrencyPrecision);
        this.txtLocAmount.setDataType(1);
        this.txtLocAmount.setHorizontalAlignment(4);
        this.txtLocAmount.setPrecision(locCurrencyFormat);
        this.txtLocAmount.setRoundingMode(4);
        this.txtLocAmount.setHorizontalAlignment(4);
        this.txtLocAmount.setRemoveingZeroInDispaly(false);
        this.txtLocAmount.setNegatived(false);
        this.txtLocFeeAmount.setDataType(1);
        this.txtLocFeeAmount.setHorizontalAlignment(4);
        this.txtLocFeeAmount.setPrecision(locCurrencyFormat);
        super.onLoad();
        if ((this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equalsIgnoreCase("FINDVIEW")) && this.receivableCol == null && !EmptyUtil.isEmpty((CoreBaseInfo)this.editData) && !EmptyUtil.isEmpty((AbstractObjectCollection)this.editData.getEntrys())) {
            this.receivableCol = new ReceivableBillCollection();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.setSelector(this.getSelectors());
            EndorsementBillCollection infoColl = EndorsementBillFactory.getRemoteInstance().getEndorsementBillCollection(view);
            EndorsementBillInfo info = infoColl.get(0);
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                logger.error((Object)info.getEntrys().get(i).getId().toString());
                ReceivableBillInfo receivable = info.getEntrys().get(i).getReceivableBill();
                if (!EmptyUtil.isEmpty((Object)info.getEntrys().get(i).getEndorseAmt()) && info.getEntrys().get(i).getEndorseAmt().compareTo(BigDecimal.ZERO) > 0) {
                    receivable.setEndorseAmt(info.getEntrys().get(i).getEndorseAmt());
                }
                this.receivableCol.addObject((IObjectValue)info.getEntrys().get(i).getReceivableBill());
            }
        }
        if (this.editData != null) {
            EndorsementBillInfo info = this.editData;
            this.endorCompany = info.getCompany();
            if (EmptyUtil.isEmpty((Object)this.receivableCol) && info.getReceivableEntrys() != null && info.getReceivableEntrys().size() != 0) {
                this.receivableCol = info.getReceivableEntrys();
            }
            if (info.getBillType() == EndorsementTypeEnum.OUT) {
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"EndorseId", (Object)this.editData.getId().toString());
                uiCtx.put((Object)"Owner", (Object)this);
                uiCtx.put((Object)"ID", (Object)this.editData.getId().toString());
                IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(OutEndorsementBatchEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                editUI.show();
                this.abort();
            }
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.getUIContext().get("ReceivableColl") != null) {
            this.receivableCol = (IObjectCollection)this.getUIContext().get("ReceivableColl");
        }
        if ((this.curCurrency == null || this.endorCompany == null) && this.receivableCol != null && this.receivableCol.size() > 0) {
            ReceivableBillInfo billInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
            this.curCurrency = billInfo.getCurrency();
            if (this.endorCompany == null && billInfo.getCompany() != null) {
                this.endorCompany = billInfo.getCompany();
            }
        }
        if (this.endorCompany.getId().toString().equals(this.curCompany.getId().toString())) {
            this.actionSubmit.setVisible(true);
            this.actionSubmit.setEnabled(true);
            this.actionConfirm.setVisible(false);
        } else {
            this.actionSubmit.setVisible(false);
            this.actionConfirm.setVisible(true);
            this.actionConfirm.setEnabled(true);
        }
        if (this.getUIContext().get("endorseBillId") != null) {
            this.actionSubmit.setVisible(false);
            this.actionConfirm.setVisible(true);
            this.actionConfirm.setEnabled(true);
        }
        if (!FMHelper.isEmpty((Object)this.receivableCol)) {
            this.fillTable(this.receivableCol);
        }
        this.actionAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.setShowMessagePolicy(3);
        this.txtfee.setMinimumValue((Comparable)Constants.ZERO);
        this.txtfeeRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtfeeRate.setMaximumValue((Comparable)Constants.ONE);
        CompanyF7Factory.initCompanyBizUnitF7((IUIObject)this, (KDBizPromptBox)this.prmtendorsee);
        EntityViewInfo eviEndCompany = this.prmtendorsee.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.curCompany.getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        eviEndCompany.getFilter().mergeFilter(filter, "and");
        this.prmtendorsee.setEntityViewInfo(eviEndCompany);
        NTHelper.setF7AccountEvi((IUIObject)this, this.curCurrency.getId().toString(), this.curCompany, this.prmtOppAccount);
        if (!this.isConfirm()) {
            // empty if block
        }
        this.txtfeeRate.setHorizontalAlignment(4);
        this.txtfee.setHorizontalAlignment(4);
        this.actionViewBgBalance.setEnabled(true);
        if (this.getOprtState().equals("FINDVIEW") || this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSubmit.setEnabled(false);
        }
        this.txtLocAmount.setEnabled(false);
        this.txtLocFeeAmount.setEnabled(false);
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.curCurrency.getId().toString()));
        filter1.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter1.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.curCompany.getId().toString()));
        filter1.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter1.setMaskString("(#0 or #1) and #2 and #3");
        evi1.setFilter(filter1);
        this.prmtbankAccount.setEntityViewInfo(evi1);
        this.setAuditBtnStatus();
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtInEnBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtRecBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        this.setCostCenterF7();
        this.setEditPrmt(this.prmtEndorseeAccount, true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contInEnBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contRecBgItem, (KDLabelContainer)this.contFundFlowItemRec, (FundFlowDirection)FundFlowDirection.IN);
        this.loadViewData();
        this.initForUnion();
    }

    private void initForUnion() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.curCompany)) {
            this.btnAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        }
    }

    private void loadViewData() {
        BillMediumEnum billMedium = (BillMediumEnum)((Object)this.getUIContext().get("billMedium"));
        if (!EmptyUtil.isEmpty((Object)((Object)billMedium))) {
            this.comboBillMedium.setSelectedItem((Object)billMedium);
        }
        String slinkNoteBillId = (String)this.getUIContext().get("linkNoteBillId");
        try {
            if (slinkNoteBillId != null) {
                PaymentBillInfo info = PaymentBillFactory.getRemoteInstance().getPaymentBillInfo((IObjectPK)new ObjectUuidPK(slinkNoteBillId));
                if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeType())) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("asstHGAttribute"));
                    sic.add(new SelectorItemInfo("name"));
                    AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(info.getPayeeType().getId()), sic);
                    String payeeType = asstActTypeInfo.getAsstHGAttribute();
                    if (!EmptyUtil.isEmpty((String)payeeType) && payeeType.equals("companyOrg")) {
                        SelectorItemCollection companySic = new SelectorItemCollection();
                        companySic.add(new SelectorItemInfo("name"));
                        companySic.add(new SelectorItemInfo("company.name"));
                        companySic.add(new SelectorItemInfo("company.id"));
                        companySic.add(new SelectorItemInfo("bank.id"));
                        AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccountBankO().getId()), companySic);
                        if (!this.curCompany.getId().equals((Object)accountBankInfo.getCompany().getId())) {
                            this.prmtendorsee.setValue((Object)accountBankInfo.getCompany());
                            this.prmtEndorseeAccount.setValue((Object)accountBankInfo);
                        }
                    }
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("company.name"));
                    sic.add(new SelectorItemInfo("bank.id"));
                    AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccountBankO().getId()), sic);
                    if (!this.curCompany.getId().equals((Object)accountBankInfo.getCompany().getId())) {
                        this.prmtendorsee.setValue((Object)accountBankInfo.getCompany());
                        this.prmtEndorseeAccount.setValue((Object)accountBankInfo);
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setEditPrmt(KDBizPromptBox prompt, boolean flag) {
        if (flag) {
            ExtendParser parser = new ExtendParser(prompt);
            prompt.setCommitParser((IParser)parser);
        } else {
            prompt.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prompt));
        }
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getCU().getId().toString());
        try {
            String param = this.getSysParam("NT031");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(this.curCompany.getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    protected IObjectValue createNewData() {
        EndorsementBillInfo info = new EndorsementBillInfo();
        info.setCompany(this.curCompany);
        info.setEndorseDate(DateUtil.getDayBegin());
        BillMediumEnum billMediumEnum = (BillMediumEnum)((Object)this.getUIContext().get("billMedium"));
        if (!EmptyUtil.isEmpty((Object)((Object)billMediumEnum))) {
            this.comboBillMedium.setSelectedItem((Object)billMediumEnum);
        }
        info.setBillMedium(billMediumEnum);
        this.comboBillMedium.setSelectedItem((Object)billMediumEnum, false);
        this.chkisTransfer.setSelected(true);
        info.setIsTransfer(true);
        return info;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData instanceof EndorsementBillInfo) {
            if (this.isConfirm()) {
                FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            }
            this.editInfo = this.editData;
            FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtInEnBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editInfo.getBgItemProps()[0]);
            FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtRecBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editInfo.getBgItemProps()[1]);
            if (this.editInfo.getCurrency() != null) {
                this.curCurrency = this.editInfo.getCurrency();
                this.curCurrencyPrecision = this.editInfo.getCurrency().getPrecision();
            }
            this.pkendorseDate.setValue((Object)this.editInfo.getEndorseDate());
            this.prmtendorsee.setData((Object)this.editInfo.getEndorsedCompany());
            this.txtfeeRate.setValue((Object)this.editInfo.getFeeRate());
            this.txtfee.setPrecision(this.curCurrencyPrecision);
            this.txtfee.setValue((Object)this.editInfo.getFee());
            this.txtExRate.setValue((Object)this.editInfo.getExRate());
            this.prmtinnerAccount.setData((Object)this.editInfo.getInnerAccount());
            this.prmtbankAccount.setData((Object)this.editInfo.getBankAccount());
            if (this.editInfo.getInnerAccount() == null && this.editInfo.getBankAccount() != null) {
                this.prmtinnerAccount.setValue((Object)this.editInfo.getBankAccount().getInnerAcct());
            }
            this.prmtOppAccount.setData((Object)this.editInfo.getOppAccount());
            this.prmtProject.setData((Object)this.editInfo.getProject());
            this.prmtCostCenter.setData((Object)this.editInfo.getCostCenter());
            this.txtDescription.setText(this.editInfo.getDescription());
            if (this.editInfo.getConfirmer() != null || this.actionConfirm.isEnabled()) {
                this.prmtOppAccount.setEditable(true);
                this.prmtOppAccount.setEnabled(true);
            }
            if (this.editInfo.isFiVouchered()) {
                this.prmtOppAccount.setEnabled(false);
            }
        }
    }

    private void setComponentEnable() throws Exception {
        this.txtfeeRate.setEnabled(false);
        this.txtfee.setEnabled(false);
        this.prmtbankAccount.setEnabled(false);
        this.prmtinnerAccount.setEnabled(false);
        String fromCompanyId = this.curCompany.getId().toString();
        if (this.isConfirm()) {
            fromCompanyId = this.editInfo.getCompany().getId().toString();
        }
        String endorsedCompanyId = ((CompanyOrgUnitInfo)this.prmtendorsee.getValue()).getId().toString();
        IBank iBank = BankFactory.getRemoteInstance();
        boolean isFromCompanyCLH = iBank.isClearinghouseCompany(fromCompanyId);
        boolean isEndorsedCompanyCLH = iBank.isClearinghouseCompany(endorsedCompanyId);
        if (!this.isConfirm()) {
            if (isFromCompanyCLH && isEndorsedCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtbankAccount.setEnabled(true);
                this.prmtinnerAccount.setEnabled(true);
            } else if (isFromCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtinnerAccount.setEnabled(true);
            } else if (isEndorsedCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtbankAccount.setEnabled(true);
            }
            this.prmtInEnBgItem.setEnabled(true);
            this.prmtFundFlowItem.setEditable(true);
            this.prmtRecBgItem.setEnabled(false);
            this.prmtFundFlowItemRec.setEnabled(false);
        } else {
            if (isFromCompanyCLH && isEndorsedCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtbankAccount.setEnabled(true);
                this.prmtinnerAccount.setEnabled(true);
            } else if (isFromCompanyCLH) {
                this.prmtbankAccount.setEnabled(true);
            } else if (isEndorsedCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtinnerAccount.setEnabled(true);
            }
            this.prmtInEnBgItem.setEnabled(false);
            this.prmtFundFlowItem.setEnabled(false);
            this.prmtRecBgItem.setEnabled(true);
            this.prmtFundFlowItemRec.setEnabled(true);
        }
    }

    private boolean isConfirm() {
        return this.getUIContext().get("endorseBillId") != null;
    }

    private void setAuditBtnStatus() throws Exception {
        boolean isAudit = this.getSysParamOfInOut("NT019");
        if (OprtState.VIEW.equals(this.getOprtState()) && isAudit) {
            if (!FMHelper.isEmpty(this.getUIContext().get("Owner")) && this.getUIContext().get("Owner") instanceof EndorsementBillListUI) {
                EndorsementBillListUI listUI = (EndorsementBillListUI)((Object)this.getUIContext().get("Owner"));
                EndorsementBillFilterParam filterParam = (EndorsementBillFilterParam)((Object)listUI.getFilterUI().getParam());
                if (filterParam.isIncludeRecv()) {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(false);
                } else if (EndorseStateEnum.Submit == this.editInfo.getState()) {
                    this.actionAudit.setEnabled(true);
                    this.actionUnAudit.setEnabled(false);
                } else if (EndorseStateEnum.Audited == this.editInfo.getState()) {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(!this.editInfo.isIsCommitToBE() || this.editInfo.isIsCommitToBE() && this.isBEAllFail(this.editInfo, true));
                } else {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(false);
                }
            }
        } else {
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        }
    }

    private boolean isBEAllFail(EndorsementBillInfo sourceBill, boolean rejected) {
        boolean flg = true;
        ReceivableBillCollection coll = sourceBill.getReceivableEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = coll.get(i);
            if (info.getBankReturnStatus() != null) {
                if (rejected) {
                    if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    flg = false;
                    break;
                }
                if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) continue;
                flg = false;
                break;
            }
            flg = false;
            break;
        }
        return flg;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EndorsementBillFactory.getRemoteInstance();
    }

    private void fillTable(IObjectCollection coll) throws EASBizException, BOSException {
        String type;
        String numberFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.curCurrencyPrecision);
        String baseFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.baseCurrencyPrecision);
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        Object owner = this.getUIContext().get("Owner");
        if (owner.getClass().getName().indexOf("4Elec") == -1) {
            this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(true);
        }
        BigDecimal amt = Constants.ZERO;
        BigDecimal locAmt = Constants.ZERO;
        if (coll == null) {
            return;
        }
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setNumberFormat(baseFormat_AMT);
        this.tblMain.getColumn("naturalAmt").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("naturalAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("naturalAmt").getStyleAttributes().setNumberFormat(baseFormat_AMT);
        boolean isFormPayment = false;
        String slinkNoteBillId = (String)this.getUIContext().get("linkNoteBillId");
        if (slinkNoteBillId != null && (type = BOSUuid.read((String)slinkNoteBillId).getType().toString()).equals(new PaymentBillInfo().getBOSType().toString())) {
            isFormPayment = true;
        }
        StyleAttributes styleAttributes = null;
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tblMain.addRow();
            CoreBaseInfo vo = (CoreBaseInfo)coll.getObject(i);
            ReceivableBillInfo info = new ReceivableBillInfo();
            if (vo instanceof ReceivableBillInfo) {
                info = (ReceivableBillInfo)vo;
            }
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                if (!EmptyUtil.isEmpty((CoreBaseInfo)info)) {
                    if (this.tblMain.getColumnKey(j).equals("subRegion")) {
                        if (info.getSource().equals((Object)BillSourceEnum.BYHAND)) {
                            if (info.isIsSplit()) {
                                String subStartNumber = info.getSubRegion().split("-")[0];
                                String subRegion = subStartNumber + "-" + ((BigDecimal)row.getCell("endorseAmt").getValue()).multiply(new BigDecimal(100)).subtract(new BigDecimal(1)).add(new BigDecimal(subStartNumber)).stripTrailingZeros().toPlainString();
                                row.getCell(j).setValue((Object)subRegion);
                                continue;
                            }
                            row.getCell(j).setValue((Object)"0-0");
                            continue;
                        }
                        row.getCell(j).setValue(null);
                        continue;
                    }
                    if (this.tblMain.getColumnKey(j).equals("endorseAmt")) {
                        KDFormattedTextField endAmt = new KDFormattedTextField();
                        endAmt.setDataType(1);
                        endAmt.setMaximumValue((Comparable)((BigDecimal)BindingUtility.getValue((IObjectValue)vo, (Field)new Field("billAmt"))));
                        endAmt.setMinimumValue((Comparable)BigDecimal.ZERO);
                        endAmt.setPrecision(this.curCurrencyPrecision);
                        endAmt.addDataChangeListener(new DataChangeListener(){

                            public void dataChanged(DataChangeEvent eventObj) {
                                InEndorsementBatchEditUI.this.countSubRegion(eventObj);
                            }
                        });
                        if (!EmptyUtil.isEmpty((Object)info.getEndorseAmt()) && info.getEndorseAmt().compareTo(BigDecimal.ZERO) > 0) {
                            row.getCell(j).setValue((Object)info.getEndorseAmt());
                        } else {
                            row.getCell(j).setValue((Object)info.getAvailableAmt());
                        }
                        row.getCell(j).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)endAmt));
                        row.getCell(j).getStyleAttributes().setNumberFormat(numberFormat_AMT);
                        row.getCell(j).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        if (isFormPayment) {
                            row.getCell(j).getStyleAttributes().setLocked(true);
                            continue;
                        }
                        row.getCell(j).getStyleAttributes().setLocked(!info.isIsSplit());
                        continue;
                    }
                }
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(this.tblMain.getColumnKey(j))));
            }
            if (vo instanceof ReceivableBillInfo) {
                ReceivableBillInfo billInfo = (ReceivableBillInfo)vo;
                this.curCurrency = billInfo.getCurrency();
                row.getCell("number").setValue((Object)billInfo.getDraftNumber());
            } else if (vo instanceof PayableBillInfo) {
                PayableBillInfo billInfo = (PayableBillInfo)vo;
                this.curCurrency = billInfo.getCurrency();
                row.getCell("number").setValue((Object)billInfo.getDraftNumber());
            }
            styleAttributes = row.getCell("billAmt").getStyleAttributes();
            amt = amt.add((BigDecimal)row.getCell("billAmt").getValue());
            locAmt = locAmt.add((BigDecimal)row.getCell("naturalAmt").getValue());
            styleAttributes.setNumberFormat(numberFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.endorseAmt = this.endorseAmt.add((BigDecimal)row.getCell("endorseAmt").getValue());
        }
        IRow row = this.tblMain.addRow();
        row.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getCell("billAmt").setValue((Object)amt);
        row.getCell("billAmt").getStyleAttributes().setNumberFormat(numberFormat_AMT);
        row.getCell("naturalAmt").setValue((Object)locAmt);
        row.getCell("naturalAmt").getStyleAttributes().setNumberFormat(baseFormat_AMT);
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("endorseAmt").setValue((Object)this.endorseAmt);
        row.getCell("endorseAmt").getStyleAttributes().setNumberFormat(numberFormat_AMT);
        row.getCell("endorseAmt").getStyleAttributes().setLocked(true);
        this.txtExRate.setDataType(1);
        this.txtExRate.setRoundingMode(4);
        this.txtExRate.setHorizontalAlignment(4);
        this.txtExRate.setRemoveingZeroInDispaly(true);
        this.txtExRate.setNegatived(false);
        ExchangeRateInfo exchangeInfo = FMClientHelper.getExRateInfo((String)this.curCompany.getId().toString(), (String)this.curCurrency.getId().toString(), (String)this.baseCurrencyInfo.getId().toString(), (Date)((Date)this.pkendorseDate.getValue()));
        if (exchangeInfo != null) {
            this.txtExRate.setPrecision(exchangeInfo.getPrecision());
            this.txtExRate.setValue((Object)exchangeInfo.getConvertRate());
        } else {
            this.txtExRate.setPrecision(5);
            this.txtExRate.setValue((Object)Constants.ONE);
        }
        if (this.curCurrency.getId().toString().equals(this.baseCurrencyInfo.getId().toString())) {
            this.txtExRate.setEnabled(false);
        }
        this.txtLocAmount.setValue((Object)this.endorseAmt.multiply(this.txtExRate.getBigDecimalValue()));
        this.tblMain.getSelectManager().setSelectMode(2);
        FinHelper.setLockColumn((KDTable)this.tblMain, (String[])new String[]{"number", "ntType", "currency", "billAmt", "subRegion", "exchangeRate", "naturalAmt", "issuesDate", "deliverName", "takeDate", "expiredDate", "acceptanceBankName", "billMedium", "elecBillStatus", "bankReturnStatus", "bankReturnMsg", "id", "currency.id"}, (boolean)true);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.tblMain.setEditable(false);
        }
    }

    protected void countSubRegion(DataChangeEvent eventObj) {
        BigDecimal amt = Constants.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (i == this.tblMain.getSelectManager().getActiveRowIndex()) {
                BigDecimal endAmt = (BigDecimal)eventObj.getNewValue();
                amt = amt.add(endAmt);
                if (EmptyUtil.isEmpty((Object)row.getCell("subRegion").getValue())) continue;
                String subStartNumber = ((String)row.getCell("subRegion").getValue()).split("-")[0];
                String subRegion = subStartNumber + "-" + endAmt.multiply(new BigDecimal(100)).subtract(new BigDecimal(1)).add(new BigDecimal(subStartNumber)).stripTrailingZeros().toPlainString();
                row.getCell("subRegion").setValue((Object)subRegion);
                continue;
            }
            amt = amt.add((BigDecimal)row.getCell("endorseAmt").getValue());
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("endorseAmt").setValue((Object)amt);
        this.endorseAmt = amt;
        this.txtLocAmount.setValue((Object)amt.multiply(this.txtExRate.getBigDecimalValue()));
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.checkFinalCheckout();
        EndorsementBillInfo endorsbillInfo = new EndorsementBillInfo();
        boolean isCreatePayment = false;
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (this.editInfo != null) {
                endorsbillInfo = this.editInfo;
                if (this.isInMsgCenter()) {
                    endorsbillInfo.setIsEdit(false);
                } else {
                    endorsbillInfo.setIsEdit(true);
                }
            }
        } else {
            endorsbillInfo = this.editData;
            endorsbillInfo.setIsEdit(false);
            String slinkNoteBillId = (String)this.getUIContext().get("linkNoteBillId");
            boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, "NT014", false);
            if (EmptyUtil.isEmpty((String)slinkNoteBillId) && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isGenPaymentBill")) == 0) {
                isCreatePayment = true;
            } else {
                endorsbillInfo.setLinkbillId(slinkNoteBillId);
                endorsbillInfo.setRpBillId(slinkNoteBillId);
            }
        }
        this.storeFields();
        boolean isAudit = this.getSysParamOfInOut("NT019");
        endorsbillInfo.setIsAudit(isAudit);
        this.checkEndorseDate(endorsbillInfo);
        FmMbgHelper.checkBizUnitInfo(null, (IObjectValue)endorsbillInfo);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
                BigDecimal billAmt;
                boolean isfromPay;
                IRow row = this.tblMain.getRow(i);
                BigDecimal endorseAmt = (BigDecimal)row.getCell("endorseAmt").getValue();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)row.getCell("id").getValue().toString(), CompareType.EQUALS));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                ReceivableBillCollection infoColl = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
                ReceivableBillInfo info = infoColl.get(0);
                String slinkNoteBillId = (String)this.getUIContext().get("linkNoteBillId");
                boolean bl = isfromPay = slinkNoteBillId != null && BOSUuid.read((String)slinkNoteBillId).getType().toString().equals(new PaymentBillInfo().getBOSType().toString());
                if (!isfromPay && endorseAmt.compareTo(info.getAvailableAmt()) > 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"644_OutEndorsementBatchEditUI"));
                    SysUtil.abort();
                }
                if (endorseAmt.compareTo(Constants.ZERO) == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"643_OutEndorsementBatchEditUI"));
                    SysUtil.abort();
                }
                if (!isfromPay && info.getSource().equals((Object)BillSourceEnum.BYHAND) && info.getLockAmt().compareTo(BigDecimal.ZERO) != 0) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"645_OutEndorsementBatchEditUI"));
                    SysUtil.abort();
                }
                if ((billAmt = (BigDecimal)row.getCell("billAmt").getValue()).compareTo(endorseAmt) == 0) continue;
                map.put(row.getCell("id").getValue().toString(), endorseAmt);
            }
            EndorsementBillFactory.getRemoteInstance().splitEndorse(endorsbillInfo, map, false, isCreatePayment, false);
        } else {
            EndorsementBillFactory.getRemoteInstance().inSubmit(endorsbillInfo, isCreatePayment);
        }
        this.getUIWindow().close();
    }

    private void checkEndorseDate(EndorsementBillInfo endorsbillInfo) throws EASBizException, BOSException {
        boolean bCandoExpired = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT009", (IObjectPK)new ObjectUuidPK(this.curCompany.getId().toString()));
        StringBuffer errorDetail = new StringBuffer();
        StringBuffer error = new StringBuffer();
        Iterator iter = endorsbillInfo.getReceivableEntrys().iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo recvBillInfo = (ReceivableBillInfo)iter.next();
            Date takeDate = DateUtil.getDayBegin((Date)recvBillInfo.getTakeDate());
            Date endoreDate = DateUtil.getDayBegin((Date)endorsbillInfo.getEndorseDate());
            Date expiredDate = DateUtil.getDayBegin((Date)recvBillInfo.getExpiredDate());
            if (endoreDate.before(takeDate)) {
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"614_DraftNumber")).append(recvBillInfo.getDraftNumber()).append(":");
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"615_takeDate_after_endoreDate"));
                errorDetail.append("\n");
                continue;
            }
            if (bCandoExpired || !endoreDate.after(expiredDate)) continue;
            errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"614_DraftNumber")).append(recvBillInfo.getDraftNumber()).append(":");
            errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"616_endoreDate_after_expiredDate"));
            errorDetail.append("\n");
        }
        if (!EmptyUtil.isEmpty((Object)errorDetail) && errorDetail.length() > 0) {
            if (endorsbillInfo.getReceivableEntrys().size() == 1) {
                error.append(errorDetail);
                MsgBox.showInfo((String)error.toString());
                SysUtil.abort();
            } else {
                error.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"617_cannot_do"));
                MsgBox.showDetailAndOK((Component)((Object)this), (String)error.toString(), (String)errorDetail.toString(), (int)0);
                SysUtil.abort();
            }
        }
    }

    private boolean getSysParamOfInOut(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (param == null) {
            return false;
        }
        return Boolean.valueOf(param);
    }

    public void comboCurrency_itemStateChanged(ItemEvent e) {
    }

    protected boolean isInMsgCenter() {
        Boolean wf = (Boolean)this.getUIContext().get("isFromWorkflow");
        if (wf == null) {
            return false;
        }
        return wf;
    }

    private ReceivableBillInfo getReceivableBill(String id) {
        for (ReceivableBillInfo element : this.receivableCol) {
            if (!id.equals(element.getId().toString())) continue;
            return element;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    private CustomerInfo getCustomer(Object obj) {
        if (obj instanceof CustomerInfo) {
            return (CustomerInfo)obj;
        }
        return null;
    }

    @Override
    public void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        NTHelper.setF7AccountEvi((IUIObject)this, this.curCurrency.getId().toString(), this.curCompany, this.prmtOppAccount);
    }

    @Override
    protected void prmtOppAccount_willCommit(CommitEvent e) throws Exception {
        NTHelper.setF7AccountEvi((IUIObject)this, this.curCurrency.getId().toString(), this.curCompany, this.prmtOppAccount);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.EndorsementBill", null, (IObjectValue)this.editData);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"258_InEndorsementBatchEditUI"));
            return;
        }
        String id = this.editData.getId().toString();
        EndorsementBillDataProvider data = new EndorsementBillDataProvider(id);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/EndorsementBill", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"259_InEndorsementBatchEditUI"));
            return;
        }
        String id = this.editData.getId().toString();
        EndorsementBillDataProvider data = new EndorsementBillDataProvider(id);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/EndorsementBill", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected void txtExRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtLocAmount.setValue((Object)((BigDecimal)e.getNewValue()).multiply(this.endorseAmt));
        if (this.txtfee.getBigDecimalValue() != null) {
            this.txtLocFeeAmount.setValue((Object)((BigDecimal)e.getNewValue()).multiply(this.txtfee.getBigDecimalValue()));
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        EndorsementBillFactory.getRemoteInstance().audit((IObjectPK)new ObjectUuidPK(this.editInfo.getId()));
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"255_EndorsementBillListUI"));
        this.editInfo.setState(EndorseStateEnum.Audited);
        this.setAuditBtnStatus();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        EndorsementBillFactory.getRemoteInstance().unAudit((IObjectPK)new ObjectUuidPK(this.editInfo.getId()));
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"256_EndorsementBillListUI"));
        this.editInfo.setState(EndorseStateEnum.Submit);
        this.setAuditBtnStatus();
    }

    public boolean destroyWindow() {
        this.releaseLockObject();
        return super.destroyWindow();
    }

    private void releaseLockObject() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            idList.add(this.tblMain.getRow(i).getCell("id").getValue().toString());
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.batchReleaseObjIDForUpdate(idList);
    }

    @Override
    protected void comboBillMedium_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboBillMedium.getSelectedItem() == null) {
            return;
        }
        Object owner = this.getUIContext().get("Owner");
        if (owner.getClass().getName().indexOf("4Elec") != -1) {
            boolean required = false;
            required = this.comboBillMedium.getSelectedItem() == BillMediumEnum.ELECTRONIC;
            this.prmtEndorseeAccount.setRequired(required);
            this.txtEndorseeBankNum.setRequired(required);
        }
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)((Date)this.pkendorseDate.getValue()));
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

