/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.EndorseException;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractInEndorsementBillEditUI;
import com.kingdee.eas.fm.nt.client.EndorseNoteBillApproveUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class InEndorsementBillEditUI
extends AbstractInEndorsementBillEditUI {
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAttachment.setVisible(false);
        this.setShowMessagePolicy(3);
        this.actionJoinQuery.setVisible(false);
        this.menuBar.setVisible(false);
        if (this.isInMultiApproveUI()) {
            this.btnExit.setVisible(false);
            this.btnOK.setVisible(false);
            this.kDSeparator5.setVisible(false);
        }
        this.txtendorseAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtfee.setMinimumValue((Comparable)Constants.ZERO);
        this.txtfeeRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtfeeRate.setMaximumValue((Comparable)Constants.ONE);
        EntityViewInfo eviEndCompany = new EntityViewInfo();
        FilterInfo filterEndCompany = new FilterInfo();
        filterEndCompany.getFilterItems().add(new FilterItemInfo("id", (Object)this.currentCompany.getId().toString(), CompareType.NOTEQUALS));
        eviEndCompany.setFilter(filterEndCompany);
        this.prmtendorsedCompany.setEntityViewInfo(eviEndCompany);
        EntityViewInfo eviBankAccount = new EntityViewInfo();
        FilterInfo filterBankAccount = new FilterInfo();
        filterBankAccount.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        eviBankAccount.setFilter(filterBankAccount);
        this.prmtbankAccount.setEntityViewInfo(eviBankAccount);
        this.prmtinnerAccount.setEntityViewInfo(FMClientHelper.getNothingFilter());
        CurrencyInfo currency = (CurrencyInfo)this.prmtcurrency.getValue();
        NTHelper.setF7AccountEvi((IUIObject)this, currency.getId().toString(), this.currentCompany, this.prmtOppAccount);
        this.txtendorseAmt.setPrecision(currency.getPrecision());
        this.txtendorseAmt.setRemoveingZeroInDispaly(false);
        this.txtendorseAmt.setHorizontalAlignment(4);
        this.txtfeeRate.setHorizontalAlignment(4);
        this.txtfee.setHorizontalAlignment(4);
        this.kdViewBgdBalance.setEnabled(true);
        if (this.editData != null && this.editData.isFiVouchered()) {
            this.prmtOppAccount.setEnabled(false);
        }
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EndorsementBillFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnJoinQuery.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getFee() == null) {
            this.editData.setFee(Constants.ZERO);
        }
        if (this.editData.getFeeRate() == null) {
            this.editData.setFeeRate(Constants.ZERO);
        }
        this.editData.setEndorsee(this.prmtendorsedCompany.getText());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.isInMultiApproveUI()) {
            this.txtCompany.setEnabled(false);
            this.prmtcurrency.setEnabled(false);
            this.txtendorseAmt.setEnabled(false);
            this.prmtendorsedCompany.setEnabled(false);
            this.prmtconfirmer.setEnabled(false);
            this.txtfeeRate.setEnabled(false);
            this.txtfee.setEnabled(false);
            this.prmtbankAccount.setEnabled(false);
            this.prmtinnerAccount.setEnabled(false);
            this.txtDescription.setEnabled(false);
            String fromCompanyId = this.editData.getFromCompany().getId().toString();
            String endorsedCompanyId = this.editData.getEndorsedCompany().getId().toString();
            boolean isFromCompanyCLH = false;
            boolean isEndorsedCompanyCLH = false;
            try {
                IBank iBank = BankFactory.getRemoteInstance();
                isFromCompanyCLH = iBank.isClearinghouseCompany(fromCompanyId);
                isEndorsedCompanyCLH = iBank.isClearinghouseCompany(endorsedCompanyId);
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            if (isEndorsedCompanyCLH) {
                this.txtfeeRate.setEnabled(true);
                this.txtfee.setEnabled(true);
            }
        }
        this.initDataStatus();
    }

    protected void initDataStatus() {
        BOSUuid noteBillId;
        if (this.editData != null) {
            super.initDataStatus();
        }
        if ((noteBillId = (BOSUuid)this.getUIContext().get("noteBillId")) != null) {
            this.prmtendorsedCompany.setEnabled(false);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        BOSUuid noteBillId = (BOSUuid)this.getUIContext().get("noteBillId");
        EndorsementBillInfo info = null;
        if (noteBillId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(noteBillId);
            try {
                ReceivableBillInfo noteBillInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)pk);
                if (noteBillInfo.getBillState() != BillStateEnum.SAVED && noteBillInfo.getBillState() != BillStateEnum.Audit) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"260_InEndorsementBillEditUI"));
                    SysUtil.abort();
                }
                String currencyId = noteBillInfo.getCurrency().getId().toString();
                info = InEndorsementBillEditUI.createInEndorsementBill(noteBillId.toString(), noteBillInfo.getBillAmt(), currencyId);
                if (noteBillInfo.getNotifyCompany() != null) {
                    info.setEndorsedCompany(CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(noteBillInfo.getNotifyCompany().getId().toString())));
                }
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        return info;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionJoinQuery_actionPerformed(e);
        String billId = this.editData.getNoteBillId();
        if (billId == null || billId.trim().length() <= 0) {
            throw new EndorseException(EndorseException.NONOTEBILLID);
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    public boolean isSave() {
        if (this.isInMultiApproveUI()) {
            return true;
        }
        return super.isSave();
    }

    @Override
    protected void txtendorseAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtendorseAmt_dataChanged(e);
        this.calcFee();
    }

    private void calcFee() {
        BigDecimal amt = this.txtendorseAmt.getBigDecimalValue();
        BigDecimal feeRate = this.txtfeeRate.getBigDecimalValue();
        if (amt != null && feeRate != null) {
            this.txtfee.setValue((Object)amt.multiply(feeRate));
        }
    }

    private void calcFeeRate() {
        BigDecimal amt = this.txtendorseAmt.getBigDecimalValue();
        BigDecimal fee = this.txtfee.getBigDecimalValue();
        if (amt != null && fee != null) {
            BigDecimal feeRate = fee.divide(amt, 5, 4);
            BigDecimal oldFeeRate = this.txtfeeRate.getBigDecimalValue();
            if (oldFeeRate == null || oldFeeRate.compareTo(feeRate) != 0) {
                this.txtfeeRate.setValue((Object)feeRate);
            }
        }
    }

    @Override
    protected void txtfeeRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtfeeRate_dataChanged(e);
        this.calcFee();
    }

    @Override
    protected void txtfee_dataChanged(DataChangeEvent e) throws Exception {
        super.txtfee_dataChanged(e);
        this.calcFeeRate();
    }

    @Override
    protected void prmtendorsedCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtendorsedCompany_dataChanged(e);
        CompanyOrgUnitInfo endorsedCompany = (CompanyOrgUnitInfo)this.prmtendorsedCompany.getData();
        if (endorsedCompany == null) {
            this.prmtinnerAccount.setValue(null);
            this.prmtinnerAccount.setEntityViewInfo(FMClientHelper.getNothingFilter());
            return;
        }
        BOSUuid noteBillId = (BOSUuid)this.getUIContext().get("noteBillId");
        String endorsedCompanyId = endorsedCompany.getId().toString();
        if (noteBillId != null && !BankFactory.getRemoteInstance().isClearinghouseCompany(endorsedCompanyId)) {
            this.prmtendorsedCompany.setData(null);
            throw new EndorseException(EndorseException.UPUSEENDORSEDCOMPANYMUSTBECLEARHOUSE);
        }
        EntityViewInfo eviInAccount = new EntityViewInfo();
        FilterInfo filterInAccount = new FilterInfo();
        filterInAccount.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)endorsedCompany.getId().toString()));
        filterInAccount.getFilterItems().add(new FilterItemInfo("COMPANY.ID", (Object)this.currentCompany.getId().toString()));
        eviInAccount.setFilter(filterInAccount);
        this.prmtinnerAccount.setEntityViewInfo(eviInAccount);
        if (!this.isInMultiApproveUI()) {
            this.txtCompany.setEnabled(false);
            this.prmtcurrency.setEnabled(false);
            this.txtendorseAmt.setEnabled(false);
            this.prmtconfirmer.setEnabled(false);
            this.txtfeeRate.setEnabled(false);
            this.txtfee.setEnabled(false);
            this.prmtbankAccount.setEnabled(false);
            this.prmtinnerAccount.setEnabled(false);
            this.txtDescription.setEnabled(false);
            String fromCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            boolean isFromCompanyCLH = false;
            boolean isEndorsedCompanyCLH = false;
            IBank iBank = BankFactory.getRemoteInstance();
            isFromCompanyCLH = iBank.isClearinghouseCompany(fromCompanyId);
            isEndorsedCompanyCLH = iBank.isClearinghouseCompany(endorsedCompanyId);
            if (!isFromCompanyCLH && isEndorsedCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtbankAccount.setEnabled(true);
            } else if (isFromCompanyCLH && !isEndorsedCompanyCLH) {
                this.txtfee.setEnabled(true);
                this.txtfeeRate.setEnabled(true);
                this.prmtinnerAccount.setEnabled(true);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkendorseDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtendorsedCompany);
    }

    public static void createNewInEndorseBill(Object owner, String noteBillId, BigDecimal amount, String currencyId) throws EASBizException, BOSException {
        EndorsementBillInfo billInfo = InEndorsementBillEditUI.createInEndorsementBill(noteBillId, amount, currencyId);
        UIContext uiCtx = new UIContext(owner);
        uiCtx.put((Object)"InitDataObject", (Object)billInfo);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InEndorsementBillEditUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        editUI.show();
    }

    private static EndorsementBillInfo createInEndorsementBill(String noteBillId, BigDecimal amount, String currencyId) throws BOSException, EASBizException {
        ReceivableBillInfo info = (ReceivableBillInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(noteBillId);
        EndorsementBillInfo billInfo = new EndorsementBillInfo();
        billInfo.setNoteBillId(noteBillId);
        billInfo.setNoteBillNumber(info.getNumber());
        billInfo.setEndorseAmt(amount);
        billInfo.setEndorseDate(DateUtil.getDayBegin());
        billInfo.setBillType(EndorsementTypeEnum.IN);
        billInfo.setFromCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        billInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        billInfo.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)));
        billInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        billInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        billInfo.setState(EndorseStateEnum.Submit);
        billInfo.setDeliver(info.getDeliver());
        billInfo.setExRate(info.getExchangeRate());
        billInfo.setLocalAmount(info.getNaturalAmt());
        billInfo.getReceivableEntrys().add(info);
        return billInfo;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if (this.getOprtState().equals(OprtState.EDIT) && this.isInMultiApproveUI()) {
            this.pkendorseDate.setEnabled(false);
            this.prmtendorsedCompany.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("CU.id");
        sic.add("deliver.id");
        sic.add("deliver.number");
        sic.add("deliver.name");
        sic.add("receivableEntrys.*");
        sic.add("receivableEntrys.currency.*");
        sic.add("receivableEntrys.ntType.*");
        sic.add("fpItem.*");
        sic.add("oppAccount.*");
        return sic;
    }

    private boolean isInMultiApproveUI() {
        Object object = this.getUIContext().get("Owner");
        if (object == null) {
            return false;
        }
        return object.getClass().equals(EndorseNoteBillApproveUI.class);
    }

    private static CompanyOrgUnitInfo getClearhouseCompany() throws BOSException {
        IBank ibank = BankFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("*");
        sic.add("relatedCompany.id");
        sic.add("relatedCompany.name");
        sic.add("relatedCompany.number");
        BankCollection bankColl = ibank.getBankCollection(evi);
        int n = bankColl.size();
        for (int i = 0; i < n; ++i) {
            BankInfo bank = bankColl.get(i);
            if (bank.getRelatedCompany() == null || !bank.isInGroup()) continue;
            return bank.getRelatedCompany();
        }
        return null;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        if (this.getUIContext() == null) {
            return;
        }
        EndorsementBillInfo billInfo = (EndorsementBillInfo)this.getUIContext().get("InitDataObject");
        if (billInfo == null) {
            return;
        }
        String noteBillId = billInfo.getNoteBillId();
        DataObjectMutex mutextControl = new DataObjectMutex();
        mutextControl.releaseDataObjectLock(noteBillId);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        EndorsementBillInfo endorsbillInfo = new EndorsementBillInfo();
        endorsbillInfo.setCompany(this.currentCompany);
        endorsbillInfo.setEndorseDate((Date)this.pkendorseDate.getValue());
        endorsbillInfo.setCurrency((CurrencyInfo)this.prmtcurrency.getData());
        endorsbillInfo.setBdgControlAmt(Constants.ONE);
        endorsbillInfo.setEndorseAmt(this.txtendorseAmt.getBigDecimalValue());
        if (this.txtfee.getValue() != null) {
            endorsbillInfo.setFee(this.txtfee.getBigDecimalValue());
        } else {
            endorsbillInfo.setFee(Constants.ZERO);
        }
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.EndorsementBill", null, (IObjectValue)endorsbillInfo);
    }

    @Override
    protected void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        if (this.editData != null) {
            NTHelper.setF7AccountEvi((IUIObject)this, this.editData.getCurrency().getId().toString(), this.currentCompany, this.prmtOppAccount);
        }
    }

    @Override
    protected void prmtOppAccount_willCommit(CommitEvent e) throws Exception {
        if (this.editData != null) {
            NTHelper.setF7AccountEvi((IUIObject)this, this.editData.getCurrency().getId().toString(), this.currentCompany, this.prmtOppAccount);
        }
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)this.editData.getEndorseDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

