/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.LetterOfCreditDisCountFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditDisCountInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.client.AbstractLetterOfCreditDisCountEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;

public class LetterOfCreditDisCountEditUI
extends AbstractLetterOfCreditDisCountEditUI {
    private static final long serialVersionUID = 2383768366336145549L;
    private BigDecimal billAmount = Constants.ZERO;
    private int prec = 4;
    private java.util.Date intendDate = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    @Override
    public void loadFields() {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)this.getUIContext().get("LetterOfCreditReceive");
        if (EmptyUtil.isEmpty((CoreBaseInfo)info) && !EmptyUtil.isEmpty((String)this.editData.getSourceBillId())) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getSourceBillId());
            try {
                info = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.billAmount = info.getBillAmount();
        this.intendDate = info.getIntendDate();
        this.prec = info.getIssueCurrency().getPrecision();
        super.loadFields();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.callDays();
        }
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initPropEvi() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.FALSE));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.editData.getCurrency().getId().toString()));
        fi.setMaskString("#0 or #1");
        filter.mergeFilter(fi, "and");
        evi.getFilter().mergeFilter(filter, "and");
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        this.prmtrecAccountBank.setEntityViewInfo(evi);
        this.prmtrecAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initUIProp() throws Exception {
        this.pkdisCountDate.setSupportedEmpty(false);
        this.txtdays.setPrecision(0);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtdays);
        this.txtdays.setMinimumValue((Comparable)Constants.ZERO);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtrate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdisCountRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtchargeFee);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtActAmount);
        this.txtrate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtchargeFee.setMinimumValue((Comparable)Constants.ZERO);
        this.txtrate.setPrecision(4);
        this.txtchargeFee.setPrecision(this.prec);
        this.txtActAmount.setPrecision(this.prec);
        this.txtdisCountRate.setPrecision(this.prec);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtdisCountRate);
        super.verifyInput(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LetterOfCreditDisCountFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)this.getUIContext().get("LetterOfCreditReceive");
        LetterOfCreditDisCountInfo objectValue = new LetterOfCreditDisCountInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setNumber(info.getCredit());
        objectValue.setDisCountDate(DateUtil.getDayBegin());
        objectValue.setDisCountRate(Constants.ZERO);
        objectValue.setCurrency(info.getIssueCurrency());
        objectValue.setRate(Constants.ZERO);
        objectValue.setChargeFee(Constants.ZERO);
        objectValue.setActAmount(Constants.ZERO);
        objectValue.setCompany(info.getCompany());
        objectValue.setSourceBillId(info.getId().toString());
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("currency.id"));
        return sic;
    }

    @Override
    protected void pkdisCountDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.pkdisCountDate.getSqlDate() != null && this.intendDate != null) {
            this.callDays();
            this.callDisCountRate();
        }
    }

    @Override
    protected void txtrate_dataChanged(DataChangeEvent e) throws Exception {
        this.callDisCountRate();
    }

    private void callDays() {
        Date disCountDate = this.pkdisCountDate.getSqlDate();
        long diff = DateUtil.getDiffDays((java.util.Date)disCountDate, (java.util.Date)this.intendDate) - 1;
        this.txtdays.setValue((Object)diff);
    }

    private void callDisCountRate() {
        BigDecimal rate = this.txtrate.getBigDecimalValue();
        BigDecimal days = this.txtdays.getBigDecimalValue();
        if (rate != null && days != null) {
            BigDecimal amount = this.billAmount.multiply(days).multiply(rate);
            if (amount.compareTo(Constants.ZERO) == 0) {
                this.txtdisCountRate.setValue((Object)Constants.ZERO);
            } else {
                BigDecimal DisCountRate = amount.divide(Constants.ONE_HUNDRED, this.prec, RoundingMode.HALF_UP).divide(new BigDecimal(360), this.prec, RoundingMode.HALF_UP);
                this.txtdisCountRate.setValue((Object)DisCountRate);
            }
        }
    }

    @Override
    protected void txtdisCountRate_dataChanged(DataChangeEvent e) throws Exception {
        this.callActuralAmount();
    }

    @Override
    protected void txtchargeFee_dataChanged(DataChangeEvent e) throws Exception {
        this.callActuralAmount();
    }

    private void callActuralAmount() {
        BigDecimal disCountRate = this.txtdisCountRate.getBigDecimalValue();
        BigDecimal chargeFee = this.txtchargeFee.getBigDecimalValue();
        if (disCountRate != null && chargeFee != null) {
            BigDecimal acturalAmount = this.billAmount.subtract(disCountRate).subtract(chargeFee);
            this.txtActAmount.setValue((Object)acturalAmount);
        }
    }

    @Override
    protected void prmtrecAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtrecAccountBank.getValue())) {
            this.txtbank.setText(null);
        } else {
            String bankid = ((AccountBankInfo)this.prmtrecAccountBank.getValue()).getBank().getId().toString();
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bankid));
            this.txtbank.setText(bank.getName());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.actionExitCurrent_actionPerformed(e);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "disCountDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

