/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordCollection;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LockRemitCollection;
import com.kingdee.eas.fm.fin.LockRemitFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.LetOfCreditAcctRecordDialogUI;
import com.kingdee.eas.fm.fin.client.LetOfCreditAcctRecordEditUI;
import com.kingdee.eas.fm.fin.client.LockRemitEditUI;
import com.kingdee.eas.fm.fin.client.LockRemitListUI;
import com.kingdee.eas.fm.nt.CreditApplyEnum;
import com.kingdee.eas.fm.nt.DealModeEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.fm.nt.client.AbstractLetterOfCreditReachListUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditReachEditUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditReachFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditReachListUI
extends AbstractLetterOfCreditReachListUI {
    private static final Logger logger = CoreUIObject.getLogger(LetterOfCreditReachListUI.class);
    private static final String NT_RES = "com.kingdee.eas.fm.nt.NtResource";
    private LetterOfCreditReachFilterUI filter;
    private LetterOfCreditInfo creditInfo = null;
    private String selectedID = "";

    public String getSelectedID() {
        return this.selectedID;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LetterOfCreditReachFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return LetterOfCreditReachEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filter) {
            this.filter = new LetterOfCreditReachFilterUI();
        }
        return this.filter;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionPay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
        this.actionAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionInCome.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_showbusiness"));
        this.actionLockRemit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionLockRemitQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_showbusiness"));
        this.actionCreateTo.setVisible(false);
        this.actionView.setEnabled(true);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
    }

    public void onload() throws Exception {
        super.onLoad();
        this.actionAddNew.setVisible(false);
        this.checkBizUnit();
    }

    protected void checkBizUnit() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnAudit.setEnabled(false);
            this.MenuItemAudit.setEnabled(false);
            this.btnAntiAudit.setEnabled(false);
            this.MenuItemAntiAudit.setEnabled(false);
            this.btnPay.setEnabled(false);
            this.MenuItemPay.setEnabled(false);
            this.btnAccept.setEnabled(false);
            this.MenuItemAccept.setEnabled(false);
            this.btnInCome.setEnabled(false);
            this.MenuItemInCome.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("Credit.number"));
        sic.add(new SelectorItemInfo("BillState"));
        sic.add(new SelectorItemInfo("Credit.Amount"));
        sic.add(new SelectorItemInfo("Credit.Balance"));
        sic.add(new SelectorItemInfo("Credit.LetterStatus"));
        sic.add(new SelectorItemInfo("Credit.isDYZ"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("dealMode"));
        sic.add(new SelectorItemInfo("ReachDate"));
        sic.add(new SelectorItemInfo("ReachNum"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("ActualPayDate"));
        sic.add(new SelectorItemInfo("Credit.IsBatch"));
        sic.add(new SelectorItemInfo("Credit.intendPayDate"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("IsRefuse"));
        sic.add(new SelectorItemInfo("IsGenPay"));
        sic.add(new SelectorItemInfo("IsAccept"));
        sic.add(new SelectorItemInfo("IsGenLoanReq"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("DraftDay"));
        sic.add(new SelectorItemInfo("PlanPayDate"));
        sic.add(new SelectorItemInfo("Credit.IsForward"));
        sic.add(new SelectorItemInfo("Credit.contractNumber"));
        sic.add(new SelectorItemInfo("Credit.Currency.id"));
        sic.add(new SelectorItemInfo("Credit.Currency.number"));
        sic.add(new SelectorItemInfo("Credit.Currency.name"));
        sic.add(new SelectorItemInfo("Credit.Currency.precision"));
        sic.add(new SelectorItemInfo("AccREcord.payDate"));
        return sic;
    }

    protected void execQuery() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!currentCompany.isIsBizUnit()) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Credit.isDirect", (Object)new Integer("0")));
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        super.execQuery();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        this.changeButtonStatus();
        this.checkBizUnit();
    }

    private void changeButtonStatus() throws EASBizException, BOSException {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            boolean isClose;
            LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            this.creditInfo = info.getCredit();
            boolean isRefuse = info.getDealMode() == DealModeEnum.Refuse;
            boolean isAudit = info.getBillState() == CreditApplyEnum.Audit;
            boolean bl = isClose = this.creditInfo.getLetterStatus() == LetterStatusEnum.close;
            if (!isAudit && !isClose) {
                if (CreditApplyEnum.Save.equals((Object)info.getBillState())) {
                    this.actionAudit.setEnabled(false);
                } else {
                    this.actionAudit.setEnabled(true);
                }
                this.actionAntiAudit.setEnabled(false);
            } else if (isClose) {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(false);
            } else {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(true);
            }
            BigDecimal balance = this.creditInfo.getBalance();
            if (!isRefuse && !isClose && isAudit && (balance.compareTo(Constants.ZERO) != 0 && !info.getCredit().isIsDYZ() || info.getCredit().isIsDYZ()) && !info.isIsGenPay()) {
                this.actionPay.setEnabled(true);
            } else {
                this.actionPay.setEnabled(false);
            }
            this.actionInCome.setEnabled(false);
            this.actionAccept.setEnabled(false);
            if (!isClose && isAudit && (balance.compareTo(Constants.ZERO) != 0 && !info.getCredit().isIsDYZ() || info.getCredit().isIsDYZ())) {
                if ((info.getDealMode() == DealModeEnum.ImportNeg || info.getDealMode() == DealModeEnum.Accept && info.isIsAccept()) && !info.isIsGenLoanReq()) {
                    this.actionInCome.setEnabled(true);
                }
                if (info.getDealMode() == DealModeEnum.Accept && !info.isIsAccept()) {
                    this.actionAccept.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            Set idSet = FMHelper.list2Set((List)idList);
            LetterOfCreditReachFactory.getRemoteInstance().audit(idSet);
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        LetterOfCreditReachFactory.getRemoteInstance().antiAudit(idSet);
        this.refresh(e);
    }

    @Override
    public void actionAccept_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"271_LetterOfCreditApplyListUI"));
            SysUtil.abort();
        }
        String reachId = this.getSelectedKeyValue();
        String id = this.creditInfo.getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"AcceptID", (Object)id);
        uiContext.put((Object)"ReachID", (Object)reachId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LetOfCreditAcctRecordEditUI.class.getName(), (Map)uiContext, null, "ADDNEW");
        uiWindow.show();
        this.refresh(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"LetterOfCreditReachID", (Object)this.getSelectSingleId());
    }

    @Override
    public void actionPay_actionPerformed(ActionEvent e) throws Exception {
        String id;
        this.selectedID = id = this.getSelectSingleId();
        LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        boolean isNeedAccept = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN005", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
        if (isNeedAccept && info.getCredit().isIsForward()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            view.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("bill", (Object)info.getCredit().getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("billState", (Object)"audited", CompareType.NOTEQUALS));
            LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getRemoteInstance().getLetOfCreditAcctRecordCollection(view);
            if (colls.size() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"551_LetterOfCreditListUI"));
                this.abort();
            }
        }
        if (info.getDealMode() == DealModeEnum.Pay || info.getDealMode() == DealModeEnum.ImportNeg) {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new LetterOfCreditInfo().getBOSType().toString(), (String)new RepaymentInfo().getBOSType().toString(), (String)this.creditInfo.getId().toString());
        }
        if (info.getDealMode() == DealModeEnum.Accept && !info.isIsAccept()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"244_LetterOfCreditListUI"));
            this.abort();
        } else if (info.getDealMode() == DealModeEnum.Accept && info.isIsAccept() && !EmptyUtil.isEmpty((CoreBaseInfo)info.getAccREcord())) {
            LetOfCreditAcctRecordInfo recordInfo = info.getAccREcord();
            String pk = recordInfo.getId().toString();
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new LetOfCreditAcctRecordInfo().getBOSType().toString(), (String)new RepaymentInfo().getBOSType().toString(), (String)pk);
        }
        this.selectedID = null;
        this.refresh(e);
    }

    @Override
    public void actionInCome_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        HashSet ids = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("credit.*");
        view.setSelector(selectors);
        CoreBillBaseCollection letterOfCreditReachColls = LetterOfCreditReachFactory.getRemoteInstance().getCoreBillBaseCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)letterOfCreditReachColls)) {
            boolean isgenerateBill = true;
            String creditNum = ((LetterOfCreditReachInfo)letterOfCreditReachColls.get(0)).getCredit().getNumber();
            for (int i = 0; i < letterOfCreditReachColls.size(); ++i) {
                LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)letterOfCreditReachColls.get(i);
                if (!creditNum.equals(info.getCredit().getNumber()) || info.getBillState() != CreditApplyEnum.Audit || info.getDealMode() != DealModeEnum.ImportNeg && (info.getDealMode() != DealModeEnum.Accept || !info.isIsAccept()) || info.isIsGenLoanReq()) {
                    isgenerateBill = false;
                    break;
                }
                creditNum = info.getCredit().getNumber();
            }
            if (!isgenerateBill) {
                MsgBox.showInfo((String)EASResource.getString((String)NT_RES, (String)"NotAllowInCome"));
                SysUtil.abort();
            }
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new LetterOfCreditReachInfo().getBOSType().toString(), (String)new LoanApplyBillInfo().getBOSType().toString(), (CoreBillBaseCollection)letterOfCreditReachColls);
            this.refresh(e);
            this.refreshList();
        }
    }

    public void showDialogUI(CoreUI ui, String id) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"AcceptID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LetOfCreditAcctRecordDialogUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        uiWindow.close();
    }

    private String getSelectSingleId() {
        this.checkSelected();
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"271_LetterOfCreditApplyListUI"));
            SysUtil.abort();
        }
        return this.getSelectedKeyValue();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        LetterOfCreditInfo creditInfo;
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info != null && info.getBillState() == CreditApplyEnum.Audit) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"ReachBillCantModify_567"));
            SysUtil.abort();
        }
        if ((creditInfo = this.getLetterOfCreditInfo(info)) != null && creditInfo.getLetterStatus() == LetterStatusEnum.close) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"ReachBillCanNotModify"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    private LetterOfCreditInfo getLetterOfCreditInfo(LetterOfCreditReachInfo info) throws Exception {
        if (info == null) {
            return null;
        }
        LetterOfCreditInfo letterOfCreditInfo = null;
        if (info.getSourceBillId() != null) {
            letterOfCreditInfo = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        }
        return letterOfCreditInfo;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"Credit.number"};
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromLoanApply") != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompanyCommon.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("BillState", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("IsGenLoanReq", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("IsGenPay", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("dealMode", (Object)"1"));
        }
        return filter;
    }

    @Override
    public void actionLockRemit_actionPerformed(ActionEvent e) throws Exception {
        String srcCurrId;
        String id = this.getSelectSingleId();
        LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String destCurrId = currentCompany.getBaseCurrency().getId().toString();
        if (destCurrId.equals(srcCurrId = info.getCredit().getCurrency().getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)NT_RES, (String)"cannotLockRemit01"));
            SysUtil.abort();
        }
        boolean isLockRemit = this.getGenLockRemit(id);
        if (info.isIsAccept() && !info.isIsGenPay() && !info.isIsGenLoanReq() && !isLockRemit) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"LetterOfCreditReach", (Object)info);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LockRemitEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)NT_RES, (String)"cannotLockRemit02"));
        }
    }

    @Override
    public void actionLockRemitQuery_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectSingleId();
        boolean isLockRemit = this.getGenLockRemit(id);
        if (!isLockRemit) {
            MsgBox.showInfo((String)EASResource.getString((String)NT_RES, (String)"noLockRemitRecord"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"letterOfCreditReachId", (Object)this.getSelectedKeyValue());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LockRemitListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    private boolean getGenLockRemit(String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id));
        LockRemitCollection colls = LockRemitFactory.getRemoteInstance().getLockRemitCollection(view);
        return colls.size() > 0;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectSingleId();
        if (id != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("BillState"));
            sic.add(new SelectorItemInfo("Credit.id"));
            sic.add(new SelectorItemInfo("Credit.LetterStatus"));
            LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), sic);
            if (LetterStatusEnum.close.equals((Object)info.getCredit().getLetterStatus()) || CreditApplyEnum.Audit.equals((Object)info.getBillState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"566_ReachCantDelete"));
                SysUtil.abort();
            } else {
                super.actionRemove_actionPerformed(e);
            }
        }
    }
}

