/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.AcceptanceRecordsInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditRecEntityInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditRecStateEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractLetterOfCreditReceiveEditUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditRecerveListUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class LetterOfCreditReceiveEditUI
extends AbstractLetterOfCreditReceiveEditUI {
    private static final long serialVersionUID = 4074675419133284887L;
    private static final Logger logger = CoreUIObject.getLogger(LetterOfCreditReceiveEditUI.class);
    private static final String AllComponentsListeners = LetterOfCreditReceiveEditUI.class.getName();
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.LetterOfCreditResource";
    private KDTable curTable;

    @Override
    public void storeFields() {
        this.editData.setBenefitCustomer(this.getCustomer(this.prmtBeneficiary.getData()));
        this.editData.setBenefitSupplier(this.getSupplier(this.prmtBeneficiary.getData()));
        this.editData.setBeneficiary(this.getStringName(this.prmtBeneficiary.getValue()));
        this.tblEntries.removeRow(this.tblEntries.getRowCount() - 1);
        this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
        super.storeFields();
        this.editData.setNtType((NTTypeInfo)this.comboBillType.getSelectedItem());
        this.editData.setHorizon(this.txtHorizon.getBigDecimalValue());
        this.editData.setIssueCurrency((CurrencyInfo)this.comboissueCurrency.getSelectedItem());
        this.editData.setContracCurrency((CurrencyInfo)this.combocontracCurrency.getSelectedItem());
        this.AddStatTotalRow();
        this.AddAcceptanceRecordsStatTotalRow();
    }

    @Override
    public void loadFields() {
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (EmptyUtil.isEmpty((Object)this.editData.getIssureDate())) {
            this.editData.setIssureDate(DateUtil.getDayBegin((Date)new Date()));
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboissueCurrency, (Object)this.editData.getIssueCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.combocontracCurrency, (Object)this.editData.getContracCurrency());
        if (this.editData.getNtType() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)this.editData.getNtType());
        } else {
            this.comboBillType.setSelectedIndex(0);
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        super.loadFields();
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
            this.comboissueCurrency_Changed();
            this.chkIsDYZ_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.AddStatTotalRow();
        this.AddAcceptanceRecordsStatTotalRow();
        CurrencyInfo currency = (CurrencyInfo)this.comboissueCurrency.getSelectedItem();
        if (currency != null && FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.currentCompany)) {
            this.txtLocalCurExRate.setEnabled(false);
        } else if (this.editData != null && this.editData.getBillstate().getValue() < 2) {
            this.txtLocalCurExRate.setEnabled(true);
        } else {
            this.txtLocalCurExRate.setEnabled(false);
        }
        if (this.editData.getBenefitCustomer() != null) {
            this.prmtBeneficiary.setData((Object)this.editData.getBenefitCustomer());
        } else if (this.editData.getBenefitSupplier() != null) {
            this.prmtBeneficiary.setData((Object)this.editData.getBenefitSupplier());
        } else {
            this.prmtBeneficiary.setValue((Object)this.editData.getBeneficiary());
        }
        if (this.editData.isIsForward()) {
            this.pane.setEnabledAt(1, true);
            this.tblAcceptanceRecords.setEnabled(true);
            this.btnAddAcceptanceRecords.setEnabled(true);
            this.btnDelAcceptanceRecords.setEnabled(true);
        } else {
            this.pane.setEnabledAt(1, false);
            this.tblAcceptanceRecords.setEnabled(false);
            this.btnAddAcceptanceRecords.setEnabled(false);
            this.btnDelAcceptanceRecords.setEnabled(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        try {
            if (this.getUIContext().get(AllComponentsListeners) != null) {
                FMClientHelper.addCompListeners((CoreUI)this, (Map)((Map)this.getUIContext().get(AllComponentsListeners)));
                this.getUIContext().put(AllComponentsListeners, null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        this.tblEntries.checkParsed();
        this.tblAcceptanceRecords.checkParsed();
        super.onLoad();
        this.checkBizUnit();
        this.txtRemark.setMaxLength(80);
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        try {
            if (this.getUIContext().get(AllComponentsListeners) == null) {
                this.getUIContext().put(AllComponentsListeners, FMClientHelper.removeCompListeners((CoreUI)this));
            }
            FMClientHelper.initComboCurrency((KDComboBox)this.comboissueCurrency, (boolean)true, (String)this.getOprtState());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.setDataObject(dataObject);
        LetterOfCreditReceiveInfo objectValue = (LetterOfCreditReceiveInfo)dataObject;
        if (this.getBOTPViewStatus() == 1) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)objectValue.getCompany())) {
                objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)objectValue.getCreator())) {
                objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
            }
            if (EmptyUtil.isEmpty((Object)objectValue.getBizDate())) {
                objectValue.setBizDate(DateUtil.getDayBegin((Date)new Date()));
            }
            if (EmptyUtil.isEmpty((Object)objectValue.getGuaranteeType())) {
                objectValue.setGuaranteeType(GuaranteeTypeInputModeEnum.assure);
            }
            if (EmptyUtil.isEmpty((Object)objectValue.getIssureDate())) {
                objectValue.setIssureDate(DateUtil.getDayBegin((Date)new Date()));
            }
            if (EmptyUtil.isEmpty((Object)objectValue.getExpiredDate())) {
                objectValue.setExpiredDate(DateUtil.getDayBegin((Date)new Date()));
            }
            if (EmptyUtil.isEmpty((Object)objectValue.getIntendDate())) {
                objectValue.setIntendDate(DateUtil.getDayBegin((Date)new Date()));
            }
            objectValue.setHorizon(FinHorizon.getHorizon((Date)objectValue.getIssureDate(), (Date)objectValue.getExpiredDate()));
            if (!objectValue.isIsForward()) {
                this.txtforwardDate.setEnabled(false);
            }
            objectValue.setLetterStatus(LetterStatusEnum.open);
            objectValue.setBillAmount(objectValue.getAmount());
        }
    }

    protected void initDataStatus() {
        LetterOfCreditReceiveInfo info;
        super.initDataStatus();
        if (this.editData != null && this.getOprtState().equals(OprtState.EDIT)) {
            if (this.editData.getBillstate().getValue() >= 2) {
                if (this.editData.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
                    for (int i = 0; i < this.kDPanel1.getComponents().length; ++i) {
                        this.kDPanel1.getComponent(i).setEnabled(false);
                    }
                    this.tblEntries.setEnabled(false);
                } else {
                    for (int i = 0; i < this.kDPanel1.getComponents().length; ++i) {
                        this.kDPanel1.getComponent(i).setEnabled(false);
                    }
                }
            } else {
                CurrencyInfo currency = (CurrencyInfo)this.comboissueCurrency.getSelectedItem();
                if (currency != null && FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.currentCompany)) {
                    this.txtLocalCurExRate.setEnabled(false);
                } else {
                    this.txtLocalCurExRate.setEnabled(true);
                }
            }
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionAudit.setEnabled(true);
            this.actionAntiAudit.setEnabled(true);
            this.actionReditOpen.setEnabled(true);
            this.actionReditClose.setEnabled(true);
            this.actionAddEntryLine.setEnabled(false);
            this.actionDelEntryLine.setEnabled(false);
        } else {
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            this.actionReditOpen.setEnabled(false);
            this.actionReditClose.setEnabled(false);
            this.actionAddEntryLine.setEnabled(true);
            this.actionDelEntryLine.setEnabled(true);
            this.actionGenRecBill.setEnabled(false);
            this.menuSubmitOption.setVisible(true);
            this.chkMenuItemSubmitAndAddNew.setVisible(true);
            this.chkMenuItemSubmitAndPrint.setVisible(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionAudit.setEnabled(true);
        }
        if ((info = (LetterOfCreditReceiveInfo)this.getDataObject()).getId() != null && info.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCreateFrom.setVisible(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionReditClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionReditOpen.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_staruse"));
        this.actionGenRecBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
        this.initF7Filter();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtRecBankAcct.setSelectorCollection(sic);
        this.prmtRecBankAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtDepartment);
        ChequeUtil.initPerson((IUIObject)this, this.prmtLtterHandler);
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            if (this.editData.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
                this.actionAddEntryLine.setEnabled(false);
                this.actionDelEntryLine.setEnabled(false);
            } else {
                this.actionAddEntryLine.setEnabled(true);
                this.actionDelEntryLine.setEnabled(true);
                KDDatePicker datepk = new KDDatePicker();
                this.tblEntries.getColumn("receiveDate").setEditor((ICellEditor)new KDTDefaultCellEditor(datepk));
            }
        }
        if (this.getOprtState().equals(OprtState.EDIT) && this.editData.getBillstate().getValue() >= 2) {
            if (this.editData.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
                for (int i = 0; i < this.kDPanel1.getComponents().length; ++i) {
                    this.kDPanel1.getComponent(i).setEnabled(false);
                }
                this.tblEntries.setEnabled(false);
            } else {
                for (int i = 0; i < this.kDPanel1.getComponents().length; ++i) {
                    this.kDPanel1.getComponent(i).setEnabled(false);
                }
            }
        }
        KDFormattedTextField receiveAmountField = new KDFormattedTextField();
        receiveAmountField.setDataType(1);
        receiveAmountField.setHorizontalAlignment(4);
        receiveAmountField.setRequired(true);
        receiveAmountField.setSupportedEmpty(false);
        this.tblEntries.getColumn("receiveAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)receiveAmountField));
        KDFormattedTextField consignAmountField = new KDFormattedTextField();
        consignAmountField.setDataType(1);
        consignAmountField.setHorizontalAlignment(4);
        consignAmountField.setRequired(true);
        consignAmountField.setSupportedEmpty(false);
        this.tblEntries.getColumn("consignAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)consignAmountField));
        NTHelper.initCSF7((IUIObject)this, this.prmtBeneficiary, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign", null);
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        FMClientHelper.initComboCurrency((KDComboBox)this.combocontracCurrency, (boolean)false);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtInstitution, null, (boolean)true);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtNotifyBank, null, (boolean)true);
        this.prmtBeneficiary.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.txtFluctuateScale.setMinimumValue((Comparable)new BigDecimal("-100"));
        this.txtFluctuateScale.setMaximumValue((Comparable)new BigDecimal("100"));
        this.txtContractAmount.setHorizontalAlignment(4);
        this.pkIssureDate.setSupportedEmpty(false);
        this.pkExpiredDate.setSupportedEmpty(false);
        this.pkIntendDate.setSupportedEmpty(false);
        this.txtHorizon.setPrecision(1);
        this.txtHorizon.setRemoveingZeroInDispaly(false);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtHorizon);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtBillAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtBalance);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtLocalCurExRate);
        this.txtAmount.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtBillAmount.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtContractAmount.setMinimumValue((Comparable)new BigDecimal(0));
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtContractAmount);
        this.txtContractAmount.setPrecision(2);
        this.txtHorizon.setNegatived(false);
        NTTypeCollection colls = NTClientHelper.getNTTypesBySuperGroup(NTTypeGroupEnum.ExportCredit);
        if (this.comboBillType.getItemCount() != colls.size()) {
            this.comboBillType.removeAllItems();
            this.comboBillType.addItems(colls.toArray());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LetterOfCreditReceiveFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        LetterOfCreditReceiveInfo objectValue = new LetterOfCreditReceiveInfo();
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            try {
                LetterOfCreditReceiveInfo oldInfo = (LetterOfCreditReceiveInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                objectValue = oldInfo.copy();
                objectValue.setNumber(null);
                objectValue.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                objectValue.setCreator(this.userinfo);
                objectValue.setCompany(this.currentCompany);
                objectValue.setLetterStatus(LetterStatusEnum.open);
                objectValue.setCreateTime(new Timestamp(System.currentTimeMillis()));
                map.remove("COPY");
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        } else {
            objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
            objectValue.setBizDate(DateUtil.getDayBegin((Date)new Date()));
            objectValue.setIssueCurrency(this.currentCompany.getBaseCurrency());
            objectValue.setContracCurrency(this.currentCompany.getBaseCurrency());
            objectValue.setLocalCurExRate(Constants.ONE);
            objectValue.setExpiredDate(DateUtil.getDayBegin((Date)new Date()));
            objectValue.setIssureDate(DateUtil.getDayBegin((Date)new Date()));
            objectValue.setIntendDate(DateUtil.getDayBegin((Date)new Date()));
            objectValue.setIsForward(true);
            objectValue.setHorizon(Constants.ZERO);
            objectValue.setAmount(Constants.ZERO);
            objectValue.setFluctuateScale(Constants.ZERO);
            objectValue.setFScalefloor(Constants.ZERO);
            objectValue.setGuaranteeType(GuaranteeTypeInputModeEnum.assure);
            objectValue.setLetterStatus(LetterStatusEnum.open);
            objectValue.setBillAmount(Constants.ZERO);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(104)));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("financeType.*"));
        view.getSelector().add(new SelectorItemInfo("financeType.FinancingSource.*"));
        try {
            NTTypeCollection coll = NTTypeFactory.getRemoteInstance().getNTTypeCollection(view);
            objectValue.setNtType(coll.get(0));
        }
        catch (BOSException e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"261_LetterOfCreditApplyEditUI"));
            SysUtil.abort();
        }
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("contractNumber"));
        sic.add(new SelectorItemInfo("contractAmount"));
        sic.add(new SelectorItemInfo("issureDate"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("AmountLocalCur"));
        sic.add(new SelectorItemInfo("FScalefloor"));
        sic.add(new SelectorItemInfo("FluctuateScale"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("intendDate"));
        sic.add(new SelectorItemInfo("Beneficiary"));
        sic.add(new SelectorItemInfo("TransportMode"));
        sic.add(new SelectorItemInfo("LoadPort"));
        sic.add(new SelectorItemInfo("DestinationPort"));
        sic.add(new SelectorItemInfo("LoadDate"));
        sic.add(new SelectorItemInfo("department.number"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("RecBankAcct.number"));
        sic.add(new SelectorItemInfo("RecBankAcct.name"));
        sic.add(new SelectorItemInfo("balance"));
        sic.add(new SelectorItemInfo("guaranteeType"));
        sic.add(new SelectorItemInfo("Credit"));
        sic.add(new SelectorItemInfo("IsForward"));
        sic.add(new SelectorItemInfo("IsDYZ"));
        sic.add(new SelectorItemInfo("IsBatch"));
        sic.add(new SelectorItemInfo("IsDivert"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("entries.consignNum"));
        sic.add(new SelectorItemInfo("entries.consignAmount"));
        sic.add(new SelectorItemInfo("entries.receiveDate"));
        sic.add(new SelectorItemInfo("entries.receiveAmount"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("NotifyBank.number"));
        sic.add(new SelectorItemInfo("NotifyBank.name"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("LtterHandler.number"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        sic.add(new SelectorItemInfo("BeneficiaryStat.number"));
        sic.add(new SelectorItemInfo("BeneficiaryStat.name"));
        sic.add(new SelectorItemInfo("LtterHandler.number"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        sic.add(new SelectorItemInfo("ntType"));
        sic.add(new SelectorItemInfo("forwardDate"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("LetterStatus"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("ntType"));
        sic.add(new SelectorItemInfo("contracCurrency"));
        sic.add(new SelectorItemInfo("issueCurrency"));
        sic.add(new SelectorItemInfo("billAmount"));
        sic.add(new SelectorItemInfo("benefitCustomer.*"));
        sic.add(new SelectorItemInfo("benefitSupplier.*"));
        sic.add(new SelectorItemInfo("acceptanceRecords.acceptanceDate"));
        sic.add(new SelectorItemInfo("acceptanceRecords.endDate"));
        sic.add(new SelectorItemInfo("acceptanceRecords.acceptanceRate"));
        sic.add(new SelectorItemInfo("acceptanceRecords.acceptanceAmount"));
        sic.add(new SelectorItemInfo("acceptanceRecords.remark"));
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtBillAmount);
        if (this.pkExpiredDate.getSqlDate().compareTo(this.pkIssureDate.getSqlDate()) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"446_LetterOfCreditReceiveEditUI"));
            SysUtil.abort();
        }
        if (this.pkIntendDate.getSqlDate().compareTo(this.pkIssureDate.getSqlDate()) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"452_LetterOfCreditReceiveEditUI"));
            SysUtil.abort();
        }
        if (this.txtFScalefloor.getIntegerValue().compareTo(this.txtFluctuateScale.getIntegerValue()) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"263_LetterOfCreditApplyEditUI"));
            SysUtil.abort();
        }
        if (this.txtRemark.getText().length() > 200) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"264_LetterOfCreditApplyEditUI"));
            SysUtil.abort();
        }
        if (this.txtBalance.getBigDecimalValue().compareTo(Constants.ZERO) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"274_LetterOfCreditReceiveEditUI"));
            SysUtil.abort();
        }
        this.verifyAcceptanceRecordsDate();
    }

    private void verifyAcceptanceRecordsDate() {
        for (int i = 0; this.tblAcceptanceRecords.getRowCount() > 1 && i < this.tblAcceptanceRecords.getRowCount() - 1; ++i) {
            Object acceptanceRate;
            IRow row = this.tblAcceptanceRecords.getRow(i);
            Object acceptanceDate = row.getCell("acceptanceDate").getValue();
            Object endDate = row.getCell("endDate").getValue();
            if (acceptanceDate instanceof String) {
                acceptanceDate = DateUtil.stringToDate((String)((String)acceptanceDate));
            }
            if (endDate instanceof String) {
                endDate = DateUtil.stringToDate((String)((String)endDate));
            }
            if (acceptanceDate == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"615_LetterOfCreditReceiveEditUI")));
                return;
            }
            if (endDate == null) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"616_LetterOfCreditReceiveEditUI")));
                return;
            }
            if (((Date)acceptanceDate).compareTo((Date)endDate) >= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"acceptance_After_EndDate", (Object[])new String[]{new Integer(i + 1).toString()}));
                SysUtil.abort();
            }
            if ((acceptanceRate = row.getCell("acceptanceRate").getValue()) instanceof String) {
                acceptanceRate = new BigDecimal((String)acceptanceRate);
            }
            if (((BigDecimal)acceptanceRate).compareTo(Constants.ZERO) > 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"acceptanceRate_is_error", (Object[])new String[]{new Integer(i + 1).toString()}));
            SysUtil.abort();
        }
    }

    private void verifyAcceptanceRecordsAmt() {
        for (int i = 0; this.tblAcceptanceRecords.getRowCount() > 1 && i < this.tblAcceptanceRecords.getRowCount() - 1; ++i) {
            IRow row = this.tblAcceptanceRecords.getRow(i);
            String acceptanceAmount = row.getCell("acceptanceAmount").getValue().toString();
            if (new BigDecimal(acceptanceAmount).compareTo(Constants.ZERO) > 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"acceptanceAmount_is_error", (Object[])new String[]{new Integer(i + 1).toString()}));
            SysUtil.abort();
        }
    }

    private void initF7Filter() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBeneficiaryStat.setEntityViewInfo(evi);
    }

    @Override
    protected void comboissueCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null && e.getStateChange() == 2) {
            return;
        }
        if (this.comboissueCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboissueCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtBillAmount.setPrecision(currency.getPrecision());
            this.txtBalance.setPrecision(currency.getPrecision());
            this.txtAmountLocalCur.setPrecision(currency.getPrecision());
            CompanyOrgUnitInfo company = this.currentCompany;
            try {
                LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)this.getDataObject();
                if (info != null) {
                    CurrencyInfo baseCurrency = company.getBaseCurrency();
                    if (baseCurrency == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("baseCurrency.*"));
                        sic.add(new SelectorItemInfo("baseCurrency.id"));
                        sic.add(new SelectorItemInfo("baseCurrency.number"));
                        sic.add(new SelectorItemInfo("baseCurrency.name"));
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
                        baseCurrency = company.getBaseCurrency();
                    }
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)baseCurrency, (Date)info.getBizDate(), null);
                    this.txtLocalCurExRate.setPrecision(5);
                }
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboissueCurrency, (Object)this.currentCompany.getBaseCurrency());
                throw e1;
            }
            if (this.editData != null) {
                this.editData.setAmountLocalCur(this.getLocalAmount());
                this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
                this.editData.setLocalCurExRate((BigDecimal)this.txtLocalCurExRate.getValue());
            }
            if (FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.currentCompany)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else if (this.editData != null && this.editData.getBillstate().getValue() < 2) {
                this.txtLocalCurExRate.setEnabled(true);
            } else {
                this.txtLocalCurExRate.setEnabled(false);
            }
        }
    }

    private BigDecimal getLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssureDate, (KDDatePicker)this.pkExpiredDate));
    }

    @Override
    protected void pkIssureDate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssureDate, (KDDatePicker)this.pkExpiredDate));
    }

    @Override
    protected void prmtRecBankAcct_willShow(SelectorEvent e) throws Exception {
        BankInfo bank = (BankInfo)this.prmtInstitution.getValue();
        if (bank == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"275_LetterOfCreditReceiveEditUI"));
            this.prmtInstitution.requestFocus();
            e.setCanceled(true);
            return;
        }
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)Boolean.FALSE);
        FilterItemInfo filterItem3 = new FilterItemInfo("bank.id", (Object)bank.getId());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtRecBankAcct, (FilterItemInfo)filterItem1);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtRecBankAcct, (FilterItemInfo)filterItem2);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtRecBankAcct, (FilterItemInfo)filterItem3);
        this.prmtRecBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal bdAmount;
        BigDecimal locAmount = this.getLocalAmount();
        this.txtAmountLocalCur.setValue((Object)locAmount);
        this.editData.setAmountLocalCur(locAmount);
        this.txtBillAmount.setValue((Object)this.txtAmount.getBigDecimalValue());
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.calBalanceValue();
        }
        if (this.chkIsForward.isSelected() && (bdAmount = this.txtAmount.getBigDecimalValue()) != null && this.tblAcceptanceRecords.getRowCount() > 1) {
            this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
            for (int i = 0; i < this.tblAcceptanceRecords.getRowCount(); ++i) {
                Object acceptanceRate = this.tblAcceptanceRecords.getRow(i).getCell("acceptanceRate").getValue();
                if (acceptanceRate == null) continue;
                if (acceptanceRate instanceof String) {
                    acceptanceRate = new BigDecimal((String)acceptanceRate);
                }
                BigDecimal val = ((BigDecimal)acceptanceRate).divide(Constants.ONE_HUNDRED);
                this.tblAcceptanceRecords.getRow(i).getCell("acceptanceAmount").setValue((Object)bdAmount.multiply(val));
            }
            this.AddAcceptanceRecordsStatTotalRow();
        }
    }

    @Override
    protected void chkIsForward_actionPerformed(ActionEvent e) throws Exception {
        super.chkIsForward_actionPerformed(e);
        if (this.chkIsForward.isSelected()) {
            this.txtforwardDate.setEditable(true);
            this.txtforwardDate.setEnabled(true);
            this.pane.setEnabledAt(1, true);
            this.acceptanceRecords.setEnabled(true);
            this.tblAcceptanceRecords.setEnabled(true);
            this.btnAddAcceptanceRecords.setEnabled(true);
            this.btnDelAcceptanceRecords.setEnabled(true);
        } else {
            this.txtforwardDate.setEditable(false);
            this.txtforwardDate.setEnabled(false);
            this.txtforwardDate.setValue((Object)new Integer(0));
            this.pane.setEnabledAt(1, false);
            this.acceptanceRecords.setEnabled(false);
            this.tblAcceptanceRecords.setEnabled(false);
            this.btnAddAcceptanceRecords.setEnabled(false);
            this.btnDelAcceptanceRecords.setEnabled(false);
            this.tblAcceptanceRecords.removeRows();
        }
    }

    @Override
    protected void chkIsDYZ_actionPerformed(ActionEvent e) throws Exception {
        super.chkIsDYZ_actionPerformed(e);
        if (this.chkIsDYZ.isSelected()) {
            this.txtFScalefloor.setEnabled(true);
            this.txtFScalefloor.setEditable(true);
            this.txtFluctuateScale.setEditable(true);
            this.txtFluctuateScale.setEnabled(true);
        } else {
            this.txtFScalefloor.setValue((Object)new Integer(0));
            this.txtFluctuateScale.setValue((Object)new Integer(0));
            this.txtFScalefloor.setEnabled(false);
            this.txtFluctuateScale.setEnabled(false);
        }
    }

    protected void txtForwardDate_stateChanged(ChangeEvent e) throws Exception {
        if ((Integer)this.txtforwardDate.getValue() < 0) {
            this.txtforwardDate.setValue((Object)new Integer(0));
        }
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    protected KDTable getDetailTable() {
        if (this.curTable == null) {
            return this.tblEntries;
        }
        return this.curTable;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        LetterOfCreditRecEntityInfo entryInfo = new LetterOfCreditRecEntityInfo();
        if (this.tblAcceptanceRecords.getName().equals(table.getName())) {
            AcceptanceRecordsInfo recordInfo = new AcceptanceRecordsInfo();
            return recordInfo;
        }
        return entryInfo;
    }

    private void AddAcceptanceRecordsStatTotalRow() {
        BigDecimal acceptanceAmount = Constants.ZERO;
        for (int i = 0; i < this.tblAcceptanceRecords.getRowCount(); ++i) {
            Object subAcceptanceAmount = this.tblAcceptanceRecords.getRow(i).getCell("acceptanceAmount").getValue();
            if (subAcceptanceAmount == null) continue;
            if (subAcceptanceAmount instanceof BigDecimal) {
                acceptanceAmount = acceptanceAmount.add((BigDecimal)subAcceptanceAmount);
                continue;
            }
            try {
                acceptanceAmount = acceptanceAmount.add(new BigDecimal(subAcceptanceAmount.toString()));
                continue;
            }
            catch (Exception e) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"617_LetterOfCreditReceiveEditUI")));
                this.tblAcceptanceRecords.getRow(i).getCell("acceptanceAmount").setValue((Object)new BigDecimal("0"));
                if (this.tblAcceptanceRecords.getRowCount() > 0) {
                    IRow rowStat = this.tblAcceptanceRecords.addRow();
                    rowStat.getCell("acceptanceAmount").setValue((Object)acceptanceAmount);
                    rowStat.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"276_LetterOfCreditReceiveEditUI"));
                    rowStat.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                }
                return;
            }
        }
        if (this.tblAcceptanceRecords.getRowCount() > 0) {
            IRow rowStat = this.tblAcceptanceRecords.addRow();
            rowStat.getCell("acceptanceAmount").setValue((Object)acceptanceAmount);
            rowStat.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"276_LetterOfCreditReceiveEditUI"));
            rowStat.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
    }

    private void AddStatTotalRow() {
        BigDecimal receiveAmount = Constants.ZERO;
        BigDecimal consignAmount = Constants.ZERO;
        for (int i = 0; i < this.tblEntries.getRowCount(); ++i) {
            BigDecimal subReceiveAmount = (BigDecimal)this.tblEntries.getRow(i).getCell("receiveAmount").getValue();
            BigDecimal subConsignAmount = (BigDecimal)this.tblEntries.getRow(i).getCell("consignAmount").getValue();
            if (subReceiveAmount != null) {
                receiveAmount = receiveAmount.add(subReceiveAmount);
            }
            if (subConsignAmount == null) continue;
            consignAmount = consignAmount.add(subConsignAmount);
        }
        if (this.tblEntries.getRowCount() > 0) {
            IRow rowStat = this.tblEntries.addRow();
            rowStat.getCell("receiveAmount").setValue((Object)receiveAmount);
            rowStat.getCell("consignAmount").setValue((Object)consignAmount);
            rowStat.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"276_LetterOfCreditReceiveEditUI"));
            rowStat.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
    }

    @Override
    public void actionAddEntryLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblEntries.removeRow(this.tblEntries.getRowCount() - 1);
        this.curTable = this.tblEntries;
        super.actionAddLine_actionPerformed(e);
        if (this.tblEntries.getRow(this.tblEntries.getRowCount() - 1) != null) {
            if (this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("receiveAmount") != null) {
                this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("receiveAmount").setValue((Object)Constants.ZERO);
            }
            if (this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("consignAmount") != null) {
                this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("consignAmount").setValue((Object)Constants.ZERO);
            }
            if (this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("receiveDate") != null) {
                this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("receiveDate").setValue((Object)DateUtil.getDayBegin());
            }
        }
        this.AddStatTotalRow();
    }

    @Override
    public void actionDelEntryLine_actionPerformed(ActionEvent e) throws Exception {
        int idx = KDTableUtil.getSelectedRow((KDTable)this.tblEntries);
        if (idx == this.tblEntries.getRowCount() - 1) {
            return;
        }
        this.curTable = this.tblEntries;
        super.actionRemoveLine_actionPerformed(e);
        this.tblEntries.removeRow(this.tblEntries.getRowCount() - 1);
        this.AddStatTotalRow();
        this.calBalanceValue();
    }

    @Override
    public void actionAddRecordsLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
        this.curTable = this.tblAcceptanceRecords;
        super.actionAddLine_actionPerformed(e);
        this.tblAcceptanceRecords.getRow(this.tblAcceptanceRecords.getRowCount() - 1).getCell("acceptanceRate").setValue((Object)Constants.ZERO);
        this.tblAcceptanceRecords.getRow(this.tblAcceptanceRecords.getRowCount() - 1).getCell("acceptanceAmount").setValue((Object)Constants.ZERO);
        this.tblAcceptanceRecords.getRow(this.tblAcceptanceRecords.getRowCount() - 1).getCell("acceptanceDate").setValue((Object)DateUtil.getDayBegin());
        this.tblAcceptanceRecords.getRow(this.tblAcceptanceRecords.getRowCount() - 1).getCell("endDate").setValue((Object)DateUtil.getDayBegin());
        this.AddAcceptanceRecordsStatTotalRow();
    }

    @Override
    public void actionDelRecordsLine_actionPerformed(ActionEvent e) throws Exception {
        int idx = KDTableUtil.getSelectedRow((KDTable)this.tblAcceptanceRecords);
        if (idx == this.tblAcceptanceRecords.getRowCount() - 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"select_one_row"));
            return;
        }
        this.curTable = this.tblAcceptanceRecords;
        super.actionRemoveLine_actionPerformed(e);
        this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
        this.AddAcceptanceRecordsStatTotalRow();
    }

    protected void entries_componentShown(ComponentEvent e) throws Exception {
        this.curTable = this.tblEntries;
    }

    @Override
    protected void acceptanceRecords_componentShown(ComponentEvent e) throws Exception {
        this.curTable = this.tblAcceptanceRecords;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    private void verifyEntryAmt() {
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)"consignAmount");
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblEntries, (String)"receiveAmount");
        if (this.tblEntries.getRow(this.tblEntries.getRowCount() - 1) != null && this.tblEntries.getRowCount() >= 2) {
            for (int i = 0; i < this.tblEntries.getRowCount() - 1; ++i) {
                String consignAmount;
                String receiveAmount = this.tblEntries.getRow(i).getCell("receiveAmount").getValue().toString();
                if (new BigDecimal(receiveAmount).compareTo(Constants.ZERO) <= 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"426_LetterOfCreditReceiveEditUI"));
                    SysUtil.abort();
                }
                if (new BigDecimal(consignAmount = this.tblEntries.getRow(i).getCell("consignAmount").getValue().toString()).compareTo(Constants.ZERO) > 0) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"445_LetterOfCreditReceiveEditUI"));
                SysUtil.abort();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyEntryAmt();
        this.verifyAcceptanceRecordsAmt();
        super.actionSubmit_actionPerformed(e);
        if (this.chkMenuItemSubmitAndAddNew.isSelected()) {
            this.emptyAllFields();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillstate().getValue() >= 2 || this.editData.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"277_LetterOfCreditReceiveEditUI"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillstate().getValue() >= 2 || this.editData.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"278_LetterOfCreditReceiveEditUI"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private void emptyAllFields() {
        this.txtCredit.setText(null);
        this.txtContractNumber.setText(null);
        this.txtContractAmount.setValue(null);
        this.prmtInstitution.setValue(null);
        this.txtAmount.setValue((Object)BigDecimal.ZERO);
        this.txtBalance.setValue(null);
        this.txtforwardDate.setValue((Object)0);
        this.txtFScalefloor.setValue((Object)0);
        this.txtFluctuateScale.setValue((Object)0);
        this.pkIssureDate.setValue((Object)DateUtil.getDayBegin((Date)new Date()));
        this.pkExpiredDate.setValue((Object)DateUtil.getDayBegin((Date)new Date()));
        this.pkIntendDate.setValue((Object)DateUtil.getDayBegin((Date)new Date()));
        this.txtHorizon.setValue((Object)0);
        this.prmtBeneficiaryStat.setValue(null);
        this.prmtBeneficiary.setValue(null);
        this.comboGuaranteeType.setSelectedItem((Object)GuaranteeTypeInputModeEnum.assure);
        this.prmtDepartment.setValue(null);
        this.prmtLtterHandler.setValue(null);
        this.prmtProject.setValue(null);
        this.txtTransportMode.setText(null);
        this.chkIsBatch.setSelected(false);
        this.chkIsDivert.setSelected(false);
        this.chkIsForward.setSelected(true);
        this.prmtNotifyBank.setValue(null);
        this.txtDestinationPort.setText(null);
        this.pkLoadDate.setValue(null);
        this.txtLoadPort.setText(null);
        this.prmtRecBankAcct.setValue(null);
        this.txtBillAmount.setValue((Object)BigDecimal.ZERO);
        this.txtRemark.setText(null);
    }

    @Override
    public void tblEntries_editStopped(KDTEditEvent e) throws Exception {
        super.tblEntries_editStopping(e);
        this.tblEntries.removeRow(this.tblEntries.getRowCount() - 1);
        this.AddStatTotalRow();
        this.calBalanceValue();
    }

    @Override
    protected void tblAcceptanceRecords_editStopped(KDTEditEvent e) throws Exception {
        super.tblEntries_editStopping(e);
        this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
        this.AddAcceptanceRecordsStatTotalRow();
        if (e.getRowIndex() != this.tblAcceptanceRecords.getRowCount() - 1) {
            if (e.getColIndex() == 0 || e.getColIndex() == 1) {
                Object acceptanceDate = this.tblAcceptanceRecords.getRow(e.getRowIndex()).getCell("acceptanceDate").getValue();
                Object endDate = this.tblAcceptanceRecords.getRow(e.getRowIndex()).getCell("endDate").getValue();
                if (acceptanceDate instanceof String) {
                    acceptanceDate = DateUtil.stringToDate((String)((String)acceptanceDate));
                }
                if (endDate instanceof String) {
                    endDate = DateUtil.stringToDate((String)((String)endDate));
                }
                if (acceptanceDate == null) {
                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + new Integer(e.getRowIndex() + 1).toString() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"615_LetterOfCreditReceiveEditUI")));
                    this.tblAcceptanceRecords.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    return;
                }
                if (endDate == null) {
                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + new Integer(e.getRowIndex() + 1).toString() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"616_LetterOfCreditReceiveEditUI")));
                    this.tblAcceptanceRecords.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    return;
                }
                if (((Date)acceptanceDate).compareTo((Date)endDate) >= 0) {
                    if (this.tblAcceptanceRecords.getCell(e.getRowIndex(), e.getColIndex()) != null) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"acceptance_After_EndDate", (Object[])new String[]{new Integer(e.getRowIndex() + 1).toString()}));
                        this.tblAcceptanceRecords.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    }
                    return;
                }
            }
            if (e.getColIndex() == 2 && e.getValue() != null && e.getOldValue() != null) {
                if (e.getValue().equals(e.getOldValue())) {
                    return;
                }
                try {
                    BigDecimal val = new BigDecimal(e.getValue().toString());
                    if (val.compareTo(Constants.ZERO) < 0 || val.compareTo(Constants.ONE_HUNDRED) > 0) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"number_is_wrong", (Object[])new String[]{new Integer(e.getRowIndex() + 1).toString()}));
                        this.tblAcceptanceRecords.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                        return;
                    }
                    BigDecimal acceptanceRate = val.divide(new BigDecimal(100));
                    BigDecimal acceptanceAmount = new BigDecimal(0);
                    acceptanceAmount = this.txtAmount.getValue() instanceof BigDecimal ? acceptanceRate.multiply((BigDecimal)this.txtAmount.getValue()) : acceptanceRate.multiply(new BigDecimal(this.txtAmount.getValue().toString()));
                    this.tblAcceptanceRecords.getRow(e.getRowIndex()).getCell("acceptanceAmount").setValue((Object)acceptanceAmount);
                    this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
                    this.AddAcceptanceRecordsStatTotalRow();
                }
                catch (Exception e1) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"number_is_wrong", (Object[])new String[]{new Integer(e.getRowIndex() + 1).toString()}));
                    this.tblAcceptanceRecords.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    return;
                }
            }
            if (e.getColIndex() == 4 && e.getValue() != null && e.getValue().toString().length() > 80) {
                String str = e.getValue().toString().substring(0, 80);
                this.tblAcceptanceRecords.getRow(e.getRowIndex()).getCell("remark").setValue((Object)str);
            }
            if (e.getColIndex() == 3) {
                this.tblAcceptanceRecords.removeRow(this.tblAcceptanceRecords.getRowCount() - 1);
                this.AddAcceptanceRecordsStatTotalRow();
            }
        }
    }

    private void calBalanceValue() {
        if (this.tblEntries.getRowCount() > 0) {
            BigDecimal sumReceiveAmt = new BigDecimal(this.tblEntries.getRow(this.tblEntries.getRowCount() - 1).getCell("receiveAmount").getValue().toString());
            this.txtBalance.setValue((Object)this.txtAmount.getBigDecimalValue().subtract(sumReceiveAmt));
        } else {
            this.txtBalance.setValue((Object)this.txtAmount.getBigDecimalValue());
        }
    }

    private void removeEntryLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getBeginRow();
        int bottom = table.getSelectManager().get().getEndRow();
        for (int i = top; i <= bottom; ++i) {
            if (table.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            table.removeRow(top);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        LetterOfCreditReceiveFactory.getRemoteInstance().batchAudit(idSet);
        this.showOperationSuccess(0);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        LetterOfCreditReceiveFactory.getRemoteInstance().batchAntAudit(idSet);
        this.showOperationSuccess(1);
        this.editData.setBillstate(LetterOfCreditRecStateEnum.Submit);
    }

    @Override
    public void actionReditOpen_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        LetterOfCreditReceiveFactory.getRemoteInstance().open(idSet);
        this.showOperationSuccess(2);
    }

    @Override
    public void actionReditClose_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Save)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"279_LetterOfCreditReceiveEditUI"));
            return;
        }
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        LetterOfCreditReceiveFactory.getRemoteInstance().close(idSet, new Date());
        this.showOperationSuccess(3);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)newData;
        info.setNumber(null);
        info.setBizDate(DateUtil.getDayBegin((Date)new Date()));
        info.setBillstate(LetterOfCreditRecStateEnum.Save);
    }

    private void showOperationSuccess(int operationType) {
        String msg = this.getClassAlise();
        StringBuffer msgSB = new StringBuffer(msg);
        switch (operationType) {
            case 0: {
                msgSB.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource.approvedSuc"));
                break;
            }
            case 1: {
                msgSB.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource.reverseApprovedSuc"));
                break;
            }
            case 2: {
                msgSB.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource.ReditOpenSucc"));
                break;
            }
            case 3: {
                msgSB.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource.ReditCloseSucc"));
                break;
            }
        }
        this.setMessageText(msgSB.toString());
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setLetterStatus(LetterStatusEnum.open);
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void actionGenRecBill_actionPerformed(ActionEvent e) throws Exception {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)this.getDataObject();
        if (info == null) {
            return;
        }
        String id = info.getId().toString();
        this.checkGenRecBill(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        try {
            CtrlUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            FMClientHelper.generateDestBillWithCU((CtrlUnitInfo)orgUnitInfo, (CoreBillListUI)new LetterOfCreditRecerveListUI(), (String)new LetterOfCreditReceiveInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (String)id);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            iMutex.releaseObjIDForUpdate(id);
        }
    }

    private void checkGenRecBill(String id) throws Exception {
        LetterOfCreditReceiveInfo letterInfo = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)new ObjectUuidPK(id));
        if (!LetterOfCreditRecStateEnum.Audit.equals((Object)letterInfo.getBillstate())) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"auditFirst");
        }
        if (letterInfo.getBalance().compareTo(Constants.ZERO) <= 0 && !LetterOfCreditRecStateEnum.Submit.equals((Object)letterInfo.getBillstate())) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"balanceerror");
        }
    }

    private void comboissueCurrency_Changed() throws Exception {
        if (this.comboissueCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboissueCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtBillAmount.setPrecision(currency.getPrecision());
            this.txtBalance.setPrecision(currency.getPrecision());
            this.txtAmountLocalCur.setPrecision(currency.getPrecision());
            CompanyOrgUnitInfo company = this.currentCompany;
            try {
                LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)this.getDataObject();
                if (info != null) {
                    CurrencyInfo baseCurrency = company.getBaseCurrency();
                    if (baseCurrency == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("baseCurrency.*"));
                        sic.add(new SelectorItemInfo("baseCurrency.id"));
                        sic.add(new SelectorItemInfo("baseCurrency.number"));
                        sic.add(new SelectorItemInfo("baseCurrency.name"));
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
                        baseCurrency = company.getBaseCurrency();
                    }
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (CurrencyInfo)baseCurrency, (Date)info.getBizDate(), null);
                    this.txtLocalCurExRate.setPrecision(5);
                }
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboissueCurrency, (Object)this.currentCompany.getBaseCurrency());
                throw e1;
            }
            if (this.editData != null) {
                this.editData.setAmountLocalCur(this.getLocalAmount());
                this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
                this.editData.setLocalCurExRate((BigDecimal)this.txtLocalCurExRate.getValue());
            }
            if (FinUtils.isBaseCurrency((CurrencyInfo)currency, (CompanyOrgUnitInfo)this.currentCompany)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else if (this.editData != null && this.editData.getBillstate().getValue() < 2) {
                this.txtLocalCurExRate.setEnabled(true);
            } else {
                this.txtLocalCurExRate.setEnabled(false);
            }
        }
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "issureDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionSave", "actionSubmit"};
    }

    private String getStringName(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    @Override
    protected void prmtBeneficiary_dataChanged(DataChangeEvent e) throws Exception {
        Object beneficiary = this.prmtBeneficiary.getData();
        ObjectBaseInfo csInfo = null;
        if (beneficiary instanceof String && (csInfo = NTHelper.getCSInfoByNumber((String)beneficiary)) != null) {
            this.prmtBeneficiary.setData((Object)csInfo);
        }
    }
}

