/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.nt.AcceptApplyBillException;
import com.kingdee.eas.fm.nt.ILetterOfCreditReceive;
import com.kingdee.eas.fm.nt.LetterOfCreditRecStateEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveCollection;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.client.AbstractLetterOfCreditRecerveListUI;
import com.kingdee.eas.fm.nt.client.CreditRecCloseDatePickUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditDisCountEditUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditReceiveEditUI;
import com.kingdee.eas.fm.nt.client.LetterOfCreditReceiveFilterUI;
import com.kingdee.eas.fm.nt.client.LetterOfQueryprocessor;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditRecerveListUI
extends AbstractLetterOfCreditRecerveListUI {
    private static final long serialVersionUID = 4190585218317135874L;
    private static final Logger logger = CoreUIObject.getLogger(LetterOfCreditRecerveListUI.class);
    private LetterOfCreditReceiveFilterUI filter;
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.LetterOfCreditResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionReditOpen.setEnabled(true);
        this.actionReditClose.setEnabled(true);
        this.tblMain.getColumn("entries.id").getStyleAttributes().setHided(true);
        this.checkBizUnit();
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setVisible(false);
            this.actionReditClose.setVisible(false);
            this.actionReditOpen.setVisible(false);
        }
    }

    protected String getEditUIName() {
        return LetterOfCreditReceiveEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LetterOfCreditReceiveFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionGenRecBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionCopyTo.setVisible(true);
        this.actionReditClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionReditOpen.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_staruse"));
        this.actionOutput.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_showbusiness"));
        this.actionDiscount.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_daybalance"));
        this.actionOutput.setEnabled(false);
        this.actionLocate.setVisible(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() throws EASBizException, BOSException {
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        String id = (String)idList.get(0);
        LetterOfCreditReceiveInfo info = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        int billstate = info.getBillstate().getValue();
        String letterStatus = info.getLetterStatus().getValue();
        BigDecimal balance = info.getBalance();
        boolean isOutput = info.isIsOutput();
        if (billstate == 2 && letterStatus.equals("0") && balance.compareTo(Constants.ZERO) > 0 && !isOutput) {
            this.actionOutput.setEnabled(true);
            this.actionDiscount.setEnabled(true);
        } else {
            this.actionOutput.setEnabled(false);
            this.actionDiscount.setEnabled(false);
        }
        if (billstate == 2) {
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(true);
        } else if (billstate == 1) {
            this.actionAudit.setEnabled(true);
            this.actionAntiAudit.setEnabled(false);
        } else {
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
        }
        if (letterStatus.equals("0")) {
            this.actionReditClose.setEnabled(true);
            this.actionReditOpen.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.actionAntiAudit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionAttachment.setEnabled(true);
            this.actionDiscount.setEnabled(true);
        } else {
            this.actionReditClose.setEnabled(false);
            this.actionReditOpen.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionAttachment.setEnabled(false);
            this.actionDiscount.setEnabled(false);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        evi.getSelector().add("id");
        evi.getSelector().add("billstate");
        evi.setFilter(filter);
        LetterOfCreditReceiveCollection colls = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveCollection(evi);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReceiveInfo billInfo = colls.get(i);
            if (!LetterOfCreditRecStateEnum.Save.equals((Object)billInfo.getBillstate())) continue;
            this.actionReditClose.setEnabled(false);
        }
    }

    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectSingleId();
        if (!this.checkIsValid(id, e)) {
            return;
        }
        LetterOfCreditReceiveFactory.getRemoteInstance().output();
        this.actionCreateTo_actionPerformed(e);
        this.refresh(e);
    }

    private boolean checkIsValid(String id, ActionEvent e) throws BOSException, EASBizException {
        LetterOfCreditReceiveInfo info = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        int billstate = info.getBillstate().getValue();
        String letterStatus = info.getLetterStatus().getValue();
        BigDecimal balance = info.getBalance();
        boolean isOutput = info.isIsOutput();
        return billstate == 2 && letterStatus.equals("0") && balance.compareTo(Constants.ZERO) > 0 && !isOutput;
    }

    private String getSelectSingleId() {
        this.checkSelected();
        return this.getSelectedKeyValue();
    }

    protected void execQuery() {
        super.execQuery();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("isCreateLoan") != null || ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromLoanApply") != null)) {
            filter.getFilterItems().add(new FilterItemInfo("billstate", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("LetterStatus", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isOutput", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompanyCommon.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        }
        return filter;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filter) {
            this.filter = new LetterOfCreditReceiveFilterUI();
        }
        return this.filter;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("entries.id").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("contracCurrency"));
        sic.add(new SelectorItemInfo("issueCurrency"));
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LetterOfCreditReceiveInfo info = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getBillstate().getValue() >= 2 && info.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"277_LetterOfCreditReceiveEditUI"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(this.getSelectedIdValues()), CompareType.INCLUDE));
        evi.getSelector().add("id");
        evi.getSelector().add("billstate");
        evi.getSelector().add("LetterStatus");
        evi.setFilter(filter);
        LetterOfCreditReceiveCollection colls = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveCollection(evi);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReceiveInfo info = colls.get(i);
            if (info.isIsGenRecBill()) {
                MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"hasBeenBooked");
            }
            if (info.getBillstate().getValue() < 2 && !info.getLetterStatus().equals((Object)LetterStatusEnum.close)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"280_LetterOfCreditRecerveListUI"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = FMHelper.list2Set((List)this.getSelectedIdValues());
        ((ILetterOfCreditReceive)this.getBizInterface()).batchAudit(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"211_ChequeListUI"));
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = FMHelper.list2Set((List)this.getSelectedIdValues());
        ((ILetterOfCreditReceive)this.getBizInterface()).batchAntAudit(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"212_ChequeListUI"));
        this.refreshList();
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionReditOpen_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = FMHelper.list2Set((List)this.getSelectedIdValues());
        ((ILetterOfCreditReceive)this.getBizInterface()).open(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"465_LetterOfCreditRecerveListUI"));
        this.refreshList();
    }

    @Override
    public void actionReditClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(this.getSelectedIdValues()), CompareType.INCLUDE));
        evi.getSelector().add("id");
        evi.getSelector().add("billstate");
        evi.getSelector().add("LetterStatus");
        evi.setFilter(filter);
        LetterOfCreditReceiveCollection colls = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveCollection(evi);
        if (colls.size() == 1) {
            LetterOfCreditReceiveInfo info = colls.get(0);
            if (info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Save)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"279_LetterOfCreditReceiveEditUI"));
                return;
            }
            idSet.add(info.getId().toString());
        } else {
            for (int i = 0; i < colls.size(); ++i) {
                LetterOfCreditReceiveInfo info = colls.get(i);
                if (info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Save)) continue;
                idSet.add(info.getId().toString());
            }
            if (idSet.isEmpty()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"279_LetterOfCreditReceiveEditUI"));
                return;
            }
        }
        Date effectDate = CreditRecCloseDatePickUI.showDialogWindow((IUIObject)this);
        if (effectDate == null) {
            return;
        }
        ((ILetterOfCreditReceive)this.getBizInterface()).close(idSet, effectDate);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"466_LetterOfCreditRecerveListUI"));
        this.refreshList();
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new LetterOfQueryprocessor();
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected void getAttachMentItem(KDTable table) {
    }

    @Override
    public void actionDiscount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("issueCurrency.precision"));
        LetterOfCreditReceiveInfo info = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (info.getBillstate().getValue() != LetterOfCreditRecStateEnum.Audit.getValue() || !info.getLetterStatus().equals((Object)LetterStatusEnum.open) || info.getAmount().compareTo(info.getBalance()) != 0) {
            throw new AcceptApplyBillException(AcceptApplyBillException.DISCOUNTEXCEPTION);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"LetterOfCreditReceive", (Object)info);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LetterOfCreditDisCountEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionGenRecBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkGenRecBill();
        String id = this.getSelectedKeyValue();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        try {
            CtrlUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            FMClientHelper.generateDestBillWithCU((CtrlUnitInfo)orgUnitInfo, (CoreBillListUI)this, (String)new LetterOfCreditReceiveInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (String)id);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            iMutex.releaseObjIDForUpdate(id);
        }
    }

    private void checkGenRecBill() throws Exception {
        this.checkSelected();
        LetterOfCreditReceiveInfo letterInfo = LetterOfCreditReceiveFactory.getRemoteInstance().getLetterOfCreditReceiveInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (!LetterOfCreditRecStateEnum.Audit.equals((Object)letterInfo.getBillstate())) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"auditFirst");
        }
        if (letterInfo.getBalance().compareTo(Constants.ZERO) <= 0 && !LetterOfCreditRecStateEnum.Submit.equals((Object)letterInfo.getBillstate())) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"balanceerror");
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "issureDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAudit"};
    }
}

