/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.NTRptEndorsementFilterParam;
import com.kingdee.eas.fm.nt.client.AbstractNTRptEndorseBillMainUI;
import com.kingdee.eas.fm.nt.client.NTRptEndorseBillDetailUI;
import com.kingdee.eas.fm.nt.client.NTRptEndorseBillMainFilterUI;
import com.kingdee.eas.fm.nt.client.util.NTRptEndorseBillMainHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NTRptEndorseBillMainUI
extends AbstractNTRptEndorseBillMainUI {
    private static final Logger logger = CoreUIObject.getLogger(NTRptEndorseBillMainUI.class);
    private NTRptEndorseBillMainHandler handler = NTRptEndorseBillMainHandler.getInstance();
    private NTRptEndorseBillMainFilterUI filterUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    public void onLoad() throws Exception {
        this.getMainTable().checkParsed();
        this.getMainTable().getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.handler.initTalbe(this.getMainTable());
        super.onLoad();
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        NTRptEndorsementFilterParam param = (NTRptEndorsementFilterParam)this.getFilterParam();
        DateFormat format = null;
        format = "l1".equals(SysContext.getSysContext().getLocale().getLanguage()) ? DateFormat.getDateInstance(1, Locale.ENGLISH) : DateFormat.getDateInstance(1, Locale.CHINESE);
        String dateRange = format.format(param.getStarttime()) + "--" + format.format(param.getEndtime());
        this.txtDateRange.setText(dateRange);
        if (param.getEndorseType() != null) {
            this.txtEndorseType.setText(param.getEndorseType().toString());
        } else {
            this.txtEndorseType.setText("");
        }
        this.getMainTable().removeRows();
        try {
            this.handler.fillData(this.getMainTable(), param);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tblMain.getGroupManager().group();
        try {
            this.formatGroupRows();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void formatGroupRows() throws EASBizException, BOSException {
        NTRptEndorsementFilterParam param = (NTRptEndorsementFilterParam)this.getFilterParam();
        if (this.tblMain.getRowCount3() == 0) {
            return;
        }
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrency().getId().toString()));
        String formatString = FMClientHelper.getNumberFtm((int)currency.getPrecision());
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.isStat()) continue;
            row.getCell(3).getStyleAttributes().setNumberFormat(formatString);
            row.getCell(4).getStyleAttributes().setNumberFormat(formatString);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new NTRptEndorseBillMainFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDetail_actionPerformed(e);
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        UIContext uiContext = new UIContext((Object)this);
        NTRptEndorsementFilterParam param = (NTRptEndorsementFilterParam)this.getFilterParam();
        if (this.tblMain.getRow(FMClientHelper.getSelectedRow((KDTable)this.tblMain)).getCell("currencyid").getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"283_NTRptEndorseBillDetailUI"));
            this.abort();
        }
        String endosrename = this.tblMain.getRow(FMClientHelper.getSelectedRow((KDTable)this.tblMain)).getCell("endorsee").getValue().toString();
        param.setEndorseeName(endosrename);
        uiContext.put((Object)"filterParam", (Object)param);
        uiContext.put((Object)"isDirectShow", (Object)new Boolean(true));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(NTRptEndorseBillDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kDLabelContainer1.getBoundLabelText()).append(":  ").append("&[DateRange]&|").append(this.kDLabelContainer2.getBoundLabelText()).append(":  ").append("&[EndorseType]");
        headerModel.addRow(sb.toString(), sa);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("DateRange", this.txtDateRange.getText());
        map.put("EndorseType", this.txtEndorseType.getText());
        return map;
    }
}

